<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.4
*/function
adminer_errors($Fc,$Hc){return!!preg_match('~^(Trying to access array offset on( value of type)? null|Undefined array key)~',$Hc);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$ed=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($ed||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Ni=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Ni)$$X=$Ni;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$g;return$g;}function
adminer(){global$b;return$b;}function
version(){global$ia;return$ia;}function
idf_unescape($t){if(!preg_match('~^[`\'"[]~',$t))return$t;$we=substr($t,-1);return
str_replace($we.$we,$we,substr($t,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($zg,$ed=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($x,$X)=each($zg)){foreach($X
as$ne=>$W){unset($zg[$x][$ne]);if(is_array($W)){$zg[$x][stripslashes($ne)]=$W;$zg[]=&$zg[$x][stripslashes($ne)];}else$zg[$x][stripslashes($ne)]=($ed?$W:stripslashes($W));}}}}function
bracket_escape($t,$Oa=false){static$zi=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($t,($Oa?array_flip($zi):$zi));}function
min_version($ej,$Ke="",$h=null){global$g;if(!$h)$h=$g;$sh=$h->server_info;if($Ke&&preg_match('~([\d.]+)-MariaDB~',$sh,$A)){$sh=$A[1];$ej=$Ke;}return(version_compare($sh,$ej)>=0);}function
charset($g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
script($Ch,$yi="\n"){return"<script".nonce().">$Ch</script>$yi";}function
script_src($Si){return"<script src='".h($Si)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($P){return
str_replace("\0","&#0;",htmlspecialchars($P,ENT_QUOTES,'utf-8'));}function
nl_br($P){return
str_replace("\n","<br>",$P);}function
checkbox($C,$Y,$eb,$se="",$_f="",$ib="",$te=""){$I="<input type='checkbox' name='$C' value='".h($Y)."'".($eb?" checked":"").($te?" aria-labelledby='$te'":"").">".($_f?script("qsl('input').onclick = function () { $_f };",""):"");return($se!=""||$ib?"<label".($ib?" class='$ib'":"").">$I".h($se)."</label>":$I);}function
optionlist($D,$lh=null,$Wi=false){$I="";foreach($D
as$ne=>$W){$Gf=array($ne=>$W);if(is_array($W)){$I.='<optgroup label="'.h($ne).'">';$Gf=$W;}foreach($Gf
as$x=>$X)$I.='<option'.($Wi||is_string($x)?' value="'.h($x).'"':'').(($Wi||is_string($x)?(string)$x:$X)===$lh?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($C,$D,$Y="",$zf=true,$te=""){if($zf)return"<select name='".h($C)."'".($te?" aria-labelledby='$te'":"").">".optionlist($D,$Y)."</select>".(is_string($zf)?script("qsl('select').onchange = function () { $zf };",""):"");$I="";foreach($D
as$x=>$X)$I.="<label><input type='radio' name='".h($C)."' value='".h($x)."'".($x==$Y?" checked":"").">".h($X)."</label>";return$I;}function
select_input($Ja,$D,$Y="",$zf="",$lg=""){$di=($D?"select":"input");return"<$di$Ja".($D?"><option value=''>$lg".optionlist($D,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$lg'>").($zf?script("qsl('$di').onchange = $zf;",""):"");}function
confirm($Te="",$mh="qsl('input')"){return
script("$mh.onclick = function () { return confirm('".($Te?js_escape($Te):lang(0))."'); };","");}function
print_fieldset($s,$Ae,$hj=false){echo"<fieldset><legend>","<a href='#fieldset-$s'>$Ae</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$s');",""),"</legend>","<div id='fieldset-$s'".($hj?"":" class='hidden'").">\n";}function
generate_linksbar($_){$Ee="<p class='links'>";foreach($_
as$x=>$z){if($x!==key(array_keys($_)))$Ee.="<span class='separator'>|</span>";$Ee.=$z;}$Ee.="</p>";return$Ee;}function
bold($Va,$ib=""){return($Va?" class='active $ib'":($ib?" class='$ib'":""));}function
odd($I=' class="odd"'){static$r=0;if(!$I)$r=-1;return($r++%2?$I:'');}function
js_escape($P){return
addcslashes($P,"\r\n'\\/");}function
json_row($x,$X=null){static$fd=true;if($fd)echo"{";if($x!=""){echo($fd?"":",")."\n\t\"".addcslashes($x,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$fd=false;}else{echo"\n}\n";$fd=true;}}function
ini_bool($ae){$X=ini_get($ae);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($dj,$M,$V,$F){$_SESSION["pwds"][$dj][$M][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($P){global$g;return$g->quote($P);}function
get_vals($G,$d=0){global$g;$I=array();$H=$g->query($G);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$d];}return$I;}function
get_key_vals($G,$h=null,$vh=true){global$g;if(!is_object($h))$h=$g;$I=array();$H=$h->query($G);if(is_object($H)){while($J=$H->fetch_row()){if($vh)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($G,$h=null,$m="<p class='error'>"){global$g;$zb=(is_object($h)?$h:$g);$I=array();$H=$zb->query($G);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($h)&&$m&&defined("PAGE_HEADER"))echo$m.error()."\n";return$I;}function
unique_array($J,$v){foreach($v
as$u){if(preg_match("~PRIMARY|UNIQUE~",$u["type"])){$I=array();foreach($u["columns"]as$x){if(!isset($J[$x]))continue
2;$I[$x]=$J[$x];}return$I;}}}function
escape_key($x){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$x,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($x);}function
where($Z,$o=array()){global$g,$w;$I=array();foreach((array)$Z["where"]as$x=>$X){$x=bracket_escape($x,1);$d=escape_key($x);$I[]=$d.($w=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($w=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($o[$x],q($X))));if($w=="sql"&&preg_match('~char|text~',$o[$x]["type"]??null)&&preg_match("~[^ -@]~",$X))$I[]="$d = ".q($X)." COLLATE ".charset($g)."_bin";}foreach((array)$Z["null"]as$x)$I[]=escape_key($x)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$o=array()){parse_str($X,$cb);remove_slashes(array(&$cb));return
where($cb,$o);}function
where_link($r,$d,$Y,$Bf="="){return"&where%5B$r%5D%5Bcol%5D=".urlencode($d)."&where%5B$r%5D%5Bop%5D=".urlencode(($Y!==null?$Bf:"IS NULL"))."&where%5B$r%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$o,$L=array()){$I="";foreach($e
as$x=>$X){if($L&&!in_array(idf_escape($x),$L))continue;$Ha=convert_field($o[$x]);if($Ha)$I.=", $Ha AS ".idf_escape($x);}return$I;}function
cookie($C,$Y,$De=2592000){global$ba;return
header("Set-Cookie: $C=".urlencode($Y).($De?"; expires=".gmdate("D, d M Y H:i:s",time()+$De)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($ld=false){$Vi=ini_bool("session.use_cookies");if(!$Vi||$ld){session_write_close();if($Vi&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($x){return$_SESSION[$x][DRIVER][SERVER][$_GET["username"]];}function
set_session($x,$X){$_SESSION[$x][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($dj,$M,$V,$k=null){global$nc;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($nc))."|username|".($k!==null?"db|":"").session_name()),$A);return"$A[1]?".(sid()?SID."&":"").($dj!="server"||$M!=""?urlencode($dj)."=".urlencode($M)."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Fe,$Te=null){if($Te!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Fe!==null?$Fe:$_SERVER["REQUEST_URI"]))][]=$Te;}if($Fe!==null){if($Fe=="")$Fe=".";header("Location: $Fe");exit;}}function
query_redirect($G,$Fe,$Te,$Ig=true,$Mc=true,$Wc=false,$li=""){global$g,$m,$b;if($Mc){$Kh=microtime(true);$Wc=!$g->query($G);$li=format_time($Kh);}$Fh="";if($G)$Fh=$b->messageQuery($G,$li,$Wc);if($Wc){$m=error().$Fh.script("messagesPrint();");return
false;}if($Ig)redirect($Fe,$Te.$Fh);return
true;}function
queries($G){global$g;static$Cg=array();static$Kh;if(!$Kh)$Kh=microtime(true);if($G===null)return
array(implode("\n",$Cg),format_time($Kh));$Cg[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return$g->query($G);}function
apply_queries($G,$S,$Ic='table'){foreach($S
as$Q){if(!queries("$G ".$Ic($Q)))return
false;}return
true;}function
queries_redirect($Fe,$Te,$Ig){list($Cg,$li)=queries(null);return
query_redirect($Cg,$Fe,$Te,$Ig,false,!$Ig,$li);}function
format_time($Kh){return
lang(1,max(0,microtime(true)-$Kh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Wf=""){return
substr(preg_replace("~(?<=[?&])($Wf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($E,$Pb){return" ".($E==$Pb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
get_file($x,$Yb=false){$cd=$_FILES[$x];if(!$cd)return
null;foreach($cd
as$x=>$X)$cd[$x]=(array)$X;$I='';foreach($cd["error"]as$x=>$m){if($m)return$m;$C=$cd["name"][$x];$ti=$cd["tmp_name"][$x];$Db=file_get_contents($Yb&&preg_match('~\.gz$~',$C)?"compress.zlib://$ti":$ti);if($Yb){$Kh=substr($Db,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Kh,$Og))$Db=iconv("utf-16","utf-8",$Db);elseif($Kh=="\xEF\xBB\xBF")$Db=substr($Db,3);$I.=$Db."\n\n";}else$I.=$Db;}return$I;}function
upload_error($m){$Qe=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(2).($Qe?" ".lang(3,$Qe):""):lang(4));}function
repeat_pattern($ig,$Be){return
str_repeat("$ig{0,65535}",$Be/65535)."$ig{0,".($Be%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($P,$Be=80,$Rh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Be).")($)?)u",$P,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Be).")($)?)",$P,$A);return
h($A[1]).$Rh.(isset($A[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($zg,$Pd=array(),$rg=''){$I=false;foreach($zg
as$x=>$X){if(!in_array($x,$Pd)){if(is_array($X))hidden_fields($X,array(),$x);else{$I=true;echo'<input type="hidden" name="'.h($rg?$rg."[$x]":$x).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$Xc=false){$I=table_status($Q,$Xc);return($I?$I:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$I=array();foreach($b->foreignKeys($Q)as$p){foreach($p["source"]as$X)$I[$X][]=$p;}return$I;}function
enum_input($T,$Ja,$n,$Y,$Bc=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$B);$I=($Bc!==null?"<label><input type='$T'$Ja value='$Bc'".((is_array($Y)?in_array($Bc,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($B[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$eb=(is_int($Y)?$Y==$r+1:(is_array($Y)?in_array($r+1,$Y):$Y===$X));$I.=" <label><input type='$T'$Ja value='".($r+1)."'".($eb?' checked':'').'>'.h($b->editVal($X,$n)).'</label>';}return$I;}function
input($n,$Y,$q){global$U,$b,$w;$C=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$q){$Fa=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$Fa[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$Fa);$q="json";}$Sg=($w=="mssql"&&$n["auto_increment"]);if($Sg&&!$_POST["save"])$q=null;$ud=(isset($_GET["select"])||$Sg?array("orig"=>lang(8)):array())+$b->editFunctions($n);$Ja=" name='fields[$C]'";if($n["type"]=="enum")echo
h($ud[""])."<td>".$b->editInput($_GET["edit"],$n,$Ja,$Y);else{$Ed=(in_array($q,$ud)||isset($ud[$q]));echo(count($ud)>1?"<select name='function[$C]'>".optionlist($ud,$q===null||$Ed?$q:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($ud))).'<td>';$ce=$b->editInput($_GET["edit"],$n,$Ja,$Y);if($ce!="")echo$ce;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$Ja value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ja value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$B);foreach($B[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$eb=(is_int($Y)?($Y>>$r)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$C][$r]' value='".(1<<$r)."'".($eb?' checked':'').">".h($b->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$C'>";elseif(($ji=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($ji&&$w!="sqlite")$Ja.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Ja.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Ja>".h($Y).'</textarea>';}elseif($q=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$Ja cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Se=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$A)?((preg_match("~binary~",$n["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$n["unsigned"]?1:0)):($U[$n["type"]]?$U[$n["type"]]+($n["unsigned"]?0:1):0));if($w=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$Se+=7;echo"<input".((!$Ed||$q==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($Se?" data-maxlength='$Se'":"").(preg_match('~char|binary~',$n["type"])&&$Se>20?" size='40'":"")."$Ja>";}echo$b->editHint($_GET["edit"],$n,$Y);$fd=0;foreach($ud
as$x=>$X){if($x===""||!$X)break;$fd++;}if($fd)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $fd), oninput: function () { this.onchange(); }});");}}function
process_input($n){global$b,$l;$t=bracket_escape($n["field"]);$q=$_POST["function"][$t]??null;$Y=$_POST["fields"][$t];if($n["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($n["auto_increment"]&&$Y=="")return
null;if($q=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($q=="NULL")return"NULL";if($n["type"]=="set")return
array_sum((array)$Y);if($q=="json"){$q="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$cd=get_file("fields-$t");if(!is_string($cd))return
false;return$l->quoteBinary($cd);}return$b->processInput($n,$Y,$q);}function
fields_from_edit(){global$l;$I=array();foreach((array)$_POST["field_keys"]as$x=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$x];$_POST["fields"][$X]=$_POST["field_vals"][$x];}}foreach((array)$_POST["fields"]as$x=>$X){$C=bracket_escape($x,1);$I[$C]=array("field"=>$C,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($x==$l->primary),);}return$I;}function
search_tables(){global$b,$g;$_GET["where"][0]["val"]=$_POST["query"];$oh="<ul>\n";foreach(table_status('',true)as$Q=>$R){$C=$b->tableName($R);if(isset($R["Engine"])&&$C!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$H=$g->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$H||$H->fetch_row()){$vg="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$C</a>";echo"$oh<li>".($H?$vg:"<p class='error'>$vg: ".error())."\n";$oh="";}}}echo($oh?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Nd,$bf=false){global$b;$I=$b->dumpHeaders($Nd,$bf);$Sf=$_POST["output"];if($Sf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Nd).".$I".($Sf!="file"&&preg_match('~^[0-9a-z]+$~',$Sf)?".$Sf":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$x=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$J[$x]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($q,$d){return($q?($q=="unixepoch"?"DATETIME($d, '$q')":($q=="count distinct"?"COUNT(DISTINCT ":strtoupper("$q("))."$d)"):$d);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$dd=@tempnam("","");if(!$dd)return
false;$I=dirname($dd);unlink($dd);}}return$I;}function
file_open_lock($dd){$sd=@fopen($dd,"r+");if(!$sd){$sd=@fopen($dd,"w");if(!$sd)return;chmod($dd,0660);}flock($sd,LOCK_EX);return$sd;}function
file_write_unlock($sd,$Rb){rewind($sd);fwrite($sd,$Rb);ftruncate($sd,strlen($Rb));flock($sd,LOCK_UN);fclose($sd);}function
password_file($i){$dd=get_temp_dir()."/adminer.key";$I=@file_get_contents($dd);if($I||!$i)return$I;$sd=@fopen($dd,"w");if($sd){chmod($dd,0660);$I=rand_string();fwrite($sd,$I);fclose($sd);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$z,$n,$ki){global$b;if(is_array($X)){$I="";foreach($X
as$ne=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($ne):"")."<td>".select_value($W,$z,$n,$ki);return"<table cellspacing='0'>$I</table>";}if(!$z)$z=$b->selectLink($X,$n);if($z===null){if(is_mail($X))$z="mailto:$X";if(is_url($X))$z=$X;}$I=$b->editVal($X,$n);if($I!==null){if(!is_utf8($I))$I="\0";elseif($ki!=""&&is_shortable($n))$I=shorten_utf8($I,max(0,+$ki));else$I=h($I);}return$b->selectVal($I,$z,$n,$X);}function
is_mail($zc){$Ia='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$mc='[[:alnum:]](?:[-[:alnum:]]{0,61}[[:alnum:]])';$ig="$Ia+(?:\\.$Ia+)*@(?:$mc?\\.)+$mc";return
is_string($zc)&&preg_match("(^$ig(?:,\\s*$ig)*\$)i",$zc);}function
is_url($P){return(bool)preg_match('~^
			https?://                 # scheme
			(?:
				# IPv6 in square brackets
				\[(?:
					(?:[[:xdigit:]]{1,4}:){7}[[:xdigit:]]{1,4} |             # 1:2:3:4:5:6:7:8
					(?:[[:xdigit:]]{1,4}:){1,7}: |                           # 1::                             1:2:3:4:5:6:7::
					(?:[[:xdigit:]]{1,4}:){1,6}:[[:xdigit:]]{1,4} |          # 1::8            1:2:3:4:5:6::8  1:2:3:4:5:6::8
					(?:[[:xdigit:]]{1,4}:){1,5}(?::[[:xdigit:]]{1,4}){1,2} | # 1::7:8          1:2:3:4:5::7:8  1:2:3:4:5::8
					(?:[[:xdigit:]]{1,4}:){1,4}(?::[[:xdigit:]]{1,4}){1,3} | # 1::6:7:8        1:2:3:4::6:7:8  1:2:3:4::8
					(?:[[:xdigit:]]{1,4}:){1,3}(?::[[:xdigit:]]{1,4}){1,4} | # 1::5:6:7:8      1:2:3::5:6:7:8  1:2:3::8
					(?:[[:xdigit:]]{1,4}:){1,2}(?::[[:xdigit:]]{1,4}){1,5} | # 1::4:5:6:7:8    1:2::4:5:6:7:8  1:2::8
					[[:xdigit:]]{1,4}:(?::[[:xdigit:]]{1,4}){1,6} |          # 1::3:4:5:6:7:8  1::3:4:5:6:7:8  1::8
					:(?::[[:xdigit:]]{1,4}){1,7} |                           # ::2:3:4:5:6:7:8 ::2:3:4:5:6:7:8 ::8
					fe80:(?::[[:xdigit:]]{0,4}){0,4}%[[:alnum:]]+ |          # fe80::7:8%eth0  fe80::7:8%1     (link-local IPv6 addresses with zone index)
					::(?:ffff(?::0{1,4})?:)?
						(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
						(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
						(?<!\b0\.0\.0\.0) |                                  # ::255.255.255.255  ::ffff:255.255.255.255 ::ffff:0:255.255.255.255  (IPv4-mapped IPv6 addresses and IPv4-translated addresses)
					(?:[[:xdigit:]]{1,4}:){1,4}:
						(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
						(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
						(?<!\b0\.0\.0\.0)                                    # 2001:db8:3:4::192.0.2.33  64:ff9b::192.0.2.33 (IPv4-Embedded IPv6 Address)
				)\] |
				# IPv4
				(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
					(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
					(?<!\b0\.0\.0\.0) |                                      # 0.0.0.0 excluded for URLs
				# domain
				[_[:alnum:]](?:[-_[:alnum:]]{0,61}[_[:alnum:]])?
					(?:\.[_[:alnum:]](?:[-_[:alnum:]]{0,61}[_[:alnum:]])?)*
			)                         # host
			(?::(?:[1-9]\d{0,3})?\d)? # port
			(?:/[^\s?\#]*)?           # path
			(?:\?[^\s\#]*)?           # query
			(?:\#\S*)?                # fragment
			$~xi',$P);}function
is_shortable($n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]??null);}function
count_rows($Q,$Z,$ie,$yd){global$w;$G=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($ie&&($w=="sql"||count($yd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$yd).")$G":"SELECT COUNT(*)".($ie?" FROM (SELECT 1$G GROUP BY ".implode(", ",$yd).") x":$G));}function
slow_query($G){global$b,$vi,$l;$k=$b->database();$mi=$b->queryTimeout();$_h=$l->slowQuery($G,$mi);if(!$_h&&support("kill")&&is_object($h=connect())&&($k==""||$h->select_db($k))){$qe=$h->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$qe,'&token=',$vi,'\');
}, ',1000*$mi,');
</script>
';}else$h=null;ob_flush();flush();$I=@get_key_vals(($_h?$_h:$G),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$Fg=rand(1,1e6);return($Fg^$_SESSION["token"]).":$Fg";}function
verify_token(){list($vi,$Fg)=explode(":",$_POST["token"]);return($Fg^$_SESSION["token"])==$vi;}function
lzw_decompress($Sa){$jc=256;$Ta=8;$kb=array();$Ug=0;$Vg=0;for($r=0;$r<strlen($Sa);$r++){$Ug=($Ug<<8)+ord($Sa[$r]);$Vg+=8;if($Vg>=$Ta){$Vg-=$Ta;$kb[]=$Ug>>$Vg;$Ug&=(1<<$Vg)-1;$jc++;if($jc>>$Ta)$Ta++;}}$ic=range("\0","\xFF");$I="";foreach($kb
as$r=>$jb){$yc=$ic[$jb];if(!isset($yc))$yc=$sj.$sj[0];$I.=$yc;if($r)$ic[]=$sj.$yc[0];$sj=$yc;}return$I;}function
on_help($sb,$xh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $sb, $xh) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$o,$J,$Qi){global$b,$w,$vi,$m;$Wh=$b->tableName(table_status1($Q,true));page_header(($Qi?lang(10):lang(11)),$m,array("select"=>array($Q,$Wh)),$Wh);$b->editRowPrint($Q,$o,$J,$Qi);if($J===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($o
as$C=>$n){echo"<tr><th>".$b->fieldName($n);$Zb=$_GET["set"][bracket_escape($C)]??null;if($Zb===null){$Zb=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Zb,$Og))$Zb=$Og[1];}$Y=($J!==null?($J[$C]!=""&&$w=="sql"&&preg_match("~enum|set~",$n["type"])?(is_array($J[$C])?array_sum($J[$C]):+$J[$C]):(is_bool($J[$C])?+$J[$C]:$J[$C])):(!$Qi&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$Zb)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$n);$kd=null;if(isset($_POST["function"][$C]))$kd=(string)$_POST["function"][$C];$q=($_POST["save"]?$kd:($Qi&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Qi&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$q="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$q="now";}input($n,$Y,$q);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Qi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Qi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($Qi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$o?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$vi,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0X\0Z\0\0C> \r9\09\$M'JeRd]/LfS9m7I[m|:(nNiTe6+y<^e(,EY\$L\$uDK}>o[`*qJs5ͅmrY<+w|9˷M2}_땢\\\"V\n+MtBK*3ypl5I`V)OWs{OIAs۹㉥N&cO}~hH@GzJyGCcNJЪ`귊FC{вU@i>YJEiNR(9A%!CQ^yat:&۝YGH/\ngxs~@%y8ZUEOac@:\n;G>9i}@p,6&c Fő^%aRAQhIZԵ9z\\š`V5ZjoT9!^O)12l.I~^Qt꒦usI;OlB\$Q9q	\\eTsęUq2H֥J'(EvT!ѐ%EQFPv\\o'JtGIID\"e3-	oj&8E@uTICTUPy3ڶ>L^jbK#qD8ʒ\\Mdql\\y^]94hNk_g^GQ1)PQ8eMUsոbRha&]O5VUз-d23\\U@kWg+˷'gZٖE)KJ|qP=ҟO`[%wOgNMPcS	C!pdS#!KL=}ߠtp4!/k6uNdU28XDXHDvOb4IN<+q*?7WM!X,dXN(Ж=0Kvǘ25F #\$a&LSd\r(ЗFHИᖒ߱2:'M>RXcq)xdCp\rah'\0hDȠ`l&&B8Bm.rAeIQ2@). n`|ًF<䤳ZJ[a(KoP\"4D?TRgLJU_#8%u\$ASʆKJA8f17M]J&1=afK<w\$	MITTH&30?6ls\$DU\$ThI[5*MdbDPLsF\0'AJp-\rG3_k]|m%`_,8sE<2r!;|*TTQ-tق`<GlJi9GLKaK{\n=M+1h/:W\\[q\\Kaleݲu)v-~5UL?ED[1\\V66gĽfΪ8Io]h[ݒ R)!Ι˕W[5K'?};ii]3lFccL|^5;*ǸQ博&<Yu/rٗ\n-x8'\r1)#n9Vx%YdI\ntI*ȳs~m7.ǌRjX+^PeRײ:Je9{#';죥u2Rj]MFZVj]ZZk]mƲ");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\nCo6C(\"#Ha1#yd1٘n:#(b.\rDc)a7Elñi1Ύs54f4ngsIhMдi:`,]YtL0hD*B0\rF&3xs'[Ʉtv4S%0XLW5)Yf\r^=~9g0\\@rQNn^yNj{opC%ʋGSZh5Z|>:'b{J)Ɠєt1*uS=^2*8t(0R,8j:x@9\n@1\nJ#4BRJFƋ>#J`HaahbC0\r4Ar&\nB54\$>+QA2DoMEL\"48=s5DLW7JGf**HjEK16ڸ,oLtJA\\\$Q|9-H@0\nxtV(o.+ܮ;1D8e*c\rT䍣B2܍z\n83=Ktƻu(kmׅ.G;+:2)cn<s5:6\nԡ)_\\6YL\"VV`c\$L;k&\$?XAWU48	Bޡڮz*[O24<?{36%;VV:\\A䎈	xnpxF<[xoW.U[Ãsd7rF&	bÒ]t*7ji=dZֹYy4:ie&Pg\\1C0:;;ٹ5Cnà\\܎#ܳ4{^g7u6NJ6OC#{!?fxw!70JJL48dpLàypC[.AltPQ'zl=N7@m\n/cTc]tהxiaD+pPpxׅUJ%Da`@^OEc)Ň@@A')hUb!AƸڠT~P\\*9Gi};`ˠh\r1Zlx9HI)AjRWI9!#̆[ysZb--q؇h7➀LjQʻ\"#lU`ׄ^Ar\rffV.QsnhGgN@e%?\$ᰂI;T\0`]B\r8[r2`\rҢ\rCKeF2ٺ\r'[t(),M)ڸ Se=*N@+9%Pin:܋T}ԎMC\rNtg%VÕ]V6Hʒl?Մ_Vhee,3ھF n%^kaM)_a-NB-v)rJ1NUly\0#YM˵Y`EM֭\"UH-_ #ܹE\"\rv42FL8wZ0]5Sw.!0ʴQ͏3E|%}AC0tLk3Pj/kbN`QQ7x_僧B<A8@%>\nx[&\rfy !SLsVG(¹	B\$a[F\\A8G&r;or>biRZMm,d\"<;\"Q?1uV~G,\0գ0c`IϣEPR^fBhUuɔ3CH(& i:\rt.W&5}UmߗpQNi`\ndi#(1QKҒ\nI,Yf`'(p7`q\rt\0U\rsr:ħ0و;A,v0p\rBPcrR^m.o\n=\\9%F7ZV#0|Yygf?/\"aMܿHnЬDdjl\0nAxsP(3}d#u`'p@[[T*`Z?\\!>˄vl}zf3; !(6/&A\08\0\0r\rp4{TT/!\ruAtH8JU`r9`j\r-H\"ՃATH ? }qA3l~a~2I^`Z\0004 ̓eP&\0p`n8pd%f\0sO`hD0\0p, i\$\\\0mO[ nD&`aP\\p2.0/0P0\nbVDd&&jd\"ioB0\$&\0aGJ& @&O7@i\$%\n0/bdo.\rro<\rP^Q\n	o`/\r^P}O6@nD d@0	^s\0#\0\$zIQjoc0M0OC [0@Q@`pf/P,ANp|PNF:ol@pPo@I`c	\$p/%\0HњpuP!h+\"A\$\"a_'/?U6DّCq fdiP\n%uQ\0e@pp#q\0\$o\npDB\0ϓ\00^P\"oB0ZO1	a*%Vj҄?/-!B,W\"ϑP\nPEFk/p_\rc+/\$S/7+/4_Lq'`D2%ύų#\r nב7p1#p7`O0\$o-!2Pѽ'&02	Nv/1\$io5\nO ip<23QD1</1-W\rCҍSٓ\n	\0\r؄JdrP#(J^nA N4\$(?\"CtH\r*\"1eptox\r|9ӰA \rADtKB@\0OCorsG`/kԍE,@O(KF,R+0A!/P\0%#s}PP;\rETE6\r@*hUK01uI8@^:`pR\0' T@b\"UaUdhi1SR+K	OtmJGTGE\0qq\n/jQ\0RA3s.Na\\@\n*1/\"a[/ϛ0Nك<aR0QUa/-P\\Hoap-%/\nskUѼ	\\#]6M!Tfr^\r*%PIZoKQ\"VE952S\$i+6OHѶZO'Zp2U M0<,Y1[Ui96-PR8p\r3?7O'cҳ`r;ӝ``%31A4%WhYqoG7oa,[Q7o sk_gii,rOij1CqI\0/!ғ]^TPHwM!wmQ01+mR},O?+T5pNK^Sfhssvk71f/5cg\0n@1zҴ\0koPI#\0i'E{GZ\rVxR`0#!/\nqc!1g?2nOj@pД@j\r<9Oq~@e0!3P#?YqلҸ5/?\0/6tIus cDi7nW\$UmA3kR?u\0r}Wt_bctō23p01r;bVv6;%17/)(]1W'QU1 v0\0gtADAWBtWX\"aXu9I<5CCTEEKATE4!W6) RccR\$kcL3:#T4'sOcV/\03\"T4j)PP%r;oLՏJT\$rnt6Ne95+#a2\r'MPo9UUmQX{Y ۛqu\0g&ZO-[IZ::?SA\0ڂ` D\"Bm*ePSj`JX\"ɍKFY>0nz\r:\00043,b,f(hޚLG3ICG.X.,7.j{\$]mrmV.Ξ\0N*vuXH`zON/V^ dɨD\0ƘhI\"˨piERVc9.O-.k\0DϻaE[HL\"b[Cj;EF9Q\"E|[2{M\0D	Fi\0h	\0`[痠E\ns\r0nsidCI@eŶ#eRivŜKn\\-|;7`qH`E܇BɚCӮܢ9||z^'p	c8-	bҕIP!G*@%:@C[	+; \0i(,LC!1[HPV[W`{dK)X\\ik=d.Е{Cכ񛿶<ɿ-I;Խ7\"Q?#ٛ9jE-%ۃ<<-\\)ͣY`\rIN!lHpI8!d]ܽٔ<yẉf	/j‘	gɵ<-DǛ>葱\rN]{юqd2]1tHFi[CcL\$_]Ӯ{kt]Ky՛i{\$Si =of{Ֆ[ݜݠ!]A=4e=#F;׾ĉ¿ܜ+ȓvƜMnsNHqw\\V?E<>	!'=|Rwd6ϊ\rwI?_yɾ!)fw˞3匥w~F#ɅxWt1(ɇRerW!I[ʤp)K1@HfI:Q S	r;5nbkqTʒ;  o*@r&Glq<\0.w6VckBhH(jOC7yC(mpV\n*1#n<[BR92E@&F(\n?J͐[ARWaػv8Wf#P:k{d`a't#tBmCXdr+sP,Adhwb?``b[ʡ\\+HXD90Ö]CY\$/Xk`/\"5|Q`Q\rj\\'CB?Uҏ,F4><agoA,(MNrHkeI,T*}òp8oPi yp\\'?9I&JNه:͏<.c01 3hB*aEzkhLmSԝ8:Ym˩vꗯ{	^^UQI{H[!\"ە^N{x4;!|}|nŵvb9ݎ<9qaY`c8;o\0f1\$o@5`} 7@h +((wq4i6x=ѣq;'9Qd# ſNiyq%>/ãb7ډ\rClFTqTaxˀ/Nt_^e\"6<1SƼ<G_+AWch=xL}GC8{Po,>9[]٘h@PÇ=4H~B\$N&4ѰPD, \0V@rj\$>:D\$	_Z#r;z4'|A HAPI}Dq*J8p\n EQ8\n  \$m`)W0ZI&ji2J²[Q\n~b@xkXrQAzb\$+ 	\"搐D\niC>\nҊ4)T{dQh`{&oBr,B(JjFād!\\jZQAO+2T,Cn|Sbr'@6| m((vú+YvK~]P@.sN_\0\0_aޗ03w0L\"a,yUwL_(ÐyL(08vF`[.Y~L(} oDjP7B^\rL%\nf<2\04)M3sG LMi?_r٘Lj_B-kZmj82͘5R4ڞYBJk3bBe1͖ٙl<f0B9!]/TG+*ʐIq\nܞS0@.B(CIsӛ^.2tRLg;:͘\r<̲eEKjtf:9ξuDg7<IM(<t9rN<ʙtˀ79L _c1yg>OVg:O6z3,x@1bM_\0&0\nb@sgN˚\0eDH+?KPrxnFUcE|ب#3Вp@jg-yuhW?(\0gThe:~t=B6Ȕ1DPaT8uCj)KZXchD#8XFy˼`-\\ Q&h_|ӃNiЖ<sa-f2NE-H>`0k-{8*IpCnt\$h7BV\\5#|(yDMKTE9I٢\rB9\\CS\n%fgJ,кt7 +DuJ6r~a.'`GPznm-7^>o5fཕ|=!PWxT⽐`)QW\np(|Z*?pс\r@kO!.3aq]\n'\nm=Ah)paU9NҝshgڕHa5x/ ");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`v0C98a^M4Ł\r|7zF[\n(7vIĈ2,9Ì#ȨDWR;P'm3샂\n\0u39Cw2fp{и/	o4ax/ \\.=NJG@YE9a߉mg[ӹ=z{4\01CH:>X>~]\0dws!:%9~a\nj0XuS6dIV3̼r`AD@x9'A@\\Ta3((\nP`o{e9=	`\"	[B{!:x?)'|f8C ?Pu|@xR;U\0(.5joN)/97LA#8eACA0&#wKդRGZaH	UݑpRb`WްJ\n!MDxkVnO(#yN#h\"@1\0Ɖ#8L2\\rQ\0r\r`Yvb+1Hl`%z. M 5lNb\$2TxH`XHSWmb)'>'zP!и@?V=8\n+da07;ɹ*~WwܕR*T8CҮ]Xn'I2n\$p4JtX<>yK)qi%Ű4>V\nH{Jj1}6JSPCa2\"}s(ڙ^m*D9ͩɸu:AyT˩L͜:+p^VJGff5%y	ܞY[댝[\$EUYZuJdA6[-CHl)ʃm=GfclRVxU UXR\$ij˻G	2[T'\n5sFYhi\0X%_!\rE44ltm93lS{S*g8\$\"kHO)Jbʵp%\\Ps#)B:ai Z^\nkv2FPJʘnB,ܧfX5pB`ooI!=8)caH㨬b(JGaʏ\"BF T{Rp*e~2^ >v>%^13wCX=!gTe=9p>5;u+hMWZA\rė\\M\\3gМ[YvqX[b)2\rWL+ŊezA|ed9Ae\\ap.@_긳~cp%-ZW[QI7E5uȔ[6%PCio[1A4KD\$i.	?V{/_y]@^q&#\0O</q\"檭\\WUHyWtjV{nVf+μt,Ċ^g:LUiݻe*ǏW/-%嬍\"8C^&(E\\6ZN9ysv^/B0RZO\0;`N &Q;P2Β+=MtZ472hLWoK'& zHܧj?\nRDG*Ӊ-#<I,P,Z;h\0#NM>I`(E4\rT]\"V\0XQj~ bR`MN-RSN,\"0	d~y\r\r@`Q-\\s\n.P)]\0p\r]T*}\rp#-jEmp!ɨf@@W<cmXv	z|KJm\0@WX\0Kl<!N*GECZoBzТ\rxGeHNH(gj񂰯\0xoK@11lD\$Р`Dv V bSгH`2pn.qQJ+*fMp\r /D*\"w\$o2[QF`M|1Rho'&5#%j>jMگt@&rpGdDbtsR\$r!N2qo{*,DɯbrM`.QqD%јG	!J-+EDE`{0䧩0DE#p(7#2ܳbd73M&ysH\"74rL9-f*܋/rRŘRBn*ij@nB茴\\FIX%x f\$9J}9a0qsnFH|@E3};)k7|HKK5SdvR@  ( \r&*Ja@fp+Jk,w _?\"X\rN3'5&t%;A8Lrn?EQ\0%NSka8\0Ю<DUGF8VTDWe7`HtHn GJl;HTjN`@HDs[tΎ((Hexm7vyIҾ#T=>()\$_ԧOOQ-e(*GKdKt`DV!C8sDi<)3BKU;8SZB(.GDc,EuTpdl7J38DK\nbtNSHUt#{VluVZuF\r@`]6Zǌǀ][\\\rf(0SS43D'W:Sc:ǅb)fĢ#w5vs,rw6&\\m0\0ڜ\nJv66Kd)cu&R37NSX5>DUZ:Z'rT7Sk_G[Ĩ\$KU\\x<m5#[E\\ɞ0WJ*.\ro]#C*5kg|<-uSO7TS^hosp f֍8I\\#8_R{pe'2=S@[:e8ҕd35]r֪ֈ&De\$nW[3^vTԖw)vܭX0cmasZ xm׌בPyyz:^2b᎗9Uqo of>\";K|3yVhl	0No.%@OGvJ7M(A,\"[\0/, %Īσ*2x}˦gA!,,ǖ:&\r,3_-ԇlHo8vwSj)V)(NSXHXMXCx'/AXZ^|f҃i,ʸg؎[ڭ@QbLxJ\0jS Z	VB\"Ћc<ТtP5uP\rܬm\"yBCMnw^1 Njx./*ntI\"2\"=r\$:kwba.1>3h(Kom5;2g|B\"iD\rgBX%rV\0n\\FMm\0~\\͞4`.*\0@'9  d	{6瞠\nP놾In˛Y[VXm^oԢ?g<P@N/KsDeP\0xǤg}[sG俥S5u%%E@/OZe{LY))BR`	\nQCLyh783\0˲\06!N\"\$[h@aZZd\"\\\"Vg9[)hN`mL-՟fЍd oXh\"kӸsJ\"m2N2T.uǜyp'c)(ݦ[ɶ[`g;SZJzK&jZOp	ɧ@˪ZJz(Ӯ@{8\0_Ł\n3/|u0K:IV:YņEmRfn4fow1rN2sb0ق<d/eGfZXɌ<I<,b\rǖK\rJ\"H+q-wP,\$߫%U,՘@ӮLiT0K2yiĳ=|\\9wā2B5\n\refJ]ѳWGyb'HQ\\\n@ s#p8P}}j\ro`\rE RMMHJW nt\r*NoCMCB\"_HkRN#]d<.\\Xe&_G_n%9ƛm4\\Veg1'ao\r5p|[\0М@h tPbgӦ|)l{)~|̙קsz1vtFF)XA4y/g!ghNqh_j̏k+`0woSkW~,~P<3h~~DXE	\"ɺkRb\$BI!IYxF%FTg6-X/\"RmdkXQ`FS?V7Uвp&إsx@o|?MW`iHBC9꥚e;3;HP\"L5	#^S,5`#\"NɢB,\$o&n;xZ-]>q1 he:\0\r[\"*bw&6Vr\n>󹑭@SȚ܋>,43Y\r*=|Rڍ09il!SL\$`dN d%252(VBA ]E x*	dF38	{f(^>H&Mf^Mҙ\0]B\r	U*nPt`'?\n|,`:{x=8nHrFƧZpsO\n|	QN,O\\)+\n .)\nhY0,_\\n/\$CۄX\nP(\n`X,͹MpҬ++@ƌ8V5yN@'#dH\0X=	kV 	BAPѝ\r(Ydh~qb	6AR\0Xg|\r`\\8H. NJq2\rԉ2[P CJ	V'K[H@KMtT 	V=!%' \nV@!S~ugDWmɗZR-kbr iƬ=08AdLYRS!\"rxYC\0CF^{xȐŸ\r\"K=;A\0t L\"וEѧX#\nƵ/|<CWt^4v6R\"ted)^f6l.&`G5%RJMIB#9T-D\"FXڍ1~ߪJ.-jb`{hX'QHtzV2G!|K*#Gխ~cH1\n%`d3bYxnIȕ`ǷyILhB\0=l!AzS\rMHb\$E6F~Iȵ^aKOj*a*ϓt0-2\r|2@~NF6Ě('`\"CPE\$ep7R^@&/\$Rz\r\\vL?m\"6-\n`q\$@I!҄C움'	9jKv(6\$?[5ʒ#DC%)7Ŧ܂r5N*A̎2쩘<Bc-IR8^!QV]CFBS/zc&@yI\$35Ոl.HlK1 s\"5\rҶ\$)kQjJ܀E.7v^\" Rn%=\nto8^68@ħɦQ MxK8`0%T3 iqɠ:E\\d2I>p\r8Yi]UEd`ԧ^#2dEb\0cL/Y!OTĸ˦ eh\n`jypxB`ð+@4T؀igo\0^PSRumҏ(gߙܥ;5y̴9,Q4J9q'XݼP#	q8?%4&q.Yͤ:q)v5!!ȅk8ʀ {\$IKخQґٖж't0~KYcH) |+&Z\"@\nB DE{#eHL\"V\"y1 j)9ب6iY>s-hЃϱ\0^md9iz#'EA@)aX Q0:F0⷟CUn[bʳ+iHL9cv-!PF+d(K\"bdƄ@_C %|;PxuoxswD\"GGcoV\"<@2}kp%\r \"\0G	\"\$4CxJ\0ay@\n{CkMt4S# ȰUphxdqcZ\nG(>Æ\0  Lk\$>`@LǓ;6A-Z\$y, @Z~V5rBy `\$+?I[RT ?],;R\re)(.5P%TS 5\n'킦U>[:NrAsJQ03?0T,%CU5D;)QVPŕ&6hB\\HVX0>XA1[I0ؘZDWR4kI,æRzE'Q;`-4xkťbtTx`\$A(ܗM-SLe\"Da1T\"-u164yQqf\$Ɵl|(	/VuQkYX&.U8\"	j%fme`syl%<ڞTARMPK 3τK1`e)QD@7cNHpOVah  PJNpĞ\n3+0gꐫ@QL-SH<fM'%tIc\\-Q2uRjers+DP&{_u*Wt'itaWSOTtD[-Jk\$-%~bZz%6 C E(,awI][VƉBҭv7\nȤqM[b.WҨN_YdV(,\\lb'pLdNtdƢ/13 LFx2Ap~1*(3 T91B\0y\$a\\9?hj5Qؕ4lGo:-`pODbw]qRv=&K@@ԯj\"HAMd;zG@KZ쑔YqTrC䁧lejEZY1tP*8_n[8]\$M8V?.PEjC\0	IX@ \"\0P\nRdvYL3(\0:)mii	94-;PTm8v*DC`\0aaV\\ tANp\0_	\"\0ÛUӡ,IɝH-lm>۪\$e[pڎ*`Q)SkS`:Tb;n+v	w<v\rO2Yۈ,o=ʜDt 8QPavf~}W#eL( )'#r\0'	B1G,)TJ:I`h'Bd9YP*(\0/W\r\0W{0>]F(cK*YT5FZއx0=p[++O.݀V*QFo)Z-AQs\\>?>d=tg1Z2L6\\҈x2X+5ˀΊ2&nI\\;;]i\nƔBBN)@=x)Kpn2]	oǩ`AK^	p+gVA۵WGHs>!اtv4	3\\	`nK],!AS|Bse`1'Db`bd#6p.aym\$=pXweufV݌UH%#̽\rm(]\0LF8rE]\n2u7ifXu&&pJWQ斡 /'6R.cxŅrUsE̎2_UNG\0\\-Qp<W3OEN!Wdb2M,{ty\0g\"ڮF(>e%@K\naVrö)3U&zB,8\0-\$TWrlRYQcpkZ!_f!_ (2ðQB2ٚ*5\".4'=a,*h[]臅mT]J;\"ݳ^P*n>0eNw̵r_WZ\"8+J`RD8b׷ӪX.:U\$jdB\0ApRsqP-./F5`UBVFsz3\"2^`05\0&E*hr4`j`e{C0A\rM/L[s2QBfIMsvA*(!2c\0/ps,' yO\rE؛Ed2q\\Pr>J𣮕i>U}ɾô'_ 'Gꐓüft\nJJyP۠TKU142GL+Wvd?-^A]9CI6Nă!A#/\nhb,a]`: kq`\"d@4c4*I35F[m*aF\n9VXWDX\\A߫L7Ri؊.:mBDB3]ALj?#beЀXSɌYe\"hm4kdc3QL3M<C}鮀'y~Fվ?;B\"Fo_\"ղŮyȭM8L^Zj#Bz.tNBiȯP.Ck\r~þ-(a\"A%cc\0B'4A)#G&=ڣIA\rMe@35x}\rc	&8ScZE_nUJI~g93\\'NKZa\ng\$I<\0%fKkrFgߐ3&mI;RY!@oN!12 &=Θp*{hPv٨fM.	cB;um;p~E߸:DǋM#6674J4Kđv4bQ3Bw+2[V?&-sɞw%gGU^wiuCHZ\0;rգ6#9\rN`Ԟ|aضHM:[X^x	)v1`1e6lu<#;7cHg.nJmǨ^7`/-~MEMngu`p	D	S]gLvqao(o?wvx7p!0J tf!oiOn+e_yْ	Ħw~\$WoQ\$>#un-Fiw-\0.5AK5/dC8fhkZJbؘzQpVq\0R'	M2Jp>(B\0t6I91s~H\"+gPq-8]y2{Sa\rn)k{hf)F2L3SQg|GZL֧J>H>X?U\\		Œ~	%\"5ݖf-8B,v093(\\8 g}P@3NeiUHF֑<	{F'A)q#S=p7r@DN	Ck}E5z03J+\0X^6G|PgĦP8˻\nv|(NGR>i Z//@p>[wfv^N^NX4Lo}IZEyz{S+xA% \\2Te@ݫU־|h7/fgD&Wf^}Y@84Ht7ٝ=fϺzyJcE2dt|:X{kq\\C0*Y)~kk\\m*(9.{򱽋bTw?:MiŬ9-ZE83ɬ\"z=!5.@'\\m0WjFN\\idA8e>j`0>ºUfm ܛ=*f#d,QmA`0:>|BW&\nĶ	Om3#ŻV,dwS*Ob\$;HbYSGOg21%JJI3事\$%aCSL';k\$XO%\$	1qf2!@cXZ!Aw=Yfx}#1ˎcמ1Pٕ?aD@dp&>2rJh']`_*\\@<\0v	c|z#zyq&;|oY4gHB;s|mh?\$	D(\0DMdQY_xJ(!!OCh7S;WkKg=APXmRJW?7~GK\$c\$}7fRg4gQwXch\"O|y&RFUO.BKqCUG/~%QntWX:֐v\"*p{2'2(9ڦH`hqe;#@~	.!:HQBT\$~y\n_-'&@_6&C\"	;4#?l3܍_o'e<Ȳ\"/'X\0fQ#0nn5#6vHS^8'`LM8V/SR~p?D{/ڇh-o-A|\0k	'Id*~C_: '\0M(Y1`+VAS塓4^HǎVY9C҇> p9jCx\0Z\0	:ZZ.Hḡ!J`ʂ:V\$pmȃJx\0V% f	m@̮Jĩ(]# 	{oH2RLz:A|y0\"4RT/?8HRq!X&A`!MA\"lL ?&\0&'h{,\\!AVR)(PYOs'yBÜ!<o>\0\\^Z4Mh~0E5F\0azJ2HAb d4PˏRUv2Jb0-b\rA:pvhs[#Pt@8PAzQ4^R< #;psy\$[FS(9k6p_PVABm{*0h `A6)4\0!Yd	@YHB.24Pln'\n|l)AN(9!U0RD#t|*5poҢJ<T1YB,\n,nAA;!\0\$м\"V|-AVz2Pp\0>vh]0u\$(ZL0kd	,1!D VJ'@̩`5dPͻXEnՆQP1@l\rˉ\r2),.0:pXWk؀VPM\0W2ɝCa:\0P`Cz\rJH-<\na( uga!&\0001/i<%ȸڦhD̩XS-<AH~i:,ȰaTkD\nGb 1!.X:`RL.\0kr H[-SL\$0VH\\ykOIn\0*BV.DXH#X[BLk0N0c&!J5G詰< - 0	S8#!	Ԉ3\$	HH3`NU0p {xr?PATOnr*[%dKadJIV\$yį[DC#	BXTE2\0004\0ua?C-ŅRN\0NLb±,-U8}Cčhf@|	jxx%D||R.[k6Dʀ*'\0de(");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%23Hb2&<9R(tTH	z' o>4?\rZwӂ4`Ї鍆NӀ'-I0(Srw,Kr'-2Hlo-U_'W#'/H֟j6̉ȫ\0<j1EQTTrBcm16͈g٫:w6ͯh@1I:2pL/w:őK<E<J76Ӏs.̲sZ/\$AsEyϜrr:w?Չ!?ǙZM9՝\01?ARͦ%7>MARr}sr)\\t-8=ЎU,WOCsՆ#w5ERlM*D1>]gKV\n\\s܇8͹seͧ9so~w4xf@D96\0	@.@9\0C;Ky+J٥u<\\`c{ӋE>yJ=l/-7Z46uC5PΩRVʳlVaNx`մ?U7(HP}jVJzNQJSs-gQ!aV_SwRO3amZXwZo'waOoZ![\n<ZOҶ'Omo[a=Q>:T\n\0=mjATRbu(I:\$vWuS\\V8v\\g!Mжu_&is\\CRVM]tXT7\\UoTo_ԯݛS?alS-LutZGei`	}XZi}QyW[iTYo(ZE\\}nٍifڋWd%Tpu3uTf5)v]UR3VEY]X\n^VqSS}XiGfv>SvJMQvڕ\\g]QYEݵ#1Vl5UEK]\0SU?\\BwSU7mZV5\\Wfէ[eUr{G\\U,W[]xVj5mTVj~u7\0VU'tw?ms5Vvݏq}u-Uq]ݗc]W]Tt:fMke][-p}^I[XDYVdO]	seNZWY[tV?3ǵMݙ`t^wd:qTL@@>]j\rFqv-LvGKwiLwIPMoǹMgv[Uss~	w:BANE{!-do\0}&hXA5%٣fzLH5d Y_%vә!m]%=B>E [#^}hYFa>{gSp[FDa6nx98LI㈫Na=S@bPk.NHl\0:2#Θ;vO}9ik]	&{ 2|a&Q)oفǸ:&.\05q\0JL64hy3ޢaރIzOﮈ\"yBʳ{3%5r(mx.7rb%^eM2\0x!b}.Y6\$qS\"^|xEaXǡ59'TR	c9W1AΔP؏h6'o-pT(\nn\rŐ1RRUgxPe#*kT<<>b;\0gL.<kZvz8~y7Yȁ7wOdn><E3wSۆ@ oW1Һze޽1z\0f=c㊤g{>np\0Α:HBn6FBrW=C>M.1~@3G98q<S|Y8QP`L[qz۫PN<{_-ٮdOd-NB74BN.V9ƨQ3{IcP\$h<R yy?G:ng;Ah!&+>ˀ;Mˌ	6SNڌ=#`T#+n;r,X|#\r#?\nD>|VSeϗ~Jm99\ns{S|r],~˹ qI?\"|w%|j\0rE,kSnqƕd8B.1\"/|؃]EϜNlxI IcŸ.|\$8DFPK3\\jxUC/җA{eܾ\rpU\n՟Wlo­Y{`]'s/|o3r};[nOM7ߣؼqq(_lqsNy;igt:ՙqk{?zMȗo'jcy߄ggkwf8Vc7fAY+Kx=gKAkT,95rd+Gٯ[%Aw柞7ଅ%{m8%_mqV˨_%!Ei~h~C߭~%_rLkDy~?p1O!?v\\Pm\"<E6 EVzk9z~/պ!Q>ONm3r Fle;M߷Ͻ_a!~Cfb}3 Kf. 	}.DX	i5|?=\0???@Õfu~a^nyQ;q)sS,\"G\nu%UYAKl\nBI86VCcO\0`}.x,-N@~TG'dJy1zlæfgABa!M\\<gʃz4ƿ@/CÂ@	Qq)x/.7inD#= *79cFd2(.V3\$g`A᧋rl|mb/qEô!bU@9i;ppdפ=1yxx	=v=(vs_Boɂց#K\r n\\# fPXu-3&	J&,F(9v0&@khZygCԋz Áhi=s9T eT>g3dtF2b&:\0PB-Q8~LSMڷcgTh'f(\$.EVLAIߌrg\r0T1P`1d\r4=6@F F=ɂ6A>NAV	(\$A/;?gf^	\n&KOn{]g˛8cўϷ\n7Lt:ѠhFVO\rJ)b(\"OBm	o\$]TSHZ^Kw\\[A9('لcۑb0 KsrBx\n*Baz6o\ry&tX1p'^M<Cg`48GHzd?gX.@,7w۞:+TiUX16Ls:\rL6fr\r`t67~gxgH9JO=-\$4?r٪4O:z{D`21Fܵ(DM;&́ڭU>I6c߸@\r//ԕ_H\n7z 7aɻ[9D'}BORݟB#s]z!(D@L^	x@ouOD!e`\nak>0`-*8EZ6=f%c㛰K=F\rShyN[v*v\r@#߸퉁Ah*L\$AA\\%*	p\r*==8\$W\r [Jx0yZ+&YHA~A\n,\\(p!F<6S&IP`6Xz+df\rJ£is+&5/rEM^\$R(RQEw3lH*m\0BqarLBQz6~lB\rI®GXٸXVbsmBHc_K\$p-:8Nj:х-#F	\0aiBs\\)<.!\\NbIw8͹tPjW`y\0&0i?Ҕ:Ia)=C,a&Mapƃ\$IIFc\0!Yxa)~C1PZL3TjC\0y`\\W\\t\$2\n+a\0aKb\n]C@?I\rHヮKs%N^9CL/=%ۨh:?&PEY>5n[Gْ%V*w<gJ]*wd]B5^֢OQ>%s{ԅ畫;WzGi*RnG9E,(u*Ւ×XsR:5;)RNvK(RMb_{F<<3:%HVYS\n%L+{o.>Z(QkN!,:rH}nRNkI		[ӧg֤;mYҳg%9V~-J_g\\ɮQ\n!t\\UY-tZnd:Bʽ*]')twɫ[BUm*r4ؖ*yvvZչ+GHZnP܅|\nT %#\\AX\0}5b+wrXwܲ1u%Cg=Iv`cre0`..<h+H̝^\\jyF%]B\0r+>%Zx %C.`Vn1KSk\rX|[;6H	U@D:޻Mj	Ε?]ڤbA+G\0thxbL`64MޛY#hfD=ew=c+H:.%^\$DZrAzjfLl7o\0-Edމyz'V ӞW	ZK+d(AfyP?xR^h'A\0:p\rd(Vdt	SFcHȟ]rrCHY	X_/fͽ 4 7e6D{,<<Z^j\"	\n+ƀMY9A(<Pllp	,>Ѐ{E9&Ghh{(Agg8(@jTngZŰJx@icՋ(p'oJ0MnĀ&\r'\0Ց\rqF4)cL_oJ}5co|6m}Q4Qb[xm( &@;+򘥮f|IR48 {	`k`ur`W㸱`\")fI\n;8Zjg~AΈ!j%TE\\\r3EjjFXZ	AykHXdgCQ΀0dt	zk`@\0001\0nH\04\0g&.\0\0O(P@\rE\0l\0X\rE8x@ԋ\0^z@E\0.^Qq\"YD_p&3\0mZ.Pp\rEϋsv\"0`w,_`\rc/]xq3\0q.pq\0002_iъE\0a1bwJ \0l\01,`1y\09#?0T^q\$F6/\$dFDyJ0b\0	W\0.c{c E\0s3l]@\rbF\"\02`\"7/\0a	^04eQ{c<ьj/_ѐc\0001*28BA\0000xƔiؾ1F50ljH\"F30\\_q\0fTl_0тBEČ#3]sƽ64_X1\0ƽd``\rS_JMV/f1\0005I6tf4F34fF-6d\"4k\$h±#Ě\06_01c@F/d]XQ#G\n5gqEF\nm\\DnqYFv1/4`q4=8bq|\00043mX1e\0.\\QcI	.7\\x`\"\0i^3(籒\"Ev4l_q\$FoȾ\r#UE䍩^9t.\03|r1\069l^xѼPF-]\n0vQy\"G2,sxQq#F+\0/Diq}8[6,j\0cmoN5ehQvGLH<T_Q?Fɋ..\$fyEC2l1s#EDlohѲj8eűbF!9`xqC7hx٣Ŏ7^xK<h	,u鱑G);lu#Eߎ<kb\0sR.wֱ#z~w2|x(\0001':v\0001G挿?|` .2X#G8K@<z1ƹ\"9|j	G/6qGs7/\0001bߍ:|8Q#~FW4g#<F\r 2XQ#Fvk7x1#Ǝ@rhFZ;frcy!\r	_x1\"H10Twٲc\rF1 \n8dXrԌ2Db{d4HrA<~1dBHI[J?q~k0t#F\r#0\\h\rGEttc7U!=D_cN\0y6a Fg!v1q1KǇ@eѳcGo\n/ƲE\"3t`#cH<cqF%?Tb蹱d) r0qcE>3\$tyQңECl`9)VFHMJ7f\$HHQ ;ri7#F-FHQ#\0G!1^&4vG&7gృ\$\0G\rr/dR(s6@'RAǬ&g\0k z=|Hٱ^J]sd,\$1<cqǦJ_bGQvJرH5FpIc[@rvH%3Dc<I\$M.dr1c=F.4c2bG.!L|{Xѳ{INFdxqscݍ#Ea)#GJm.\$=GhAN=sŤE͑GG\\a10HF.tg8ä[Idn8F.TF3E6riqsF6xrL=nFTod>-3|2\$0= :xcHI\"NP\$bQ\$F DĂ}F%?(G3\$O\$^x2T0R#D:E|i/2XG8-\$Hv=d `:laxI:XRJRmxJ#\nGG9!N{cI&IR=I\r&j:8g#H'3_xbH}>7cُ\"&K<x2H\"6@db뱭e;)!.]/dm*f6,vɪL(qAI87d9TtcULX%HI*z:|IXqs-Bq^(Raq(~e9JU+-eq*nT>\$ѫerαp\nռ\$es+VIbeq:#]cc7r\nf,gYTC%	}\0\\*EWPa:E,&Wp)xlM3\0t\0/IipD'\0	k\$TF]fdMȀK\$H(@ɔ(znWҤ_Mݔ*\0elF^H	W*BZPe֘R/dRRʅ\0Ku,yH)\"SXI'Z=LR3\n'[k6@;}RI_)w[ \nnʓbBrl,\$v԰H\\s*.QtBdb@?3S`a@K\\.~f),?|&ӶKZ9.X+S|\0PʼEe/\0V^K\0\n-	:Sز)ת0j9TXBK\"ů²,2'2P,xpKꗪ\"D#TVD1Ao;ؕ/9TH%V`WJ<9aeʰK/V^/Q\nBZ\"9XүM~\$5\$0dIU2^X\n*E7I\nV3+aIiNKKg0az*V#bJyMҦeZ V`U1C.\rF-j&LUp9s鹊+Q&1RmӱgZ	,.XryZ첰032A1ւeN(?Al ,Nue\$|r_%E05E}\$X2%Ze \n\";<9ah㶥a]8*uLdR0+Qm.,GM_2edBݸ,S2>U԰4vl~e22eĵYg2nf=\$%ٖFfa)fTƶGg2W,[X>)tA]R*&Z6j2|\0(p	9 uҪ?`n-lZn!H9zL9VLϹyݢZJhRgEfLU~`4Yx)\$BQR#ÕS,6i#Y,;Cri&X]\nw54Kx\n*&TW+SлqNcyIW\0W5cɫ&+Vr)Kg? |gRhR%K)Z#5,ֵk漻`l:LsC[MUB6ldѓJ1nl:jLߖ\0h *)p/ާ5\\<9V/ޫhTdjrMbx\n]RWR MaU3=`0o,Zl}m월lmLS6\\tΙL\\%JK7oѩefMoCYv慭NV4=RsJ*hhn-m44yHM|isU=A\$ڭiϙ>ppQfq,5sUL8}ݬ٪#XHI9U8c:If7kl5}fLYN2ް}&	ic,I3R6r؉3b͍6>lXYfL)+S,ى*elU\"ed\"Zږ6ZDE9%΂Y9rmtE'.M[4^ɷ;Mw59av+70ld%<3_<lN(v+7YRl΅Ӫ].4I)=փNT]۹'U^?S7XCũӨ1u9EߙkL;NhSqNXk;1[LgpVB1_gs;RlENT8w,s1Pxrq3(;Z	yӾ'{O	_rȪMg|I92eLfO\rYnkuSNv9Vk	3ǧ.̛v9zyd)NY&s\$jd'6͔Q<V)e+:جYjtpu<ʖ3]qMY:9XSgIÝ*mCvGR@֯jT=:e(\0_Vn,?p	3'Π\r|\"igTnP皤\nӔq,Sf.YQ AA,ZeSsE\rvTQZ\"pIsUAϛ\0vZ}rKtfPf9疮{^Jς\n0%NGګ*~lD.Ke6[,%O՘-~쵕jRO;@	˨enb_%sKŜYY0LWjrՐφ!BPvfwګMR22z4rh;#M@}\0|M\0=ځ=f-!6pg[P4C[5:\rCtàu@ۺ<ifNun[!u8j{&9KuFQlRi(CA䮙s4\0Y;fB<{嘼R_I~6|MWTA]4e@JeP|[r5*OΠBt)%-\0Pjm	us}ИBi^*z0YK.`[Y2Ы|XB(?З.\$l,XD\njOD->_<֝\0sh\\ea\\\0e䑙Y`7U\"eCYTzt:V9P_aЕF;݀\0M2eHCZ?V'}cYa脬?Qh8	0QCM`6,JeZZ\"GWuu\r>49KI%LV9։Z{VEOX;oagP\$\nRX@}!-SiRqz	ITH.\nk\n\ndϮT>\n?E`5D+f?#zIZ7T[Qs#D\$PI	3*:9YIHHX0D!u7JmYB}E简r8Q\n}'PS	Q\$`R)^(OP\0aKm3\$H.X)V`9 .Y18eU`X9	\\LcjIE N鍫6WDXB	Z:|Ϥ:	E-P-&)*l)Puy|RLh.p_*QA@ ?,ƧY)tч<P*jVuQ:2\0L?J,TPHLE%\0yP(YJZTHX\r	Q4hO;\\vV#TWw\\`Oҡ?JR2=F]I5TMjI9,(ƤDv|t)Wy-]zea,pQ6\$I-g=%SW#TPܐ)T&]X15jB8Vӥ\nem yh*d4ςbd!0gRJ\\ Mt1R\n\nx._u+Ƽ;*4θ)]\\l(m\"QnT(*\0`1H@2	6hYcH_f?a7=KKdetH2\0/\062@b~`\0.\0v) !~JPĝTO{t\0005/ீ\rJ^0a!)8%KޘPP4~H\r+Lb/24)GKe0eS1B	-0jfSwLΙid L\r1hȩS MJJht)+?Le5n|FHMN5jɩSHL4=TDMn6Zm@I@S`)'7fzSzx~OU1kSFMOU4p٣2\000076k#xSl'K77\nlxSuLR77stxS}GM78*qt#xSOM\"78u)ӏ\09r)Sr2;)7Njm/xӿsNڞ:jy4SgO:1=\ncTSͧ;{Sȧ/ORH\r=tTIݧO\\zx4SM>j|TiSO~\$lO}t٧Oz*%]PPvU\"ݧK@\nojH;P>1FdP.5Bظ\r3uB<L#<QPECʁu*\nۨyPNl\r6?KmBZijHO2}1JM_MmD&KQ6Fzv6ӹQj;jj)*mEʌ9FdQv5eGɵdԄEM\0+D\"j)SDQҤpZfƂmR&HUہ%{Rv0m0z䧟Lƥ@'ER?eJ>ԝMIYTR/Bʕ.UTYRΡL:jNԅRL5ji&,OmJD5,9Q1hTfNޥQ'7Lih\rcjԝSzu\0nԺg9@c\rT%LAfTMT9uQ\n)USuD:jU	ƨPږq*EڪKSbl\\ڤFŪGTzgJHSF	\"Q:1;RꦵL*~EߪoTҦ\\z:]SꕱBU^JuR*kE	TQtRg2UjV\$_SmPHU\\T[Uʫ5Jhٵ\\UpV7a_*=R>\0I*VX:hU8jTKZ\\:)jT8	WZUbJ8R=YUVUR\\:-jѫiV.[zҪ-{TZuojU3 [>E %\\h#bՅWZ-\\CW>]ںg4#KTrZʤwj\$z-RjtjU*Wtp\n4'NMxUX32[x+\$BUS*qUͪqXZ}Sx@-W\n5XZՅJU2=\\F+V0]XXU0-VJ+/Zʮ5sjDU޲%bɵV%Y^u@dբW愔ŲRk&YR\\ŒRkYcVO-\\	kdKoXK/9]VO-U<@嬥Vγ[6U=eϵo4TݭY0eHդ\r96(󮝕+7ybrI |\0:Fz\n|s<R%J]F3jΣYZ^<5XIJM`nO\\B&rsQuzx	TVwJ5g	?vqF49ӝ6zjOV\ru=@ʒfT͚y	֫pKaXU9m\nekMo5\nhTꦦVv:s\\p>L:)O=nk}jS&֮~yeܚZֵ)jtVRVsr:+ao,!TlUϕ*n5\\Udv+M\\)]B|Jl;45pLӵئ7Li[~bmtSe\"Bvd@ͧS4)ؒZ\$)5ic!Ό\\R*SDw\$9tS\nGfPԛʸ*	KDVy5uȦJב\\C\$W,M\\5k^Vs5kֻM^{uϤwFQJHgWNk8ʉ+1br˕VX]dLjYTv6twy˕kvx=5h8]˷x\"c|ufU\0ҧ5jȩ}Pkn̚Rlf٪+ۣ>c4W+TDoqSXb}}hn&<?/3-áhqn	p%)SyP\r͵m-f5[\\=T}y )Ydؤ46#Y>3נm\n09h;40+ae\nȃİȞ!)@xx}\$AFÑ0N R	ӄiܥU?b5!+׭\0Gw{ӤlI )w-4;p8ؤ;@\r\n\rN5ƅF\\ӹhgPE il0X%)\nLk^2<5FdI<FjbMd'	ƲDBmaOYXgg8ZV%mf%F-,\naFwfs0G乑Z\n	1;J1\"iPByCtzӉ;l4ҡJmLX+lᘪ{8\"\nV(\$Y\0d\\݆6D9BHd%16f \"TJ`/>C=c쨱?e!k*3l~i,Az/dMoڲn\"ɽzTr}eٌ{MaC7fiT/6WP8Fa`5Mf2V]['}cn4]heZŧ\r2XllGa`((\0_lOf&f1c8D{Q	S6p\0Y\0\rq3m&*f;p6r^cϳ`ɵ&zn^ڱ;DSoj^=L'g5&Ef&|\nK 6?bX*.fψE~&9!dk@v\"FGx\\=E7XP2[:\0׎X~7X64(\";B\nXhy&DֈZl\nKCp`mS	2U;G8{-WBm\$F\rl&BY2\rmAőwZ6RВ%d_T5``BaGcXK\r\0gN\\;Ns^\nuѲVwzUF\"\0T-,^\02 / EW/\0¼ľ4;\"K-NZMcλRVNeZwj6aÿKVlN?jt2T/[Nj|0t% #\0`5F<X@\nӢZF\\-mcd2p5Gv'B'7{k*'LAZ|Ik\n-.C6k-Sk]_\$+Gנ[^z]k8\\F|?B^B̎|@BzPW/R?[!bBkѠ'	(e:xfr7\r_qMa\0#7|Q&\0Ɂ@)1뮆LA[Pt\0`6\\ezxS݀vՈπU:ڱTϗ>f\nql+K(|\\ѠGU؋@(*iS%F\rR\$CL;dļg-\$m?lhʝ3?PY\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$sd=file_open_lock(get_temp_dir()."/adminer.version");if($sd)file_write_unlock($sd,serialize(array("version"=>$_POST["version"])));exit;}global$b,$g,$l,$nc,$vc,$Ec,$m,$ud,$Ad,$ba,$be,$w,$ca,$ve,$yf,$kg,$Oh,$Fd,$vi,$Ai,$U,$Pi,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Xf=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Xf[]=true;call_user_func_array('session_set_cookie_params',$Xf);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$ed);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$ve=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lv'=>'Latviešu','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($t,$nf=null){if(is_string($t)){$ng=array_search($t,get_translations("en"));if($ng!==false)$t=$ng;}global$ca,$Ai;$_i=($Ai[$t]?$Ai[$t]:$t);if(is_array($_i)){$ng=($nf==1?0:($ca=='cs'||$ca=='sk'?($nf&&$nf<5?1:2):($ca=='fr'?(!$nf?0:1):($ca=='pl'?($nf%10>1&&$nf%10<5&&$nf/10%10!=1?1:2):($ca=='sl'?($nf%100==1?0:($nf%100==2?1:($nf%100==3||$nf%100==4?2:3))):($ca=='lt'?($nf%10==1&&$nf%100!=11?0:($nf%10>1&&$nf/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($nf%10==1&&$nf%100!=11?0:($nf%10>1&&$nf%10<5&&$nf/10%10!=1?1:2)):1)))))));$_i=$_i[$ng];}$Fa=func_get_args();array_shift($Fa);$pd=str_replace("%d","%s",$_i);if($pd!=$_i)$Fa[0]=format_number($nf);return
vsprintf($pd,$Fa);}function
switch_lang(){global$ca,$ve;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$ve,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($ve[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($ve[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$wa=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$B,PREG_SET_ORDER);foreach($B
as$A)$wa[$A[1]]=(isset($A[3])?$A[3]:1);arsort($wa);foreach($wa
as$x=>$Bg){if(isset($ve[$x])){$ca=$x;break;}$x=preg_replace('~-.*~','',$x);if(!isset($wa[$x])&&isset($ve[$x])){$ca=$x;break;}}}$Ai=$_SESSION["translations"];if($_SESSION["translations_version"]!=2531682878){$Ai=array();$_SESSION["translations_version"]=2531682878;}function
get_translations($ue){switch($ue){case"en":$f="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qB74-98@1# \r1<+PGFPţ#O7Ct\rd j\nR[z0c9i.>\0\r*Û\0xC@:t<\$s~8_#M9xDjΞ\r22-xx!H㌣ͮ-E\n;a!-863&2]\n(OYĜ+s	cx<?V!<HKy^6%(6X/r\"3(0Aߍ8`X@P:\nMc8΀>\nK84N`;PR0=5£\"k5~5\rncP(g2411m5h̽g2B [20{Ƿm\$C\"}jB(Q/(4`4Tj#\0@7 B,Y<N2r/!5~/2\"'~HR?dH2pH	Z3Gm0PK^mn*@)j\nz5]<c6#L\r]iCQ`_;2#eeji~F]&J_Θ`:t}Xp\r)F@xQ~ŬRY0 S\niN)joTS*x\rzV\$vڽvpMRBf(k'2&cat=G	\nq[GD\0HIPdF0rF0f_k*	BxQCH\$`b;-fڝOa5@\$>\0\"Hˌ[O|HÙONLh 1>Jϲ&ZTu3	Fآ<) bn,I~𴕒^o?IJq!>)S	գ\nP( A!|k@@C*\$]a|{|Դɰ£a3ME0ӹʆpki!,rǌi(18cQDdF\nx2o\\f(↬IًI0eKO	*\0BEUh@-azK6iҸr(ѰV;G	协4>)eg8X#T{\$bw)1f\$s`SIaKMOQAYy?\$07>0a37'd/)4xe5(*m4V0g.KىStdN\nZX4KF\rk|S =](~MaU\0T)e\n* ai2(E~l!kE=݆4(Pɽ	d·tc<jC	\0+<S5FH`\"\$&liOX/`L\$O-`ry~]H1@AK0.,+4`MsfGJ Bw2vJƙCuϏ⛓D'܏%a)8(5:WP\$n@S΍dvKXWǏp\n	P}1vr趄:LY>e#5	<S\nŉ;;Q#{.ˮd1{-5Z~ZynN+xM5(\0bNJȟ_ ֱ2~	 [XSC~\0Pkh%t?cn{ ܹgd9\\Eb52\\v67TvC|tΤ9Wtl{0tvC؄4䅑C6]|`\$)b37#Q&]vstl.lςKdFYSCmV_P>55AF<Y?9[hh9j\\}V/\"dՍ4*0?Hʔղ9;z*jjA\"ص<ꑳBblO쀬M<?4L{	u7[4l*GC\0F\"Ʋl	㐄\")*bbP5.N\0\rLc(`0dlsB}:D\"jYPEb\0IjmCg%ifn%P`//'pPY\n΍'5\r,\$B0l!\rDA,F\ny\r捑	?\n\$C@M`Rpr\rbL\"쾂Q:Ok\$7\rB<7\"2.\"	qCQF7M1PB\0e\r \rol\$n\0#\r/'JhZ59O&M K(Zs4\"gd3Z˯n4K\"e+&6\".GVQArEdK@gĮ:+@Pp \"Z\rڲŔc6d1LQ̽Z.r^ܐ&N܅6\$ܽ\r%<K`tυf)^0@9ˠHh>i@9@	h.ha+@ #N%Ư~Y\"vm\$0z=G\r0Tm\rĂĀD	zE,~л \n`uJ<t`)DJ\$ZLM*M3S8j>";break;case"ar":$f="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o{\$ð6\r#\"74A2(:\r3AqKq[!*r)ʨxQ*XؐeJ	7&3ޜ:ñ[+U׬Ҩ2\rTBPOp6#oPlZh޳\02\0yu8C@:t6eA#8_E!xDlҽC46CH7x)L[LSrY23,2NADʖ^lլJ_IiSZɻB9\r8!58C~2\"ܠ#sȒ'g|Ye/J]UJ\"0:6+/uIJʊ'	j>\\ᱦZԏ<dRYMլlO4c-R*RQ3\08Mz61#u4I	Ȧ(RV3U#X(g>;KkƼa|%+uZ,z߱Ve}FZ-0z[}ACrs	 0דB7HaiōO	1TRt\"&C_cym--CYP* 0e7@8LȂ:\r* \0Q4\r<҆	0Y\\=v	:BMP7@ƣ[X5&֚bV6p9i\"NN,Kh/Ɨ+J|'/bp\\\\C>xKJ갽FFV#D&a5Ø@8^}/w`dJ91@C\r(:2GA]	͐@rJ]H%'a&dA=虅@iVʌ?\0iCcAir[Kp38\0A9ޛIFPj(أϊ6G-ԪJC[u܇%ZjC@pT4Ca%*ԡ!R=g9u4:7`7\0j!f1C:\0\ny'!01DI!LjCFyd\r-W\"WPK#s!GQcAE(%]&+H]y'\"	3	\$h<PQSp5\\(sBA=QJ\n-鱊5+%BO\naP_!QD2yD My9IN3gRk14l8 e\0xv\nX&\0k)]a*ZjlgQ[({	]&G@\n	8PT@.2SWU]zU\$UJY|U9BؠaRvmw`(pIPD	0j*+l*L-&GNh{Bfd%z3dcUyFC,SU~D?a[F*{bl4i:Rp;^}qL[s*V2E\$YCHsfXHzpRhT)!\"P@Tf҃\$\0T{d@k_4dbBM)kmἌ~I(h/&JPJR.d*^8e&A8&mFT&RЀV)RGϦ.Q[̃?|?XNtJ0ʁLBH)-J\"\0gK Ul8Pݤ+k%'X2~(^ XSEl\n&^[Bn\"\\y;UǰG*4\r#D&+fmRʼ\rxJB ;ĽgA>>S4xkY01PBaOԺ*I#RNbTeSr?J)\$upl\n\0w\"`5D)%NGs=3zH-yy XƎ\$?gc\0\rfB&S\00F/?Gq	.n),lhP*bffԊC-lM`Be6nİxm4I,xH[k\0-+\$R|H@%+BP\$ΧэZ*BB'VP#}^-p#\r-~P\r\0gGQ0|@{%2.E*Z0oE|è ~\r\\,˼1IĢ&m	B0#!r=RS1u`)찦TmP>/PB2h0mNM?`I*:11Vi?o\rQ\rg-D\rd<mN/qDqq1`R'?/W.ǭdsǲOm2Xd#Hf{=%mEW&''%Hxq:rI)vl\"o֒nTFyÐ bOb~\r'Җe1L12(<QK-r)Q2M|v%+.a0mp}/ S12].RIC/ew3<{I1S\r3>U,-3sJ%R\$\nv%P-..N23C\$8.jWsH:{ӟ7:dLy83c#%>18\n\$<i<01*Y.#vn2>sFS0Pb22\0n,>Enr&+E i\n.\";&`\rVk@`Pd]gpb\r j&`	.ŠZ\n\r\rb=p\"R v:l\$n&4F@Go]/='2:\0E4LMTX?	0&.\\#0[h(R*>1Ntbfg\nM1+.l(6;LأSsau>G)T@Cf4CHkvjYewT^;K³&ls.kTXAPpcT[<xG&Tu^{Buςi!PdcPS1YI\nŲ\r|&Д ڝ8lvND:OD\"l>\rQGL@5U:@P 5cvR=!W=6sϨ)	\0@	t\n`";break;case"bg":$f="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLH	#p0HȎPEa\09 7Mh9(,8B!,V-SYF46*e>HK3!uI\$*Z@2U\r,	# 4oc|z9#w1_q4@:9Db#E3:x\r~EtV3_#Kp|6q3Ecl^4px!k9)-	;%]V}jʣ]U8z;[v;@O;DKbUr\n7a7@:\rj8C2#`HK5]J䧔xMU3M(B>H;hfT}=-Zh^譜9*2W876𝽬ܾ+0h[9)MݺQZ	\"4\$ҩg0jtߢ~}\$ZBJ?.\rDX\nCS+n@j|e4։Je;d&yMjtL(!)?FLB.PǹxW3^tXRRn!R gYN)6)ųlC:YrJAPraE^rʆtUi\r6T(lsJ݌0PɦJD B`I\$MWz5/	9Cb2!<xkp\"GKrH7KpA.U:,8B·e컟ruE6Pzn\r@3xn_br\r!APΰXBGQ\"zIb77|iўy\0LUIBg!\$C)<P҂	aG<X+`S?S4z\nD!s.U`Ǣ1EuFOҏ@/IXBrc,|dK-f3I4OֺSTMO#!&&q*lBD9Au4ٓ\\  d2X˙2f<3vCs=Y\rBƨڬGFV.(uA`8/Ft3mଵudTj2BTᒆRWѷ*vxPB5a+:1y5 <f0l(3@˓\$t0|XdޑVz7xz1N:!@\$ee~u`\nKy4PtCJu\"0A{J\r1䊑\r1@;+Q}+	V&b|	v;QM+׵n֊-iK`rM&VZ)AE(BI[)N܃m}͛d5%QĄnohO5m(jj\n{K,X 9Zxd<F\\<\0L,2R(Z洟\r@iT9d=yl`3a&{`@+9O	9щr`iSO[JO֟T\$@ؼfTZɡ!*ad	JΒe*З;x8ϼI2	eh~mqRbz%*YYM2GDtעኝl??	!!AUn %FN_DW++&f󫯉sl^հ<XeݮN2]¥k%y?\\HԢmIl\\%a)][(eʒEơ[\0Ήn#>~1A`[K0]oD49ps:o_\$REnx3,qJnIwnW5	X*96>ءF^VfԠhCEv9G\n%*!oK8{coP@'މgZL0Kho0kOFB#<xR|;p\nR3DZhkuQAD'jpÈod\$n>|ECRnΔ&Be\n 	\0@ E\0`FxGĀHER%l&m:Nt`@@s?'DV㌆oR,O̶++\$ί(ƷI\r0-;%\"ypQ%N*6+,<펾Ü\\`9e#xl\"Ȉ\r+jR=01D\"\rp6%HK0GN-[bf&5-^ע\\ZGlG,-o^qgA\0 	z֊ 촆cL\"J\$#Jnô#=k4*o(F#d6nN~&\"p+hª(\\BB.v4QJbK\$*9#j.ʫ.ή~|bcp./va8Dp'O''kHJx#rN):)J#or\\Bxu6kp\\WÂTD\"B\\krw.F+ǔPO\\J&'#.#tuNo؂(vBu˅Ja`.Xkpr((nTn55M6+~m5qC\$q)M%q+-bs#26}:Sw2=S\$N*3:};N5)	9qM!s=\"-օ#eƣUe*?09?o\nz&?\$R@xj0?*ss)s6Q +@\"\\:jS:<Q4W*Bȍ<3R̼%ĬR!˄K7ˏly4&ultƾJ\r3O.N~B(%/Kqpxx3FbFA'oz3\$%B9#\0sL.k4:f!Evl6~jQs}e+;'R/QS_)tr%paTQ&蓐bJy(U/6lM}OQU:Vzo:U?+\nR#yVUUIU|uxob:ar7'7\$JJre.PWHBsAU`eE!)5*5<P#]m-FaX4w\0gUXO0Y?Tn1a' ş*ppu^v\$*#IS(:3\r]`I]Dl3n!-eif!fc`e.g/Ye^W4c_PW`¹g\rv7GI?c]jhh֭,M2U/;g2EՀI+6Ob;Ph龁l)iu-^n>+ou=tw%*;gT5!Oj&o;nַoJP-se(k5%8jQDqt@KUL\rr42vq0{vwrs!BB?; \\)1,Bq@S@upQ'\$5{Z<n\\;|\$'{3-;o)\"E)..Ae7ǛQ	4|=ғ}42SQVRr	\rV/&.p+e,g(\ruMs4QT\0\npʨn,kQ?u()n	!窤T)5A@\$Bʨ)՜2r=gT,?hS nâXaJP:w.ǄdT/6;ǎTR4meGndK*xe\$tL򍊭awђ((\$!&n&>q݉T*Y=7vf9]Ǖ.\rXo%M5OeN\$~[xkqDfb\0@X\0ν'Dd*E[揂͚!Z0+10xnedn9OluHJnyG\"ZY|swG\rN\"]05Ro3)5ЕOt/jv*+p\rԘg\\VjlNyZb\$\\!%\\תɤ>8\0";break;case"bn":$f="S!\n\0@xJ_:6\0P\\33`\0!(l	MS,S,\$])d5s@qD<6(R\$i撦VI\nxʙ+\rBb\0!e4M*+Vp@%9;e2S'	`ObM^bS%UPH)x2S)zʞ4\0h3QL<We+lqr'PP~9.-Z!NEy@h0q@p9NƓae90X4\r/0OΛ(%\0QN!Ί6	Т'P\n5*\n`9z;{b껥D5đ;h&\r(%\"(@;sݮ<GC#pΩ0ȭjbVҨ1䖣*[;\09Cx佈0oX7`:\$OAR9zSE-<73S\"l:Ns	+Ĳˎ\$\nVr\r9mfSz9V;i0hjqֹqN-EDYYs)\n SwE咪ni!p6H;#`2\$S9@1C(2àӂt⪈MTWG5ʚDʷ\r[kv@jSyPe\n皸6!8.YJfzq2\rQtkHt(#rϮj0D=c2\0yC@:t:AC8_LSAxDmˣ56H7xSqMۯ&EKti\"Q)E1A+Ǫ׎2EݎIq,'Qؒ^8Ṏ }Wi%W'Dyp+#ݱ\$b8/1À7\":C\$fJƥLWSZlSYqY%\$6[XJr̀D0Pؤ lx3\\ݙ|.h9VB?_I.󔘑ҽX\0\rg2\$#yGG1g] ]h[Yoʨ!dD=&yٌvpl?H  Cp\n\naD&ԮWg<trDTS3>xY<Yi]I	Fmi\niVjdR:d	9geҗJ	81G^;>UQ ڛl.Cr VECkQh,hM0%MSr>#*f>2c<Dڽ؝'fݘ@-Tl}\$dv\"E)H{U< 6{5t&^Q<ϴ4S0Q>ߐn!%{ω>݄)0jp6NR?-3Қ3%9-2YXjK}F4AnQp)Ԁ<Y\0w+ZTBaI74ib*m7pNwN9R]L	!8Pt[vݽ!)T'cJye,rKQU}N(@z\0zÂs۰k̀3BA;:]\rH\ran1pcW\\IPCb/%\0.tLp*XrF[5Gm\"Ӎwn5,}@np7\0[h1zC;~\npTa2S\0F!خ,_̄XXNq9\0wql\nlgP7;f\$[,*td):8͠VTLDC\r\ng'CB!^ۻNC&MA\$:kR CC3j@3(&Q2>qn!@'0Cdng@}0`Dp\"ZmQ6\$t̔QΧH,&\0}Ym*a<m[Z7uZ-\$!\$E6`Ζ *yh\"ʒ9E.lVz;J9b#.*qҀhWV(DMy%]P0):}DҧQLIc-I	5Se&AHvOETunс%nȤ\r!v#F_txYfR]\nҵqiMq<\rh:A*lHU~{lTC+emg23[9?+Eו_	ت\$Ѭ-|L˷1`=Ǻ\na=CGm14\na\$LXʉiJʂ_@b@@>ixB*UOY(h:I%hnЕyP1&舃N	Jꇞo0e0XyǼYGE)y>{zNGP^ALC`838@(O*\rnBDJjx`'@\n 	\0@0QxE\"\n@*Aά|'%*G;D\"ϽJ0BSh9d^>BXϑṭMnL¢(|reN9N;b#1Ez1~:1F;lig869mUX Cz;F1/.ZQOqvlȹO<Bn	j% P \$ez\nBjRU%:NB\"͔ͯ>eXu#e ox1R/~/a*VFE*gz\r(fg\"G3l.r	vg\r-fňx\rAmA҄0Qc1hFORy̙\n/|0O q%y\r2l\"α-#1DTc)h0|2 A	>o+3o8S\"\r'/7QZWo.}7257p|OS8zu\$' .iuY1.P ं9#.VRl*T(3yfSnn9OuBqRR8z=1\n5233AId&%\0PNN RnڰDS5R	3SNO8B݅EBkBEuH1HI4]IsuT4G7c\0s+HvXtoC.ƕ:Ѭ{-L5L2+>M<eQL'M3'e.XzJNzFN,Le\"g_tmF%wZPBITRV+.3TNxXQ;2OUI-VU8͵j:Ksq;SWXXCtM8ͣ)d\\(^UEH-e|%\np|4ND05uW25\\0GWC[eUBYAlڮS	01\"榫VBY-Yƕ3^U'8S'T@pSηKnSH}CLVqLfgGM}OKu-oT.6F{2YUf͢4?ODbUhkpjvZVmk3vVk%0{j`I0W.@;hUý-pXRBp4HN^Hu	-vjWJ6\r;fIbVklvgt^vhSw]cB܇yXSSosD^wp(uqwsvhw,?vjygidGBwZ	yot®v@.Tm\$g't0	N4m}6v7!G}nTl3-uNUq}B82~xm'<D7WwOЭ\$]ԇz%3x/HwUs6^Soh_4jFu{uuYvOpԷBIMX+WvRszMXu~'mH2VP\\.?wENc'xw~98ZwؿT}iY%P{p[F(]#qhR0U!j7Z xɝ©UIv2o,Th,!.̎8KomBv3s33tBY`ι2 `@g\r \rfOކ(f4mbR @\nZ\r\rKuQ/rZ.mUa'i0ŸI3SUqփqs2LS	`dO6ObS=c_wVe1pc2*⿌Y2zsf@lY&ӹi.褖dTTcs)c+עA38zn8S^.d&y\r8388QU*@C=mx~f,j/suCbhQcA{OMuGXN\"آ\0W4Qb ΅ڲlD&¯<@rJTN:aR9o^XL%cgO3u'P@k|a.j3.\nCAͲM\0etbݮ'Ju)\".nm 'U5?\"'@a`>\$f_qcGpOwo	\0@	t\n`";break;case"bs":$f="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,	#s,(䙎Q,1n.rj.9l:br܀\n@B,\nhԣ4cS=,##M)BB1C3	1@@\rKp*42c0z\r8a^h\\0J+.c8^%\nC ^)ڹ\n(̹7^0%`U2/XP+!M%8Ƀa%x(7,UB\nU`P7Xh1\r:9A/ٮb|:6I) 47083#Lc^#ü\\H5}ƭ<14h2mBb)m#Pꚺ:ڇr:2D`^K\"[&p4:6\r;ލ:.(不#ːL7{/cٸL낈Fޔ=bڪ4Bw-\0;U]*+Lo芝]./=x?IeB'cʝ')x¶9+B]y'WH\n\r+5mI)oYsE2 %1:\0UMbUpOo\n].¬ϡdҚsR!6%RX\n1D2%Y~URDK22D(vK[Jn\"x:Q_V:Yk4;rZbBIsEܼ  K	\$*%Atdޅ˙!	p7j&G5AMSdG*cUFf\\y8ehf Q*uR+3d_e&1&Ӝbr2(\n!?hIVph@\$\0YUl 5,\\Um*~͒\rtfisu.q\$2LV;!02gN@c1:޺]\$ˤ5s7HӽӜgQXm46oN<TJ'T7ISfj̘qkDcM4lj54ɔAO\naRr(Q	 t\"p)Fț32'	pt7bC2*8#IRIq'NP \nnkHF\n(H*_	itF#lpE[C4P*P@\n\rsh94a *\0B`E>Nٻd=GLiVW;!ڗKh\nqn5,΃p\$J6d.uɂQsh.P[lފn{E_]ܷ<1n\$^8;\0[z꯶@Ol#䠈{T:%aqS7;'t_2N*%۹ubhc	gAƖc.'˄D]kDe3A#'`^jvXȍ1wlI`#A='FĀGH7sF&khAAI+)M}+ 62^-==*@@ K1H\r.d\$h(QaANYђ2t0pBG9lI^3dnpA7dJh/-8O'd#qBhw9Gu\\-x%mIڠ%!=7`m'{pc9|{m{y<N>t	2?ݐQ!*w.9Lw	&;]|v\"nbx?+\"٦ޜ?r\r).Jt*Iceǃ|z	)`w5J~Fa&ĩpl{	#ږ12Q&{,}ǽQb{obms5IRKÄ\"\rV6#dtR+d%0EU>1>1i4tK~h\"\0q'%XL?49L7;|c2Us,]/0\\'-t\0Mz'HL_,x`\$Ѐ n&TN*w	GН0E\$Ьo^\$8bmtԐkГ\rqv#^GXblbzp\"\\e\$3f>\$XHP& 1((	 .gQ*I̺wFP(as\r /K~q&`Op1y\rP#(g	S~nF8W\rpz1POqm\"oaQ&oKxw#RB.EcFDh<@蕭w\\א 1!0Q\0	92rR\"\r\"#\"f#rHB^q*-%Lp%bѰ% 8~ʸf1`HQw%\$jb\r#H&ʢ82S\r&Rr*2!AjՒԧ\"ղԯl7Ob\rrr6 C'\\C=҆\\	\r	 z1+Df\$A\rH\0in>5N`\"in223'3@* `\$4&`1F7l-N/3cr3si	\n*3d \"%Kf0\rd/ZkLBPB\0\npDVоݰS\r=s%\n6Hk`\r|+#.>Gm93f0KF1MREID@=,dPBe.N+,\nG(dGljt7'9WEWEN<pf.(h4/<wEh4(d0tGamn_97h@2b#\$ҍ&W+%\rpLDP.#\0eC\$\nC(Ih4'Q0#oQ֧-2l#@ŔxNC..D OI\nDA\nd*";break;case"ca":$f="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.̀7n%BLl+ZF))\$ #.PL<t4\0GRl4s@ao\rZ0#\"mP7@1n=F?\r\r%bp2C!h420z\r8a^\\x\\{hń2\r:˪|EA^0ЊP2qJF(hдN:!L%l-&57ᔂiJ1,[.+s&cٳp1\r(Ȇ\0<\0HKmH7ڽG)AK1l=XoBnx3,T2-4_1S #\$TU&#;=YR'Rh8b;g7\"}2h7Ma\r/Fb%-MR_4\r (o#(\nbIzu(1QJzq~XXӆHCﲇ=(bqֵDkR+C(HT\rKlB. 8h3\0>@BH`w/Mɐv(Ӟûz5}\$tLMUwdLC}&\$ud:NChPw\r\r6\\l+1VXGoz@5 r'vrc	4 YNJHr?d:UtY\$PLBi7pWcnc%jZ+Mju[x7-Lv\\Q;D,&}^MCk]h)OF wr䧃:6's\n%}ۙfDt%,b	+56R\r`+/0a(I \$ݥAAsfL!QhABH\n@\n\n)@ԋ2#|Le/]o hq]a  ùau00Pߣ(C\naH#P@R3Df*˸\$t\"	g:6\nEQh i\r)QBLBI&}\$׈QT~j+ߑ\$`,dgO\naP)O4lʂ(\n5P%31QQQ+!1Hڟ\n*CHYht \\M0Tj`*M5#.Af:G̊O	*\0BEt\"PnJ|)R~dEr\092\"\$\0TRRu_FBgkU,2	d^i81`)ӅA=<0;GV6'Wk\"(+\$x&H\$TaXfԚAN4PJ|eEEm8dTULFӠzkY&\r/mg<hO5(&r15[a{̀(ص= #:`\"q֙\0{\rD\rL96MrD}=PCJeF߱7k\0N(5&H\rrOZ@DeBP;%P&ôbAh+6f;^3\$Ց.hnc	#KC,k=-Ms=܄sEhmwxhPɇK!0ڻGpoI7UiQoM!1^qʦ܄Ȟ! \$D\\rMXuF[l[+HEMzyҎ]h+v̙Ҁ'ʹGR0IIvL&\"F}:M		a\$xm<ZM#Yjxr(FhU|*pitg\0}xz+\r5K2JHW~L9Q! 'zhJ'y?9on]Ro<T\nJ3حϴO\n1PwY}`u\$8\\S.z6TN|Kg¢?\nu \nƨp4x쾋~P i-Tn3-ޏMVy0Z@\rD,.č!P0Ѱ\06KgB.0'd`ɃL>2d%%9CH\0C+gy3@wN\"ܣݫ2܍I0p`b=\$p j/LPP\0I\r_p0R\"\$b=Sǀ\\bP/fqJafM	LkL;MD\nv8'z\"J\r\"81rm&vJCϽP\\\n.&)vpV?%h1ƗgTl)\r2mGݯj/Oty\"#aQ3QR'\".Q(-#в%\$=#;\$>N1\$)p1%1(pd/&2|8Po	)?PSҠ='*Q2)N )2뀨wDP\0\$0\$䊦ҧ&.\"& ?xe_Tjo	Ea\$\nݒlҾ1QN ݍH/2-`Jf/ւb\n L\0jRn&MC\n@ZosZz\"jB\nJZco20b48A3Ni(\"2s%&0Pm#=D8CjD>P7r «/r	:F6!@>;Ϛ1f'J<ݭO;(d0Ѣdc0(d,!OtBG4̌T7XNt]-4AFCDl7\n0cPm\r=l*FcGnDIV<.DdqqDgi@q(AqCk@z\$ĭgAHo\n=H/D:łw  9(D6΄ξh\nvQRPNFM@.pSRK\$\"GJE-r]&@T`	\0t	@\n`";break;case"cs":$f="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4ƈ65zJQ%	,4#i@aHX)*4x6c,AFnBD\0B8Cz9Ƃ0I.64*S̊׎@6khC,9`@7\03:xi\rOTIHc^8IØxDòk̔Z|875.:)c[^#x6szN-Ff\rcռ(p5E%I~#C\"2W,śGu.o2:(\nKp\"P#BL>9k+eNB&7\rg=07\rq3;	 ˀc#\\C^(CZ̍0\r6	\"\"G gN1 b7VEn@=[(;2k:-'4G#Ӝ(a]B<\r3/-oGR`a*;SU,7\0ކTD99b0'v7r3k]&; PP)\0tHtF; yE#ezad=G؛8'Puʤ&@JOa\r60CQf	\n1jH 2vDd4b0C9LJ\04\$1'\$ bP \r2˛u	P3LgCV9ID`	`'ь7R%L!T\r@P¨t<\"Fh|4	!u5+#\$tuI9+t F@XN\$h;.eSAO}b\"Ċ6MxsB1ղIDd(!2\"kVd'9L+XY)f,場|-\rs.<Eh]z/hċșL*o6-iℝ 1&\\a1J\$\$Qq0v%〝s\"*`pNB:!vi%eK	iD>+r(Ꮹ:ZJb]?\0(*y۪0,\nPjJu	c \n9/O9!Eĺ2X aL)`\\e;DLP3R;CcDH<YK3欝*DDm\"'D˅,v츚B	BYjBj\"Ue2*VaXEQlxd?((\0£/8:al9Sf\r!:1MKX`6Bzst j+#Ā[א Ra\0N1\$!4&liQ(ZZ4\$*DEv\r)R)\\gEi@`ۂvK&%4K11\$|٭Y6I%,j\" l*R=r{|gyj(q\n{xw<0#Q9FP{.,aPPz>YL(C2JzsdCT\rV5Ld@ٖ(E;p#I1a>6tΆo])+%]/eXm'a;Vn/<*IH!h2 Ռ\$\nO\\sq6;4:LC5}37VcAxa1\rF362s!29\$xPƴ@OX !P*\n\$yRJgg!ƣ/+_|e=_ Q!]ZzDuXYv\r%m`MW)d21נ#a5dxc`	ޠAYHzLԳ&eU5ut9d=-3uxCw\r;v>]}Pخ5TNy)\n4\"׿QƘl<\r-0AT¨RJ>JcJ >IuC=_wtXQ (RL8t1\$`c~~lǋx4~C^<Atv@8'p'hdH|@&.W1kP:h3LbH\$7Fk\$lfH-`7 a@4@'`nRvL'\rc@D|O(Ђ4i%j\"c@hf`@R&@00Px4%biUlŐb^HW,0h\$x(#M\nqbfqRBzZCK2cA@ fLO(̂4hd-*1ўT\"<w\nw&QFq<o/Hd`Lhqj M\nLj8	y	@\r#|>cشM@LcGXB<s6]AzU#w\$\n>kXEb#.,<'&NELS!q!\rȐt0n_n(hr'+#Q wqQ\"E	(ab@*(s -	NPIҸR/IԪQ`x7.2إ3\r1\nCïeh\"|0a*C͜Nkn7аCq14s,	m*`@9n341m7tm8R֤SXC%i@DBC,SS.Ӧ\rs/6S;7_-w\":y71;9,3+\"Y0\\iSTUR!;#KnAt#6s|Pb \$I.-\nlS@ RPDDfG03@Й4H瀋c\"+<R<\"nHI̗\r,T#T4tlJ@#)=s PJa24|CQ\rVp1ІTiN'O.\rV;qL47=XFPJ?fD֣BCGaf~o&\np\$R6-{ONUVyѰ\0K%ڀ_O2D\"b*\"*_h5B1/F P*ib9G迦G&B;(\$9[#OÂF*zS\r8&@5ba_fn-p>ܓ6`FRIW6*tv/A\r\rcc(PRױa2b\rH%oe?Ñ	?\0\"!BJd&uP\$p(\".FVq\ntbE1j`2\"dP&#we(0C	Fzl`-ͤͶ\$\n)L6\r(eV1s=5zrLI@@";break;case"da":$f="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑h2 T\0ީI9Cʠr2\0`7\"czDEc֠Bc\"ȢsBR2\rZ2=悾1o1=4@:#\$4'0z\r9Ax^;rC::3P^oJ |6ێLb7^08\rBÃ:QC44mۭJ|	B\"P0Cr3`P7ap01\$\"WP&\rzcz>CIk7^HEIp3##`e5ȭ4؎Ë)Y y8\"0Bt\r9~H6\$P4ά0cF3@P6{HTc%\"`Z5dq\\v5ܣȁB{0o\nE-XpR:\rb8V!B.#1<<hB/BB*W03-s-Zi^\"ԣ\n#^b>p<&w7\$bY<T,J76ĪL(ƘЋ)+>6[Hw/T˸y1\r(&hJa}h\\cBAf67 ehSA1\0e? A2urSjuO*U*;*{/m\\+Kwd @s\"6T>hC9:o!\$`j8;[P4#ͭ\nWgI8T3F}5jv?\$)`|P\n32`@X Qj4G0j)8rbd[=2Ir\$AȜ.f\0P	@6O`IbȦCyG\"(s?JH|RjJ@Hc\r<Fld\0PZi4!) K	)p`׳R\$})P\\gcPkI\\6P9Be_R\"{(F2zYZX{1Z\rF3\\+!<)E\0!N\n@	\rm\"a(M\rjEz\nXizp7@ζMf8\$G E̜\$Aj\r@aI`qv6-`䤥Gar1M!ېBp \n@\"l\0 &[XzmAxIpL4)y%>G,\0غ p֠8\r/qCPPx@XVbζ8#\r6=8Zb*Cf:Wx:zuIJY+y\r(AE@mE)W%fW]K\r!wj,0Z_8C9qSVD\r\"\\+Ep.+j\"%er7\$t&1J[=APbtu3VZ9b8po܂kCv^ϫ'4 =kƎNҘ+4!C	\0WO\0JX8E\0S7,b1EA,Gߋ١	-L0Hu|9t#P:!ۂ\rs|(ZKJii,[pb̀A[MhxX.Zh`ɧ5'	qiSxxH3u#V6lQQzEIwP\\HUaWalIZ	c\"x56۹=AY:,ܿj(m\"묀oo?t87ңoPezW~*sTk%T2zReF+`+t^iܭ^\n2O<QIso s匵K.T\\1(\$q2%\\I)]O+MnC- r[\\B6PmᜣvmeMB76r/4^=[\rc&Լt\\Az&tV8cN@P4λ{oQ<^աtHKaZwۅwAY϶]d2Ȧ445]0lH7)P/IdeD;Xl{J>ĬNl,v\rX¯~ZG0Or0\$O\$_e*oNM	O\0[BO\0ϫB\rhLveC	\r\n6ӋĚEOLNF/~pU	N5\0Ј;}#J:/CmffXwP\"B[nbf)8Oq	\rp\n0HBρ\npp0qf'	bDK\nϐd410\n~*1!n-,t 1:C_/2D/XF0XCK<pQ@;qoRk3C\r	e'n1in\r.L\rlAhRqV|&BLB ##\rH\rLq 1+~d8\rV\rd\ro.o騦BL5`B/W\n	;^bNX#bjmw#b#x턪!05\n|&jECz߱z6j7ZlQ_ ƢbNl#~xL2B\nk¯d9'0LLK|N>IlAf௫~^.+tګOȨR+4&,r[+2-q.+R&#\"@b2@^d#'CPzfz\0p\r\0\r^qk>3溮)@\$#'!p;\r0 -N g'U0-q\nz8eK/d@-JJ7#\nLKiH`\"";break;case"de":$f="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº\03#dr `|R#t6#ah7Rs.10<k;.2,@9FQ&\r:S#?\rk# ڀ\$\$9|-CTv1ij7mFB4\rTևBDxqfpP}U!xDlP2F4^0cݎ5)C:F+++C@ NH.Rc.2.9c+9B8!\074Ìz!) z*Z'I&7LP\rtu4s){&˄b\$\0PX03tK\"/펮CCI;bH\rߍ6c	f{/z1Ѯآ&^FV O1u׏.SOtc۱]5\05-\\ ,Əx[7:\"ݎҌK{[[@f~UBH^(c\"D#vPvmIPQ<\r8+\"!90ZrKƁa03;/d \$Fc2\r1\0p.p@ߢ{Tݘ񺇆\0\nJRT7Ь	\$2\r{~t!2TM ' BO	9\rVr(h@bX9n.d+D!\"n\r?Y\0d?=Vp1NH30Y+Dk\\4^g(^x &9R\nz87rJ]֪em5\\t%Fc#l7/%ok7/\0A\$Y&FjVBg9S '.S\$D\0hSXM\\\n\r9jfZQue9br3BV\nԝtV[6,53:QZ\0!N[ا?á3PPND#S`r4LdчW(sCFHpY˽iWE+ƙgHL1\naH#\01M9DJAP 4>ϤO\$ؒ\"7RpCR'i#I0O\$Ee,|䊲ӨC\nmu@@K\r)房FJJ4u!\nPP	L*	[I(ES&rRJZyOik_{wM#_#ΞR(93@D3<ݢ3T#@hH*#F9OaA=!3p2<0/Qj& P*\\|P(L'+SR_A	s)'\n6zA7'Ʉ\$	ѾK.zpȢ( wa	#X n\nFs\0Ǭ( :AXÆIoTAPunO:\nVM[uHAa\0F<vFh6	3_Y:\rtr5f\nK?Gɯy:rfMNgftİخc ӣ)[g\nQ1[v4GCdѺ	aȻRh*xꊟWY,l\0g@ήY*\0q&ݜ5r\rS3\\t\0/,]!@9FmX1tR`A!,=!NޙeAF,*p:3}h׺`FwPguA{+jXၟ}W>w{Wl:t;GWPF2jȝfLt/@μ\\4Nֶ1ܲ!~)fRK^Q \$Ξ\nIjSadu׸*PyB䞰ǎޚ\r24)'@tŞOaQ#rS}\0<Hov d\0ГNBfjOp\0܃9zoM+bl.ǊA rk5P0^nLjh1FepH-BbX&e#`j@\0`RLx\"8٣x#\\\rQf0)Я0O5c>0艰\0\np0d-\0j#\nN<:&@C#3N *Ɏ-XƢ0߃h'p\0g-[p5\0BUU\r`d\r0\n:\r#>6HBE/CZBjUC`A*FJ6)[ƾ0Il<~Mq\r\0\0|ɢn&bqpQa)\"m#&-n@v1\"д\n\$GPg\$\$r7\rRL2GF&\$\r0S#`	H~M֒dj6!;Q4Ho)9%2cdn\n6݆DѠۏ&+'EP~2	pV#ep\nC\"`olFNd#\"#\0pRrr10r%Qu1+Õ1&K0RTs+/2#oR-%\rN()\ncnOvM5;06\n:C5nS6:j@E;%D)LRJDddI1+3&`Ah2M~\nE&ƄpnC\"-LsBfl&`}F\nS)c\0S4wFa@s곫6\n;ƩpH`dmp\nZJODuj-<o1p\"XS/C#Y@P(Pr\$zlD2mRlpcJ1,Fk@@gn74!I#4Bt,%%\$T@#(`TlFRj-FLh:,\rj8:WPaCtH0NGdxx#fduPP*UOP#fG%g02ă#`\nh_y%8`βR#UP{cԄV(Mrpc+?m&?\0LSMOtR\rѣ#<CRCNIO&\rPcvd#,𼿋8u=gT\r\rjM2oJS|##ϖ%,#HK%:/b";break;case"el":$f="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0sOjC;3TA]ҺaOr4vOxB-wJ`#k4L[_\"h-2_ɡUk]ôu*\"Mn?O3)\\̮(R\nB\\\nhg6ʣp7kZ~A@ٝL&.WB\"@I1H@&tg:0Z'1vgʃCB5x7(9\r㒌\"#1#x929(Ȼ[yJx[ʇ+\\FOz\n]&,Cv,[WBk4F9~lD//!D((H@KC╖=APXJPHF[(eHBܚ;\\tCP74;LAc2p4CQ׶#6zD@gFuӼ4ȤdӇn.Is0X^eAKq8\$􌄗fa,# 49Σ|93;#9z@35ͳx4@:9XD49Ax^;pãi]2~{h2\r,ߤ(4#x|5pvg)e\$gTO;-^\"|Q;w~	nPD*!`P0Cvcx<~^c7\"3zC2!/Nyb:C\$<3tQsWc U1d\$\"v]Z;.^Iy1g0ٕgLy h 6Ź IBٛRQ) ef3 8bR!h(!F`ք=ȌDXH	4% \ryكޡPX{Q/Gv:'t|V2S̈&*10	ucHR=2d%H0	gDPPe	U\nyr AZ΋;1ZR'Q\".]\$ġ;* RPAN;˞_Duv(v}a:Cbk\rl4;\ri݅1Ne5i0e.ܖPDOT0A9!fM\$]rL!4@e7L*]Yb\0]-ѳ69DvnNz!3CsIl75ڃi@2uړt5ɱ/T5q	ƹE́>+\0j۽**85	S2ϕ3K=\nVB%`OW%^R*RY-f%B[Yiڮ2N++	*S#}5:ԌJ((xzЄ,9#]\\@0B}SZDojSX]EV\\2%}.dGu-tn7pÇ'EǛY糎)=)eܦ;R\\T#P5[z<+\r)({?xFQ!6,dI0T\r	9p I8&'2mG!Ц՚fMclÐW`	H)%kNbلB~aČ(!AmgT%4*dVYH\n\0@RKW2BRYNr%5*[]i\\n\r'h\r!4:M~ꛋJTIޢraL)iI.	3BE%u<\nSVs7Xא*n{)lԍHX伈נN0%]c-U MF-nqQD!Mp@ 9\\54hcYk0G5N1\0¤|qbxUu&%\\wq՜SfQ|fV<ΤqYUv|4	ESBw9o[#L)N@ZS\rcuyp/Tm\"oyb(HQ\n}Ns{0C\$IqHYt(W\n8Ty230\n}Fma,ˮᔳč,JFFK3hxN|iGvAA)e<wɈ4&XhO^a4Z%HNu'ViBؿ%;HCBij\$ϾRv&#bT\"Fr'`t| l\rbp~4R#|>N9j\",l\r\$bf,B(\n!axdψ(:\\/\0{BdIDI*NP.J~OvL{E)H	(~@WІ\",D%'	l\nZ)B((y'|,g0īV;Oε\rǬWM;O*K&E|7i<.!o-a1T&I> g˲ҥƆ݈@* {{Ȭ qlu\\v0cd \n`\0\r&|NOD_{6/D4Zzg\0^\"X%9b\">q&c\r\0?\\44'.5 O!+,!=\"&K\"n,1#CW##\0002C L(6%eb0(h\"@:HXmB%ID%)r\\&A&21\$\"2+qW*+\"a'Rdo\nĆP(L]FM'qk^0\"\$T!^%]P`&/#0Ni*zSHzF\$p?Eh/⒴n=>%4Č)N/n0Rd`4\$vF^X\nIQ%%(R)L!϶*r\$3)t[*ЮP6of%-ǲZP\0QaR{\$c7c(\"҂@	P>C['3A#bdQ1A6>&;@FfC\"Ĵ2\nZ	oq*MH[&\$;%pQ#\$}!rѰ:T܇\rCC|@\"-%SE5Rt(H>Z	ON9u'@u0TRd_E_Q#CQ3\$̓tOBQQPEUDUAS\nПRBPehKlz\"+R>a&½P- rJnUr5w)+c_&XT-+\r'u'W%9,Q>,223WSOX(I<\"\\j\\&I.RaR*56^\\UהWU.r0j8R)/9DΪBRbNDu'L+cD&%.A249MRZxLLb:,eV>-@u_F^e>m~nꑯ6ma:bno^Uaw\r@/VVnv	Tm1mCo!lǋgwUBTn?R֍qUpr	7!Ec]W4y-9|qtq%Wt	Tb\"(/?tkTP>5Px!k=p&5\\]5SYp{L'mKz{5utE56p)+^Ԑtwp;ISr+\$<|L%\$?]ǝQ<WW~&.&<B2z\"qdԮ\"Rgn}54Z88\"X=St@x2XN{swrNx3kX7xSWv8I|%\rB*SRedooom}GB4-0_xhMTx 'ăFi^_6[Э}9tرqQ4`B4JZos0b Ѹvizzc35>dTFA_BAD{PjM&DJ(g\"DEu(VUүkpү~w\n8VˊE[˝cQsXZՉ\$pI\$\$5\"u;5|`^`\rkBe6TvFeVA5`=%1[61e,+BCAy_X~\np(I\$DW !t@\nXGY?4E8erjmtwpEJRΊB3sҐѸx1qLNbilRKa<ٯǯe:*뭘@!\\.M/֒*%IQȧrfr!F3\\@]d\"zfaZzK&(ժA(>85\rR˵TLHC>cK{?	w#;LSjdJTj+͗[veBLvv\r>Ȃ=6F^f6j8Dk@_gL m;	'j+t氺iK'(.<z_}<sȒR1{~I0t8V[Dw.3ϤW04<;g	%R\"INp@\r~~مykI(pwq\n0Q3)";break;case"es":$f="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[*#p칍#\"4	T\"135ӸMJHL!ʢ\r|&\r7STYc*# ڴ\r\$8@h1(ԖïH)\$9p\\D49Ax^;ځtiQϰ\\z2\rrDrr8^0ɠ7 q0,~:!r:TҠxS0i*èʣLJеO@8C{rC!.c U6lm#Լ|8S5Ԃ\"6@>x2݈è1Ķ2<wD90atHD'kukcҋUt:P<NM_n\nBr☢&WNibU=3Wa@=b}*]sH>ɂH!1.[#K6 @7u\r<`722s6eUu\rB	)*ܔ7b(ˋs2pL0c	>0@RCdA#\n#zT8f\"3Fp'\"FGNG8eThɋ5	hl}I\0.K!6(	ܚ22ч&dɑp% VTgcDJ\n\\f@83!e,ŜYQ*Cn[@ʹ߈p\$-(:/%JWf\nֺAspPd!3+F플@\n\$5z!<RDI)5*V!*ZAWfżp\r)К<p`̍T\$8\"H\08o\nJA 9%1!UԚP8+6jFdfnzaL)c)9+1ؙաy4#	d\r]C80Tҍ(?\$w%PE!UMT&LM/UԮw\r	Ԇf*А	A<)EjJ9#ͨPZaä\"pN%T:c!0Cl:!&TT/\$J: 3*OHߑ'\$h3Vj2DNDʄ^BT\n8\$MA<)+]Chbvl7|U5TY4C\0S., 2\0\$1&,ƛIi#K\0{o\"62f	A4HؑVe|UɜC<gN(\0C+\0|i0U(8RNIhP*V5a1-[2Ú˜aQC\\s4l8^/l[!zOJTmm}@iC(w)*n8ٰ~9o6ZN{v!_h'UJ :scg<ڟnrQTWwAII\0;4ѿ=.HKY*~g(zK(jI~D02o4jNdy\raBqKC2O\rcۆymF`ǚtGOOU&{R#ª.鯏69Fh~P\no\$~Ù7ڟ7[QsP9ʳy7hx]@bJF(M@	)5F K%-(BD\nnc@N[0I1+^rf'Wc@m-f\"al?9x/S]Ҫ_F4g)/6ڙ`R[)\$ݠ+E\rCp\\R:&u8\\G=D5aY\08\n}AJ؛\nSv©bnӚ;NN򀧄E.Oͧ~E0&@ݍmi`߰06:ޯɌD~H/\r0\0p& bE	BOD\$<-/Cp4B:p`]\"gʔ~.CH#8\$IY	 8&>m@9  P'	X к~\$M7m*ԅ4f#O %0iQ(ϐa&ze1.6{wF+qB\"\nuAƖg%Qdr\$Ě-&t%D7>DcZ9Mtio5N6rTqOO!0qZQ	ϝjōqQr1:BFhQg\"hkD\$@PPn(n]/M \r9R1; qڅQ-n7!T8ƃ2<98>B1GF!HrR.#C\0a%KMF7ln;g\rvP\"fZ&-X6	\rWhF\$7m\\enW+2,\":L=+2D%j-Vi1OE,Mr/2gD\rVci,6#G&y,C		\nZ8c-BhސHm42q5N*# 8&ܲY\0l6	hOX=0~\rTN:d_e4Y0%(Ҽcɤh<-l ,Jk7G#fˣ:=O/Ib0ΞIFD2O@Dns	N2I8F(?B8& %D0vˠD\$82x9'(6k7kqgx0Ƹ D\$>#C.gChm!7dvɶ\nzxM\r̲&ǀ>X])(\"@	\0t	@\n`";break;case"et":$f="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\$̒6c69 s`9 Р4Cj r<x5ů4^\$<T2OI,&\rb*0`P෎/eH%c\0?1Ӵ7Z42jUK X8D49Ax^;ځrH=r3_6^)ڴ(P̴7^0ɨe \n߰(֩8H2@\$b끨kP&0M9\rC(+ɣr38-3<1c7ɱ`Jʐ'N#Ã/Ks\r&4|0cc(*~::\$xu?eQf@[\0P2ݣb	t2CF%[2à(\r#H	\r#X֣.\r\0.H**1\0&CuGC\n\"Û'hܿi<7cԣ=c%xX\rQJ}X 	O~蠃R';3h#]a/`ٜ ꗺ7Cj\0\$Ȝ\"C6\"@ZB0.#!6D& EksN}#VIb6OIRĸR|pn'93NgI \rpa2R\$kF6w{R@gAeQa0؂[4%\".bC)5&.\n0pq,ERYAi-@B[kt7-N\\\08V|k8OZtc11f!=R򴈋ILK9%C1M	W#lLloN-9:VJO/E@wv!FG\r;(;*S0z L	V{Mr\r+ fa▵2&)thJ aL)hڂi+EF9ɛ\riD.xKb!5?>ԅA1BsC/,	)&ܜu?@l'W4(lavF+Wc*6#ߪsHlL!8á.M4)p@bN#I\\prR+<%DScD)P o\\P*Vs E	CeQ'qi40G/\nr\\/rfU!c87}Gdu\r 	|NAIXA2?ϵLzxL}?GJ P>-2T;s8֡A5 kmkB%T4럳sfJASUlAܩ\\yqLˠ	dDzwL*pT7\r;S4bhC(wI@ޙb!EBSr@a|bń۱j{CuBࢧ.AE9%A|Y*@B8GI-:xNk5`R.ËfwTXy{IP\"`SKJ>gaPQA0@@ (7`[-՝a	A4!Z-J̗m%oҨ7u%TE\n&P;G[a\rknw'I;2NOw\"0b@+q刬^H(i⚝ߠ+Ӕ-	Y7Cx3	#9u\0o|jqa̛︙0!(0eSy*w^^uI&-2X;/e\"_^Eb<osOG|^Q +\r`z3Q\$j\$ޥIƀJW(zs)*Dy#[	CLJ\nт2Z	ޏf<%<;0W<#b~-O	Xy#`:ofl/p&cO,!DஔDא8.hrooVD0/dx\"9&p#r:l vB\$rX'E3kn2BD(DHi7F&\r%\0C>L8:iϤR{VDWp=pbPpzhm\nZ/>C;eada\"0??	/Fb%}*;.FS\$0\rR\rR|xJ}\0Va\n/πcFfqx @Pح\n	^	-cʟC8FM&B@PN Lčz-LQ.EQ1}\"ω=/pmTb?;mIh=\"qcݍ\rOSBH7}nD	RO\$}	9\nrrSO'r]\nQ&d2,3HiM&ҤJr{-G)d1Q|J*MI!1!rj2r_q\",RrJRmI1e\nrQ	+-P1eE}Ң̝`P	oխwOvnLnK2c2 \\+*M8'M0gq=>ion>y@dfJEnOvc8'*TL `&f2H)kSc.j\0Z>iLebj*B8h\r/qj#nm;){<ӊ LpS0MbL8%N\n7\n\$co&#4\"b:_0LlK@oF dSJk\0|4Ge4lXk	N~B3#6( `NbNԇDDaCXERz# %hFl\$e>zy5(,Xd<@lto\$ryd	eL\"#o~_RtNX{#x5K,RtdiiZDM`-CY&	r`V\0c|1fO	Pzb	\0@	t\n`";break;case"fa":$f="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&YH;#`2#p8P@1C(2à@\r*w) \r*FjB[.,\\B:ʓSh%%U3?;5Mc'2BB6D-CC|89\0#o`0BP4@:F9ı8XFD49Ax^;߁paذ\\3_s#J|6P3ACl4px!^u:C6NJ,~˽Z!43JƿIP8%z|\n7Z7@:\r]8C~2\"#뜕@HK%[48o½\"%l>zI`2HlR} \$Е[l~;k82\$D#Yc01::103>N#(ΈL\nISn?o]v&N&0;*1ݻOwUsY侮q'lј7|)zGM|_V쑕?{0BKU4 n@;5P҆OPa\r!ʺв\riB.\nTenH\\3Ó̔Uuɂ B}8fB\0PDU\n50n#JVxl6Ȓ\"MIb\"O*5@)ԑjmT8 zgQ˙Vlp+MJ7S<@R	\n2l׏&\n4gh)EDޥj#H	Syph|I))%#nN:tӌu儻vQXIR-N+%\$fn-6p-WE+*P6/Z4)\$Ak謜'Ujm.\$찛،b^z/ew_0 4O1QÜ;~2 ꡝ0ٗ@\nFtFrkI5Hqg)HԓCT	±3L*(T[\$(;A=bBZKP3P g=oQa-F\"dUFE<A3}d)<u%60%Z@PĝZi%(Ĝk%4d%fƊؔ#hi\nƸXns\"DL« h\r!4ץMBE\0C\naH#G0֤%uxM	|peg;\$B`)4&VJL8OSO:Su|\nb4WPrBc!!̂Ch ܀Нg=%6O\$҄(4EhJ	n3J5e0PQRI'W_)t[Mю8zKyA3\nl/z1\$R,UV/R?)Z)Ӡ3IU9>!R48`('@BD!P\"L(Lө5wT\0)И[>?#y`&<:2G):Q>a''5`8.F:_\r5k3{݃ fњg=Ֆ~}RYWMn-t4W!䪸 RHF6H*UAaGi#sM9WSEjLVQ]RBĭNUSsdϘǈ\rL	,#\"\\tn\\Ɏ,ߗf,b86,j\$K:`t-B?y}bNb	P8B'w~'.z8`@BH\rҐC}`::	ܰnA\0/-eF׍3CfF#v9IyUI	k:kD~.T.M!Utaė(d4?LI\"?\\F?\$}h9\$0mGn߳ܚqJ/G~)Rh H킝JLC&L8>`)&dƽNLg9Hbv\\.vʻ0GF~JS^mܘBhpA H~JtuB2cMOBl\0>#J3ZA^r7.z|	ON:2k3fF@\r\"&RХ2|n90gM30b8#]\r:쐱Q}.7(HƗp1&o;iij)J>L0/-eg%kQTX]qc|!/s\$n6(#\\qٱ/%C,:>J0m-tE.6͂\$	Tn'R!\"?;N~駢liNQpuI Q*;Q͇\"ho19 I#ipC#f#K\nq|L?tF1\nf\0aTN\nIi&?a\nr+~8Dv1h,KR/)!\$RGZe7m!-*%+,s+g~ĨBOHmrg!=.2c s/'.-(mA*i2.qNP.0H	}G+2)A*S3 ,-!.26GLR)%,0TR3ԚH53UT~ϰ3VKsBgL-v2&pETvbTXf0\r:c~5 2\0mC=͆w/:XQ`@l`T+\$Po=fŠ\npCx64eC,2(G!0e3؄~#j'B\"IEi;l1BS 54n23J\$*d̂B&ˊjVr\$ø6/I.vaD6Js%R,^gTUP<Р0M̈́TUN\0oMrP4MmT7mMP9+j*MVF\0<PVD\$[\0@QΫƔ@,'f8vQ.f)afx4%m(wt^GХb[GO88'1f^pMN8\$\\-ש<UO˫ZF\r4fnM)=5\$Hm5c;@";break;case"fi":$f="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1eţxo}Z:L9-fS\\5\rJv)jL0M5nKf(ږ390`KPR2i<\r8'\n\r+9\0ϱvԧN+D #zd:'L@7 ȉ.ip䋮\"X9R9B^6X&=qb4dGґO\$\$%x8#\rcM=*##K꺃\0\rM\$(\06!I	X0à悥#@6\0xCB8a^\\\\7C8^\\H; ^)ֶ\rXx!j+%;%@5λ@݌S#r53K^رo\0^O!􂆂i1#ȆiH:!.R0l@-(<Ƒ)&O|l R.Hߊ^5#=Z#81<.U~*9Bd(Ӿ\n挨:5>\nPp2\n%Eƣ%%`hdj59l(j	kr%.cla(RЌ=aN7.İñ@OS1{>XЂ;.pʘ49u] fL1 50;b9-;(	\nȷ&u+]sp%X,W\rWl5s^sZ[eaЩaA  M_mt&@C2҈)R\0:@_H\n+(2jG	\"4Pxp[\0xGñ+Y` @i\r*6U()D-Jrr:-R+rG8pGV@\". \\LTC'hnv(̈́W1a-)D`@12BAF60U	%!Fq5	2R/H:Pc.	\0U7]	1Dha,EPtY9h-%][+l7-|s9ਃM	)]kԦ! :ɼRPR!(!(*UTi9-E<\$Z;uh^=<Jڮ%tW;\"2J/2eOcGdd&!84H\nJ\0!ix\0()CH`Ql4Ȓfq/	X3*[tdurzwcL( aL)`Z܉J:E\0}]-hFfq5	iT\"|\nw&,Űdk?AFASM#9)mw\"7V)0 R@V 6![OjP+1ȉtO\naP[)xv`٢: n3DϕJ#0d+(\"I'%7!)Tw*\0tO4{H0%d/a+%SYKCHD	I_i!8PTL@.OȘr\0Rr:M\$[,e#bJ\\'/)k,\"x9cDʓ\\V*6E#W{Q^n}UÔO)GgU*4y8QW엝:S)O'<Q*:x-Ķg\"5si%NmRe~~hKa<nܟ-%C:7@K`8ܛcNuWbuL	xqR5F^#+1x7``vR;D<JZNCړ\$67\$e#|h\$`cT!\$9\$m(<5pI~5ʊ7}*D2@2!&c_\0\rOD\"5BX4bw㲃yg#O\\y`mɬf\\xиғ5TWjiCuACRb\rNl*eās]j@[N=i9#jh]5>LTIIW\r^7ɊwN֝|Gdߞ0ת|ps]M!5Ve4ƂA`)uM!Gj\nV TiyD%\0?f)=״ե~dJ6Sϑ#/4:c|EAlgNcOS`OwĂRvkc5^4ptfe@ PFaRF^,/G̟NjpIdLaO0?'Zt0(Hy/`M8b,y#pb<DWz.@.bh k\"WP`e	,:HdAaث2DpuǺجI\0H*H\"	f@\$k(\"@-T˄g\0-h8>C\$E4B:'mn\$|nAwL%\"R@n=cg\nG\r\"vקjLm,pfVN5̫нc\rpI\rRb6ȣOP\0`ܢ/S\rtG1!@'b&	:ib&&iC%Pc71k0o\0\0j9Mh\"| R!B3!rO\$0#P\0%ɲbs\0\nr>.&O\$1pмփ\rr@̣!k&2fr\$/f*2:\$i(qRsҋ''(nQ\$v*\rre\r*ж F,RHj4EBO#](/elsvND5ҎcdOCv\r(̆ zBKs2\$2KzBtNHdP;3#\ns\0\0LSRbE4hd\rV6嘐+rfj̉FD]\np(3	(n*LUI)bi. ƢsHÆ#_U=#0\$*5d05\\\rE\$/,egֈBdh\"W@ҵ~-6&؟ȴ6DFIC*q/ʄ@;\"7ф`@\$/b:k!<2_nxM%&&)J\"p\"e\"\$Ǧv4`&\"EnevOrWp30Ȍ~#i0C4T:kK%,5.\$m%2vĈ|E\"Ъ@P\0#";break;case"fr":$f="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏\"Lpp\0\0%\nJR̚£c\\ChڪQF2B:	;V:26\$*ȍ.*ʘ++B0es\nF0M'\rhʣ\$<D^ʁB4̀PɬI \"85*\\2K4t).yT7@PBMpj9lW6HCH:MTZ.H/WVu{㒆»Q`2\ra3\\EIN1t;(µARSAT	ED9`@'C*3t6%8^2}; ^*6!	JV7r[x'B&\r/U,.c)X1r1@؞<`@ɍ:0+7@0I؁k[Ƚ7hxE&96	#p͕9A;\r`8\"5JɿQ-bº\"3HL\0ϸ\"/)pP:-2YYy\\B[S	ci	}L\ncQDYoUd\nbNߏRbwMk `W%m2n0׸E>GpͮGB.TwABCyWRXye()q*p,D7H-%D\"@cehqMK?2'k (\"v( *ADpbZn~@\"Uϙ#|6 \rח\nN+l!acaZchP}3\$Dѡ{2K\\:fcz=V\$\$ɓbWP!3	^uwM-m5նw.28H\"۫aHG\$䩿,;x8;*A \n\\_z5(R[f'zK@V'E+|{2\\sj^+zBrW\06\nG;>_=1&|hZ%hfP22-٢EJƗHD!zSx<HhYp*B#Y2mԆ4HBCk7F-J`Q9H*bXޫʗa=P	AbA\0(*Pn\$\$3 ffJ5ϊ}\0@Lt73K9=xD!&@ aL)cΠhf##44Fe֓\nĳLTPClI䀧RdtNf0HZJiI`7fqVAy=`B`\\E2:%nB04S@xS\nW\nJ	TjA?JCArU(pT͌4 \nFMR\nWZX8o^̸DR0z!1\0*抨d#>ɁI(02΢MgF\n:N%6f'\n	8PT\"@.Jf&2)wFӑPoI۶;x'nƳf!-3?bԞKrv©T؄ RR)	tAvHtkR#q*z3%ujBwjnlk\r@\"Q\nf\"LKQ(rz'Z^i!AvUiD@?\\EiG0ap(`K!*nDwV\\=*14XTMb杛д1cBmcd!Ӷ+J>R3diAu\\&lJ)t\\N\\aц\"C0\"icxiSjtYs.T\n!NQQcs]y+<V&12C:SNA嬄{IצŜpC5(t`M~j; 9)&XvjB˻ݰNdI'R!MNʏ<a%+e/!ox1`5,JQX|\\\"32\"\\VkJK#ۣb0\\2#sV- WlK61)=E3nF4!	/m??J	𯆥̟M 'mtr\"fnP4fwP0\n*f\"	nf6\"r\"quhw.Q'ʋy\"ES&\$LçTp&\np:%\"`ˀb6,oV-]{pRBlj1\0vpݐ-JştҐ=\"ԇK	jm1\$|J		Kn7'ѱ-|}(|'/?0T'~tmqYRf*CrbzC_OJD4*O\$#O/O2𮼍f.<!Ppn7N:Ak@Q.?)t1\$)CE ['\$Z5- !T7B|JѺ(.5Z :Ja B/<53G\0=.HNI-P ,m@۰.(: (%\"e1rPy*MqΎZDe!΂&\r-rP,Qc',21PT|(2-c+r.2ۈ(n: I2%0+\n`\$f13Ny32-}?)	\0FzaV*\0=;L+95/һ6zw\$dR2?D2mmM	s7i9j+3;5O4d\"99S}7S3v\r#9y\".`#q/3lBbN,?H»sE@i?K@c>n@KҎBt]ۀG.K*\0*K-铵TWDAR'@?qld0ƀs8\rY6yT!bFa.8\0001<!g[ERLFbJ3C;ixb\rV٣V36Y\"r'bl& *2\$k\nZQA4N	IMr#RϔB;k6%mG0fl\nSD\\xp3 EJ74\$&ZocpH=fюXhېƀR!'3>K;o)HkSU\r4;'\0!57	gTPz m\nF5MN;u5[E1\\B\\J VPiX-U<Ҝ#0s8_#a&WP 3\rD?oNkdYRB᠊,<X>c&E\"LvJD0\0(\"1n*1\r͚:,HΦXn_\\|fjGg<H|%?C\0\$LnJTucHJ\r";break;case"gl":$f="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$VڌP;)IRR1jܧ.8)\r*s;MJʽ#!*,%Ѓp1ₔC1@#\"I%0;@240#XApk\n43c0z\r8a^]TjP\\{\05J|6.3/)ʜx&ʐcԯ ܏zRL#dhƨRX67\r|I3+9T <X6G\r#ҁ!.[6jFm.5Ծ+.J5<^W슱43{Dl Ib.QQ.1誨E1M:,&Ljf\rҨ&ޱH %KAGm)\"`Z2V겸pӄ\"s4~Au:ͺßopaGIbPEAIl9#\0ވ6\"хc3UA`*\$P	%Vǈc.#ͷ5}d ]{ i{!*ɸ?n(=S\$MQd|ʚ7T(\r)b^n1ELM8i5\$34U m9ZU!\n/l+\07P	_b\0FҀHD!!(Ƒ!0DȾIb*3 Aݔ%RjXR㈴!\"doB\rHfBIV7cZ(*CrA2]IArXkcVzMQn[H~\nuI\$c9vUq-&	I)gVƇca!*0pa1pB`M\n6Iy2AK3Spsx\$v'&|@St\r\"<\$0n\"gG2`!@(AC{C`RnMSFlA7I\$Hv; 5\n^ 8B*3A9än^g@C\naH#E@A7TZ\$𩒹LV@<)pnI	*`\np}t8)r=BR)\n ڪD\rIi7~erNmz@aC?J2\0£T'1	6W<g%\nYܕ# 9ƙ% 6H4vl2J1]&;Li	9'dP(}ęҨJ̚~/,&!-}d7x-4NNSKc&!@B`IA)Q\0U\n @~B	6A<),	@D0\"E'h\nE	AL(SC[	6*;TJtǯMXByqQp)m9mg`P굌.ĎX(kqC )8[P/P%>U	DHE\rSMJ+Eʳ6ߟ4JYm{oy6E*P}ȭ\nKN!.Vk\0<3\nv*x5+'\nѵ6\rx\0PD3Wh	Jcي	<>9l'MjFk5RsПm<!WYSM#.UΩ0Y	JM*K/FIgUQ&KF/'L7by+,E:\nN,JM]#@°#q-ū)CJ(<sCA.BaNSB=щA4܀s.:>zށȯCbb)ʞn9//D'Ʈ(e˾74KHurq`P5J}@#/M9ceLa%36G\$^m#M Lllh&he/~W7'0wVKA!FßK,}~yj	Jtgsl0L!D\$\\R\$J%F(#\0000q\\@#>)L\"B51\\p06٦lgt0PH pb>md0gd&+*~Ph˦Bϳl˄pFxGr'lϺa9\nC8#N20\"\0\".x~0\\r|.\r	OB\n\nP\nu)ѰHG`/-IȠ,2j8#gE-*_LGIvPj8(ꆩD<O\"dFP~bCx\0MT\r~\r1Zgp0_	pp~uaMѬ\"B	\n1Ȭm7Q2zk`jFm'(O70ѫp24ެϧ\nL!oh\"L\"\"Rkp9!Rh&K\$R4cFy`Lj*3zpt X00pwqq&i'H͠9Rs(2S'!	*P*oS*1昦?,{\n,RO/,-,7,mмl%2-k\ng%,Hj+10-3\n@AB`m!*K\$*ۨ\"l%\")B83Z\"4*FPP1܊\$R\r5s	\r密h|d\rVd\\\0ĥKj0\nĴ1ĂE\nJw.Ma'@\npP\$j41NZ(r.l:,1lSh =Ğދ~*rȍ)&\0\$2`/(GN-UBG<<Fv3>(\$3х9 GAO7Њb0C&lD4dThԐTuENf)ޔEtzAF dҥ`ԇFj!\r>_҈,ǯŬ^p,`QCM B`ޤpQOl1n2l~*!B2,+Ed1ȃ\nE\rTҎ5\")Tn*;)rwn:#~\"}ȽB\r";break;case"he":$f="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;)74˾;;c2p4Ü/S:	:pTLitקp{	0qc!q3^؂2\rH*7O1oG\0<KH4\r4?\0\0yQC@:t㽌4eˡ}cYC ^)a=p\r87^0淳LbW9C|RB0Ap+#P#B8!\07x1\rhȊJ0#Zk9#2h\nfLHu7\r0NGq\"	ZKC'-VZ5ۚ:\nZNB}Cޚݨ).8'Hj6#ȂA'qKy^:z!)(|K]}N[9#wXr~P30A:*Z o'T/;ʲOܒ1EѴx\"2h6=#`Zَ5U&;(zkr=;ʦu\"'佪\\9;w<pA%՗2\n=mEb א)nT,]X 8emXԚ\r= ^ڇq`-^ZKۚ +!&i@AAPĀBH(4GM\$B q' 5KȀMג#~A]@UneWj_V:w1g-\0ܴ\\rl0}I)OQeA2r\n/e:pȚ\$CX	n\"KP9'd@{T_w*\0{C[6@RqO`8*Vť3,%\0l-k\"M%\rq2Lk0@@P\0MK@*0;n૕?Vj@ Q_KAaCl!679@\"/|BAA'l7p	&tٛxa@C9Z@K0fJ\"rŖ\n6%NɛD-rt! ̼J)]%P!`(*\$8T>fY5Dp	%[#?0[R	1FJCBk\$#IIPO\$dSM('M(KkDCn#h!n\"-mEJM娜G&L3T&9d4&CIvգI8Kdb/)ƧbI2\$4+.o~oEР28%&!>NCj6ӲwO	d	͕Mt0Z+ٔm2ClcFLңtS0uΰLLuh5h,a\$Fs*d%d>Sm!:\$N_ki\\Zj90:9HF啃YJpĀL8fsR	fNCn׎vbJ\$A*@C2PWԑH2\0@]HBuPKa,IMb_*ĩ(c,AZwᖥ֣u%k(UhKLƻ40JY0f:t C40Hg1鸩(`⮆`2-AơŬ\\C	jA6tS- -\\z!9,o`\$sC60(\"!J4|>tie@UH8-D3py48!r'p뚷@r.k'Xii2@rUjTފ4уLQi)_ͯd16-'IмY˶Q5΁\r@W!73-n3rY\r1_sN3@2Fr`npʴpٮLKq\$8N1!|:_ߜB[g!ߨ{J=vCO9l`Ϫqiʓ^\"N0,_F\\@.r'4io@d.*m|00D\$LgQo?\02PN\"E:.֝B6ବ\$,-pHMP-J^P0nq]u-p:PūmjtD \"Nq2\$. 0i]p.xtJ9ncFEL0+I,Oq.BM(`(-le{,ԋn6h	όHDc#q>(onMT`bvnc\\%h\rFb>ƱN<I0dCd\0VPt0E666Bg	Z)PC\"h\\Z\rTK^ n{P@qNm80*n7-[R'd2D\rD%x@`:qLk4`FL # 0طzj><gf)pPA+n)w(gmᣠj4`M!k^ыHf% kRT@@K@Ι;VIP\"t#rhc'8nkG'\0f]@mB\"60 e\$3:@vk#biQESq&k΂";break;case"hu":$f="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;H;*\0hX9`@14#ގ(;R #OYBRPI)	C4C*モkC@9\"ЮA\n i1ܘVp	^44RcpBb4)0z\r8a^\\0Tzٖp2\rcZ`\r#x|퍉,~:C֕1JR&Y0ς(83M\rI\n7=x7s=7\"9ӃPi6	68cl2l<o:wI꜃P> 3#RN`2B[fF4#Zp3@1\"RIk4Ӄ\0\npeU)X\r*eԠ3b-cmӈTr0&67xL+M7I93c'~cCC\\}\n\rhHz;S}O(^Ur\$#VM6@ v )J@Pp\"2ω|/镾|t@EKEٺ#6\n\n51<d=!<97	퀢Rc1`ƴ7`PQ7nGQVfBC(ck3sblͩNp|%lXKD@)t\\:'dQJ6/EeMU\nAt<<y>墴֪[+mn#@t.ܺ)ypm\0t`\n #4Eٺ0DBr6\r?P\$\0:Yȫk#(G2%cf_6#FCFI9%P»W#PB3G\0֝\$PAyFMC̛6lHC9\rh\0(0gXVCk3e\"Rb꼀 /pܓ	;idPDS7b%EsF@ aL)b`zbO\"s<F`|\nF|PZ3a)R3>}9rM0\"nHy4-.N)ŷ2Y  S vmCHkX@'0L !Lh[9窪LX!`ajօ9*L8SAԃT@2-@\0)CNdK@ISvpXʹSģ\$h\nzg-јT-13BMcxEJ\"hziâ3TEq'>(&6vZ45\\ \no>Ĝ1҅}*pBhPw117ma\\i\r ܭS&\nk3bL\nV\nJ%7@[3\rq3-\$U\\fvt{܎Bǡm\r<M-#zY!FXB<F1m 2G\r#G`ʹ16|ٛG\n=}%g\\.὿ZaUv\",#, @BHsKepf9w4.+:\$޳\"s\"˄sC_+G_BVq'xY(ܬ\\xsi;qt_a㡇qy!IF~rg0`88KtM豐m#TJB&@Zn\rL|*z72t.\0xFGȔ`wrہPxcmriH\$gYheGME\"Jbmp\\C9H!] Z~c>&w6YoO}FY(	\rt䡕`V\rb6h\0,7s*+=x\"r^ (eۓjI^ll2LT\\SaDAa`ƾoek0D\0\r,:l%0\"h4/'T.HG~#GԆTjF:iP(ˌ-:0,v8O\0Czt,a'|%onfDblo{̘a{bd-hC9\n3(\"C&\r.@FL0.ZnD6PphNr\0أ\nϡp\rtPq!\"ACB\niO,CD/D\n/C0I4QPGJ2ZcARG\"Fۊw\"ZCljhZd(NeP\$v+Iʜ)ڱ10FLNBf:~<dl*1Pf'\nlzcDQUR\$3\n?!P·\"\"'zF|<0!>\$*sl#:BpFc/!`D&joF.{cؐB#roI283(#\nLU%*AN<fG+#p-#&r-R-2c%/]* l2Փ2*M\$-VR\"O M-q`+R4VR1;#MTR\r*&ܤ(P'܄9'?6gTțr>7Ҷ5pp_#ʉ᳠fS3,;:S'h\nBVnAœ<6χP>w?&V>akOKdbmޘ\".\r f_'ƙk<\nZ>/Cc;OJBEHME\$#@\$BH\$fw^&1JA\"@0OD\"?I#<c-;+J,0)4\"ĉFxX(	=;z@;4Rc=\n4bNՏ3d0\"ӽ0/3i0gJD',\0OK,\n8v5cZ fuPN	o-юeU  Xgz?pF`46%zf(?-RYfDLgۑ 	Sd #p?922[9 5sQXs˪{PQ,pe-a\\3b*qG\n\rd+2.l-a8+ 90\\.-af@\r";break;case"id":$f="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87\$ô\"	C\09\"<A0k]%%\0PEr:#dBjV:sL֋DڜP2\rBP)>1i m9øѱ?X(D49Ax^;r<@\\z<ҏ2\rCD,^0hˍ)-	j4Cd9;J5l*M2t&C+Cszcx<r8Czd2!c\"MGX6HFMlH\\%cH@'4B 3#؍`2`ν<厓xG&%9̒BM܎ZQr(~\$.A0C!J)\"`1Mj5~r˚!mvb)(21FNx;rZz;Չ@;2-+01K&{7\$oE>i(ٱ;\"[624rƦh\n@<B\\\\&#6cĦLw3-5jZ%[xhƻ&ʲ̢?	K?8'Půc`@Y2.^@q7`I-MI`S[JL)8TTuTV\n7+'GrWn8CH!7+?\$%3ԛQQPųnHf%P4KQs\$J\nr}DГ30fcX7O@0ԝҘiJ\"auia	 8'L2Dt\n\n@))(O\"eBhn:䕩Un c\$3ipcc2)PBS\nAIbp 	a@ǚTa\rzb@ڰe8:NNh@MYY='`Hk(TLA;_FiRqdhDc1)1E=ɹ3O@\0TiaȢ\"hLOLh((\\Jq\$`\0Tyb\r4\nA2Ƞ>-\r&ORDp\$\$cbLD\"xNT(@(\n \"Pk\0\n	ԁfZә&Q2TubTe*GU£\r\n\n9&ШYe4xKHRݭ9˓S&]\rFe#\$yX\n\n#\\\\i\nĢ*GCH*Quo&EUzk]yLxn.I|D3*R	2hWDJHAlb|ȉu\r Qj9A%oyk߲pRp8\ria\\4֞\";*@@ MpͽF}r4/#R6Q#dfQU`̣lJɱإ24M{0R-}5鎹a;i&Рܢr4y;1aS9n/E<ȉEfGQ#1e>lNp=fRMj{qߣq	u19NFQC\r(̂꒘^A~.ޤsW*ɯ]-tfڑ.\"1x{	3c_3-vYlեf6]%TU͌ٲ[\\}DuC֥\n3;*B>:/L܏XSJ,}p-LZmq7M0\\ژ\n\rcI#7ߏg{\\9Cva;\$zÙɭ({4P92|04\"_6.ݿ]5t#Bor#CU<е	uGk^zktGҸ/AT%A\0j`oD0x&>.nGSi߅wMq<q^5}jNpzKX5ޛNӸ^ߒ!ouxڝ&GDs>\r%bK</	 ]`TkIނ嫪oНk|?;JX#X&,dh/#oedȳO\0[D(#0bbP4J@v;NϨJP=\0/-S#J%\\&&O&06\r,0o!EpeFZKTg0`D\nй@܏HTK9%-8zi&*.fmiJmL],d>\rV\" fBdeWlQZ~i\nZ0z7묦= ǭN2Yĵ(db >h,ö@2l((V\"r\$]bB_EW0Y(c:Bg\04+\$/x,BkMzicb{jO*\rb[50	v'f)ex2e#Z		\n'LL96k\$ @%%μHRA\" 89\"c'#\"`QEcYqh.r q\n\$dHZ\r(4&3fvf De\nJ&BDj2\0";break;case"it":$f="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9[p&P;PmB@a3ڭÔu܄+َkٴrC\$6ӄbsächf)ek-f}(sNPM,3w#lԨɇY:七Ѫ8Ng{AZJ`5R#()*Z*J@eZ)2B82<7%q\n6R*-(B#B!;2ł87j01=\r+k(\rB:2#*8(?O2F1BT\"Rbn\rRJΎIÂ6l>ÓT0c@s3\"`s`440z\r8a^(\\0s-8^Dtʍ2М x!Z+8=QkzYDf&\n/K`̪vMZ溯r;#ʙ\r=FӺ7r1;ɀވL(CʨFbHC{/5\"wx	.2KZWwuM-J0ङ]l(/:741\0RTXO{3vVyҶYvj֪IYtc2#&C.¼\rnܣ\$4[\"CrڣW}P3YD29A)(ޅS9c*9>;ؕPʎpm:fo.sߺVĈc*A.:揥iy>|^JZ*p9K1ޖ\"\\ Xz4{q>*y*L\"B}L].F̵̫d&1\$ '1Ppm)k(`3ց(Zz؂O\n7@fRH@p+\rCTC0fGeT*B̛ePz\n)ޗ)\rr}dGgn%G䦿\".R]L:\nTS6V<%*UIvDx\0ʰ)Et^Ht\$4[2x{⓷Oa#B򼳭ʬd3( 0\nq摕FTIH4e!T'dc{('3JqSa'h T!!8P	@S} lvvX0\nnqޤ䬗SJ0DOQCxk\"!0QI͢9#fI\".4\"h9<\n앨Thɒ2}&ճI#\rpIUFpJHH9RxT @'0Gf)5aET٥Sк<wBҪG#I%텳H[PLL'#(24\" ďiL:LLKݯִp \n@\"@U\"iz@(\\\$ƦTu4&eieڢcs\rQj?K1(.gg5b^sy;:Tƀޡ2\"	6xT0reP\$f~nq\$`fjh۸Gx[g:Ǆװ&o\$T@	Phrk]Fw!._z%@)yOD\\H7|iLa%AΖxiewvpk!s/FW)ԟNE(gsT\n!@HQ!̒Oyʣ<l}h/4Cn2)h4qAnWã0\\_n}tgE56-R j	fш\$Q;Lf.%7G@y/Wo,WBMwqBEMƊnKtW+i,LI->@C<iyP_hKzZЌa3l^gݒ[S^7W쑌ϝ#GN#\"C~\"[um\\k{cnd=uĐ#bDF42ʖ~'\"ʛ2ie}u>mkH	MоF*}C[b`\neP9/*cyxHcJ@]?<jmbwwyt瑎\$Աszw7V_ŘFb_z\0Po}U\$\"h]{7(|u'4\\2x'2_|=		 S#ELkIRfYehCVō*RJZԤα:op,DL76CJIjz{|֠Ȫ]\"g/̲oŠJ`OX@j6Zt\\hsHBP`oQf,B/HM\0h#sG*\$ϖ%PDai#``d~PM[PG\$#:K&Icpf6[1\r0|bp\"5\00e\$Hc5RhCFV\$Phq2D>l7`DqORˣ=NPрPn`<1[4\$|n9&.\nAMOQļX%'D6LqH]aPn6ڦiMk*aD\"-\0l#hHHB(cM^=\")W(N&\rV_C*4fL3F\$A\0gBg\r@\npmv&dj-48gd\reBM@wn~\"N<*#15&#L5#d*fW%vn-'!d %ΈHТ,bF\\e0iT\\\$\$ /11؝#v_-2)	1\r)03!	2djdZX	\$0\\f3/2\nLBNȪfi\n\\F..̚l亃(:GRM'l	XK&;\$\"wvCk1h\nk9E+'hM%', IH[j¾\$`";break;case"ja":$f="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99##X2\rZ7\0\\28B#bB >h1\\se	^1ReLr?h1FzP B**;@1.%[,;L)K2Aɂ\0MRrZzJzK12#eRiYD#|έN(\\#R8U8NBH;#`2CPCV9X@1C(2àNq1C8i\\A\\t/>W33) F>\\+DAVq]*^A\nføsQD[Ab6#tB]c:9C#1#3\rPX;.#MF9`@aCER3:x\rzt3`_qHJ|6me3Ack4px!ekWEzSgI\0#8R䒂DhL\n@ñ%\nset]1HB9\r<!ݵ<8C~2\"UƼѨgIjJRE5t%E?'I,Qӧ8\\R(\$zR9hQ9vs}XF[w\$/\$o\"\$Y+B06\rےCC7B&r=̦\\->3HGY䙵6%/y\"z8V<g6'żZCTlR,A;T|ᕍ!D\nRb(\\;RНZNDO&\"2[1JMѻ7Ug[LDu.CJT4C(x8AGEdK\r9CLUL&y{+%Jfsn\0007/`ƫs7Cln|!D)oJD]>Cr	8 5vJeX[:3?Q8\n	D*FpΘ4Jd,vRû-e&hͣs\rmUѥ<m5\$>2UVJ,%&'\$-֖\"A#= \rcUЕ>@@`pA\r9O%@C4CAՁP81n3Sib'Tn:Ƀ xBOH\n#\$h! fPqD\"SXbIbhhF4@487\0ز\$1@;#ꄎaV*S\nA(cG(y\0@CD&*B)L֛Sx!Yr|P\nIUWp(CDQ\n\" Qb4NܠHyOu'7J8SrC2\n\r3I^3\rJB@n`P	L*EuA& Dr[W2 #Z #T\n-V+;@2GK}0cjk\r\nP(0z7*c\"#E!E;y]<`\0U\n @ &\\\n/\"<A\\ۢ\n1=b(拄dRJ,-t,\"	o0!b\"82\0EuNa;W2>Yn#z[T%~V}0/\";!\"Ȩ%!k^@ATBUb\$J6Q*1YAC)\n\r1(☓uɄC50r#G\"!E2\n=*@m!TkB\r+	!uwJ'F/3i֍}*Ŕsp7YlZxu@ùdxŴr t#(Z/;	/x+\$@j+k5N]\n!AyxofO/4\$H,7!I0Pڔ] i	rLoto6߮Ay >Z NSbj{\"׼_}D݂`i^etn)WR\"j=M){E\rM_|PhB2O@Dcy<\n7-\"Q@-YׁDq@*8/XZlab6ð2\$2m‍\$oF8m\$ma*0*20\r\$>KChlXRPt),GQLHtZBD~8Py0\n8(_'3gJ>g|k6}0\\SЫlH/%#`N>M0ސ]oԈނnh ˍp.Q)1&m0%L?'юm1I>!!x,\"鮀x g˔O	OP,ɑ^P'?HѨ?hGԡŲWNBm'\"B2. ŜB\rD,1P!Wn01\0+RA	 .Ꞻsa. )-g\$lFPsnWPZ%k'&%=Y'1&0c'R^?Q:~.jAC(^c ng:1ZQr(MR0N%rv%{\r~#,RPu]/%0!0rnZP+0t0q'0#51s<33qo&>SC-r4E1AEtM%rSW'p#u}C1i6MS76S고Msleҋ8\";]%џ9Ng%S<3c<o2\$ux*p\"98d7?:s	\".9-h2a3a0=aB(9SՈkx*31\\gjÁ*FtPErJlP;h\rVp`TaE8\rp\rb#nC*@\$\nZ\rJ9hDW0\$8,,E+/#1&p%P\"2bTQdB^hjCS/S=8EM~'EC/O <dh\$3pf+\r#vWo #(NWXor\nf7CR5kUJ\\^\nuWxrhQGy\ru\"\0B,^U |fCb`}-\\q.,.\"4 @`@UA\0utLA\rVHnB%hP2\"..NDkzЍGQ\\OXg._X*~!Yn\rFd8E4A3q]5>j!D\0Oj!\0";break;case"ka":$f="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-;.JAJK ZmO1Kӿ2mpvK^(.䯴O!FLڪRkjA/9+e|#w/\n❓K+!Ln=,J\0ͭu4AݥN:<#p0HȋXxc2p4ՃN:K\n.-w943+6qvNh\"R*;OiAjsZ=6MAԩpL=lZR2꒷Ml_h3d995-A󮵄6#uc*݁bԳ*<(KwuЌ5_*\$!\0]D49Ax^;pÇ5][}z9J}\08Z|ષrwB+ Mxv6AA[C<mp';]96u)RCR4/=\"8!\07h1\r2\"U|1ֶO1wAlEn-D(	;[Ri>̪*w[q\$ܪ.K['ýs\$3mCOK1jmȠ?zDҖ%EpB>ȥ/\nXRm}frK&\\ϐ()\$GNڱgofmJyXQ!L((^	>SSy\0Eb9\n,pOd~aw&#Z[\$6Q+ۀku'\0 bAZ+0Ho\rԋ0 ăEp40@UXi\r1Ń o6:^Cb@Ⓐ(=da\$4T@R{+}:\n`n!iiai^8\"Xo:xpP7K#Rbi\\MkDqPY,q+=bδYjsO_ݍ\\H	w2s'\$@U^tE<OAYH#u\"]&̏<0	DRIM0[rQ.<ue( ŪJS)SIB8\0}N9*AL7ue3&h͙:gݟ4ÓEh<E{#SPjUٗb<Pa<ʥi<,HPs*~2b9KsYp-R=NI)\"tfA͝	1IŲ\\):#\nj}21I%H}vnQS'8eK>`K붥nܯ A_&d:U|u:/ba}mM3[\n1\05^4Sv(ІFbA+&(۸NNa҉lJu5^8lu.zTY,z=u3BInط5I(K\nIY1v*=6:Ԁb991JZsl].8͞ݤy[&\0¥zcܙIg~6;7|B)(.#Gg;|[g|4kGIfVXxQPCZ`>ĽRANIwgA0T\nRU^l@ɞ]+(y	NmvxJpݑvCSlɽ^J?q\$R^9?ĚZl48	Q8;i@Pf7W2DeS#Ʀn>R>U`ԩ}e߃g۵*e tHzjbl5~]䧒⫣u5y+I<_%K7w\r\rn2rINy\"ʣtгkV{ښ6ܤaw]I'bp}I\"tr4ZgvwQvmvվX]xMnXϿt4]]urΔESu\$T8Jm@VMS|T7UM\n!P*WAk rӈkCƉN+ˣvlГ`@I/*_Dƶ\"#䮈*c d%Zy+nLtq\0&k^Nf8B0?KLLu&JY'+D;\rnubw\n׫k꼕ldBf8҉bС\n)Pħor|+\0	dME*\$\rĠ­XNDÆ)î(Jn\\7h[B=lT|nHo#O@]NrB8Q\\\n#zI;N1t,ԯ\\~L)P9`	Xvq.l.j\\'gBezzz+\"ILMf1uCmŶ`Kp:o-BS4/\"HuDVaPBh1\0t,xqLG*Т0ʔ(]2<k[qg&J'\"=%Jڌro(p8=F%*1m\"vrǉL!Cw)hpbaoj	4Tt)JpmOoP)RڀZ).RҨ\$ERAI]r(ɐX({\"m\$rK\n0ĥ2h⌱lI1DLS2M6MK=2Dvd!lPs˓*2MpPM;/-ދDcFd.c5xY3iP#M2/q:@MҦxI+j0}&>	2A\rE/ZS=A/2~6q=61[mHi-G'@@TsgA_r4C01o@3Ή>dT5Dpњ[\\u1Y/:cPx@\r.M1+.dnRAQ>AgI.It'/qHb?J );n{˕EqAJJT4[L-J#f\$ԲM(i1~-^ıP2%9퐟2>4iP[Qs'	CNĂRTܳ<|	 RMJl5T'4@U\nu%<QVr#S'Kk#]D(*%/XT➠DQQgYqUJIRi&3XSlZUL..QR@tRPJ	Y*Q@5ZZO.|Cb`?l܂ҵIGO;YY>+r ]1\$Ū7O U\\B}Vճ';* 꼧0\$i\rV	JgdL3شbJ&䪈i\0@\n@p486iJP11\nЏ\$\0vG	S54j\\lS;yGUMxo6})g5BBGUAwS&078ABTupu;\nLqa:5[Jn)1\"(vԯx\"|\\	ֱIS:'>rw=x	/|S,.Űc5 mw|#{jm>UwyDBKiHtenWF }d8m8LF1 c=EhQ(*d/hSvC:(Ђ7ϗ,6VtQƸ\nxwʊ\nJIyǆb \r\0TU7u[:OLy&JFŪtRl";break;case"ko":$f="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠈0C2 2a:8H8CC	2JʜBvhLdxR@\0n)0*#Leyp0.CXu<H4\r\rA\0<\nDj /q֫<uz8jrLRX,S\$ð6\r#\$KxA	2(:\r48栝mvBZ!%)Sy!eLӚuv]:5mAQ!uJ%Qn͓YL'Qk	NrgmYVc kGCD7đ4Q13ݰ-CP4@:ăAqt`4Rc0z\r8a^\\07'	},02\r8А\r#x}NS\r #!@vdETi@E\nv.,ed^sgkEYTT9:\0!1\r8CxÓ4UpKviA	TGYL1:> 3#P`2ZA؜0HYbXmiDEQPO*uc\nK\$Cج-KBLd H #sd\r1#s(1Tχ鹎rGcU3)AYN\"[0zi}W i'q\0PADA;6Qup. ܃(vo!0Cc! ߔR\\~m[qkE'ݢS9bH!VOК\"#eTe*3P!\rm܊\\\\r0,vA:4F-ŖYm͛BpƦx`a4GԣEH.v!F )d%dH%-XQj@22/\nBMtMb%=9%\0yLY\"PpL,tiRhń؋b]v6a;L٨ne,\$CjFiCz噆^{3\\Q-d0pڤ\$*H9^eH,T\rqw)D\0 Hq2&bʊ!i\"P׈fssLTfS!:fs1F(AyPd;<YgJ* _Q*,^\0^\0`hjHc\r\0qv#JvR.u\r<Pb@01@<KiĘWjG!S8BȊ:bTS<&D>Eb@PJAHhE#LEIe\$ꉓ,7P+\0Tqtad\"A%c\rK7ކE`\0¡~X9!X5^IO)[H_MpvhƸh%W2]	tMb J`F\nC٩^B\r8%d82갾tlLcp&d\\mnx\noM4^[}dy(+R)h&\reՔ|ʛމZUXa>q:# C0r?*][FAY&򊪖A\"~Wpg2iZ_t]k2]D-;\nRib֨%EQUZSFcguI|Ȕ{LU2Xeh*2kxN}J\06ElҮBY%eF4&K\r!LH8[JkIsQI_\"mOGarfN]NӔrg`RZ+L-eN)[@sR/BTҀNDE_EVd*@@ H<4f6]a8J1/yy%ܡ1)(d=́Efx]d~&\$\\(@7GG):	wԏI?l<b{|K6{Y9|Bǫ݄ߒJU=AE6D.*HH	\rA<tlH2flU=.%lUb@e?آ^4+>Xd2/M,0\n6066k/\rI1mN0oV\\\$ND*#HB F0\$cctniJZ (lP9MPL5RNRNnȬҐv0IRM\$k_6,[\nVk{H-mCoҎL=bpH/	,BDW箆讎ex3n{O K!, ȸ#qIG\rG/P䎥P	CcA%brA2(M8TNa:T,8a*4|0j1=\"<Eof+,!*Q%\np\"K`>JUfmP=\rQsn*Poc!9  .n(yR)!N<D%xH\"b 66:Q.ч&dPdwk#qh T-N96u2:җ`\n'.\09VvqHI!+K(r5,ғ+Ւ8hd1-/\0()V.w+a:H74m),rq\"BE2\\T14增mC094r6ɳ;2C!D\np12o`@#3!3S7rr;.@CJFf,8kh<̞3!Tϣ7,+`F#Fs!!1,1!jނ?2/,H}<k=2K>VJ* \rVe`Q`GBti\$e\r n( 8\r꼋\nZ\rƠ%QA	Ts#22R3!P\$h-F,2rL\$;D;2pZpwx#_Ittk}70Ԭ?M:\0N,M#sIipN1߂pgxAdxp<NV/#bHp26o\\!QQwRE>\$Sm`DB\rCVSGQ#!5:,Olw4^&<o&`xpO\nі*PzqJur%nN0d?3jVU-ZHP¼@˯m~Lm6G'\n>}\\k62-2YL2N";break;case"lv":$f="V0DCse1Mг~\nfaN2OFC)sC͐#&t&)2ӓFD	m 2!&r8	A\0BP\r&AeNgIt@\nFC1l7AGCF\"%I7C,.'ab:'#)D,<obٸu22Q@ S0MMө_i2|9R?0&[w0DL:N\n\rC(Ģ\rf!xbo|00Č0p@8#އ'H\"Cx@	b\n77P.T6j9)P!\r#֯#ϻ!mS44mZPCJO2BUjbC(6d͍ô 4t@1L7L!7Irq#R<(B)=K<#Ɯ(zP\rX2EA\$׫th؃\0x\rC@:t㽌5\"\$|(9c2MQ5#p̽)\n\"%B:xC#LIi}<>\n`K`,6e].P_ BP)⌊ʃ:\\!ƷC86ШȌM|9!.b9o\$Ibf/)\"<%sS?ps<#p.2p~\ry޳C]<3{:>706BjzP2C[	h^/KB<Fz4ŘBC<+'IbLfqIYWJ7∙	qZ<L;FaWěI?49B\\6/~5\0pz< B!{7JttkY֣ ;ϕB͍)Fl!v\rbo%|zzԑ6:!b1N*zP\r:6`tLU#2xzv?#t4(N4_`.m`1 I9C%\n9V*S\$i.I&ʪmT#\0I	vq'AOŲb\$\nFBTj#Djy	͊Gs=bN.H ĄB2x\$ZG)\$¤4db*Y)MDHGaυ4H@J1)T6h9E^S'<[!Tq4dKzºW`,%YJf%a4(a-_iڻ?2ȽZb}'(g 1^X*d3X9J<`5s^\\Hs%\nLYrSBIxx,#@8RH\n\$Rl\rAS'h X*l\rrcBZ)h	y2*(aL)cp/+8r크AS\"\r4tʪX)G)%.cXJBʼb<Z,b|Őe(s_eMyb<R7(T4m\n.Rs1)\rBMC n\\\\\$VAP@3\$Ǘ4tv!Sw	X%RHp@Q1&dԛ5O˹D2		޺B+JCD- ihšz\$v\0ӯcЎO\rE	`Mظg.\$(eE!y\$r%,J4BQ	urO6^KąaXPBl9/V'\$ \"ueQu\"T<AJU/{\n6MJl45?9zAs{O~dyrzz!Ƕ1k8a\nL3dBTcrᚈ9<۸b]y15*O\$*sN'{o	&u)U)1Kː(eX#;aޞr*KAfASP*&\rVlLЊn C4.VH\$\r)gFn>r*׆>Jn%BZ+%b9Xb+6 ]Q;7%/Z咋>q[itka-?1NONɬǐ-<v=+-|>f/ERыג 9Ƚ떅uU\$4QQ,zw22tԓr>hAmIx\"B\0lD\04\nܷEn)/{\n!Hޖ\\hh1cB.,dg?yvff&(L=Ȧ(m\0tItAM+ȇ1mdHemj^p\rjk=E.8t`|BP(Ǡm\r\rprFO02g%\0Pr5Rmf0'~AOL؁\n\"!\0\nzP\n&_\r\0\$鮂pu؇F~N\"P.NE@Spl0.MBcbk\n͎LILNKR%@ıG\r͏\n·+,%ZVC\"k.\\0u\0CE?+iP>o-wm#JoČ12hX1K\0+/ܔ\$0ȢAq.0ƿ\n!'7s\0R0f\"k'pRP.!-\$`\n-\$q\$jϭG&.*&\"u=f\r<li!q'K\$0!&\$rGd\$E\$p\$t+|\nҞ+xCP첲*vIfX1b}-1*\r,0y2x\$ލP\r˝O .-1,3gj2P|;/+O6H-.'.#(iE0\$OjC.Z6kSm#7.d'6f	c\"b^pJklmS+:f| RPx\nvOthd\r@d&ǦKNfGP\nZdV<d2æ3\";4Od#gAH@MB0\rb<m @\\]\0N3;Rc<<iFhx@EEED3DL(g(H@+E:Q.C0.\$O)!\0000\$\rs%1G\$TtBPdEK;mIfK>C\"\$tbmgDuM~/&QD.ľh\nj#LL>CB\"(0T\$C#cˢA6w)dlJ̾#PRm@T5 %Gl`uJf,Q	JG	\\";break;case"lt":$f="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)nh;%HȆ>{~2.(Y;8ʕK*Ʊl-B8?)|7j/\r=-P%#P₀ЎtJ\r4-B6A(0(!\01lRU[l0j\0yb\r0C@:t㽴5=R9!|cC ^'Aڱ8̱h7x\$n E2D:e:&)V9;k4C&\"\"#n\n٩i{0PDN!ӢC|l2 ;\0HK :	h)`!KmR@\$t8B ʐ,(`KcB7h۔Me9挪*ux\nHҿ<]\rIR,:L	V.,,ѠʀiZcVֲ0&\r,6mѳC{݉/eWQ%	}uDx`6b'G4.3I,;;SRS{zSU\n\"^DY'%Q'46nZ)(=g[Ӌ! )WXl!=W/_.0ʓc(x.aHY (8sdQ~Ugf}^Z	%ˬ7R߂@(%0RDT7zt\nf}R%3R'e!#\$mU.tOxHdrZKQk-K9.5a=]k\$_p/Y,\\|GH]1zx10FS(+(_u0ʴÒ^L33~բ͔}U4t%ڛӉ`\rÖՈ#gGCr>fH\ny%Dv\n	)xDU>xV*\r;@gZS}W^KqJO8b^RЍL&hY֢7Gףtxx~Q\$XDgN	9)%d̡\0mGhDvv6\nhYiѯ!a*́R\rɜ[I#6f^DL\$\n\nITj0ƂWpҌH²Gbdinŕ6V?A\rXkv!N@Yms#y\0@HndhIוƕ!\$LL=k:\\i\\7:4L/O\n[QHq.?hD7ƨQ;'nѹb75}EqR4GNؐM*ă>~=|V}\$hS%-ck\ro]dAړ\r98	j	y0yBnd%BA0&QB:RJl^QqK_/-A2Вjf5\\\"zRY2mQ|i@gC#V0^nd%1'Q#7-Β1E,D)Ti1C{) l\"ʞd +۞3fXE\nOyz+d\n&v\"ރGcQJ;a*@@ 	ěgjQ.)M8GӁ|X,w+orf'y՝&RHUD\n\\aJdEs^MCH.<>:(Lchin];a|	wX{tZE9yL=:_/n+w;Mc̪~C&'L5oIgH-6QCJYr&\$qaYv);B<\r`a7	6;r.0<g`?#~!W):|=8Ჯp=:k\"BV+}̄2.~_0s4 oX3\nRiy %q>5&.E? DH|8fX;@DH\0DC0-O\rojsNf06%&Gi5@Ptl-6mQH<|XqB)BpnbL\rǌp<h~V,o\npM{jkNw/K箞.0 -a0L0?-n	pb\n\r:<q\n`1	oQ%H\rJ>7:Ĩ|Lj	,@<kB\"##Y1>f'[ozJ1JP(P	,l6H7\r#(q%)Ƣt>\"SO<>٪0բc1\$ȏ-`ЊM;cT\"1\"Ic|N~bʂ= Re?,#!\0KbSǂ6cPPQ RK\$1.G>n;rZf#2r@b!(.c&2w%?''@tD]xjhH2Dd*Wcof8z砷jQ)J0<?)K,,b,Ȓ.Or+qS/ۣIb Fd<oO\"&GO,O%*\0/%\"o&e&/k&_gq62>6B=657RpˤI7o%D8p.	Ƴ7Yg:]:;1'0N\$_fl\r gXxm)QFfc'\r4\0\np>ƻ>C\$0`<#t#	K?\rg@>@'\"HM=,b/eP8baB{3*tTh7)sWCH|<\0%JmF[Fm@vBD,ANt>\"6R*\"M`^2d~s@oҐĐl^`p!BplѪzwjLoF23%lbOJ6ksH\"gͫnq`@P%QK\"fxS'x LEv&~\nLM4 :oha\n>ylY`j@M@,*m)	 \":\r0\"̦@";break;case"ms":$f="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0P7\n29x@1C(ȟ!S(2l8DB0	o@\r(*3v7.JOs kS(ì(c&	>o;#7΃@@X*D49Ax^;ׁrE\r΀\\z|H2\r{ԌzZ-!^0(4/(* KÆ\\ow(XHzhP5I\"!|\\1.xx6\r5H!\"Z|\rJ7W37H̿p\r. &LJSqƨZbɁL:,M+j'\nz\$w4jjE%P݊b77\nzc;{ %(p	:4 'I(E2N\\1\r-WFcf&T/̌|91{.f!\$H8f >jY?XR(dr6C:r72`/0lu]7f`)DN\\3 4tOI\$P'&^M1',59DnDY0Apt3\0e)D\r`!3	S]	&!0Td)eЁAB7Ki%MCvS4DAI*P\\rVJ[+tQ*,,E3'ϙfF[My>BhڐgCd49\rK@fE4pTJr300cRS:eҡ)\n8ҪW\rd6%\\D\"BnH\n\0PRL-\$ҤU\nTןAT7rqDP:4RPgVIXt,04D4EfA7O/}64}(м&]\"^0PL	I d!S\0PJ#Dc\r	p\rP0F!\0f8\n>QP(\" r\0@Ƀ9''Kt9=<Wbycx8r.	R-f){WL|2*LhmH1xd	CS-1ҍ&@PO	*\0BE6l\"Pm\n*%ZZQk\rx2f\\+*LU	O:GP\$ܡ\$y\"7@Bg!ۥNEIo(*nBѸ]\rhv隸u+#Tm丧Á>E0[m	2y4DD+RI(:im1əe)@BFϱz\$!\0Ip趴K,ECIi/6L@`imż=È4PEhu}Oc0u)s\\،ֶĎY |t&%]^n	R쁖 ƥU]0% mAC2\"()*SRΌ9\r&z.:,B'E!D:OQƄl2*;\n\0ib\0V9DN1/&丛kܧ\rAKMu:F2U,vڏDjhP\rlؚ9\"\$Lr5^q.\"ckNj<>(ǜ	Zh<`Jo3obPt\$5t6.1\r[g<.]5޿z! EɐKԝRdI_\\MLA\$h=ӟ{\"OM`]\$%qoȩ%L\\ys.Lķo+KÙ\n;oPw Hҥ\\Rt5O:-(͌=cw:(~3\\un络.izPzF	n7VxW8g.yK1w_s,jγֶ<7Y~a/,,Otq	&z!NnÎdj3DəU<LʬNg v<\$SbkυD5ߙym]>\0(n\\4t#\0+^&orK:&`0P)\$p3Iê\"bF9?Jf::B\$~Όp\r͂#S\0+B8gkJƩX`B\n#Z]@D9ƨƨ	\0\0gFL]pͫF~fC	lfC-M@aż'Nr&t\rpq1D( F\"όMP4mxpQJAG	fi*b0D;Ĩj\"?O\"gd0(j>Ə0>:*u-jT.\$\rdւ\$C`-ƃI5Niv C*3Sh)\rh\nZJxQKv7nmHf}X8D,0+OiD#oB.J\"M<ObːXf&-ddF(Q^nxijďWO6Nzd\"~w'P*r`6&nW'Dh6^fjd֛	Zľ%0 \rNrșnkr- @Ī@\n.	M)Bc/fv#&\rU.4-&x9x)c'~\r89p&e0:δ";break;case"nl":$f="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n*э:|m0KĤ=BF'K.O8RxwEّʍ9C\rֿE#9oEhi?ȕ5u4>T@f7N%YXS)6!Bюh+âjH@M(j*%\n2Jנc2CbO3ІJPʙan\"X:#H\$#\"@ഃPïCr1kN.(\$ð%-˰@1ɓ64qLØ3Plcs^6B:@9O j;70Ԋ9\$6Ib6Hh@!B~3:|:5#4TD2\0x00M܇Ax^;فrcP/c\\zfmRUMH2xAl7*m1q3ƬHރ9;j\$m{7`̈ҕД0X	cxTT/\0 cZ6TR CVf]}*GL_/\r\$ˠV8i\rB3zjlȻ%!K1KȈ#2_%891P֒(Ε0XĹ\"x)\"eF8<淔cX3=/6Aͷ P2;f2J4#z)OZh*1\r*2ף ;zbXC/հb([^ֹ;#XTp!O\\@\rzF0d:bu9_Cz&0Ö٘3D\r6BM[jRt1\"8p8pJ @GI#Pu>+᰸\$I&jFb\$]1z_(+8qt<)4nPeua3k2Rd*4IaRvɷ@@_0qq}L̹7?C4W\0004,%BYg)B\rYGq(s%rfJj]`Y@o=Ɲh\"1*'j8\$pКH#\0j02WJc~аsD 9ƨ{p%a5Hf=qJ2GJd_Zt (*čңY(*WIG8!ٮrQH9W]@4Ex˲y!*DԌ.S\nA\\%_%d]ԛvONrAvӰ4LzPU@!䍡 \n5\$k:@w}\0%Pr(1LV9|aV&Q	P	L*Ȱ#P)e6LKԴ%IMTdQ4U]-Jc,H3W \rfز@L1ם8kH RN8ITCIF.@3RU0pP*[ E	ji\n\\0z@PL&m/EB*\"m\"ݗJk@VGI7µH\ndRȰ+1t`&HZ[&%?XUTz3LVa~/{1'-5cJB9aVQ3e/]zv{^)L(d58J``94XL8SL9L9a \rj,\\a13cƎ-(ف+a\r,*3.RD+?w'4Wp*\0q3\nUn7(QsÐye`\reY)2D(_W ʰ8m\"f!]8*epXPm>eFdVsH߶{Gc5gC}%XRUU\"VQ!)N07&'=p\n5ĥ3'\0jm.2JkOAя7AMf1y7%\nTAHEL0Z@\$ضPR_b۞.WAMDB쓷i%σsiPKPg-ÌUH}{NSCżoΝðuJ27V\n@PNPxiֻF@7pp.K-;at9K42:Sꙷd2}(ߒOF[-̱EA{j?W'B~>Dnv @ZHZϠ`gL'LLJ@ B\r䮣|!\">\$8ɒ c&,DJ0(<9\0IL(I`l\$D9>0B:,eFl:kf\0	/v&2-V?	*]D80)\nn^s\r\n4\$Ǻf<Kfl&@EC.x\rcmH/Jq\nÈt\rx&\r?Q&M)OC\"u,K@܍]\$Qhq^%#@u;&q`g1bqnљ\nQQ-bQt]1QL^tK8Ѷ2@6I`n1&nL!fʉz\$<!j2(zb<k\"0/\"&3Tbe\rVd&Iv5	Ϊ	dCn\0ZCcp0Gb:bjۏoa^zbj+{0#J\$aBʌ2udjn\$#BBR\r`DTr|5RxGbY	yF9lR֯\"D;i.Jn2H\n0>n@A,#N0RGC!]3zGl6	5pcb;6U]7#7o\"tLb78):\"!\"+VdN*4(L8,ڔi.NffpBĽ=@2\\c4%P9b<6B%\rgc6)\$2F\"V/;6*h45ЅZK\"7`\";7І\r\\4C*]g~mP.Cz0#B&`";break;case"no":$f="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2ÎtlRn*<+39I3ą-\n>ܹm1S\"p孀P2\rb򂿃c.P4O@;#7p@\0yM	CBl8a^\\Ϩ-8^>9xDjЌ-2Ȧcx}'4Bo:+RՎH;WT>-'.#\n7-8ipH1\rn`8F_bX;Pη\0 #z50:t66PU\ncێeCfTn;-̨80\"H!8C;	虻bׯh1L&^7\rSL8\"R:7H>|\rւz3\"	,q#/O#ŊMʼxsrr\rgFhZB.PB38m߰*[kmkݼ(!0<lrأ\n,f~3(\r*	 |c`Z4'cp,3B9S+gpLj2;a͆R^![j'p_IH\n\n;\$ &YS!aAI68psU)v\"U\n:*\\O\\ܮK|	b|^Y1\nZI\"c\rYDpNY?%8M\nnpò:5a͒P\r1)\neD,ҘYwS*5C3P%EfXGďRHψQ/L4RR\\KLS+&`][F-h؟\\\n\n()h՚4cK3&mQ 72\nX\nL4)gUH1vHJ	)\n<BS\nA!50B8`n)p`Xk!\"\$p頂JD<Ta*YmPXf=9So(2m	͍!42T(\\E2@j#lE-PHI<'\\Q[\$ptK>02̑#ܑBPSn`A+A\0F\nA|#tSY&#f͙,\r\$\0:KD	8PT2@-cLQ:QdȽCL)&Ks5f9d:Fd\\EѼG.r\r  kej*sȨE5tI\nV+*!Vpt*aWbm	[Q@PG֙juiLe~2̭'\\+41JJ\\SL,򋉌%\\uSș'la4r q~\$ȗ&.!!o\n\0#sm#-H8\$KkP2g\nJf)7H1kBC	\0M])PQ`Iɾ>xCXI7H\0 S!8PRPBa	\rMA1jPөl)ٟii<:j		`J\r_	,xnCJ}9ǰ;#So]90ݰbb\\0\\2*/k`K!#,&whॼ\$>й;&8@`\nZXo1vً{ESD\"|~>ݼlC)ksr5ـMG\0l'aLVwB_mT}Xu2gps`.cZN\nZQ]`6\n@PNRK@or?WfS;%4[3&4ˮ?~j9!zT#xK֪Q(~Oy7l%:t+Dkmq}r~\"u6)42dnJ4̻_3'|'B3PA+nְ\0At+>E{WgB?4Ge>E?7*h0iÈe\"'Dok*Og%L]p̐nƈ.02\\:o='AϲC7r0d]TJoNHpAL(L޼0+7S&N	@e\nbI#\$J/l/0z8=c'qJgP;k\rp/700\"}\"\0P?(p(1Py%F,cF.Eo% ǯ	lkpU4	lʃ1\rLH9nDFic#K=!/RQq@fc2d*hsbAR&a(%<B %(d%ϴ	f(d\re`;-Dvٯ|փL*dF\rV\rd!.4OX.Ep~<ޞ%1a\"02NB'&\"&h]}\r'BNCA8Z1\"#\"FCb:dE[j-q~/0̣L*\\/0\$nǀ#̺Ütnʺ9-(Q6.bf2+&S2\njB:<Q|:{x<\r%%Q'))P̻x0aqf1\$\0-\0h'@d뀸L2Pg9#bR0\n0!@-\"A\$l:NE.\r ";break;case"pl":$f="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#BH;'HȌDN?!\0\rl)12X P/>R7#HݍxcK+55SȺpC8Ac0cN8@O!à7,XD49Ax^;pU8\\z Ü!	%|7{;px!7c\ncJK35Z6q8a?!Ss2ȍ2Ĭ3\"5IXƑߔ,C\$[z*;BX6I\nm3픽\rӚ];e4cjPM, P:-: p<)X[ bpc\n'`T &\r+å#BÈ:tH;Ԟ\n\nx+׹\nb@*R㘥MK:wś܌z쿺\nR80hQEP!|9SUdN\"Z@i\r,Fg7!ׂU7ݘlS`)Wa\rEə Ѕ:fDT\"8c\rN8x l1\rRB_f\$H|pTنb8NKPABc\0YbiCxzB*f&DIY-%K:*PNgp2uaIXNX.&7Cc<G`]霐A(A!S\\8R*FHʌjJG5@<\0 Q6'`J[b!\$ew.9³ҜPSxLũ1YA1t  g%-Ԓ3&p.ZIj-e\\]q`l]PC͓)\$\n	B7EYtJpdBAg~A\")D0JI.FTNZSPP\0P	@HF\r\nL`r_!\$:<J]`OVSpPZN<'^|iDȡ؀..utPǩPC2uAd*'̀.OBAP1 3&N!ȝ?<T7B\r×Pζ)NARC>e3D\0C\naH#N,4ʥAT0Sڤ֖R𔥴'\$\nHbBʗ@q'ERbkdB3:DVF ER;4	\r&'a̹t)u\r%9cj0uM\nmj]LD^R)T\0%1q*W,ҝA`+WEC˙@\ro+!\$æeؽ3lmP1@!im4fMXaNRyxpmĘ;c\n;S.mh)H|8tT,)-E\$o\nGHbqD\rI<ZU\0_XoWA\\>[|0d+`PJ+\nN`*TľRFB}e\re̗iC\\(}v\"(A&-MVЁ<Fɳ?<R3cČH\$T̝IѺy+rwYv̕9҈lX1OJ+hNi2ڸ=S0mYR\nEƧԾF:\"jjsmn8VDo3I\nK*@AĴ;sGB<'lGéM`4J!2(H<d)ed%CYK@Tls2GkѣJ=:adZ|v,Jhȭb%?\$zC~`g\\񠗞X9%\\1b4G2*pFim M|D*FxPf-@ydo\$vLB'X\\lJ)L`x5H(M#@+\"LdĤld0##\"fL.mT/RC#F\$,n+	fLp\nl-V(,	&㰅/~\r00z0HvM6Zv6ͤC\"@e#4lN-Òn\$V*6\0ͤ\rLpnG^L&iڤP,ހSR%&hP{NPоtԱvKP=ћH;}P\ngAPHI1p!k&%\r,aP!BO]oIMCOe	.WRL p ̥W\\q\"į11O\r[\$q%eblR2XC|@etS,p&(+B\n\$2DVuC-eAb%wZCJG\n;(GCY)Qb\$RIt-vKby\$Z(\rN\\JROX)n|Сl&q*n0c,U&S'zrb&49j&bWm^?E5.i3ѨFbpzn3%HJHsF%=C8B@8TD DX\"#P5B#3;&#3y7\rc9~3E?4(..S?3z#c`ͷ*2\"i/\r33%\rt\"4E'B3Bs-=7C!@4tOD%?Rg2Ȧ{F4;3r.b44Es\0Cme	)x2#IT%4o77Hn@J:Jm;rP4줆*ԙB\n}pIIG4Q4F0NdX`-#'3Lc7P!\0P\$(S22~EPRU\$3bpbqR#ѹ\$FLmVVS /g\$L@`*?q<t**\$Ð)ú),1,K)S*-!@JJ\nZlMFv+\\O&k\\ tU-5\\Քo\$	\"Q0B:l\rPcD:nxnpCCXl9N5*-g2BkBjTx9et5x#VCU&	#Gら7MV F^I\$u\"\"Z/ֆ\n(hvg5H'j'jmRq.jiR&/4ɔ=CoP6Xwf%pR\0WSh@3w\rpɖ\"e,oopR'Lijb`yr(5r2B'pӮp~3fP71gyX5N4eCҗXf6\rA` E\$-l1	\rKþ%";break;case"pt":$f="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%lRH(<	hrV60S%@!@DHO\$ ?D8\$ТPӁS?=PJ0[2ir j|AAƃ\$:C;#~:0A\nC X ΌD49Ax^;tmS\r8\\zP2(@ˢx繡^0׌k<҃S)>	`1+űSbaP7̺϶PHpΊcx<h! @1(H\r`Htz6\0`>*1B \rdhR2߮k#hnP؁U ӵE(MPxK8cfT\r{*Pp9!)vKfd\"Ԍ[@ؓW-z&\r;➩\0(SC;xkS*;!G\"/:(\$)-r6\n2D9r%R[8P0#c~2C| 6C1ra@RRn@@z^[Fu%\0f_yO6HeÆ'DT	q-`>\\{\"x3JK8op@9FLRc9왖ZM6ު'\n\nrOi9	W+@M!2p8TlV:CHq)tj0]a!4*_*p!e,ŜZ`;J\n\\AqM	b`\$^C_h\$|b)<\rh^O'CBS\$ L]OܝB3 q	>:DKB]]WTASPNiԋpЌa\"'s9G'AA@\$\0@`LXs#\0nLqT. n:p@2hL	AC\n73R;#R#ڗ%G(&Kp'mBpӒ@Ws#,_1HQ6N!h\$M\"M19Pe|oL+h'\"&e}C=5\n<)EqO` 3`܍]ԅ}*Y2ajޭ?9;\$+PlE:5+*NP\$ɋXs\0\0U\n @q@D0\"\r5hh݄	`Rx\\xpn\r6U(\"->r߅tCrz\nQRJLC	8w(T2J{_D/㕀k(x>E\nRz5(B\$f\"VejIr(GNGBR;'qPN<3׶QmѾ_urF@HnE# A`aCI\0M7&Q4J0394bu|Éi\"ϊZR/?vbqv{oPT9Kۅ6aBS֡3k<:rnɅ,Itw\rڧSm\nP 0uAPI#%ɪ漎Y3d3m6PY)Ȱ#:gj\ntAp	mwrϋAOl>ͻY#VK1%u%\0q\$ۙ}<6	[ċ\n<\\Θ.4zw1=S lȤU9>d5a2ƔmUJ2*4C(bPsNSx}+[iƟ~Fܾ%լd2OIV.0oƣ(1FޘtwaI98')}`qw]پ\0('`^\n5z+,M!@GT/9yF=oE8:E3փA^=]\n93\r0?x>3-~w7_p̝a<`1~]?0i7&:BCpMݠ\\&\0-Mm߭dRL*æO#PҮhN1,h(}()X9/,\"%Fib3crĜb6o~ \"&@ M\r*6OD(C9b3fY%do	\r&A0Fr'\nv?FMƂlb0LR\n͹ 0(a=-p<\"p|(&\\xѣr׈\n4d#\"\$Fshn~Me>e^Pւjms/p:tj11\"vVm/w\r %G-m1<QC\$~o@jl'%qxZ2q bV\"+q/9h4.9(\"&pQ\"DM-%.ӍFb\0QQEx\n@&%4jc!	\r\rG(~,Q8J#/K\"6Q\$\n*/_\nh0Bez3p,xF\rVeoR!D]3N@ED\r<A˒\np\$aL+`2(p))8G_^ bO.#n/9!C'd-P? fffwc8l<(I!tkKbR\\Lb5#dcΌ;C! Rce;4.vN0n}ec	(ʳJg&sc_=BpeCTB\$Sx \0i%0(D^x+N\nϤz-wD|0Ϩ \\#':mdB/\$1b.~vhm1+<+eHe&V.dˑcmM<+N";break;case"pt-br":$f="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR43Ґ 30\nD%\r:kCj=p3C!0J\nC,|+/,\r,`1q\r{ϱ6HL\$2SҼA#\n͉zz7%h0 0AM!#!\0@;J\0TBI*9`@UCF3:xgU<ax	c ^+ѻp̾'|=T&O+ۼ*cb\rG	jH8_\07JB^7G\0P7r#7\"\"2!.Q Ⱦ66\nuXܜK-8 8 k\n-N(#fO6%k͠Pӌw(0I\r	VG\0::*ZwKBBkbRM,1*&L[>c( H[!PaE=2`Ϡ2c+]DA7fΛ\r#b<\n2|9i+NZcMx⸃-|ۍmNira1Ue=`!]n2Ͻ@V	0.D@59+zA;7cS3f0fM*`=tc:AfM(T*5\\^''RhR9\n2Fx3\nYQA_!6IqD]gA405r)+*Y+-fTZYlDˀ9Y]\n(0T\"'doyȭS`OɔrAU+GRyWhUXs5)#\08xTtNdΆgL#\n*Jaa@\$(+\0dfd!,\$JyR[d)r5_[\00\ngXD(,\r802\r4`@Ii#6zlb ((DNB(kPbx\$Q*j,D\$cCܘEH)9	\$T<H;'\06Y٧!R9?9RqD -HO\naQXO^*d87G*5>22]3I\\88@T!\$|h&!`Ip Ro9'5\$NB\$IqiP*Vm E	ޑƬ{4f>c:K`x4UHeŶ M,ɵW+ ӾA/!\n&(ha+`8g8iUz%\0xٙ;KoՙBmÚP\nļ42Ng;AX{*_TLT_414ۛ)ZIGX CHt'\rcHS\r!3T ̘ C6گQ!ӦK\0gF11vn]t(\\ۡ}\0]*xړ^w\rֽLWÑSw]B1PgE\0iAty҃]t\nOM@BH\r<&O\0s̻M1@)#H\r;-eve6V/zvڤ3K,mmo!˷D'rҩǼa\$p8s{mn{v%LWow\0M8w\"^MK䆏M;z)\$C\$#6W\na_*>\0äsfKre̾-i05\0m`/'n\0N70a>o6(~G|Ķ8;rωkU08<G}&W1rc1sI@(ȳ7ۉ7l2^\r8pB\rLWiJEqDH9kG!dϰVz^\0f\$0718znzyOO/ &o,n\0FwP\0o\\'6\rTN8MƖ̔\0ݰBFO7\ryM6\r/:nZ`ʉP0t*/pv:\"%c)	<*b p{F&\rl%EP\n98ڏD|3P4PvOFx/E2Dr*FjJǔb=	P|q<3\$P0\$P{f/	&'˺:Y4тc*fbcHSb8+πDtj0VqBT5\0x\0`bkfg\\.2Hg,1hFn'TM4uJ/&\rQ`\nIU!3 >Mr\r!g#\"!qy\$qOM`\$2@:f/RLO%`@i2'R\\b: m+)r\n&'pH?TҮP(qle/21KfԈM0儼3Ms%SQ./.VQkPn%ٰc0oz2p\"M/3.JmN<j\r&\"E#:&' :\nq\rƒ2MI//2S~ޒ2>\r8#@\$BHR3j{'4J\r \$1\"=*l:?ST=~U 4rR'\\es7\nRdat`Bn\"q#pL8FjrJ+t;4 !*7T;-\n3T2%D/*CkD	Dcc*,BA˶D?>+TCE,sdF_gH\\JOAZ,B[f#G;\"6m\$DnnΎ0\$>^312(&2&%n0Hk6cM/;\$\$[/0.J/";break;case"ro":$f="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2k<72'#v/X906Ig2	C0LK(FL#1P+?@`3u##\np2ChCJԪhKBYHGC X`D49Ax^;rWC\\}\"Vm2\rp/^0k(2C: ʕ@S{2%S8<wZӒ:&6&R5q;(9B8.p17\"'D\r+P73?Q:\"a+\nC?1L2pحP\n)x# #Z4C;Z<֫AȰ[Ƶ3\rE\rez(\0:c̌nG*9C9+UJ6xcE/So7.Ί~H<t'VE.縋עf\"ÒmOpl9ao3F;<d:ŏS22(WHB:OBe[M%6T-*OpC4v_'V\rV34tOBI&.%tJ7!ݠEJqX?\$N-애i'e73BBH\n>Z8\$xg!\\;s̌b3&КO_șADxAr\\Ks.Իr_Un_ACJo2:0!\"Z \nkGTeN3Kxh\$5b9v&	[6!DVf(p!qxGCb4JLX1f4#xuc يpܻHEq,h3q8n\$mr	D!KjNۍ	=aL)f-	HC\$1\"	H3DkRzF14&IYK5jIc	+\$q/àA!Qx1 .MP)hr\nqws薠<V^\"pqJ\"7PO\naRzP)!PA)\$]<ۊ!)%m%D	%-*\"|P'hyDѐp)hSX[G&`nPAd2rQtxn\n;p	Xcy	MXaM*D:䣚p:*tGҠ'Ar1!3z^@yU!c4@&e*/mCUPa/kUp\"x)@H*,`%\$bXX2+6ieN@XLT԰O@E*Qb~Ae7&`]8dL(Fמ!AjG5;g+ai~MeJ ݿl;*l{0c>apE4Q!ҾvML%nLR`bWqo(01t\noӛ:lKܰ]-װyW)6AŏHRSVd{G]OPT\n!t\rm<c!A\$\0PGmBdц`kXrwLԖtEHsEuKro}zD^FGjɮ(e~il=6b3frDjPOtVxwh)\\vR602·08(fSd8fhc\$凼\0\rc)#Tme I+%~RC,<Xn2TuE2f?)TB\n3^hy3h6 ^(~ٟ%WݾpXzvX/3Lњ8D\0V5wټܐzs*DK*\"%أh7H%oAp_ѡwq&IɾZ(z?ܴj=@PfOh<IjnZt,,ohQ^'<p*lm 1|pB>PWb(V*: 4^7,bd>S`0|v#cBJ1x\0XP\"F/`h0\npʴΔgpP+F< (#CJ&!DU[<1p.K5F:FJbB&жet@[Ll-\nC\rzezm;p\0003&VWfSL%\r{@LuωdfLd\nچ@QD&юoP)GVx<w%vRtm\0\$#@䌢|&K<è-h'q'	&?\rPa\r)\"#1W#жJ4F [%c>JP4\$M&&RJl/&\$MDL|AcBq Aw\$)2r)j,-*f)*\$%1vyR)E\"!)t:*-D'\rBQ86a/lnp!Map0ć\$/&ճ\$M\0{jr6\n17.\r4PVT]1y2	*zƥ\$3W\nvPc傮@P?e')\nsN9@t:&niC\"&Ʋ\00031b:P2ӡ:E\rVi\rqT7) BhZq,\$G 2j,\0\npGBNeEJh*\00\$Д=,b:#B\$hNbbrTe|O(3G\"S#1b]6DȄN&Ɇ8\"A(-vhm8NVBhEF)TjMN\nKf2rб:\"@H&gN0hyOJ*)h6&R.MƋ٦OxLm4@*Z&6//KIRcT&#DGZSfo>Gƨμ	QFUBL.dn3MrzB8n㮃\n	4\ryo-R.p:J.B Sr	\0t	@\n`";break;case"ru":$f="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$ٶj4y>N:D.1ܧ\r=T>+h<F.\"]-1d\nþ\\,3:Mbd5N(+2JUC%G#\nT,`	#p0Hȋnxc2p4\\E!y&h0W\$U%cĻhlܨfNd6K#\$󜖼1;)=*cCW,P2\rHpLW4lI+QtյL[̓j\0x0E3:x﭅Q[u3H^8#;C ^.A_3\\!J)Q^0˪\"Kfb0}&K<cZcqe_G&!3%۴C N~=if@<l-sx<,9;oN'+DsR%mijX^ǵ1/{7+_\$/҇E#\$˵bwaK?HONAYXI@R|RT#A<^#\"&ա#\"ȕV*Z&yҠ`sGHbć4lMupt(VˉX=Q	ڻlFI))nHE*a8Jb\$\nDvufѝ|UJB+=om f\$XX|j\rM\0A;i\rpfNYXr7\0\0aZ6+I;b0SӤ7#\"43&F	t B8B>cQ7<HrO?]=ΉDCLM7w\"'S\0\n\r9\$Cl4)F1TO'>'>fwt;P>,ax-쵚,P\\j=c7gS`9_B<V+Av?J[G(ĪFgLG?2Io0\\WEJS*r^IT*SKnMUDܑ((RCkCԈMKa[&orܪ,Q0ڪ\rYuXJ\rc'42dilW*S.TR~2&7!*S(ZNك(0i?pMBHBE#-E[B.2&Z.7+ꭴڋSj]ZlAɲ6`2p!)װG*I41Ax;T%\0ʈ)Be#WUPqF{R}Gާe5Fd۩EZ*o۵*y.=(-T>.ǴIu:#Jgs˂٥/56egDlǦ#  iS5w`j`u@>Ty	\rO9\nR\nC\naH#>t\\4[CJ~tYWHblE*X-HQY+		4&=(2%Je1JSNXӱkI 9]5SuR=]hoE;VnRݯ\"*G\0TZa5LFg{8ק|?OLwKݜJSZvS''Зh%Kɲ??Feq\0)4\\lq衺qtcc\n>`dhMt9ka]\nÆ	VwI\nC:P!x4|3a5A\\Ad橩+,-\n橔pND£)5mc#I!oy\$\"tw;v.Ch/SЕS(:qǦdj}d~ЦkA|^^\rvSW\n\0\n\rllpńn!tJc'D\\#, ^C`?i P45\rH \njF`OtCaD&B`-Ctt/'Jw(>tO|LuT_b|xLs,0L*)a\0gTYp&8IF̢)xDdO\rl!/BФ@,VD(Zʥgh|oi\$&2j	/5*l,oE`p%N˼U< \n`#`(mc&NcEzB\"L\0^1\$qq2cvz+IpC\0(vlߧD!Dn>Nz!q!MR( \02F 24-Tj`0x\"%;qhF\";+=''D'5&a}(1',Cg)r})(bH{Z^b%\\/'@_!,` Y./=Աe(>wa /14ȡ\$H/k:Cs/Avc0\rFNJt_Jn\\J\$NC=IA3>D}cǎ9/v0a#2!\"8OJ!j\$Qe8\$7lda(|-	Э8EDuo&*7F	S G0#zK;\r\nk</2&O6GY=YFT<h2Eb⢁6HI8.B\"ZppRKGIBT'\rTa&\$%pI=2,T3D4\$/?>:t=f<qԆ;)?,RM	3aZf,A:KJ活;\$S\"oI4֛S@ֶQ*\rJB6ElIH!C#!#J,URr@i29\rO+MjP&u1v@u!*s{%LL?=K1STt}N:%`0uURbgIx'RDUDL,*qYXXSY%!>/.lvfB튅85CRuHT6&&-\0iRr~,\$˳&M)LƬB0\01:U+{&_vc\rN;0\"6GT+)p	tn[SeR+\nsf9HʛYv}*6wQg9SUUM1fPCgDQqgh4hj+Oi6Zshk8]l5Ȏ-o\rjlt`t2R}.(A\roBwSlU?G2qWT<hS<0V?rvm<q=W!sQ]V)>L3mƐa	h0;HuIArNv6Niu֟7im.-L4VJO^AV^g\rfNUkw/kQT_FhuzT=ˬ(qw\"Q{Vteebo|l|/}\rLf3wsjz7W~wg7,u7iz0#ޤWsmр%%aEQ!uMZYZ}`.U=>7yx/Ɉv(|xNal^RUspZ-Y\r~eSns\\f7酶֏V\$Cq+s.a\\R(\r\$UqS05[k7D\$vK53Y\"\$穒C}BF9LS\"/Y19qK)R3N'O\"sTWaWCj(\rVSzŊ|e@p:g͉E{\\WwX%\0@\n֠qouȕg#js67Sӟa\$qY?Rh0by6)\rfwՑwD6.Y;mg>nePcQ,T\0A|ylW9.*ء#Ii.b[bdqu(QmR!WU 71I<Z4vMHN\$c_L.K@7fOJI0t[SB*BîZݢE;.вr׬1aVw7hT%Z28bAF|`NE3ČNeIb+wdDK	l2:,, y9Ӡ~(HODyqY1P\\3*\\r]dfx/L)n}GNahm5}򫁘ъջB%H|UM1X&";break;case"sk":$f="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0q^:S\r0n4&b	a6OS5\$7\n\n*8	!#F+o;ICv8.DXܢ1*͗\n-L0<a+y5O&).3:=.ϐ@1x42#JB\r(%\"<jxBz=\n1\rH֦j*JH22)5eH@:#c\"`Cȳ0KԱ87(́LzD)(\rX-#<2HڇN(\r㬄Vȉ|	@A0YBؘnC\nQKX>ԉR# ں*ܦH@SҘ1D+*\0x\$(C@:t㽼/09Șc^8KxDU.2&϶8x!R+Iax7c\\)(Пd7:ͮv8C[+#Pm\r* Ȑp\"P\"2:!.7#΋n:2uDf80Vt	1X'#C\n#cp޿Cî{AV>3'kceCX2)zs[R22@PX\r;0TCh5|5\r2TdY([K#`2o>،ےR/S@VIw뒉01-x-5d*\\(7zZQ_XpYw\rĀ/Exw (\$\"ق(xL\${1N'^Vi02po'\rՑL=R\0a\r<6&h0f6\$``(U)CAPSz1D3/PM\\ԢCt	9I(d\nbyI&5T{U(CȁY/ą\0(\0@@k@\\Mx:<o1ŎFxʮ?Đ.Kr,сI:HF\$9qIDbYK\"%B\"&I7SyǄ\"^\$u*(Y?FZ)+6MGB{z_ uqC:iēRP;49MrlkMju\\*r.eк!9z@qZ7!RI)4!&iUbTbC\r5wREP*d@3ۣV0t	H=NPLP[45⵱tP7Fs,SB\"qx^J\r5\\UR1&C\"\$42vKšXAZs3ftED aL)i11s1} !ys!I>L9ɪ3g[Ah S\\CGBOb#44DG	/#lc!nSA[0k&F#+@I (A@hB\\[{o)(30smrJ=s@ۻJ<v\$_&THM%щιi%%!:ecJjS5:dCJ8ΛKl+-D83#	5U8\n+B1\$G	\rm6D\n#ly;lM!oh62yJ~+F;4Ղ8'Xzza\n&u!fZIi\$ƢKp:F\0jqe)XoZ')HT4.FGhoi(F0)ۡy	4rʤ1+4&dع}e5±ݜosL\r,<\$r\rI?c`鳨\0_d!g7J=#Nlw6/0WT:21DH +9E+_(AR\\UJ y!P*#!LdB3N;@3r zTnYbk+!ֆé3uY:C{g\"d9mr6\"2w.]堓|ߩd6jQYOsvgxRtt~y/V2;<j*_~VNr9g&~E{彴?9z_wsd9osN \$f~;;22:f4Ӭ誑\$*XDTϾ>/c\"<@nHa^(?d	lkafMv89\0<(+e\",>B.2&/=l5ڋCLP'PnU\rvg|%-vN&,ysEhF>0(\"HlȷXuI/(  GT8(v\r~ dmIPbАIbFjF\0Q Rt|\r\"-%\n:A@Bs<ӇYw	'{mn*1u	pe\nc>OРq4)P10.єLBK1=q+hqGkћC&'oR\"<R!t9cw' R2\0- \"kf\rdĔ\"'<,GZT,>BHRNedIYfhB`VHjL'KNjͦlZK\"\"9.T>hINjRNj+%\0\$\"RRLpeN<`FR\rha{ Dr2ލ\"a#M:R8rc\np6/GB\$:l{1	23(P}Rj\$|𹥆۲\0 dP1O.plDq3!`(nP6r:snz:o\r4Jt-&E\rbzEj_0}\n\0qʦ/S<s<Рy:i9<r6;3=97Rjł. l9;6IfU\"RG/n1C%s!	CD/9/4-@t(ėDFJ\$00E\"Re*CC dy-ETGT24\0\$C)g;lRrPI\r1l%5eF\$~F ES`IIQL,]MtķM7L	b@c~\rQ`MrÎqb\$#M|Ϛ\rvM`c\r 5F5k(+7BIDGGB2!Ͽ\$(Cfn\nZjf\"gJQ_XXqNu~DJY	(2#b:\$>nHJq\rphlFIlq67\"CIl)dQ]3(2C8T:c<Bn*i%,B4ދv,4USv-\n0kb	\\h0>\nLѵ4p>Pjfc'p`\n;g\nCCZ\$&BL*<Jw\n\r(`()zl֥nBt@v09\0-nq\0&`6ڄTMp\\Ʀ]C&`cB]mςt&f6U*&'=s<T1!";break;case"sl":$f="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!\"l	_!X@+\0001#Jh,P4L2R@G4i2LBZ5#̜Ƃ6T*-'0p83jNCH41t#X2D49Ax^;smD*\\|ԭJ2#(+3#CjR4px!^鮬h(\rX\$֌),<;.28.'\rCɀP !*!2Ct8]b:8A\rK;cNGx\r1ϱh%Pz992#(셨ѭX0bn=K:8C :'\\:J5Òx8?b7 P\$7E*3c`.(1nފb8964=]:\r*t'Kie\0 (E&l-\r\r^=B(73t 6q#,=	l٧8Bx+}L~.?]u\r.l4ͣA)C7@jQ\0)3cQ^N07\0ITPFXT(~á4-`\n\\fQ)pq#\0Rx	cQ-شA%	/	ĀuEAUjV*ZurJX7,'eYA]l3HBzP\r!4o	(fpI	2J\r᝺K£Kp]߂<7=K@9\$(C4M\"IH \$)hs),2̓IhP*H=HhB!Ȉx  L^9\raҬG\"O`8\0U\$Q1%Մ2]%D04;\\\\B)kIH\0\$l&Țuѓ2Gpb4 R-x\"D<@ :<	\$L<NPA=C6ACN'389H(@|\n<)Hvj:\nBHC)qoH9Hk!AoJSL,n!hQBS*tNLLul(6:hX80Y}r:RkQ|o&OI-%/sf'IFp_=B_/E\\ cÕ/I[t\0˳&ԣ*sk츈/CR'M{5Hj;ROA<95ԏ6-*/.\naw\0]y_j\"[ZQ(쐡wKIr_\n4	5Dls;\ri푬TRs	ܳ8n7\$'-\\gK]&\$Pf`ؚ!lY{# \$0)Ȅ%&\\!GTIjK**@@ -D@H~C Ȍ0N&kaI+d5mg8e\"j<Ƣ4P]|b\nnyǵ*%rl}|&Nlَ!_CH.ځkHV@ػ{p5\\&\rյvgxgvFW}7#>j8bE܎f<u:w.܀1G\$%[̊.TyGX\0MF<W]9񻨂~{	3)O	B7?Ͳ]4h%ԭ;oE4eáP##\$Ƈ`b6.E̺2D{S5QDlR\\4+le.u[i3lV}-jL:?Yg+a/QVOl}I[DZL;;#Da hC!L-\$&oV/_J伤^ttNb4 \r9>\$b<\"`;Non!|&ވbK- V|or5G_^ĀBv	'KF	btqipL%F\\\rmeMPtykU/~܂m00\rpaPbA\rj簳	B{Ё.vKDF´\"DOBH\"L67dІZe<#f0B6BJv	.bl\$*5j\$06AEX=DI京\n	 &N.Bw^ȅI\$)P\\pTJL/&(p)oQ\n1omNq(n3lƆ%f`vk̺q\rc\r2HEА0R'	ĵk\ruQe\rf\rGBq{\"u\$ƪO.5AdJ\"J~AE(RI2(j{%(b\n[(QCq\$G&slK.l\$-Ew?.,.r)/XR;a&͗0,G;%.BfD2;2#p3Ƃx/cb-23\r\"l^Bf>!PrKR*\"R5w#%7K3P7a6c4`\"_Ū̲\nr?vc5c0\",7o7OF.s#8(>/Q1<9d`h9TIkA.k7N%)6\np~RBc/3\n'D70j00.z\n2s94,Db0#E/` \nQ% D7x;c#bpj0^	ze>cnԪ/e.ecbl8\$hbBύ`4zOֽtqKW(N-'oMtN3c2Ꙇ\$qCh^lBh16\\(n2Tf CS\"\n\$~\nZ1`xcL'UV'd	ͭ+׀R@G}3vXz5\080&*+N\$涒c4Ol( 2)C\"P@@Gc򴋖";break;case"sr":$f="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\0P74`Afc2p4Û-S#/AJ*σT\$R&ˋ`Ϊ\n.LBHOTS6QAG9r(@0c9C>rK#\$IC44XC0z\r8a^\\0wi}㜓%\r	ј\r#x|1?hS:ښ?ƅ4@\",W\"*TkFp\\6r3h(@_0Cvcx< [s`2s|ꊰ<֢N*\$EZ32f j{W\n= 3# ֣`2ºQ#ʍO2n?*\"QWw,cJ	?AǮL'puSyġTy}8&oL۪w\$EO1!͘PS\n!1)J[,%a*xx)'\rЙ6yN=t74mlhx7H\r*h\r\r!xDN)n`FL\\? +~B\0p(w_4|HW\r\"cv:9GxxCcW,YpBJOy%B@rbK>u7I!ieP\$*mx%\nn:ЯŔSNC\rіYx\nxaܛ8fV񬵉䶬+\rѬ1t&N)9',櫔ώ	`\nmD6Wa6DO\raC+,Yq8dB.'1ru=gyVLd,vRk/f!ݙXÓ9grYKFHm,6P9Xkh4ֱkV\$(E1m!A\$'̇ X@pF\r\$9RrC5HL%g#gB@V	aQC2JE,%TAu/-RdB\0+(]\rd{,^j0#i\nvZ8n#1ė]c\r4vSWxoX:Nh\$!0*`'vےuu	<	k|RqY]!<Klΐc]\rԉnp\rX5W؁]5F2Q@bV!22+~-6;G=afFAFm]*(soNIADY`¥\$KP\nQ,ea4	i]BT*d:Jn[9NTȡypqӏ,ч+z!\$(4!=Ҧ\r0oÈ9+¥_-bd\$C'p \n@\"A\0(K\0T+G\0R &]/t\"PYK^D^Ůe^s-CUjRp>yb^Rp𢠨2ݮ[ Q+o3oY3!VktI\\pMc;X[EC[(MpMT]W-4HWëf./b0L^UmߋV%v\rӟR V\0P#JL:f^K9#kwr\"]M兠	BLXRr#K\na=<J\naՇ кCj:M=b<+PS+TX`QƁ䑧zAnwPSq3\rbvn&w\"6V<4%R'3T+ڑ1\$(kMڞRGatu]ZX*:h	55l:<,l/D&O!	cwڙU9ֱpM?B&p'i)	)/W(n?k\"nOC&ʈ{6\0p8130B\$R_\rr/pCb-MzHЈǦ/	P>PG\nI,Ы	I=	T)\rN	_F@BL Ђ+Y~[b\$\"0삌V.\r\$ێPw-)iN&AbAFZQ kĞL>(z-oa.%]),Xև'D-z'o*1n_&8B\\ko0	mDIqp&@F7n1⑹0a#4fQ؍:!p3x)|@dL8Hj1\0005F@B9)TG#@r5leL.ʔﭰ|55\"A~[Pt.^t͂)m4ڀcrN#0؅M1(Qj0&.:r%r+a\r׭)2kO*\r*RRK-r-orF1KFmB,QC4&f0	1P11Y\np2)\r#+6Or3Z\0P64>/2в1K|Jk71\0p%17o7,N\0@&҂\n'3>1:Qbd*;D^^ho%0r*5'+҃ w\$~\"-BƸb38mЯ?\$ӑ-D͂os\nn-L34	DHk7օ2NDssiDt6|tK7شvz=94P-%Fbe/^NFS]H~%HDoT?I#j>L\$q1E5+3&MO45ԝ,\"t	m)m.G=:N/n0DH6nt=NF1Jו_HOJ5!4#5׃;FI\rVJ3;'q,3W3'5Z~JH)O7Wɍ\\5Z3\"Z\$AVU^L@I%SGH5UEs`c`WrJuZurbP:u63\"/:Q0uJ0}qEeP0C<Z_Tc=lKEBMp4lЉ8{h++SI\0:4/i'P3kjTű2v`@gb\"bMO^bا\0\\\nZ^\r\rBb\nemE\046fwjp6/qΑ6g;ĸ.TB΢m`q\0[n9&ZnQ.Cdȏ%Uv!I&*^YE8R1(|,eT FQރ\"!&m.'7k3t)#MQ wf T&k~LA?걣1ȓ0G5]ozF@GA/o	!EPG&X@xGaf\rHIY &yR \rPNeՆN\nO3)yg*\n\rG3!fvCŎTx\$CX5خIv@lڨ\\FRi9{K\rx:]XQnhnNl[6H.`";break;case"sv":$f="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5Nu)j\$ܢܐo*H#2J@)ʫ):O*O\$\"C8!`P:lb\"41rݵK!#P!셼8ʴ;.n(ș')ʵ\nrcL6P(OñH(!clC.*p<\rj:ΧҀB#:q*M3S\nK8&P\0\\HD44Cx[71(A{h9c\0J`|&0?'x}!`ԁ\0P4jH:c3P; U25\rr0C2`P7,@ɼ*H1(b>9BXK͎_1=~4\nCI4*1`Rݽl@P:(iL8⮶.ছ	\r0YP2(P<d(茔l:w9q\"`Z5hwbq	u%4/\0 n-4q\\|t=bEx;z\$ 4X\"zA\n`!b7ޑ*;+8j@<yn)+^Ӱ!9<[QLe8 N8#Pyg͌p-\nN܌4\n	LOL\nSAs2fIKp47eQЧ@HѕK`Pl7t!څ\"S\0h=,\"QK6BhPH!R_U[BsAM`n bTrC*u\0#\rtwHACXJHP~A :`qf\$Z2AhU:W+\0謕W\n|rlӭ%K&,xӆR@شH`-#2`6FP< Q1j@&53LINcXf4gad\nFđpXtfM#bc!ĒjA\0P	@ΡHP8s-\$:b\n\n`)-D\n]L||Cxtl^&]QKT&(/r/qKh aL)iQ3@4rRkl)QBlNF؁NJPi\"汥f\rsTM=܂(2)G<3\"QJ]Pf@])A d1!t\0 -SLQU8M#Vw@X!Β<\"bG	d()PZKa%!*vs^;ɱ%0QFey	:(Ix\reB  \n@(@(R	!8#{xR\nP ptct0yP<R#]9s{Ϡ[:DDSEhae^zLL	z}))%ߴTZ\"[]=\0[7QK?CøF!Lf(3R(Ϲ=')7ӌL\$䤴ˆ.++;/ORՈY\rm}-=w24	(b]-yDP9Li.+_z&L7DbxC\$7NO1>KxG<T:-*AIL:\r9/EFXn}a\"әF:W>2cSH1dCμ>޳(MswLCg4b:_bmiv1\n`)-#GLa&CaͶ#<ߛ\\%}IK3AòndچlL\r%ց6Q*nBCβߋbeI.+SQ̉-^xqYjz|Qpi¹f^R0\n1/ńla`>V6)3=Zm\rX=,x[ҲA	36ދoH\$F6 J25Ú,N|=s(aQJxW8K4=baMuQһ6_3=ޱ^	 Mq6f}~&7ڒ7yO{BhnOK\\AB@ШN.Oj}\0/| ^6	F#Iz2E64\$^wJf0(ظO6GX!h%N>O\0{\0.,g^F2\n\0pp,.N/\$-P\"\n0\"\"i#P#V9\rf'l\nh[&?\r\"5pP\$R0\"FԯQ/&\nϊngtZLHLF \n&g&\r\$26\\lĨAF'F6L\rbp]^\0CbBQ`cBZtEqfq156-M\$d1M\$n#'-M#Qj=1;|\\2q @@4\"MWο (o2 bz(	2CQʎFQt0f!Ď,FX:2TT.	eo'f\rb-\"Pp%&2 R(KbhdH\rV\rd\nMn\$(5+4*h2\n(\npB4-BH Ҷ'RZ#쓲jgRR)|f}MF/&H@KC0r\"΀\"rlJc(1+4K>:S\$:Gtt&CiHn/f#)(E/,\"b,o\00댙8N8.`z7c:9|,V<~F#\$\$>؂ƾ2H<//=>m{H%Ѝj#.j+:6*K\$ bӊysK(g~[@z<x\r@";break;case"ta":$f="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-BH;#`2\$;9P@1C(2àӎp\n\\)\ncZ2,7XP)S>}\rʵiZ *#}r\"9)IJ6l\"D,nrYҲY%괙w)m;\\uucy%\0P2\rDNs<s#rO!MKO?#D4e#0z\r8a^\\tMC8_@PAxDlI46 }Blx[^LER.\0;Ƴ;2ni\\_WT|L5JI9-'N!x̔m\\:⾛ba5TDtR!.+@g\$!7\0|O(cc1GLF}0Xra5C\r`D*`FP+F @r\n췂 e:`u|/gȮRp!:˕)!9h={(!3U+>I989[ST%I<L+\0*\$lNK֬W)JHK̞E-6XCa?ǰ0(Q	\"UAl-]5p^-n#i ,[<֓J:]	.Ȼ	}6)L+d)]&ئJN6ۣho\"rЮ_rs g*'d)gjH>s?B	ò5FY)pn3PyOېcaWP!C('`e:[29M:|gjx:\0,\n-;%v%6bQlb󤯾OJ\$D%*&u!2fY`&SP2^L`&0rGlc0fcH7;\na=@Ðt>Ź\0PbFypn8ZjOja.ic̥8*դM%k\n\"0jLPsK}[(@.sn7\0%ꈕ*}#y3YJu.ֺbݫw!ݸG\rƪ'eP(FG  b},TC[O;[v\rD(O\ndR)>ErK6P.	@pLH91V@C6\0O.Ih\ngI\0Ο	\0abV^ď%HCHNu|\0((R1*[=F(0~zgz4\"e?/@7\0]\"͇1TC;8L`JC\naH#fa-ܾ.ֻ\n2a\nfo\$9L\$fK3Ok#Vgo\"ZYJ/0P[y(1Y0ޗj\nGTP/N7\nKmRRaSj(}*:b^F*z}]\\{nGq};8YOe!53@HmXq?、7B\r!JRFO\naS\nosg\"2'ԍV\ro#}U`vmH9ARmpCL[^xt<\\\"qʦ2e(5/}pD4sQ8b92;Ktxʊazڤk`|[؈p \n@\"}&_~.믍I0.+Q֣\n91f\\F+ݹq	VXKgEi(S;i)PC\0\nj֠^c\\b*m\"Kh0Ȑز	I\0<|F\n*و\n\n.(ڰp)\nGJJM:}-kԚ4\$\\ \nLe=BmR P|?Vm\n t#M  @ѭz8 hŭ\0t9Fb~\nHe \rJx&hYG\rom\r hX4^f=eOʜF4/ޣBnG'4X\nmj4\"\0De@@=JVDаhp0&4e`(Q±R+`QxVj7ʖ*^	//T:il@	IN3p!MVّ:ZҦa`RIJK˦	\$ ,i[eb\0zcg(BЪ\r#p\"0#qYR	-(ʘ8|\n`hLN<p>҄h.\0R㚸h|oz,!7,˺,aG~'Q.*Ҥh^g,_222Ѭ1.r!\n5I\\10nMmpj\n\r0r@ò/=0I?0!ШC歓O0s/1Kƺ99ߍ:Fs3\r;3&l74HC4zHC	:n(&|BQBb(B(@eYr64ۂ~t#FGKL5\r聤0ia4\n1,tH=8@Fm{.\nQ0p:LQ1%o:b_D`p,~q>~D)Hؖ)|.&%Pc؄|ܯ[:|sAD-	\0mH+\0M0G53;8Gt=F؝CP:X\$3h\0g#.JSPtC6,Q;EJO5G>(V&\$)L-2'T\ngW:uVU1/LK5d5SLq?\$U4%\0ߨW|RT3hF+\0M ం5I!>-EtJFu/\noF\\]c[u[<c`UohWTUV_c.H\rV\0,oCqaTmoʓƗ_(eEP&J[P5_=3Wbr4sf0%b1={??g=vMQ0CWD-36{H1iY;uL⾊:SjWluiPl[B\nOR Vb񪞒D#oh)TnU~o&)O5TRڢvq\\De}D59a3\"'bvp#f};;}3p''W25U3lGTHAERhVw-u4a?j3:N7WR+cvUosYV	֏\"tq2gVP@ʭ 6Q	jqi7uRAeHU@S]x5E`{aD3f줂Ww6-4-\0Q\0H{*r&\$^HP3yzR&!Wd6MnNaZwOri?6~TXR\n\n\0ǈ\$gфbw}}WFUQ3Xxkn[t]z`HB6wn6yYP){dstgnqT+NJ}*2x~ْhlĭmߒ}ZQ&[y\rp|@<9c}Xױq6O2zYOMYa\\\rr[YNl㋍&OP|Ђq-OYCuu[Iq')ׯmى|!swdsewiHGv:X%=Yḩ1ESp\"A`^7ݛ|zJ#94iBigt#	^_אy՛O7p/6ww_z2Yf9QѩNS})acZa1\$MCSdz{Y%EH'Z8zЮ对ebXׯZn!4s딺o\";+w{/\"˫kͳDWYYg{:HR%;Ck!'Ѳ\nPuZo4F\n[37DRZ%\"U{/jk]\"rQ[dݣ7	\0ɟÇr:`&^VaMTѓD	BE.:u8¹y\ruY~8f8mStT--.:9:uE׼WĭuHi1Y\\FBR@Y\0hd\r \rfJLDԶ'̅<+T\rR@Z̎+3􅴑^=)7ʽyxi\nSlDN%S{`3oY9X[7j#zPߞVɢ	\r<RT\"1 \rf|CYA_ТR@z'Q\n\\tVH\rK~gL+AlTy0?\"2_j<ߙIrzM[eԉǮs䎩,Qߓm\0PwNZgSJKܡf+ۊ-FYY	Wyl;n~\\pG,wQYxh,(yIm8~|I\$N.ʄ\n<(z&խ& I'\r2cM@RxwevD`߃J\"~	Q?qGdt\\Xa\\40ZFȌz(5}4\nA\r@>b\r|4J%Ǐ8	P	F>8 \rF>ogݫ*Qq\"XYPt	\0@	t\n`";break;case"th":$f="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NP74Ac2p4UĐ} ZnZR:6SIwB2uap::8JTE^RښX,a7(Z kCN* l7AS1o*\0þΣLϝDC XxѓD49Ax^;püs3H_CtEL@|6/|3N#l4px!};u2*\nYh̳c1M!qLS?}-F_#\r:?Lo#%v\n\0Cnq0>A\0d\$,t\\!K(pAf\$iѹkaًjN6υ\"'hp@(f!6'2ead¢0S9*CDL\nn\n6%u]]1#GICr~vVC6ZONCvTmQRprvI+l\$Flpһ%\0F a\rŲZ\0S\n!1\"WnB^^+~MAtVSۆ)22K1ɼ,q:N̵w;V\"s|L!1=YA>;@k\"\$CA.9\\\\zMa1,C!+%vQ[Ezz3bK0*3Vm^'\$:f7Z'!e4TC\rKQT9\0z\r31Ja434n`nh4|ϩ?'편@h[qOa5c~#Ps=,Vy	 8؊uSY#%1׫+`/ڹ+5;VBM8Lt:X띀wvN҃;`HU1< C\r:<P.ۗc<*nyT,jنEs>E.l+Rn8d1@rlt0klqA*\n(Үr_n\$q\\c\r:2UL\ncv(:KuG0\0\0(1\0TI	;r_W3NQU**&\\xsP\$appͨ'-\r!`D\reuONJ0dp!) IQ 	5a#g\"֯jE\0p|.j\"¬cߓoԲUV\",+#`c[nSY\n܇E|VI%'YMAfNPGkYK\$е~~O#\r\rlҫ9Ѕ*g)PKh>-DZ⧔R +	nBZ\rϱ%l@4Qٸ	̻0Tʋ]	vcɐ g &mtrjK81GuxNT(@/HA\"!>!ZAzzHg8(;D֓+'.f\$7iXٖϿu(ePN)&u'|j4xR,l3S%c:B\$w5/bh;TRC^v>-YvR)J=Ѥ@nJmkNtAV&FHO.dppa]ɅKqa=]/1譫O.:<9)H,ƋK\"?*dKIȜ/8{MBlįd@>^	|Rc\$\"g&		g)E{gi	N~)HN\0Vnnt\\CL8S|cwbh?DSEbDܣڤ\nE8^ܢav8\"\"~ Pv*J(FW\$ 	\0@\r\$-PNj.56:OO%`HFI<[&'e\\D&n6K:U#0H;;iDJ.p8:l.f1P\$[q,Bo5pЦƣcDADegƂk\0\r&O(;9\reF5h¾9C(\ro\n\\\"9fq\n.D^iBK	/#+fg:[±?\r{P9hS%Fn9~G!q&brn&iФDDPM.fn1YŰ\n~|쳑+#\neS\nk:A02*Ҍ\\r.R|,/m|\r.z*LN+-FƢC*VXVMx<H|&LX(STb{E4,5E2PE&<3L652'Rv0[1PK*A {99LXef̂0/~`S6pS+.1\$DS.ŸRBF{6og=R9(\nS8y>gAXs=	@o =,)B\r5*:T/=ɰ~4I=\\↣BR3nq	\$_I=e1-HD\$qGdec*OPKFnJPhS<4z4Y8rKt(xD~TF47>5oWTW,rVd8ȐƓ T,c{~ŉ\"ީ(=Q93QB	REg&uIξ,\nTMN0hTGhVk3%Ҏ*e-s8\\DHXTn~LJ4TaBdZYIR@24C0\nuus1[@ rG]KZp{8Ё\\o^*5C\\uQ`WA4[_Ӑ[]}]\\!]ubi\\Z-C6^~UF's[<#VC|VU\nG0otSDFT)ggVDaAu[og*\rgv|W^sZM4	T\ry_\n\rd+U\0Ak6rmlFOl+Rj9B놚0e;D1kChuCE?7	iʣag ˗\rijaqfSrs7Z\nJW)qANWOnnɅ[rR[Hon/D4aCX+ryw\"[lxewQkQ\rG \nq\\wrs6ZYiWww!u֥tV{~ A|0xG}MbSbLcT3yy|tith7F8My\\\\tNGVi;V-\\z|ZQdtB_|6guX~EoG)dDUXW/tmWԕiI2)O68mL\rV`kZ8ׁ/3%bJO\nˤ\nZk@(H8Mwj8oiLee-][v0q9a@WVe`Qb\0QaDyhK5WoAHM)ÿ2t2`x A`'fq@S'΍j[FtX/t샊kDR|mnfƈ1<'`7hB=ͲVoOE'Di+FL\"#NDL訂v>m23Ry)n;󣓽O3.s9e:1J\"\n\rHgxmS(|[z8:#zf(ř\r!Z#fæ5&nT	8<:7?/JF/+8rl\r@@Qr+#v+`/\\;if	\0@	t\n`";break;case"tr":$f="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`	#p\r#\" %Ð@&#Ҷi84p厣p꧵PEE(AC|\nx@p\r++CҠȀ7>#&9p\"k5ø:\rzt9`@\"D3:xa\r#rJ3_V^(ڒ̒ǒ|(́B8'b*=##C\"\rl\$όrx*-tАdX\"-.7@:.c8&PȅOX:!.B5\"\\mҒ8[K0 x\\-}235#e	w(9Sۜ P #떠P4-HϥpFԹbSp'X&BrN7@7+Q~)<a|~\r\\)+:|V>k/(9JV^b2t82EQ;.s%A'hY&oc3,+;17=#[鈉(~+_\0*k93ǀSt'>2cR2'lؒP4>uOk	<[ l(gdl(,7xH'в<& >@H<	`JW'aɘ6\r).ň.dH\"FlEÙ8l\\2&7AO[Aa ŖG	eq9qɘlY2Cy\0YbjC	C2[8:ķ#{!b\\<fd͒heW\n^+倰\"w\$eܳ_1Mj\"Lj\\	9#~@K<@7(`HqƄ60փ`g&~6']I̘)|1R-tJ<]\$.\\&'\n7BsHD\$*4\0EKȼF@\n\n()\ra.bS*4|b2fdPZ\n)v\\Cu=#A(aL)j4m b_0hjKY p v%\\%x@# h	(T'UYb2FV9DcF=0w0	ts|fO\naP֑\$cT\rDҢExJN8u!4fBPY\$vuk;gzV\nmGGg3ӁꚊz\r m`G\\GJ*ZSN9VbX1A}<'\0 A\n4@ʿ'=_B`Ex8+R 2FT\\oᤤ\"IΆ'ʍ9'L9Ad:DWZr/\\{쑱H	{b%\$8W\"zqse͘{sL2D\n #	^טD\$,U/h:~P!*d8>[f'r^\n_S4mfzC!5,QG&^R{-n_p#9C%;QG,͝.znmq%1dpafo	6^\r	&u^QF.w50C	\09[̶]\n&0j5Pl=-U\0^U]̓c>¹\$Nf\0\"ňE\r1X0Ϥbss\$3Od~s\rnTC呩vqOմ4ұONWc_fJîΎezS\"Ml>zixx.ԉe\"\r40PDCƔuH\"Hj!^PHnq:zT_#Cը HA|\n^\r#\"C|FE2/|fO/|ߧH5pG#S؅'%<g:H\nǸBlrb:٥\r\$\0OdZ/Tebƀ*`̪|諸F|FtL;)5_PVGslBNsHOOBM##7\0@abrx\0	70鮠0z&zdǧ0ۋ\rlPq\rIۭ\"NCG*J\"T\0qb\"\":.bVQQ\n8&\"#ubl;\$ҚB7gC	<)\rhڱ(n 0(#mשf\r_x1-­pFcPbёpg\"1|@\rReJvGGogDoAsoX\$71fhþ\"ҪQ	4q!+hv]2L:d\\!bX\$~\"WDG\$rRJx/\$C%L`]\"ZI&\$r@'rў&f)ur&oc.\0B&O+I?Wpq+ΔODöq	0a	gN:_,8޸Y/LލR0&bF0dU/JP0.p5/21&a 2H36^Q@d\rVak.\nZdn)+\\̝2.\n/9#9pg\\86c\"STu|H\"ç#o;*dLޢe;fڠ\$BhPzk92(*:\"JF+&j&E,ЀA\n1Bs0.QCtPB#GCDr񘛥CN3fpP\n\0@Rt\ntJ4:ce!>n&ܑ@8bN \"\05(#@K#L\r简ʐJq/B̒FeT:jJ#::V\r`ml|j@";break;case"uk":$f="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвH)Lxݦ(kfBK{))ƯFHm\\F \$jH!d*B郴՗.C\$.)D\nlb9kjķ\\̐ʾD\rZ\rqd隅1#D&?l&@1M1\\`hr@:H;#`2#(;X\092(:\r6\r\04\"VUZz4M2]+4OrҌF#V8uTix0GB6#u̥5ʋMYߪLżĤ\n13@4Y0z\r8a^(\\0xYc8_i9c2Fm=Ir\\MQ٢:!^0JXƐT*A q	J\rZ]*\r&ęm8k\0BcH;sKcx<fC7#ȉؐrr!/kUps}Mfb\n5Ge!s=]!3SN(Fm1ԏ#8}3xI12*{EcW.FDbɶN@I1=&z߈pA)|jRR~FrlPA+nd=##@\"|AQ DT1!E8XNռ(twv,\0Bcsr4\n`yt+*Cn<VR(Ћ=2!H f`эn5F'8P>q:,D1`V@ra7Eؓb\"gVC +\0004`eL7p\r!BPBF10Ȧ%bumA-ڻ\\rHh#rA!KQ\"kon,\"I?(SYJkYeiH\\K6@74*^P:9S>3	9Nc*^=/鷗lNǱ\"i@]Udf9\n\"D. d\$ICXc\$S.wD48]p	TTvXjUJ8tz.H?@u%ҩKI/`i9}YgKSJ\rC\\tY7TwFi\n ~R\$,j'U4ޱjOI-?¦ZS{=)غŶUKZa%db*\"13#8&Q\nB3)cNtWISab3M/J[ ަױ8KRj;g6;Im0948 niQE9v.{\"?TP#4	@e!7%K2}qѡF	fJP%\0_q,Z9tGa{h^	Pu=^j^U>S;e 9\\IU:喴ng)yOf>r4oC(rK`ɏF\noJ]1¸T'*,θˉkuJ|r\niFY's.iQEʆ#1pF<b9E+̰L4orFsH:\$8QJG\\tmo!~Rs9֣s}	ͮ}X\n*9\$\$ZPr(Z)o+V̖<STB* Z,elWJPJv{_<pΦ[eHMv'SA\rŴ	yQ%}\\^7hڕAAMaDl#@y#\rKfPNtJ([`nʔi[\"xvXסbG3DXw2IfE(}?!|2?F^*	`ਠcH5Wpzy/簃(D[5krFqkߋ+ȭ3:wHkMEk\$&JaWB]g!Jq|FUD=dpuəvUg%<\rY5.?ʯL4η, #CLO.\0F\$fh8\$f~ﺁ|l!Ȝ1(blHD\\77R@,gd7gqPbq<`),:\"Qqz,~\$Db>#AL율k~,_7b,ZeQĦ`Q[\n#%n*l-\\p8(Τ(-LTdBRjl\$p'򁪊.[i&]j5\$V`\n 	*}ed*-qGHH\$*M'h7)twdQbwk<x%mNC&T)Bwl\$J\$#\ndJ\$ox Qsg!Q\\qM}+\rxSM\"3e SFI	r'vܑ \n#Q2!QZ#v JGR&q;)g6L8tHT<.hzBb,*d;y'1@!#c#E'.L\"!F(N\\Barp,cdO\"FÄ0:hH8Ki,破2n,4F%Lư52q'i-4-+*)=1\"H\"m1,\$;j\$-e\0(Ow2q/\0Ȇ4EsQ3AcW5n%M\"d.V=Pmg2jo%ԉB<}%C*\$@\"Sb	_s=.7n1:s|b:4/;\$zymo>FL\0PBr3f-2r31p71SA3l\0SomBB/7S?D+DoiCSa2jL5Bn#	]7)1wF\\_scF0,t6\"M1\r¨ٲHs*A#IIԒJjPFJ MI)>?K#ԞtLM25KmMGJXN24q3QF#PGKTH5n-GE5?یR({\".<nHdoIkZ<RMNS-UCj.X,BP\rF|,HuY\n.ΜS&pQa	Р1G'8H(p5W!@0gMHaP-_QG4A:V7uDTT\$'+`q\0	b4EB<aBp󺪆Pc,Lh]qx1[dR|SpB)?JGcFScLĪpU1PvfOOd4}e5!N&rVk\"D'm=mV?fXֽnG>46@%`.1LĐRE*Bc\\:\\WdL\$ۭGHtP9_(merw:Ed6{?cXP7uVQʛSG 1TUl^Ry\rjW#a!Eykvy+Mlw5t9Bxv\$DqE:Lg=cx)%ww4+}Q 5dWH-w[Ik~lUGG*Ou;%oF%,)vX4A3L֎Oq 8/1V+9\$=FƁk2uD[ ,hQvLIx]PWME~dxi=ӊG>MS\0u*7*-ILg=L+8P\"U[cXAc>\nZ4z7Ζ]/C3eG&r1Y&~:'1}dG76Fu\"\nat%%D ED[gK97'Z{\$&'5\$1&h&&/fn\rR}=tdކȅ\0,6zi{E8USqMSBC85HusXWwYQ0Uǎ)y8WqB6y˟l8B@9Lr0L/5U۝Iٟs/\nF@@Y<`j\rJUp .nOAjf ]],p:_4@ \r!Bsg|)Eym-Q,ʌKKnp1ʏ%HSvh?yt(T-9vPGBQBc%ig:";break;case"vi":$f="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤH	#p0Hȉó?((2(:\r4x	\njh-aC3&IN%h\"4'>a3R-Ȇc(q́F! bk:V\0P(2\raUD_M3#p kC,ACPP1p0j;(:\"9pXED49Ax^;plo3p_}ߣJ@|603?#k4^0p2u/^	h	K)Ft @VZ+`ά;\n7]7071\rȇPc:@ NĐI`0ZJh(\rT6(BTJv7o2pJGb@V:c[_KKgS<erEzP<:,Бfm(i\$:2H;YkJ(-a13P ti/kg%%*o)\"`<fP0@3pDH!b'~v2f&*n\"韑Ƃ@)vk q 5k:K(\$n>;6\0ҁa\r!ʿ\rAT	XdWb\\npPb[VVnIDG^Wb\$/(tcGq5Pt\$'0 抃C-\0(,p@Րo@¢nml7BƤ__A4lbA! B}9-H2#_\r;Ve؋Wmx\nV%I\r4\$a%6c((ҨJ :gh A\"ߌC#tZ:V.pTk\0`L0sIB,92DaQ\$l\\ wg\rBE7<e5Τ!*m!36θB6ޚ\"#ztbR\nHB%#ETh%yOL]t@P&/B&MHsɡB+_Cpp_	!F<֢h3i_8@D6\$'LN-\r *CLsfβH3H]\n!:\nFVz.DĂ@\n&bBʐ]4F \\A;\$KQ@(D%LQRq\"nEڲkI.	\$H<Ƞ\rj2\n+S;@U0~ⲻBXO\naRXNgHQ4vL'DH-tvLD|v#)\r\rX#cRcOIQ,=j`Z}8XrUgV\$99]u&b%X	VA4]TtJbWȓSFfbNX\$ق	JA%>3k#a\r\$\$-rz>z<v\"B{:ӛ`(GhEiidϺ|ZM	R\"Nj|u:Vm(+d]M\$at{}7<D%]N\0Չ\$gW\"bhs\\J%&)ڃ-<L#%7zNQC|sŜ\n_dFPI'MRߗӛ:UentHXY\$\\I+#)@PR^Ape2)^DBD @BH;GzW\rA3I`t.xC92IbNWA\$igvJL<wh1YF{wpgAA#&s})xI*2x\n?܊@\\l2܎۲EFү{Lb@~\$bl&6ڟ){sRV]~Y/Gp;zM7I^[N\r\$s\0|NZT뙦 6\\`lW'|p6:HҢF-B)i%jS%#-*w.ʛXbgit\"D < FLtbLo\$ff'<Mc688ChAK2͠nlM>06/HPltōD\0)sg\rOHOҀ-eP0p~PHEܤ\$__\0#J)fdDC#	)9_q<1/\0#E\nd.L(ADێHU&E\nj	\n1(&lAJG:bdrv*XH-,nH~Dj߆iUB,ߩp\rQCpG1K-W16n~p\0P> !{!*(r\$vsR\"p&,`lOKp7.`8DLoUavB,V:&4- .y!1\$p[r dr|vM(B<J(ɵ#RYkM19VԌ&1r~l l]Ҿ-I!Pr-R,L2m΀R#\"y/рp R5r/s1/\")+13.#ŦM;#.nTNU3#ʹOR*45MdIW<f|%PX04's5e :T*=6ld{)smH0%CJ -\n'TlM|G\$G0HڰtJIE` \nq`J'01mb>h9f5(LR+x/t\\3>\"i-ZchfT&{BH6dX6\rI{g̀(Ѿ12BU7Df\\ʱo:.\$,1HQF'H7|\"6&,igJtbWLJrpDdΨ\0DPIAxj(-'qF`i8td35N\"N0Ӯn%b~‖+4D1\n	FDM\nX\"J0 lS,4j&Ј-WIӦ!3@ބ@+.֬dأ:Z3:Zrg\04b";break;case"zh":$f="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3Wq*'Os%dbʯC9Mnr;NP)Z'1T*J;)nY59XS#%Ans%O-30*\\OĹlt0]6r^-8\0J|r\$ð6\r# @9.xc2p4\\eb%ʁP˽DF/@[r)3'=(Q6#ttdlR> \\.D/ri&\r0C@:t㽌43.!x0c1xDΙLsd)SC֡xMI\0DYS1,ZZL9H]6\$O]NJ7\r&ギi,Xuz=ZScx<2K7#ȇPE%.1\\ZY>6tQE@e=sU9O!@5x2A{zhH)N]	i N夤g1i^iZ+,n.Aɱx5}L! HYQ\0HPE[bۣg)x7MNb=`eTO GO\rdsSP*ˁBAM9cH7L(-LSC;dcH26#2\07pٔKCH\r^8?YCf\"]4t-Y~eIG4ܚz,gD	rAU\r.C`tDqLпCu\$#Fs<'0\0Xq錠brG	&\"tDd+3h3-t\"\$r#b\nJP]rB&B-^-ќj63TQN	򔭕ºW`,%YO5f%C(xu\nA8.}	#bT \\ 0\\Q#tT\$ Y݌3cEhLFʬ_g}\09ظ!\"1WZ{#L(SQcLPL*ਏ@\$#&`\"CI %̘9	.h \\9\0~8<EL:E&ap) 	8|]ԻQI`ˈ_r\\L	,&!+h(VCnoUEb9嬰Li\"\n7'\n,ט2Z:(P	L*@bLY27PD@J\"\r\"6)JgDOB0T\n|~͜L)גqYxOG46)m!<\nrxNT(@-A\"pHZ#äJ)pYo	B(T\")0!?63\n⮻%:-?Xz&!eF@(H\r`B{J	ݝBq`O\n3--jPZ)6#W38~Y;GFC	F&R0):N:L5'4#ɹ< YDڧq-U&6J6xO'zAO3Rz-\"l]a4:D&~FLTU7XFq	C^ٷxT#eꐷP 09Ӯ{L(e\rG7nSroa9kV.嘓sX,:3tPYp.Z=Lë6)z8Kbq=@mg	pyH'E+<V;(bݖǡBQ̍E5XV1v![_zz\"Z_2^\"6_t.1f9rW\\'fe	9cMDG4e:[M'Bbf%as8,'UX]\niZz	sc\$TZry^Ǚ;~~GQ~|a\rh-~Mk-iwB7lsW^VfCIMLB\"dZTКBBjeٙ*dGܴ\\jeS]C&e2Ї~x{=^ȩ;ҝ/kW~k&\0BP&%\0R/CsB`-eV^NN*H\0o1\0*0VЯ,.n(}䧭	ͨ#<6ϐ\no0fPΦ\nOP_\n-/ULlF%\n/>ppN-\rHbp\\`\np0Ѝ0N\0Gu0DHDѰn*ZL-+2A>k4,m6+*-!\n\\(VJQJ\\n rh@h4\rzĘ 4.Gɼ&O@@\np6,Pb\rZ\n&8(#b::ma0AfL.A.76Ofi63HvB!*حĤ_&ȏRCIm%n|!x*l&rjϖ4jk\"Ez@LLi\"Z\r.A\\kl2\$pDMd\\ \r\$2pΞ_G#`BbPG\$Tkhh@03prFff+ϖ> G.";break;case"zh-tw":$f="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ]EJ4\$yhr2^?[eCr^[#k֑g1')T'9jB)#,%')n䪪hVd=Oa@IBOs¦KJ12A\$&8mQdlYr%\0JBH;#`29X@7A\09 7L9ؿeYYqb*\\gA2@1D?-c%^Rpr\$)NP2\rH5% B%dU1M+%3@`x0D3:xm\rYWMat3^8#; ^)AT\nt[Tex!t%4C TtW!u2s\\K/ï3SX\\1H@P7@:\r8Cx9|1#aJVǫd]9FJVUZ`1&C9zr~M) D#9v)8!v]!*Vsē'UFsޔ8*\$nvq\nOg1\nbeI'&\rYd[M~&/؆%x|v'c~PAWt9cH7MWV㐊;g#H3 6#2\0øn\r4>\0!%TX!.z#vHLOH=QjXe``SA\0Y^NRL+i!@!B,6@e@b	.1TzelKɉ35B\nT ,8crA\0X.hA`8	:QIM@C UE\"F1LA?PTA,*|ϡ(֒#z\njĵ>e@F8'Y=h5uo\"s7>Wλ׌pC(lr*3`\\\$3TJB-!L:5Hk(b9d\0FTM! q	E\r	,yD5\r	|6D(.vBb\0)u1CAJ!%\n(X\rKZ.s\nxWٟ>^a0+u<#ln/1?Ĩ) xkN]I3P&%ra\\~91\"hM Qg%Dsg@DS!'3,͗Y'ZUbK,D_B\\N\$9#N#,xS\ncExPLeHTxU,VAFB7 kP(D,BG&{a\"QcFә/Q\0:jSE\0(iT'@BD!P\" E	4/JRrwк1t[+(d4uIq8E*jQ6>6x49`	*9Ă-š/qH\$`E!K\" \n&Q\n%\rh8DqQGuXĘUHo	UQB\"I\nN!<\$g[h,`ωB\$T6UMLhS1͋\$Q6ؾѢG.eH|LCeٻwvQqV.&Sq2/5JTj)/MfҁbD\$\\F'+tBXT!\$c\"j'ϙG^\"0	\0'wP3H^''Hv))a\"32\rl(!le+n'%@\\~DS1#[	96`_'aX8PƩE#)I{i[%!l%مޖ}24hG83NXeayR+o/\rFSNbY@eFN(;}{˖LxvFCM\\Exdy]o/P9\r@ly\"P~w[Azw^h\\pZ:%h4WFь\n(.7a䎏3,75t}soOQ}/1WVzGX1la2߭n6HK+Pp\$ԉ00CaP5\"V!%n3ʀS/j%bBˍR5v҃z#(WN*6pfӌʘH4@φiBc&6c0а-/pd<Am/\r0Pi1As-PaA,Ɔ&y:!ܜT'7b\0Oqpd\"2O[\n!mFmrV\"~*?-M{\\7b%6GG[\rDƤ#-A/as/͎Q\$%[x/'-LSaO1%)IѤIAFqD #	 j	\rmȃFADo\rC\n@i	+H\$DZAaz#pma\n.(C0HR.5eM\0\0D\"\09r:#~5JC(\$N\$HA\nZ@́B0)#JaRKraK(죌08֨>r̼S썦/B4)!:3w|.rL,aS.%n[\$S%s@`aF/&x8,;\r0o]'sN|\\ҏ:ء2#|ғt2n.vH\n*0\n`\"\0`\n&2'!R3*333f'\nɒSDT<ALg\")\\* ";break;}$Ai=array();foreach(explode("\n",lzw_decompress($f))as$X)$Ai[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Ai;}if(!$Ai){$Ai=get_translations($ca);$_SESSION["translations"]=$Ai;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$ng=array_search("SQL",$b->operators);if($ng!==false)unset($b->operators[$ng]);}function
dsn($sc,$V,$F,$D=array()){$D[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$D[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($sc,$V,$F,$D);}catch(Exception$Kc){auth_error(h($Kc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($P){return$this->pdo->quote($P);}function
query($G,$Ji=false){$H=$this->pdo->query($G);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($H);return$H;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($G,$n=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch();return$J[$n];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$nc=array();function
add_driver($s,$C){global$nc;$nc[$s]=$C;}function
get_driver($s){global$nc;return$nc[$s];}class
Min_SQL{var$_conn;function
__construct($g){$this->_conn=$g;}function
select($Q,$L,$Z,$yd,$Hf=array(),$y=1,$E=0,$vg=false){global$b,$w;$ie=(count($yd)<count($L));$G=$b->selectQueryBuild($L,$Z,$yd,$Hf,$y,$E);if(!$G)$G="SELECT".limit(($_GET["page"]!="last"&&$y!=""&&$yd&&$ie&&$w=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($yd&&$ie?"\nGROUP BY ".implode(", ",$yd):"").($Hf?"\nORDER BY ".implode(", ",$Hf):""),($y!=""?+$y:null),($E?$y*$E:0),"\n");$Kh=microtime(true);$I=$this->_conn->query($G);if($vg)echo$b->selectQuery($G,$Kh,!$I);return$I;}function
delete($Q,$Dg,$y=0){$G="FROM ".table($Q);return
queries("DELETE".($y?limit1($Q,$G,$Dg):" $G$Dg"));}function
update($Q,$N,$Dg,$y=0,$ph="\n"){$bj=array();foreach($N
as$x=>$X)$bj[]="$x = $X";$G=table($Q)." SET$ph".implode(",$ph",$bj);return
queries("UPDATE".($y?limit1($Q,$G,$Dg,$ph):" $G$Dg"));}function
insert($Q,$N){return
queries("INSERT INTO ".table($Q).($N?" (".implode(", ",array_keys($N)).")\nVALUES (".implode(", ",$N).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$K,$tg){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$mi){}function
convertSearch($t,$X,$n){return$t;}function
value($X,$n){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($fh){return
q($fh);}function
warnings(){return'';}function
tableHelp($C){}}$nc["sqlite"]="SQLite 3";$nc["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($dd){$this->_link=new
SQLite3($dd);$ej=$this->_link->version();$this->server_info=$ej["versionString"];}function
query($G){$H=@$this->_link->query($G);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($P){return(is_utf8($P)?"'".$this->_link->escapeString($P)."'":"x'".reset(unpack('H*',$P))."'");}function
store_result(){return$this->_result;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->_offset++;$T=$this->_result->columnType($d);return(object)array("name"=>$this->_result->columnName($d),"type"=>$T,"charsetnr"=>($T==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($dd){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($dd);}function
query($G,$Ji=false){$Ye=($Ji?"unbufferedQuery":"query");$H=@$this->_link->$Ye($G,SQLITE_BOTH,$m);$this->error="";if(!$H){$this->error=$m;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($P){return"'".sqlite_escape_string($P)."'";}function
store_result(){return$this->_result;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$x=>$X)$I[idf_unescape($x)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$C=$this->_result->fieldName($this->_offset++);$ig='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($ig\\.)?$ig\$~",$C,$A)){$Q=($A[3]!=""?$A[3]:idf_unescape($A[2]));$C=($A[5]!=""?$A[5]:idf_unescape($A[4]));}return(object)array("name"=>$C,"orgname"=>$C,"orgtable"=>$Q,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($dd){$this->dsn(DRIVER.":$dd","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($dd){if(is_readable($dd)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$dd)?$dd:dirname($_SERVER["SCRIPT_FILENAME"])."/$dd")." AS a")){parent::__construct($dd);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($G){return$this->_result=$this->query($G);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$tg){$bj=array();foreach($K
as$N)$bj[]="(".implode(", ",$N).")";return
queries("REPLACE INTO ".table($Q)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$bj));}function
tableHelp($C){if($C=="sqlite_sequence")return"fileformat2.html#seqtab";if($C=="sqlite_master")return"fileformat2.html#$C";}}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($G,$Z,$y,$qf=0,$ph=" "){return" $G$Z".($y!==null?$ph."LIMIT $y".($qf?" OFFSET $qf":""):"");}function
limit1($Q,$G,$Z,$ph="\n"){global$g;return(preg_match('~^INTO~',$G)||$g->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$ph):" $G WHERE rowid = (SELECT rowid FROM ".table($Q).$Z.$ph."LIMIT 1)");}function
db_collation($k,$ob){global$g;return$g->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($C=""){global$g;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){$J["Rows"]=$g->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($C!=""?$I[$C]:$I);}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){global$g;return!$g->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($Q){global$g;$I=array();$tg="";foreach(get_rows("PRAGMA table_info(".table($Q).")")as$J){$C=$J["name"];$T=strtolower($J["type"]);$Zb=$J["dflt_value"];$I[$C]=array("field"=>$C,"type"=>(preg_match('~int~i',$T)?"integer":(preg_match('~char|clob|text~i',$T)?"text":(preg_match('~blob~i',$T)?"blob":(preg_match('~real|floa|doub~i',$T)?"real":"numeric")))),"full_type"=>$T,"default"=>(preg_match("~'(.*)'~",$Zb,$A)?str_replace("''","'",$A[1]):($Zb=="NULL"?null:$Zb)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($tg!="")$I[$tg]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$T))$I[$C]["auto_increment"]=true;$tg=$C;}}$Fh=$g->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Fh,$B,PREG_SET_ORDER);foreach($B
as$A){$C=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($I[$C])$I[$C]["collation"]=trim($A[3],"'");}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Fh=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Fh,$A)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$B,PREG_SET_ORDER);foreach($B
as$A){$I[""]["columns"][]=idf_unescape($A[2]).$A[4];$I[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$I){foreach(fields($Q)as$C=>$n){if($n["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($C),"lengths"=>array(),"descs"=>array(null));}}$Ih=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($Q),$h);foreach(get_rows("PRAGMA index_list(".table($Q).")",$h)as$J){$C=$J["name"];$u=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$u["lengths"]=array();$u["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($C).")",$h)as$eh){$u["columns"][]=$eh["name"];$u["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($C).' ON '.idf_escape($Q),'~').' \((.*)\)$~i',$Ih[$C],$Og)){preg_match_all('/("[^"]*+")+( DESC)?/',$Og[2],$B);foreach($B[2]as$x=>$X){if($X)$u["descs"][$x]='1';}}if(!$I[""]||$u["type"]!="UNIQUE"||$u["columns"]!=$I[""]["columns"]||$u["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$C))$I[$C]=$u;}return$I;}function
foreign_keys($Q){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($Q).")")as$J){$p=&$I[$J["id"]];if(!$p)$p=$J;$p["source"][]=$J["from"];$p["target"][]=$J["to"];}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$g->result("SELECT sql FROM sqlite_master WHERE name = ".q($C))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){global$g;return
h($g->error);}function
check_sqlite_name($C){global$g;$Tc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Tc)\$~",$C)){$g->error=lang(23,str_replace("|",", ",$Tc));return
false;}return
true;}function
create_database($k,$nb){global$g;if(file_exists($k)){$g->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$z=new
Min_SQLite($k);}catch(Exception$Kc){$g->error=$Kc->getMessage();return
false;}$z->query('PRAGMA encoding = "UTF-8"');$z->query('CREATE TABLE adminer (i)');$z->query('DROP TABLE adminer');return
true;}function
drop_databases($j){global$g;$g->__construct(":memory:");foreach($j
as$k){if(!@unlink($k)){$g->error=lang(24);return
false;}}return
true;}function
rename_database($C,$nb){global$g;if(!check_sqlite_name($C))return
false;$g->__construct(":memory:");$g->error=lang(24);return@rename(DB,$C);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){global$g;$Ui=($Q==""||$md);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$Ui=true;break;}}$c=array();$Qf=array();foreach($o
as$n){if($n[1]){$c[]=($Ui?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$Qf[$n[0]]=$n[1][0];}}if(!$Ui){foreach($c
as$X){if(!queries("ALTER TABLE ".table($Q)." $X"))return
false;}if($Q!=$C&&!queries("ALTER TABLE ".table($Q)." RENAME TO ".table($C)))return
false;}elseif(!recreate_table($Q,$C,$c,$Qf,$md,$Ma))return
false;if($Ma){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ma WHERE name = ".q($C));if(!$g->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($C).", $Ma)");queries("COMMIT");}return
true;}function
recreate_table($Q,$C,$o,$Qf,$md,$Ma,$v=array()){global$g;if($Q!=""){if(!$o){foreach(fields($Q)as$x=>$n){if($v)$n["auto_increment"]=0;$o[]=process_field($n,$n);$Qf[$x]=idf_escape($x);}}$ug=false;foreach($o
as$n){if($n[6])$ug=true;}$qc=array();foreach($v
as$x=>$X){if($X[2]=="DROP"){$qc[$X[1]]=true;unset($v[$x]);}}foreach(indexes($Q)as$oe=>$u){$e=array();foreach($u["columns"]as$x=>$d){if(!$Qf[$d])continue
2;$e[]=$Qf[$d].($u["descs"][$x]?" DESC":"");}if(!$qc[$oe]){if($u["type"]!="PRIMARY"||!$ug)$v[]=array($u["type"],$oe,$e);}}foreach($v
as$x=>$X){if($X[0]=="PRIMARY"){unset($v[$x]);$md[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($Q)as$oe=>$p){foreach($p["source"]as$x=>$d){if(!$Qf[$d])continue
2;$p["source"][$x]=idf_unescape($Qf[$d]);}if(!isset($md[" $oe"]))$md[]=" ".format_foreign_key($p);}queries("BEGIN");}foreach($o
as$x=>$n)$o[$x]="  ".implode($n);$o=array_merge($o,array_filter($md));$gi=($Q==$C?"adminer_$C":$C);if(!queries("CREATE TABLE ".table($gi)." (\n".implode(",\n",$o)."\n)"))return
false;if($Q!=""){if($Qf&&!queries("INSERT INTO ".table($gi)." (".implode(", ",$Qf).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Qf)))." FROM ".table($Q)))return
false;$Gi=array();foreach(triggers($Q)as$Ei=>$ni){$Di=trigger($Ei);$Gi[]="CREATE TRIGGER ".idf_escape($Ei)." ".implode(" ",$ni)." ON ".table($C)."\n$Di[Statement]";}$Ma=$Ma?0:$g->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($Q));if(!queries("DROP TABLE ".table($Q))||($Q==$C&&!queries("ALTER TABLE ".table($gi)." RENAME TO ".table($C)))||!alter_indexes($C,$v))return
false;if($Ma)queries("UPDATE sqlite_sequence SET seq = $Ma WHERE name = ".q($C));foreach($Gi
as$Di){if(!queries($Di))return
false;}queries("COMMIT");}return
true;}function
index_sql($Q,$T,$C,$e){return"CREATE $T ".($T!="INDEX"?"INDEX ":"").idf_escape($C!=""?$C:uniqid($Q."_"))." ON ".table($Q)." $e";}function
alter_indexes($Q,$c){foreach($c
as$tg){if($tg[0]=="PRIMARY")return
recreate_table($Q,$Q,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($Q,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($S){return
apply_queries("DELETE FROM",$S);}function
drop_views($gj){return
apply_queries("DROP VIEW",$gj);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
move_tables($S,$gj,$ei){return
false;}function
trigger($C){global$g;if($C=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$t='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Fi=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$t\\s*(".implode("|",$Fi["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($t))?\\s+ON\\s*$t\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$g->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($C)),$A);$pf=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($pf?" OF":""),"Of"=>idf_unescape($pf),"Trigger"=>$C,"Statement"=>$A[4],);}function
triggers($Q){$I=array();$Fi=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Fi["Timing"]).')\s*(.*?)\s+ON\b~i',$J["sql"],$A);$I[$J["name"]]=array($A[1],$A[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ROWID()");}function
explain($g,$G){return$g->query("EXPLAIN QUERY PLAN $G");}function
found_rows($R,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($ih){return
true;}function
create_sql($Q,$Ma,$Ph){global$g;$I=$g->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($Q));foreach(indexes($Q)as$C=>$u){if($C=='')continue;$I.=";\n\n".index_sql($Q,$u['type'],$C,"(".implode(", ",array_map('idf_escape',$u['columns'])).")");}return$I;}function
truncate_sql($Q){return"DELETE FROM ".table($Q);}function
use_sql($Tb){}function
trigger_sql($Q){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q)));}function
show_variables(){global$g;$I=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$x)$I[$x]=$g->result("PRAGMA $x");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$Ff){list($x,$X)=explode("=",$Ff,2);$I[$x]=$X;}return$I;}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Yc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Yc);}function
driver_config(){$U=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);return
array('possible_drivers'=>array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite"),'jush'=>"sqlite",'types'=>$U,'structured_types'=>array_keys($U),'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL"),'functions'=>array("distinct","hex","length","lower","round","unixepoch","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",)),);}}$nc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($Fc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
connect($M,$V,$F){global$b;$k=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$k!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$ej=pg_version($this->_link);$this->server_info=$ej["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($P){return"'".pg_escape_string($this->_link,$P)."'";}function
value($X,$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
quoteBinary($P){return"'".pg_escape_bytea($this->_link,$P)."'";}function
select_db($Tb){global$b;if($Tb==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($Tb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($G,$Ji=false){$H=@pg_query($this->_link,$G);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$n);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$d);$I->name=pg_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$d);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($M,$V,$F){global$b;$k=$b->database();$this->dsn("pgsql:host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",$V,$F);return
true;}function
select_db($Tb){global$b;return($b->database()==$Tb);}function
quoteBinary($fh){return
q($fh);}function
query($G,$Ji=false){$I=parent::query($G,$Ji);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$tg){global$g;foreach($K
as$N){$Qi=array();$Z=array();foreach($N
as$x=>$X){$Qi[]="$x = $X";if(isset($tg[idf_unescape($x)]))$Z[]="$x = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Qi)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}function
slowQuery($G,$mi){$this->_conn->query("SET statement_timeout = ".(1000*$mi));$this->_conn->timeout=1000*$mi;return$G;}function
convertSearch($t,$X,$n){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$n["type"])?$t:"CAST($t AS text)");}function
quoteBinary($fh){return$this->_conn->quoteBinary($fh);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($C){$_=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$z=$_[$_GET["ns"]];if($z)return"$z-".str_replace("_","-",$C).".html";}}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b,$U,$Oh;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2])){if(min_version(9,0,$g)){$g->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$g)){$Oh[lang(25)][]="json";$U["json"]=4294967295;if(min_version(9.4,0,$g)){$Oh[lang(25)][]="jsonb";$U["jsonb"]=4294967295;}}}return$g;}return$g->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($G,$Z,$y,$qf=0,$ph=" "){return" $G$Z".($y!==null?$ph."LIMIT $y".($qf?" OFFSET $qf":""):"");}function
limit1($Q,$G,$Z,$ph="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$ph):" $G".(is_view(table_status1($Q))?$Z:$ph."WHERE ctid = (SELECT ctid FROM ".table($Q).$Z.$ph."LIMIT 1)"));}function
db_collation($k,$ob){global$g;return$g->result("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$G.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($j){return
array();}function
table_status($C=""){$I=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", ".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($C!=""?"AND relname = ".q($C):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($C!=""?$I[$C]:$I);}function
is_view($R){return
in_array($R["Engine"],array("view","materialized view"));}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Da=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment".(min_version(10)?", a.attidentity":"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($Q)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$A);list(,$T,$Be,$J["length"],$ya,$Ga)=$A;$J["length"].=$Ga;$db=$T.$ya;if(isset($Da[$db])){$J["type"]=$Da[$db];$J["full_type"]=$J["type"].$Be.$Ga;}else{$J["type"]=$T;$J["full_type"]=$J["type"].$Be.$ya.$Ga;}if(in_array($J['attidentity'],array('a','d')))$J['default']='GENERATED '.($J['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$J["null"]=!$J["attnotnull"];$J["auto_increment"]=$J['attidentity']||preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$J["default"],$A))$J["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$I[$J["field"]]=$J;}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Xh=$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($Q));$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Xh AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Xh AND ci.oid = i.indexrelid",$h)as$J){$Pg=$J["relname"];$I[$Pg]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$Pg]["columns"]=array();foreach(explode(" ",$J["indkey"])as$Xd)$I[$Pg]["columns"][]=$e[$Xd];$I[$Pg]["descs"]=array();foreach(explode(" ",$J["indoption"])as$Yd)$I[$Pg]["descs"][]=($Yd&1?'1':null);$I[$Pg]["lengths"]=array();}return$I;}function
foreign_keys($Q){global$yf;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($Q)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$A)){$J['source']=array_map('idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$Le)){$J['ns']=idf_unescape($Le[2]);$J['table']=idf_unescape($Le[4]);}$J['target']=array_map('idf_unescape',array_map('trim',explode(',',$A[3])));$J['on_delete']=(preg_match("~ON DELETE ($yf)~",$A[4],$Le)?$Le[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($yf)~",$A[4],$Le)?$Le[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
constraints($Q){global$yf;$I=array();foreach(get_rows("SELECT conname, consrc
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($Q)."
ORDER BY connamespace, conname")as$J)$I[$J['conname']]=$J['consrc'];return$I;}function
view($C){global$g;return
array("select"=>trim($g->result("SELECT pg_get_viewdef(".$g->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($C)).")")));}function
collations(){return
array();}function
information_schema($k){return($k=="information_schema");}function
error(){global$g;$I=h($g->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$A))$I=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($I);}function
create_database($k,$nb){return
queries("CREATE DATABASE ".idf_escape($k).($nb?" ENCODING ".idf_escape($nb):""));}function
drop_databases($j){global$g;$g->close();return
apply_queries("DROP DATABASE",$j,'idf_escape');}function
rename_database($C,$nb){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($C));}function
auto_increment(){return"";}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){$c=array();$Cg=array();if($Q!=""&&$Q!=$C)$Cg[]="ALTER TABLE ".table($Q)." RENAME TO ".table($C);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$c[]="DROP $d";else{$aj=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$c[]=($Q!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$c[]=($Q!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$Cg[]="ALTER TABLE ".table($C)." RENAME $d TO $X[0]";$c[]="ALTER $d TYPE$X[1]";if(!$X[6]){$c[]="ALTER $d ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($n[0]!=""||$aj!="")$Cg[]="COMMENT ON COLUMN ".table($C).".$X[0] IS ".($aj!=""?substr($aj,9):"''");}}$c=array_merge($c,$md);if($Q=="")array_unshift($Cg,"CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($Cg,"ALTER TABLE ".table($Q)."\n".implode(",\n",$c));if($ub!==null)$Cg[]="COMMENT ON TABLE ".table($C)." IS ".q($ub);if($Ma!=""){}foreach($Cg
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($Q,$c){$i=array();$oc=array();$Cg=array();foreach($c
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$oc[]=idf_escape($X[1]);else$Cg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($i)array_unshift($Cg,"ALTER TABLE ".table($Q).implode(",",$i));if($oc)array_unshift($Cg,"DROP INDEX ".implode(", ",$oc));foreach($Cg
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($S){return
queries("TRUNCATE ".implode(", ",array_map('table',$S)));return
true;}function
drop_views($gj){return
drop_tables($gj);}function
drop_tables($S){foreach($S
as$Q){$O=table_status($Q);if(!queries("DROP ".strtoupper($O["Engine"])." ".table($Q)))return
false;}return
true;}function
move_tables($S,$gj,$ei){foreach(array_merge($S,$gj)as$Q){$O=table_status($Q);if(!queries("ALTER ".strtoupper($O["Engine"])." ".table($Q)." SET SCHEMA ".idf_escape($ei)))return
false;}return
true;}function
trigger($C,$Q){if($C=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q)." AND trigger_name = ".q($C);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$J)$e[]=$J["event_object_column"];$I=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement" FROM information_schema.triggers '."$Z ORDER BY event_manipulation DESC")as$J){if($e&&$J["Event"]=="UPDATE")$J["Event"].=" OF";$J["Of"]=implode(", ",$e);if($I)$J["Event"].=" OR $I[Event]";$I=$J;}return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q))as$J){$Di=trigger($J["trigger_name"],$Q);$I[$Di["Trigger"]]=array($Di["Timing"],$Di["Event"]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($C,$T){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($C));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($C).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($C,$J){$I=array();foreach($J["fields"]as$n)$I[]=$n["type"];return
idf_escape($C)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($g,$G){return$g->query("EXPLAIN $G");}function
found_rows($R,$Z){global$g;if(preg_match("~ rows=([0-9]+)~",$g->result("EXPLAIN SELECT * FROM ".idf_escape($R["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Og))return$Og[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$g;return$g->result("SELECT current_schema()");}function
set_schema($hh,$h=null){global$g,$U,$Oh;if(!$h)$h=$g;$I=$h->query("SET search_path TO ".idf_escape($hh));foreach(types()as$T){if(!isset($U[$T])){$U[$T]=0;$Oh[lang(26)][]=$T;}}return$I;}function
foreign_keys_sql($Q){$I="";$O=table_status($Q);$id=foreign_keys($Q);ksort($id);foreach($id
as$hd=>$gd)$I.="ALTER TABLE ONLY ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." ADD CONSTRAINT ".idf_escape($hd)." $gd[definition] ".($gd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($I?"$I\n":$I);}function
create_sql($Q,$Ma,$Ph){global$g;$I='';$Xg=array();$rh=array();$O=table_status($Q);if(is_view($O)){$fj=view($Q);return
rtrim("CREATE VIEW ".idf_escape($Q)." AS $fj[select]",";");}$o=fields($Q);$v=indexes($Q);ksort($v);$Cb=constraints($Q);if(!$O||empty($o))return
false;$I="CREATE TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." (\n    ";foreach($o
as$ad=>$n){$Zf=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['attnotnull']?" NOT NULL":"");$Xg[]=$Zf;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$B)){$qh=$B[1];$Eh=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($qh):"SELECT * FROM $qh"));$rh[]=($Ph=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $qh;\n":"")."CREATE SEQUENCE $qh INCREMENT $Eh[increment_by] MINVALUE $Eh[min_value] MAXVALUE $Eh[max_value]".($Ma&&$Eh['last_value']?" START $Eh[last_value]":"")." CACHE $Eh[cache_value];";}}if(!empty($rh))$I=implode("\n\n",$rh)."\n\n$I";foreach($v
as$Sd=>$u){switch($u['type']){case'UNIQUE':$Xg[]="CONSTRAINT ".idf_escape($Sd)." UNIQUE (".implode(', ',array_map('idf_escape',$u['columns'])).")";break;case'PRIMARY':$Xg[]="CONSTRAINT ".idf_escape($Sd)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$u['columns'])).")";break;}}foreach($Cb
as$_b=>$Bb)$Xg[]="CONSTRAINT ".idf_escape($_b)." CHECK $Bb";$I.=implode(",\n    ",$Xg)."\n) WITH (oids = ".($O['Oid']?'true':'false').");";foreach($v
as$Sd=>$u){if($u['type']=='INDEX'){$e=array();foreach($u['columns']as$x=>$X)$e[]=idf_escape($X).($u['descs'][$x]?" DESC":"");$I.="\n\nCREATE INDEX ".idf_escape($Sd)." ON ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." USING btree (".implode(', ',$e).");";}}if($O['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." IS ".q($O['Comment']).";";foreach($o
as$ad=>$n){if($n['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($O['nspname']).".".idf_escape($O['Name']).".".idf_escape($ad)." IS ".q($n['comment']).";";}return
rtrim($I,';');}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
trigger_sql($Q){$O=table_status($Q);$I="";foreach(triggers($Q)as$Ci=>$Bi){$Di=trigger($Ci,$O['Name']);$I.="\nCREATE TRIGGER ".idf_escape($Di['Trigger'])." $Di[Timing] $Di[Event] ON ".idf_escape($O["nspname"]).".".idf_escape($O['Name'])." $Di[Type] $Di[Statement];;\n";}return$I;}function
use_sql($Tb){return"\connect ".idf_escape($Tb);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Yc){return
preg_match('~^(database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Yc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$g;return$g->result("SHOW max_connections");}function
driver_config(){$U=array();$Oh=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$x=>$X){$U+=$X;$Oh[$x]=array_keys($X);}return
array('possible_drivers'=>array("PgSQL","PDO_PgSQL"),'jush'=>"pgsql",'types'=>$U,'structured_types'=>$Oh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","~","~*","!~","!~*","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'operator_regexp'=>'~*','functions'=>array("char_length","distinct","lower","round","to_hex","to_timestamp","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",)),);}}$nc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;var$_current_db;function
_error($Fc,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
connect($M,$V,$F){$this->_link=@oci_new_connect($V,$F,$M,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$m=oci_error();$this->error=$m["message"];return
false;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Tb){$this->_current_db=$Tb;return
true;}function
query($G,$Ji=false){$H=oci_parse($this->_link,$G);$this->error="";if(!$H){$m=oci_error($this->_link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);oci_free_statement($H);}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=1){$H=$this->query($G);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$n);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$x=>$X){if(is_a($X,'OCI-Lob'))$J[$x]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$d);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";var$_current_db;function
connect($M,$V,$F){$this->dsn("oci:dbname=//$M;charset=AL32UTF8",$V,$F);return
true;}function
select_db($Tb){$this->_current_db=$Tb;return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}function
insertUpdate($Q,$K,$tg){global$g;foreach($K
as$N){$Qi=array();$Z=array();foreach($N
as$x=>$X){$Qi[]="$x = $X";if(isset($tg[idf_unescape($x)]))$Z[]="$x = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Qi)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces ORDER BY 1");}function
limit($G,$Z,$y,$qf=0,$ph=" "){return($qf?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($y+$qf).") WHERE rnum > $qf":($y!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($y+$qf):" $G$Z"));}function
limit1($Q,$G,$Z,$ph="\n"){return" $G$Z";}function
db_collation($k,$ob){global$g;return$g->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT USER FROM DUAL");}function
get_current_db(){global$g;$k=$g->_current_db?$g->_current_db:DB;unset($g->_current_db);return$k;}function
where_owner($rg,$Tf="owner"){if(!$_GET["ns"])return'';return"$rg$Tf = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$Tf=where_owner('');return"(SELECT $e FROM all_views WHERE ".($Tf?$Tf:"rownum < 0").")";}function
tables_list(){$fj=views_table("view_name");$Tf=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Tf
UNION SELECT view_name, 'view' FROM $fj
ORDER BY 1");}function
count_tables($j){global$g;$I=array();foreach($j
as$k)$I[$k]=$g->result("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$I;}function
table_status($C=""){$I=array();$jh=q($C);$k=get_current_db();$fj=views_table("view_name");$Tf=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$Tf.($C!=""?" AND table_name = $jh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $fj".($C!=""?" WHERE view_name = $jh":"")."
ORDER BY 1")as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Tf=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($Q)."$Tf ORDER BY column_id")as$J){$T=$J["DATA_TYPE"];$Be="$J[DATA_PRECISION],$J[DATA_SCALE]";if($Be==",")$Be=$J["CHAR_COL_DECL_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$T.($Be?"($Be)":""),"type"=>strtolower($T),"length"=>$Be,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($Q,$h=null){$I=array();$Tf=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($Q)."$Tf
ORDER BY ac.constraint_type, aic.column_position",$h)as$J){$Sd=$J["INDEX_NAME"];$rb=$J["DATA_DEFAULT"];$rb=($rb?trim($rb,'"'):$J["COLUMN_NAME"]);$I[$Sd]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$Sd]["columns"][]=$rb;$I[$Sd]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$Sd]["descs"][]=($J["DESCEND"]&&$J["DESCEND"]=="DESC"?'1':null);}return$I;}function
view($C){$fj=views_table("view_name, text");$K=get_rows('SELECT text "select" FROM '.$fj.' WHERE view_name = '.q($C));return
reset($K);}function
collations(){return
array();}function
information_schema($k){return
false;}function
error(){global$g;return
h($g->error);}function
explain($g,$G){$g->query("EXPLAIN PLAN FOR $G");return$g->query("SELECT * FROM plan_table");}function
found_rows($R,$Z){}function
auto_increment(){return"";}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){$c=$oc=array();$Nf=($Q?fields($Q):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($Q)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$Mf=$Nf[$n[0]];if($X&&$Mf){$sf=process_field($Mf,$Mf);if($X[2]==$sf[2])$X[2]="";}if($X)$c[]=($Q!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($Q!=""?")":"");else$oc[]=idf_escape($n[0]);}if($Q=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($Q)."\n".implode("\n",$c)))&&(!$oc||queries("ALTER TABLE ".table($Q)." DROP (".implode(", ",$oc).")"))&&($Q==$C||queries("ALTER TABLE ".table($Q)." RENAME TO ".table($C)));}function
alter_indexes($Q,$c){$oc=array();$Cg=array();foreach($c
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Cg,"ALTER TABLE ".table($Q).$i);}elseif($X[2]=="DROP")$oc[]=idf_escape($X[1]);else$Cg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($oc)array_unshift($Cg,"DROP INDEX ".implode(", ",$oc));foreach($Cg
as$G){if(!queries($G))return
false;}return
true;}function
foreign_keys($Q){$I=array();$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($Q);foreach(get_rows($G)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($gj){return
apply_queries("DROP VIEW",$gj);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
last_id(){return
0;}function
schemas(){$I=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($I?$I:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){global$g;return$g->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($ih,$h=null){global$g;if(!$h)$h=$g;return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($ih));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Yc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Yc);}function
driver_config(){$U=array();$Oh=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$x=>$X){$U+=$X;$Oh[$x]=array_keys($X);}return
array('possible_drivers'=>array("OCI8","PDO_OCI"),'jush'=>"oracle",'types'=>$U,'structured_types'=>$Oh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("distinct","length","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",)),);}}$nc["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error.="$m[message]\n";}$this->error=rtrim($this->error);}function
connect($M,$V,$F){global$b;$k=$b->database();$Ab=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");if($k!="")$Ab["Database"]=$k;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$M),$Ab);if($this->_link){$Zd=sqlsrv_server_info($this->_link);$this->server_info=$Zd['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Tb){return$this->query("USE ".idf_escape($Tb));}function
query($G,$Ji=false){$H=sqlsrv_query($this->_link,$G);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($G){$this->_result=sqlsrv_query($this->_link,$G);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$x=>$X){if(is_a($X,'DateTime'))$J[$x]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$n=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$n["Name"];$I->orgname=$n["Name"];$I->type=($n["Type"]==1?254:0);return$I;}function
seek($qf){for($r=0;$r<$qf;$r++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($M,$V,$F){$this->_link=@mssql_connect($M,$V,$F);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Tb){return
mssql_select_db($Tb);}function
query($G,$Ji=false){$H=@mssql_query($G,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$n);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($qf){mssql_data_seek($this->_result,$qf);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($M,$V,$F){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F);return
true;}function
select_db($Tb){return$this->query("USE ".idf_escape($Tb));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$tg){foreach($K
as$N){$Qi=array();$Z=array();foreach($N
as$x=>$X){$Qi[]="$x = $X";if(isset($tg[idf_unescape($x)]))$Z[]="$x = $X";}if(!queries("MERGE ".table($Q)." USING (VALUES(".implode(", ",$N).")) AS source (c".implode(", c",range(1,count($N))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Qi)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($t){return"[".str_replace("]","]]",$t)."]";}function
table($t){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($t);}function
connect(){global$b;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($G,$Z,$y,$qf=0,$ph=" "){return($y!==null?" TOP (".($y+$qf).")":"")." $G$Z";}function
limit1($Q,$G,$Z,$ph="\n"){return
limit($G,$Z,1,0,$ph);}function
db_collation($k,$ob){global$g;return$g->result("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){global$g;$I=array();foreach($j
as$k){$g->select_db($k);$I[$k]=$g->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($C=""){$I=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="VIEW";}function
fk_support($R){return
true;}function
fields($Q){$wb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($Q).", 'column', NULL)");$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($Q))as$J){$T=$J["type"];$Be=(preg_match("~char|binary~",$T)?$J["max_length"]:($T=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$T.($Be?"($Be)":""),"type"=>$T,"length"=>$Be,"default"=>$J["default"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],"comment"=>$wb[$J["name"]],);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($Q),$h)as$J){$C=$J["name"];$I[$C]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$C]["lengths"]=array();$I[$C]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$C]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$g->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($C))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$nb)$I[preg_replace('~_.*~','',$nb)][]=$nb;return$I;}function
information_schema($k){return
false;}function
error(){global$g;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$g->error)));}function
create_database($k,$nb){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$nb)?" COLLATE $nb":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$j)));}function
rename_database($C,$nb){if(preg_match('~^[a-z0-9_]+$~i',$nb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $nb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($C));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){$c=array();$wb=array();foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$c["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$wb[$n[0]]=$X[5];unset($X[5]);if($n[0]=="")$c["ADD"][]="\n  ".implode("",$X).($Q==""?substr($md[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($Q).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($Q=="")return
queries("CREATE TABLE ".table($C)." (".implode(",",(array)$c["ADD"])."\n)");if($Q!=$C)queries("EXEC sp_rename ".q(table($Q)).", ".q($C));if($md)$c[""]=$md;foreach($c
as$x=>$X){if(!queries("ALTER TABLE ".idf_escape($C)." $x".implode(",",$X)))return
false;}foreach($wb
as$x=>$X){$ub=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($x));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$ub.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($x));}return
true;}function
alter_indexes($Q,$c){$u=array();$oc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$oc[]=idf_escape($X[1]);else$u[]=idf_escape($X[1])." ON ".table($Q);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q):"ALTER TABLE ".table($Q)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$u||queries("DROP INDEX ".implode(", ",$u)))&&(!$oc||queries("ALTER TABLE ".table($Q)." DROP ".implode(", ",$oc)));}function
last_id(){global$g;return$g->result("SELECT SCOPE_IDENTITY()");}function
explain($g,$G){$g->query("SET SHOWPLAN_ALL ON");$I=$g->query($G);$g->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($R,$Z){}function
foreign_keys($Q){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($Q))as$J){$p=&$I[$J["FK_NAME"]];$p["db"]=$J["PKTABLE_QUALIFIER"];$p["table"]=$J["PKTABLE_NAME"];$p["source"][]=$J["FKCOLUMN_NAME"];$p["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($gj){return
queries("DROP VIEW ".implode(", ",array_map('table',$gj)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$gj,$ei){return
apply_queries("ALTER SCHEMA ".idf_escape($ei)." TRANSFER",array_merge($S,$gj));}function
trigger($C){if($C=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($C));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($Q))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$g;if($_GET["ns"]!="")return$_GET["ns"];return$g->result("SELECT SCHEMA_NAME()");}function
set_schema($hh){return
true;}function
use_sql($Tb){return"USE ".idf_escape($Tb);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Yc){return
preg_match('~^(comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Yc);}function
driver_config(){$U=array();$Oh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$x=>$X){$U+=$X;$Oh[$x]=array_keys($X);}return
array('possible_drivers'=>array("SQLSRV","MSSQL","PDO_DBLIB"),'jush'=>"mssql",'types'=>$U,'structured_types'=>$Oh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("distinct","len","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",)),);}}$nc["mongo"]="MongoDB (alpha)";if(isset($_GET["mongo"])){define("DRIVER","mongo");if(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Ri,$D){try{$this->_link=new
MongoClient($Ri,$D);if($D["password"]!=""){$D["password"]="";try{new
MongoClient($Ri,$D);$this->error=lang(22);}catch(Exception$uc){}}}catch(Exception$uc){$this->error=$uc->getMessage();}}function
query($G){return
false;}function
select_db($Tb){try{$this->_db=$this->_link->selectDB($Tb);return
true;}catch(Exception$Kc){$this->error=$Kc->getMessage();return
false;}}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$le){$J=array();foreach($le
as$x=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$x]=63;$J[$x]=(is_a($X,'MongoId')?"ObjectId(\"$X\")":(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?"$X":(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$x=>$X){if(!isset($this->_rows[0][$x]))$this->_rows[0][$x]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$x=>$X)$I[$x]=$J[$x];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$pe=array_keys($this->_rows[0]);$C=$pe[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$tg="_id";function
select($Q,$L,$Z,$yd,$Hf=array(),$y=1,$E=0,$vg=false){$L=($L==array("*")?array():array_fill_keys($L,true));$Bh=array();foreach($Hf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Ib);$Bh[$X]=($Ib?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($Q)->find(array(),$L)->sort($Bh)->limit($y!=""?+$y:0)->skip($E*$y));}function
insert($Q,$N){try{$I=$this->_conn->_db->selectCollection($Q)->insert($N);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$N['_id'];return!$I['err'];}catch(Exception$Kc){$this->_conn->error=$Kc->getMessage();return
false;}}}function
get_databases($jd){global$g;$I=array();$Xb=$g->_link->listDBs();foreach($Xb['databases']as$k)$I[]=$k['name'];return$I;}function
count_tables($j){global$g;$I=array();foreach($j
as$k)$I[$k]=count($g->_link->selectDB($k)->getCollectionNames(true));return$I;}function
tables_list(){global$g;return
array_fill_keys($g->_db->getCollectionNames(true),'table');}function
drop_databases($j){global$g;foreach($j
as$k){$Tg=$g->_link->selectDB($k)->drop();if(!$Tg['ok'])return
false;}return
true;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->_db->selectCollection($Q)->getIndexInfo()as$u){$hc=array();foreach($u["key"]as$d=>$T)$hc[]=($T==-1?'1':null);$I[$u["name"]]=array("type"=>($u["name"]=="_id_"?"PRIMARY":($u["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($u["key"]),"lengths"=>array(),"descs"=>$hc,);}return$I;}function
fields($Q){return
fields_from_edit();}function
found_rows($R,$Z){global$g;return$g->_db->selectCollection($_GET["select"])->count($Z);}$Df=array("=");$Cf=null;}elseif(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$affected_rows,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Ri,$D){$ib='MongoDB\Driver\Manager';$this->_link=new$ib($Ri,$D);$this->executeCommand('admin',array('ping'=>1));}function
executeCommand($k,$sb){$ib='MongoDB\Driver\Command';try{return$this->_link->executeCommand($k,new$ib($sb));}catch(Exception$uc){$this->error=$uc->getMessage();return
array();}}function
executeBulkWrite($ff,$Ya,$Jb){try{$Wg=$this->_link->executeBulkWrite($ff,$Ya);$this->affected_rows=$Wg->$Jb();return
true;}catch(Exception$uc){$this->error=$uc->getMessage();return
false;}}function
query($G){return
false;}function
select_db($Tb){$this->_db_name=$Tb;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$le){$J=array();foreach($le
as$x=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$x]=63;$J[$x]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'."$X\")":(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->getData():(is_a($X,'MongoDB\BSON\Regex')?"$X":(is_object($X)||is_array($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$x=>$X){if(!isset($this->_rows[0][$x]))$this->_rows[0][$x]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$x=>$X)$I[$x]=$J[$x];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$pe=array_keys($this->_rows[0]);$C=$pe[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$tg="_id";function
select($Q,$L,$Z,$yd,$Hf=array(),$y=1,$E=0,$vg=false){global$g;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$Bh=array();foreach($Hf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Ib);$Bh[$X]=($Ib?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$y=$_GET['limit'];$y=min(200,max(1,(int)$y));$zh=$E*$y;$ib='MongoDB\Driver\Query';try{return
new
Min_Result($g->_link->executeQuery("$g->_db_name.$Q",new$ib($Z,array('projection'=>$L,'limit'=>$y,'skip'=>$zh,'sort'=>$Bh))));}catch(Exception$uc){$g->error=$uc->getMessage();return
false;}}function
update($Q,$N,$Dg,$y=0,$ph="\n"){global$g;$k=$g->_db_name;$Z=sql_query_where_parser($Dg);$ib='MongoDB\Driver\BulkWrite';$Ya=new$ib(array());if(isset($N['_id']))unset($N['_id']);$Qg=array();foreach($N
as$x=>$Y){if($Y=='NULL'){$Qg[$x]=1;unset($N[$x]);}}$Qi=array('$set'=>$N);if(count($Qg))$Qi['$unset']=$Qg;$Ya->update($Z,$Qi,array('upsert'=>false));return$g->executeBulkWrite("$k.$Q",$Ya,'getModifiedCount');}function
delete($Q,$Dg,$y=0){global$g;$k=$g->_db_name;$Z=sql_query_where_parser($Dg);$ib='MongoDB\Driver\BulkWrite';$Ya=new$ib(array());$Ya->delete($Z,array('limit'=>$y));return$g->executeBulkWrite("$k.$Q",$Ya,'getDeletedCount');}function
insert($Q,$N){global$g;$k=$g->_db_name;$ib='MongoDB\Driver\BulkWrite';$Ya=new$ib(array());if($N['_id']=='')unset($N['_id']);$Ya->insert($N);return$g->executeBulkWrite("$k.$Q",$Ya,'getInsertedCount');}}function
get_databases($jd){global$g;$I=array();foreach($g->executeCommand('admin',array('listDatabases'=>1))as$Xb){foreach($Xb->databases
as$k)$I[]=$k->name;}return$I;}function
count_tables($j){$I=array();return$I;}function
tables_list(){global$g;$pb=array();foreach($g->executeCommand($g->_db_name,array('listCollections'=>1))as$H)$pb[$H->name]='table';return$pb;}function
drop_databases($j){return
false;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->executeCommand($g->_db_name,array('listIndexes'=>$Q))as$u){$hc=array();$e=array();foreach(get_object_vars($u->key)as$d=>$T){$hc[]=($T==-1?'1':null);$e[]=$d;}$I[$u->name]=array("type"=>($u->name=="_id_"?"PRIMARY":(isset($u->unique)?"UNIQUE":"INDEX")),"columns"=>$e,"lengths"=>array(),"descs"=>$hc,);}return$I;}function
fields($Q){global$l;$o=fields_from_edit();if(!$o){$H=$l->select($Q,array("*"),null,null,array(),10);if($H){while($J=$H->fetch_assoc()){foreach($J
as$x=>$X){$J[$x]=null;$o[$x]=array("field"=>$x,"type"=>"string","null"=>($x!=$l->primary),"auto_increment"=>($x==$l->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}}return$o;}function
found_rows($R,$Z){global$g;$Z=where_to_query($Z);$ui=$g->executeCommand($g->_db_name,array('count'=>$R['Name'],'query'=>$Z))->toArray();return$ui[0]->n;}function
sql_query_where_parser($Dg){$Dg=preg_replace('~^\sWHERE \(?\(?(.+?)\)?\)?$~','\1',$Dg);$qj=explode(' AND ',$Dg);$rj=explode(') OR (',$Dg);$Z=array();foreach($qj
as$oj)$Z[]=trim($oj);if(count($rj)==1)$rj=array();elseif(count($rj)>1)$Z=array();return
where_to_query($Z,$rj);}function
where_to_query($mj=array(),$nj=array()){global$b;$Rb=array();foreach(array('and'=>$mj,'or'=>$nj)as$T=>$Z){if(is_array($Z)){foreach($Z
as$Qc){list($lb,$Af,$X)=explode(" ",$Qc,3);if($lb=="_id"&&preg_match('~^(MongoDB\\\\BSON\\\\ObjectID)\("(.+)"\)$~',$X,$A)){list(,$ib,$X)=$A;$X=new$ib($X);}if(!in_array($Af,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$Af,$A)){$X=(float)$X;$Af=$A[1];}elseif(preg_match('~^\(date\)(.+)~',$Af,$A)){$Ub=new
DateTime($X);$ib='MongoDB\BSON\UTCDatetime';$X=new$ib($Ub->getTimestamp()*1000);$Af=$A[1];}switch($Af){case'=':$Af='$eq';break;case'!=':$Af='$ne';break;case'>':$Af='$gt';break;case'<':$Af='$lt';break;case'>=':$Af='$gte';break;case'<=':$Af='$lte';break;case'regex':$Af='$regex';break;default:continue
2;}if($T=='and')$Rb['$and'][]=array($lb=>array($Af=>$X));elseif($T=='or')$Rb['$or'][]=array($lb=>array($Af=>$X));}}}return$Rb;}$Df=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);$Cf='regex';}function
table($t){return$t;}function
idf_escape($t){return$t;}function
table_status($C="",$Xc=false){$I=array();foreach(tables_list()as$Q=>$T){$I[$Q]=array("Name"=>$Q);if($C==$Q)return$I[$Q];}return$I;}function
create_database($k,$nb){return
true;}function
last_id(){global$g;return$g->last_id;}function
error(){global$g;return
h($g->error);}function
collations(){return
array();}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();$D=array();if($V.$F!=""){$D["username"]=$V;$D["password"]=$F;}$k=$b->database();if($k!="")$D["db"]=$k;if(($La=getenv("MONGO_AUTH_SOURCE")))$D["authSource"]=$La;$g->connect("mongodb://$M",$D);if($g->error)return$g->error;return$g;}function
alter_indexes($Q,$c){global$g;foreach($c
as$X){list($T,$C,$N)=$X;if($N=="DROP")$I=$g->_db->command(array("deleteIndexes"=>$Q,"index"=>$C));else{$e=array();foreach($N
as$d){$d=preg_replace('~ DESC$~','',$d,1,$Ib);$e[$d]=($Ib?-1:1);}$I=$g->_db->selectCollection($Q)->ensureIndex($e,array("unique"=>($T=="UNIQUE"),"name"=>$C,));}if($I['errmsg']){$g->error=$I['errmsg'];return
false;}}return
true;}function
support($Yc){return
preg_match("~database|indexes|descidx~",$Yc);}function
db_collation($k,$ob){}function
information_schema(){}function
is_view($R){}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
foreign_keys($Q){return
array();}function
fk_support($R){}function
engines(){return
array();}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){global$g;if($Q==""){$g->_db->createCollection($C);return
true;}}function
drop_tables($S){global$g;foreach($S
as$Q){$Tg=$g->_db->selectCollection($Q)->drop();if(!$Tg['ok'])return
false;}return
true;}function
truncate_tables($S){global$g;foreach($S
as$Q){$Tg=$g->_db->selectCollection($Q)->remove();if(!$Tg['ok'])return
false;}return
true;}function
driver_config(){global$Df,$Cf;return
array('possible_drivers'=>array("mongo","mongodb"),'jush'=>"mongo",'operators'=>$Df,'operator_regexp'=>$Cf,'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),);}}$nc["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url,$_db;function
rootQuery($gg,array$Db=null,$Ye='GET'){@ini_set('track_errors',1);$cd=@file_get_contents("$this->_url/".ltrim($gg,'/'),false,stream_context_create(array('http'=>array('method'=>$Ye,'content'=>$Db!==null?json_encode($Db):null,'header'=>$Db!==null?'Content-Type: application/json':[],'ignore_errors'=>1,'follow_location'=>0,'max_redirects'=>0,))));if($cd===false){$this->error=lang(32);return
false;}$I=json_decode($cd,true);if($I===null){$this->error=lang(32);return
false;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){if(isset($I['error']['root_cause'][0]['type']))$this->error=$I['error']['root_cause'][0]['type'].": ".$I['error']['root_cause'][0]['reason'];else$this->error=lang(32);return
false;}return$I;}function
query($gg,array$Db=null,$Ye='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($gg,'/'),$Db,$Ye);}function
connect($M,$V,$F){$this->_url=build_http_url($M,$V,$F,"localhost",9200);$I=$this->query('');if(!$I)return
false;if(!isset($I['version']['number'])){$this->error=lang(32);return
false;}$this->server_info=$I['version']['number'];return
true;}function
select_db($Tb){$this->_db=$Tb;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows;function
__construct($K){$this->num_rows=count($K);$this->_rows=$K;reset($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);next($this->_rows);return$I;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($Q,$L,$Z,$yd,$Hf=array(),$y=1,$E=0,$vg=false){global$b;$Rb=array();$G="$Q/_search";if($L!=array("*"))$Rb["fields"]=$L;if($Hf){$Bh=array();foreach($Hf
as$lb){$lb=preg_replace('~ DESC$~','',$lb,1,$Ib);$Bh[]=($Ib?array($lb=>"desc"):$lb);}$Rb["sort"]=$Bh;}if($y){$Rb["size"]=+$y;if($E)$Rb["from"]=($E*$y);}foreach($Z
as$X){list($lb,$Af,$X)=explode(" ",$X,3);if($lb=="_id")$Rb["query"]["ids"]["values"][]=$X;elseif($lb.$X!=""){$hi=array("term"=>array(($lb!=""?$lb:"_all")=>$X));if($Af=="=")$Rb["query"]["filtered"]["filter"]["and"][]=$hi;else$Rb["query"]["filtered"]["query"]["bool"]["must"][]=$hi;}}if($Rb["query"]&&!$Rb["query"]["filtered"]["query"]&&!$Rb["query"]["ids"])$Rb["query"]["filtered"]["query"]=array("match_all"=>array());$Kh=microtime(true);$jh=$this->_conn->query($G,$Rb);if($vg)echo$b->selectQuery("$G: ".json_encode($Rb),$Kh,!$jh);if(!$jh)return
false;$I=array();foreach($jh['hits']['hits']as$Kd){$J=array();if($L==array("*"))$J["_id"]=$Kd["_id"];$o=$Kd['_source'];if($L!=array("*")){$o=array();foreach($L
as$x)$o[$x]=$Kd['fields'][$x];}foreach($o
as$x=>$X){if($Rb["fields"])$X=$X[0];$J[$x]=(is_array($X)?json_encode($X):$X);}$I[]=$J;}return
new
Min_Result($I);}function
update($T,$Hg,$Dg,$y=0,$ph="\n"){$eg=preg_split('~ *= *~',$Dg);if(count($eg)==2){$s=trim($eg[1]);$G="$T/$s";return$this->_conn->query($G,$Hg,'POST');}return
false;}function
insert($T,$Hg){$s="";$G="$T/$s";$Tg=$this->_conn->query($G,$Hg,'POST');$this->_conn->last_id=$Tg['_id'];return$Tg['created'];}function
delete($T,$Dg,$y=0){$Od=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$Od[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$cb){$eg=preg_split('~ *= *~',$cb);if(count($eg)==2)$Od[]=trim($eg[1]);}}$this->_conn->affected_rows=0;foreach($Od
as$s){$G="{$T}/{$s}";$Tg=$this->_conn->query($G,'{}','DELETE');if(is_array($Tg)&&$Tg['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();if($F!=""&&$g->connect($M,$V,""))return
lang(22);if($g->connect($M,$V,$F))return$g;return$g->error;}function
support($Yc){return
preg_match("~database|table|columns~",$Yc);}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
get_databases(){global$g;$I=$g->rootQuery('_aliases');if($I){$I=array_keys($I);sort($I,SORT_STRING);}return$I;}function
collations(){return
array();}function
db_collation($k,$ob){}function
engines(){return
array();}function
count_tables($j){global$g;$I=array();$H=$g->query('_stats');if($H&&$H['indices']){$Wd=$H['indices'];foreach($Wd
as$Vd=>$Lh){$Ud=$Lh['total']['indexing'];$I[$Vd]=$Ud['index_total'];}}return$I;}function
tables_list(){global$g;if(min_version(6))return
array('_doc'=>'table');$I=$g->query('_mapping');if($I)$I=array_fill_keys(array_keys($I[$g->_db]["mappings"]),'table');return$I;}function
table_status($C="",$Xc=false){global$g;$jh=$g->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$I=array();if($jh){$S=$jh["aggregations"]["count_by_type"]["buckets"];foreach($S
as$Q){$I[$Q["key"]]=array("Name"=>$Q["key"],"Engine"=>"table","Rows"=>$Q["doc_count"],);if($C!=""&&$C==$Q["key"])return$I[$C];}}return$I;}function
error(){global$g;return
h($g->error);}function
information_schema(){}function
is_view($R){}function
indexes($Q,$h=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($Q){global$g;$Ie=array();if(min_version(6)){$H=$g->query("_mapping");if($H)$Ie=$H[$g->_db]['mappings']['properties'];}else{$H=$g->query("$Q/_mapping");if($H){$Ie=$H[$Q]['properties'];if(!$Ie)$Ie=$H[$g->_db]['mappings'][$Q]['properties'];}}$I=array();if($Ie){foreach($Ie
as$C=>$n){$I[$C]=array("field"=>$C,"full_type"=>$n["type"],"type"=>$n["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($n["properties"]){unset($I[$C]["privileges"]["insert"]);unset($I[$C]["privileges"]["update"]);}}}return$I;}function
foreign_keys($Q){return
array();}function
table($t){return$t;}function
idf_escape($t){return$t;}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
fk_support($R){}function
found_rows($R,$Z){return
null;}function
create_database($k){global$g;return$g->rootQuery(urlencode($k),null,'PUT');}function
drop_databases($j){global$g;return$g->rootQuery(urlencode(implode(',',$j)),array(),'DELETE');}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){global$g;$Ag=array();foreach($o
as$Vc){$ad=trim($Vc[1][0]);$bd=trim($Vc[1][1]?$Vc[1][1]:"text");$Ag[$ad]=array('type'=>$bd);}if(!empty($Ag))$Ag=array('properties'=>$Ag);return$g->query("_mapping/{$C}",$Ag,'PUT');}function
drop_tables($S){global$g;$I=true;foreach($S
as$Q)$I=$I&&$g->query(urlencode($Q),array(),'DELETE');return$I;}function
last_id(){global$g;return$g->last_id;}function
driver_config(){$U=array();$Oh=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$x=>$X){$U+=$X;$Oh[$x]=array_keys($X);}return
array('possible_drivers'=>array("json + allow_url_fopen"),'jush'=>"elastic",'operators'=>array("=","query"),'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),'types'=>$U,'structured_types'=>$Oh,);}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminerevo.org/'".target_blank()." id='h1'>AdminerEvo</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($M){return
h($M);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$dd="adminer.css";if(file_exists($dd))$I[]="$dd?v=".crc32(file_get_contents($dd));return$I;}function
loginForm(){global$nc;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(33).'<td>',html_select("auth[driver]",$nc,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(34).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(35).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(36).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(37).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(38)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(39))."\n";}function
loginFormField($C,$Hd,$Y){return$Hd.$Y;}function
login($Ge,$F){if($F=="")return
lang(40,target_blank());return
true;}function
tableName($Vh){return
h($Vh["Name"]);}function
fieldName($n,$Hf=0){return'<span title="'.h($n["full_type"]).'">'.h($n["field"]).'</span>';}function
selectLinks($Vh,$N=""){global$w,$l;echo'<p class="links">';$xa=array("select"=>lang(41));if(support("table")||support("indexes"))$xa["table"]=lang(42);if(support("table")){if(is_view($Vh))$xa["view"]=lang(43);else$xa["create"]=lang(44);}if($N!==null)$xa["edit"]=lang(45);$C=$Vh["Name"];$_=[];foreach($xa
as$x=>$X)$_[]="<a href='".h(ME)."$x=".urlencode($C).($x=="edit"?$N:"")."'".bold(isset($_GET[$x])).">$X</a>";echo
generate_linksbar($_),doc_link(array($w=>$l->tableHelp($C)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$Uh){return
array();}function
backwardKeysPrint($Pa,$J){}function
selectQuery($G,$Kh,$Wc=false){global$w,$l;if(!$Wc&&($jj=$l->warnings())){$s="warnings";$I=", <a href='#$s'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$s');","")."<div id='$s' class='hidden'>\n$jj</div>\n";}$_=[(support("sql")?"<a href='".h(ME)."sql=".urlencode($G)."'>".lang(10)."</a>":""),"<a href='#' class='copy-to-clipboard'>".lang(47)."</a>",];return"<code class='jush-$w copy-to-clipboard'>".h(str_replace("\n"," ",$G))."</code> <span class='time'>(".format_time($Kh).")</span>".generate_linksbar($_);}function
sqlCommandQuery($G){return
shorten_utf8(trim($G),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($K,$nd){return$K;}function
selectLink($X,$n){}function
selectVal($X,$z,$n,$Pf){$I=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"]??null)&&!preg_match("~var~",$n["type"]??null)?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$n["type"]??null)&&!is_utf8($X))$I="<i>".lang(48,strlen($Pf))."</i>";if(preg_match('~json~',$n["type"]??null))$I="<code class='jush-js'>$I</code>";return($z?"<a href='".h($z)."'".(is_url($z)?target_blank():"").">$I</a>":$I);}function
editVal($X,$n){return$X;}function
tableStructurePrint($o){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(49)."<td>".lang(50).(support("comment")?"<td>".lang(51):"")."</thead>\n";foreach($o
as$n){echo"<tr".odd()."><th>".h($n["field"]),"<td><span title='".h($n["collation"])."'>".h($n["full_type"])."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(52)."</i>":""),(isset($n["default"])?" <span title='".lang(53)."'>[<b>".h($n["default"])."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($v){echo"<table cellspacing='0'>\n";foreach($v
as$C=>$u){ksort($u["columns"]);$vg=array();foreach($u["columns"]as$x=>$X)$vg[]="<i>".h($X)."</i>".($u["lengths"][$x]?"(".$u["lengths"][$x].")":"").($u["descs"][$x]?" DESC":"");echo"<tr title='".h($C)."'><th>$u[type]<td>".implode(", ",$vg)."\n";}echo"</table>\n";}function
selectColumnsPrint($L,$e){global$ud,$Ad;print_fieldset("select",lang(54),$L);$r=0;$L[""]=array();foreach($L
as$x=>$X){$X=$_GET["columns"][$x]??null;$d=select_input(" name='columns[$r][col]'",$e,$X["col"]??null,($x!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($ud||$Ad?"<select name='columns[$r][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(55)=>$ud,lang(56)=>$Ad)),$X["fun"]??null)."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($x!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)." <input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(57)),"' alt='x'>".script('qsl(".icon").onclick = selectRemoveRow;',"")."</div>\n";$r++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$v){print_fieldset("search",lang(58),$Z);foreach($v
as$r=>$u){if($u["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$u["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$r]' value='".h($_GET["fulltext"][$r])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$r]",1,isset($_GET["boolean"][$r]),"BOOL"),"</div>\n";}}$ab="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$r=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$r][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(59).")"),html_select("where[$r][op]",$this->operators,$X["op"],$ab),"<input type='search' name='where[$r][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $ab }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"<input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(57)),"' alt='x'>",script('qsl(".icon").onclick = selectRemoveRow;',""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($Hf,$e,$v){print_fieldset("sort",lang(60),$Hf);$r=0;foreach((array)$_GET["order"]as$x=>$X){if($X!=""){echo"<div>".select_input(" name='order[$r]'",$e,$X,"selectFieldChange"),checkbox("desc[$r]",1,isset($_GET["desc"][$x]),lang(61))," <input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(57)),"' alt='x'>",script('qsl(".icon").onclick = selectRemoveRow;',""),"</div>\n";$r++;}}echo"<div>".select_input(" name='order[$r]'",$e,"","selectAddRow"),checkbox("desc[$r]",1,false,lang(61))," <input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(57)),"' alt='x'>",script('qsl(".icon").onclick = selectRemoveRow;',""),"</div>\n","</div></fieldset>\n";}function
selectLimitPrint($y){echo"<fieldset><legend>".lang(62)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($y)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($ki){if($ki!==null){echo"<fieldset><legend>".lang(63)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($ki)."'>","</div></fieldset>\n";}}function
selectActionPrint($v){echo"<fieldset><legend>".lang(64)."</legend><div>","<input type='submit' value='".lang(54)."'>"," <span id='noindex' title='".lang(65)."'></span>","<script".nonce().">\n","var indexColumns = ";$e=array();foreach($v
as$u){$Qb=reset($u["columns"]);if($u["type"]!="FULLTEXT"&&$Qb)$e[$Qb]=1;}$e[""]=1;foreach($e
as$x=>$X)json_row($x);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($_c,$e){}function
selectColumnsProcess($e,$v){global$ud,$Ad;$L=array();$yd=array();foreach((array)$_GET["columns"]as$x=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$ud)||in_array($X["fun"],$Ad)))){$L[$x]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$Ad))$yd[]=$L[$x];}}return
array($L,$yd);}function
selectSearchProcess($o,$v){global$g,$l;$I=array();foreach($v
as$r=>$u){if($u["type"]=="FULLTEXT"&&$_GET["fulltext"][$r]!="")$I[]="MATCH (".implode(", ",array_map('idf_escape',$u["columns"])).") AGAINST (".q($_GET["fulltext"][$r]).(isset($_GET["boolean"][$r])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$x=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$rg="";$xb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Rd=process_length($X["val"]);$xb.=" ".($Rd!=""?$Rd:"(NULL)");}elseif($X["op"]=="SQL")$xb=" $X[val]";elseif($X["op"]=="LIKE %%")$xb=" LIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$xb=" ILIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$rg="$X[op](".q($X["val"]).", ";$xb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$xb.=" ".$this->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$I[]=$rg.$l->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$xb;else{$qb=array();foreach($o
as$C=>$n){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$qb[]=$rg.$l->convertSearch(idf_escape($C),$X,$n).$xb;}$I[]=($qb?"(".implode(" OR ",$qb).")":"1 = 0");}}}return$I;}function
selectOrderProcess($o,$v){$I=array();foreach((array)$_GET["order"]as$x=>$X){if($X!="")$I[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$x])?" DESC":"");}return$I;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$nd){return
false;}function
selectQueryBuild($L,$Z,$yd,$Hf,$y,$E){return"";}function
messageQuery($G,$li,$Wc=false){global$w,$l;restart_session();$Id=&get_session("queries");if(isset($Id[$_GET["db"]])===false)$Id[$_GET["db"]]=array();if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n…";$Id[$_GET["db"]][]=array($G,time(),$li);$Hh="sql-".count($Id[$_GET["db"]]);$I="<a href='#$Hh' class='toggle'>".lang(66)."</a> <a href='#' class='copy-to-clipboard icon expand' data-expand-id='$Hh'></a>\n";if(!$Wc&&($jj=$l->warnings())){$s="warnings-".count($Id[$_GET["db"]]);$I="<a href='#$s' class='toggle'>".lang(46)."</a>, $I<div id='$s' class='hidden'>\n$jj</div>\n";}$_=[];if(support("sql")){$_[]='<a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Id[$_GET["db"]])-1)).'">'.lang(10).'</a>';$_[]='<a href="#" class="copy-to-clipboard">'.lang(47).'</a>';}return" <span class='time'>".@date("H:i:s")."</span>"." $I<div id='$Hh' class='hidden'><pre><code class='jush-$w copy-to-clipboard'>".shorten_utf8($G,1000)."</code></pre>".($li?" <span class='time'>($li)</span>":'').generate_linksbar($_).'</div>';}function
editRowPrint($Q,$o,$J,$Qi){}function
editFunctions($n){global$vc;$I=($n["null"]?"NULL/":"");$Qi=isset($_GET["select"])||where($_GET);foreach($vc
as$x=>$ud){if(!$x||(!isset($_GET["call"])&&$Qi)){foreach($ud
as$ig=>$X){if(!$ig||preg_match("~$ig~",$n["type"]))$I.="/$X";}}if($x&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$I.="/SQL";}if($n["auto_increment"]&&!$Qi)$I=lang(52);return
explode("/",$I);}function
editInput($Q,$n,$Ja,$Y){if($n["type"]=="enum"){$D=array();$lh=$Y;if(isset($_GET["select"])){$D[-1]=lang(8);if($lh===null)$lh=-1;}if($n["null"]){$D[""]="NULL";if($Y===null&&!isset($_GET["select"]))$lh="";}$D[0]=lang(7);preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$B);foreach($B[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$D[$r+1]=$X;if($Y===$X)$lh=$r+1;}return"<select$Ja>".optionlist($D,(string)$lh,1)."</select>";}return"";}function
editHint($Q,$n,$Y){return"";}function
processInput($n,$Y,$q=""){if($q=="SQL")return$Y;$C=$n["field"];$I=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$q))$I="$q()";elseif(preg_match('~^current_(date|timestamp)$~',$q))$I=$q;elseif(preg_match('~^([+-]|\|\|)$~',$q))$I=idf_escape($C)." $q $I";elseif(preg_match('~^[+-] interval$~',$q))$I=idf_escape($C)." $q ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$I);elseif(preg_match('~^(addtime|subtime|concat)$~',$q))$I="$q(".idf_escape($C).", $I)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$q))$I="$q($I)";return
unconvert_field($n,$I);}function
dumpOutput(){$I=array('text'=>lang(67),'file'=>lang(68));if(function_exists('gzencode'))$I['gz']='gzip';return$I;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($Q,$Ph,$ke=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Ph)dump_csv(array_keys(fields($Q)));}else{if($ke==2){$o=array();foreach(fields($Q)as$C=>$n)$o[]=idf_escape($C)." $n[full_type]";$i="CREATE TABLE ".table($Q)." (".implode(", ",$o).")";}else$i=create_sql($Q,$_POST["auto_increment"],$Ph);set_utf8mb4($i);if($Ph&&$i){if($Ph=="DROP+CREATE"||$ke==1)echo"DROP ".($ke==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($ke==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($Q,$Ph,$G){global$g,$w;$Ne=($w=="sqlite"?0:1048576);if($Ph){if($_POST["format"]=="sql"){if($Ph=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$o=fields($Q);}$H=$g->query($G,1);if($H){$de="";$Xa="";$pe=array();$vd=array();$Rh="";$Zc=($Q!=''?'fetch_assoc':'fetch_row');while($J=$H->$Zc()){if(!$pe){$bj=array();foreach($J
as$X){$n=$H->fetch_field();if(!empty($o[$n->name]['generated'])){$vd[$n->name]=true;continue;}$pe[]=$n->name;$x=idf_escape($n->name);$bj[]="$x = VALUES($x)";}$Rh=($Ph=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$bj):"").";\n";}if($_POST["format"]!="sql"){if($Ph=="table"){dump_csv($pe);$Ph="INSERT";}dump_csv($J);}else{if(!$de)$de="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$pe)).") VALUES";foreach($J
as$x=>$X){if(isset($vd[$x])){unset($J[$x]);continue;}$n=$o[$x];$J[$x]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$fh=($Ne?"\n":" ")."(".implode(",\t",$J).")";if(!$Xa)$Xa=$de.$fh;elseif(strlen($Xa)+4+strlen($fh)+strlen($Rh)<$Ne)$Xa.=",$fh";else{echo$Xa.$Rh;$Xa=$de.$fh;}}}if($Xa)echo$Xa.$Rh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$g->error)."\n";}}function
dumpFilename($Nd){return
friendly_url($Nd!=""?$Nd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Nd,$bf=false){$Sf=$_POST["output"];$Rc=(preg_match('~sql~',$_POST["format"])?"sql":($bf?"tar":"csv"));header("Content-Type: ".($Sf=="gz"?"application/x-gzip":($Rc=="tar"?"application/x-tar":($Rc=="sql"||$Sf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Sf=="gz")ob_start('ob_gzencode',1e6);return$Rc;}function
importServerPath(){return"adminer.sql";}function
homepage(){$_=[];if($_GET["ns"]==""&&support("database"))$_[]='<a href="'.h(ME).'database=">'.lang(69).'</a>';if(support("scheme"))$_[]="<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(70):lang(71))."</a>";if($_GET["ns"]!=="")$_[]='<a href="'.h(ME).'schema=">'.lang(72).'</a>';if(support("privileges"))$_[]="<a href='".h(ME)."privileges='>".lang(73)."</a>";echo
generate_linksbar($_);return
true;}function
navigation($af){global$ia,$w,$nc,$g;echo'<h1>
',$this->name(),' <span class="version">',$ia,'</span>
<a href="https://download.adminerevo.org/latest/adminer/"',target_blank(),' id="version" title="',lang(74),'">',(version_compare($ia,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($af=="auth"){$Sf="";foreach((array)$_SESSION["pwds"]as$dj=>$th){foreach($th
as$M=>$Yi){foreach($Yi
as$V=>$F){if($F!==null){$Xb=$_SESSION["db"][$dj][$M][$V];foreach(($Xb?array_keys($Xb):array(""))as$k)$Sf.="<li><a href='".h(auth_url($dj,$M,$V,$k))."'>($nc[$dj]) ".h($V.($M!=""?"@".$this->serverName($M):"").($k!=""?" - $k":""))."</a>\n";}}}}if($Sf)echo"<ul id='logins'>\n$Sf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$S=array();if($_GET["ns"]!==""&&!$af&&DB!=""){$g->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.8.4");if(support("sql")){echo'<script',nonce(),'>
';if($S){$_=array();foreach($S
as$Q=>$T)$_[]=preg_quote($Q,'/');echo"var jushLinks = { $w: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$_).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$w;\n";}$sh=$g->server_info;echo'bodyLoad(\'',(is_object($g)?preg_replace('~^(\d\.?\d).*~s','\1',$sh):""),'\'',(preg_match('~MariaDB~',$sh)?", true":""),');
</script>
';}$this->databasesPrint($af);$_=[];if(DB==""||!$af){if(support("sql")){$_[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(66)."</a>";$_[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(75)."</a>";}if(support("dump"))$_[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(76)."</a>";}echo
generate_linksbar($_);if($_GET["ns"]!==""&&!$af&&DB!=""){echo
generate_linksbar(['<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(77)."</a>"]);if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($af){global$b,$g;$j=$this->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo'<form action="">
',"<table id='dbs'><tr><td width=1>";hidden_fields_get();$Vb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(78)."' for='menu_db'>".lang(79)."</label>:</td><td>".($j?"<select name='db' id='menu_db'>".optionlist(array(""=>"")+$j,DB)."</select>$Vb":"<input name='db' id='menu_db' value='".h(DB)."' autocapitalize='off'>\n"),"</td></tr>";if(support("scheme")){if($af!="db"&&DB!=""&&$g->select_db(DB)){echo"<tr><td><label for='menu_ns'>".lang(80).":</label></td>","<td><select name='ns' id='menu_ns'>".optionlist(array(""=>"")+$b->schemas(),$_GET["ns"])."</select>$Vb";if($_GET["ns"]!="")set_schema($_GET["ns"]);echo"</td></tr>";}}echo"<tr".($j?" class='hidden'":"")."><td colspan=2><input type='submit' value='".lang(20)."'></td></tr>\n","</table>";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$O){$C=$this->tableName($O);if($C!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(41)."'>".lang(81)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["select"])),(is_view($O)?"view":"structure"))." title='".lang(42)."'>$C</a>":"<span>$C</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$nc=array("server"=>"MySQL")+$nc;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($M="",$V="",$F="",$Tb=null,$mg=null,$Ah=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Ld,$mg)=explode(":",$M,2);$Jh=$b->connectSsl();if($Jh)$this->ssl_set($Jh['key'],$Jh['cert'],$Jh['ca'],'','');$I=@$this->real_connect(($M!=""?$Ld:ini_get("mysqli.default_host")),($M.$V!=""?$V:ini_get("mysqli.default_user")),($M.$V.$F!=""?$F:ini_get("mysqli.default_pw")),$Tb,(is_numeric($mg)?$mg:ini_get("mysqli.default_port")),(!is_numeric($mg)?$mg:$Ah),($Jh?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($bb){if(parent::set_charset($bb))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $bb");}function
result($G,$n=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch_array();return$J[$n];}function
quote($P){return"'".$this->escape_string($P)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($M,$V,$F){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(82,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($M!=""?$M:ini_get("mysql.default_host")),("$M$V"!=""?$V:ini_get("mysql.default_user")),("$M$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($bb){if(function_exists('mysql_set_charset')){if(mysql_set_charset($bb,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $bb");}function
quote($P){return"'".mysql_real_escape_string($P,$this->_link)."'";}function
select_db($Tb){return
mysql_select_db($Tb,$this->_link);}function
query($G,$Ji=false){$H=@($Ji?mysql_unbuffered_query($G,$this->_link):mysql_query($G,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$n);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($M,$V,$F){global$b;$D=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Jh=$b->connectSsl();if($Jh){if(!empty($Jh['key']))$D[PDO::MYSQL_ATTR_SSL_KEY]=$Jh['key'];if(!empty($Jh['cert']))$D[PDO::MYSQL_ATTR_SSL_CERT]=$Jh['cert'];if(!empty($Jh['ca']))$D[PDO::MYSQL_ATTR_SSL_CA]=$Jh['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F,$D);return
true;}function
set_charset($bb){$this->query("SET NAMES $bb");}function
select_db($Tb){return$this->query("USE ".idf_escape($Tb));}function
query($G,$Ji=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Ji);return
parent::query($G,$Ji);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$N){return($N?parent::insert($Q,$N):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$K,$tg){$e=array_keys(reset($K));$rg="INSERT INTO ".table($Q)." (".implode(", ",$e).") VALUES\n";$bj=array();foreach($e
as$x)$bj[$x]="$x = VALUES($x)";$Rh="\nON DUPLICATE KEY UPDATE ".implode(", ",$bj);$bj=array();$Be=0;foreach($K
as$N){$Y="(".implode(", ",$N).")";if($bj&&(strlen($rg)+$Be+strlen($Y)+strlen($Rh)>1e6)){if(!queries($rg.implode(",\n",$bj).$Rh))return
false;$bj=array();$Be=0;}$bj[]=$Y;$Be+=strlen($Y)+2;}return
queries($rg.implode(",\n",$bj).$Rh);}function
slowQuery($G,$mi){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$mi FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($mi*1000).") */ $A[2]";}}function
convertSearch($t,$X,$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($t USING ".charset($this->_conn).")":$t);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($C){$Je=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Je?"information-schema-$C-table/":str_replace("_","-",$C)."-table.html"));if(DB=="mysql")return($Je?"mysql$C-table/":"system-database.html");}}function
idf_escape($t){return"`".str_replace("`","``",$t)."`";}function
table($t){return
idf_escape($t);}function
connect(){global$b,$U,$Oh;$g=new
Min_DB;$Mb=$b->credentials();if($g->connect($Mb[0],$Mb[1],$Mb[2])){$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$g)){$Oh[lang(25)][]="json";$U["json"]=4294967295;}return$g;}$I=$g->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($fh=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$fh;return$I;}function
get_databases($jd){$I=get_session("dbs");if($I===null){$G=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($jd?slow_query($G):get_vals($G));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($G,$Z,$y,$qf=0,$ph=" "){return" $G$Z".($y!==null?$ph."LIMIT $y".($qf?" OFFSET $qf":""):"");}function
limit1($Q,$G,$Z,$ph="\n"){return
limit($G,$Z,1,0,$ph);}function
db_collation($k,$ob){global$g;$I=null;$i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$A))$I=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$A))$I=$ob[$A[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$g;return$g->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($j){$I=array();foreach($j
as$k)$I[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$I;}function
table_status($C="",$Xc=false){$I=array();foreach(get_rows($Xc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($C!=""?"AND TABLE_NAME = ".q($C):"ORDER BY Name"):"SHOW TABLE STATUS".($C!=""?" LIKE ".q(addcslashes($C,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$A);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$A[1],"length"=>$A[2],"unsigned"=>ltrim($A[3].$A[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$A[1])?(preg_match('~text~',$A[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$J["Default"])):$J["Default"]):null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$A)?$A[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$J["Extra"]),);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$h)as$J){$C=$J["Key_name"];$I[$C]["type"]=($C=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$C]["columns"][]=$J["Column_name"];$I[$C]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$C]["descs"][]=null;}return$I;}function
foreign_keys($Q){global$g,$yf;static$ig='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$I=array();$Kb=$g->result("SHOW CREATE TABLE ".table($Q),1);if($Kb){preg_match_all("~CONSTRAINT ($ig) FOREIGN KEY ?\\(((?:$ig,? ?)+)\\) REFERENCES ($ig)(?:\\.($ig))? \\(((?:$ig,? ?)+)\\)(?: ON DELETE ($yf))?(?: ON UPDATE ($yf))?~",$Kb,$B,PREG_SET_ORDER);foreach($B
as$A){preg_match_all("~$ig~",$A[2],$Ch);preg_match_all("~$ig~",$A[5],$ei);$I[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('idf_unescape',$Ch[0]),"target"=>array_map('idf_unescape',$ei[0]),"on_delete"=>($A[6]?$A[6]:"RESTRICT"),"on_update"=>($A[7]?$A[7]:"RESTRICT"),);}}return$I;}function
view($C){global$g;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$g->result("SHOW CREATE VIEW ".table($C),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$x=>$X)asort($I[$x]);return$I;}function
information_schema($k){return(min_version(5)&&$k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){global$g;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$g->error));}function
create_database($k,$nb){return
queries("CREATE DATABASE ".idf_escape($k).($nb?" COLLATE ".q($nb):""));}function
drop_databases($j){$I=apply_queries("DROP DATABASE",$j,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($C,$nb){$I=false;if(create_database($C,$nb)){$S=array();$gj=array();foreach(tables_list()as$Q=>$T){if($T=='VIEW')$gj[]=$Q;else$S[]=$Q;}$I=(!$S&&!$gj)||move_tables($S,$gj,$C);drop_databases($I?array(DB):array());}return$I;}function
auto_increment(){$Na=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$u){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$u["columns"],true)){$Na="";break;}if($u["type"]=="PRIMARY")$Na=" UNIQUE";}}return" AUTO_INCREMENT$Na";}function
alter_table($Q,$C,$o,$md,$ub,$Cc,$nb,$Ma,$cg){$c=array();foreach($o
as$n)$c[]=($n[1]?($Q!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($Q!=""?$n[2]:""):"DROP ".idf_escape($n[0]));$c=array_merge($c,$md);$O=($ub!==null?" COMMENT=".q($ub):"").($Cc?" ENGINE=".q($Cc):"").($nb?" COLLATE ".q($nb):"").($Ma!=""?" AUTO_INCREMENT=$Ma":"");if($Q=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)$O$cg");if($Q!=$C)$c[]="RENAME TO ".table($C);if($O)$c[]=ltrim($O);return($c||$cg?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$c).$cg):true);}function
alter_indexes($Q,$c){foreach($c
as$x=>$X)$c[$x]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$c));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($gj){return
queries("DROP VIEW ".implode(", ",array_map('table',$gj)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$gj,$ei){global$g;$Rg=array();foreach($S
as$Q)$Rg[]=table($Q)." TO ".idf_escape($ei).".".table($Q);if(!$Rg||queries("RENAME TABLE ".implode(", ",$Rg))){$ec=array();foreach($gj
as$Q)$ec[table($Q)]=view($Q);$g->select_db($ei);$k=idf_escape(DB);foreach($ec
as$C=>$fj){if(!queries("CREATE VIEW $C AS ".str_replace(" $k."," ",$fj["select"]))||!queries("DROP VIEW $k.$C"))return
false;}return
true;}return
false;}function
copy_tables($S,$gj,$ei){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$C=($ei==DB?table("copy_$Q"):idf_escape($ei).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $C"))||!queries("CREATE TABLE $C LIKE ".table($Q))||!queries("INSERT INTO $C SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J){$Di=$J["Trigger"];if(!queries("CREATE TRIGGER ".($ei==DB?idf_escape("copy_$Di"):idf_escape($ei).".".idf_escape($Di))." $J[Timing] $J[Event] ON $C FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($gj
as$Q){$C=($ei==DB?table("copy_$Q"):idf_escape($ei).".".table($Q));$fj=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $C"))||!queries("CREATE VIEW $C AS $fj[select]"))return
false;}return
true;}function
trigger($C){if($C=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($C));return
reset($K);}function
triggers($Q){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($C,$T){global$g,$Ec,$be,$U;$Da=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Dh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Ii="((".implode("|",array_merge(array_keys($U),$Da)).")\\b(?:\\s*\\(((?:[^'\")]|$Ec)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$ig="$Dh*(".($T=="FUNCTION"?"":$be).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Ii";$i=$g->result("SHOW CREATE $T ".idf_escape($C),2);preg_match("~\\(((?:$ig\\s*,?)*)\\)\\s*".($T=="FUNCTION"?"RETURNS\\s+$Ii\\s+":"")."(.*)~is",$i,$A);$o=array();preg_match_all("~$ig\\s*,?~is",$A[1],$B,PREG_SET_ORDER);foreach($B
as$Wf)$o[]=array("field"=>str_replace("``","`",$Wf[2]).$Wf[3],"type"=>strtolower($Wf[5]),"length"=>preg_replace_callback("~$Ec~s",'normalize_enum',$Wf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Wf[8] $Wf[7]"))),"null"=>1,"full_type"=>$Wf[4],"inout"=>strtoupper($Wf[1]),"collation"=>strtolower($Wf[9]),);if($T!="FUNCTION")return
array("fields"=>$o,"definition"=>$A[11]);return
array("fields"=>$o,"returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($C,$J){return
idf_escape($C);}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ID()");}function
explain($g,$G){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$G);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($hh,$h=null){return
true;}function
create_sql($Q,$Ma,$Ph){global$g;$I=$g->result("SHOW CREATE TABLE ".table($Q),1);if(!$Ma)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($Tb){return"USE ".idf_escape($Tb);}function
trigger_sql($Q){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field($n,$I){if(preg_match("~binary~",$n["type"]??null))$I="UNHEX($I)";if(isset($n["type"])&&$n["type"]=="bit")$I="CONV($I, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]??null)){$rg=(min_version(8)?"ST_":"");$I=$rg."GeomFromText($I, $rg"."SRID($n[field]))";}return$I;}function
support($Yc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$Yc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$g;return$g->result("SELECT @@max_connections");}function
driver_config(){$U=array();$Oh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(83)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$x=>$X){$U+=$X;$Oh[$x]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$U,'structured_types'=>$Oh,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","distinct","from_unixtime","unix_timestamp","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'operator_regexp'=>'REGEXP','grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$yb=driver_config();$qg=$yb['possible_drivers'];$w=$yb['jush'];$U=$yb['types'];$Oh=$yb['structured_types'];$Pi=$yb['unsigned'];$Df=$yb['operators'];$Cf=isset($yb['operator_regexp'])&&in_array($yb['operator_regexp'],$Df)?$yb['operator_regexp']:null;$ud=$yb['functions'];$Ad=$yb['grouping'];$vc=$yb['edit_functions'];if($b->operators===null){$b->operators=$Df;$b->operator_regexp=$Cf;}define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ia="4.8.4";function
page_header($oi,$m="",$Wa=array(),$pi=""){global$ca,$ia,$b,$nc,$w;page_headers();if(is_ajax()&&$m){page_messages($m);exit;}$qi=$oi.($pi!=""?": $pi":"");$ri=strip_tags($qi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(84),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$ri,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.4"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.4");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.4"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.4"),'">
';foreach($b->css()as$Ob){echo'<link rel="stylesheet" type="text/css" href="',h($Ob),'">
';}}echo'
<body class="',lang(84),' nojs adminer">
';$dd=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&file_exists($dd)&&filemtime($dd)+86400>time()){$ej=unserialize(file_get_contents($dd));$_COOKIE["adminer_version"]=$ej["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(85)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$w,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Wa!==null){$z=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($z?$z:".").'">'.$nc[DRIVER].'</a> &raquo; ';$z=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$M=$b->serverName(SERVER);$M=($M!=""?$M:lang(34));if($Wa===false)echo"$M\n";else{echo"<a href='".h($z)."' accesskey='1' title='Alt+Shift+1'>$M</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Wa)))echo'<a href="'.h($z."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Wa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Wa
as$x=>$X){$gc=(is_array($X)?$X[1]:h($X));if($gc!="")echo"<a href='".h(ME."$x=").urlencode(is_array($X)?$X[0]:$X)."'>$gc</a> &raquo; ";}}echo"$oi\n";}}echo"<h2>$qi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Nb){$Gd=array();foreach($Nb
as$x=>$X)$Gd[]="$x $X";header("Content-Security-Policy: ".implode("; ",$Gd));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self' https://api.github.com/repos/adminerevo/adminerevo/releases/latest","frame-src"=>"'self'","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$kf;if(!$kf)$kf=base64_encode(rand_string());return$kf;}function
page_messages($m){$Ri=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Xe=[];if(isset($_SESSION["messages"][$Ri]))$Xe=$_SESSION["messages"][$Ri];if(count($Xe)>0){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Xe)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Ri]);}if($m)echo"<div class='error'>$m</div>\n";}function
page_footer($af=""){global$b,$vi;echo'</div>

';switch_lang();if($af!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(86),'" id="logout">
<input type="hidden" name="token" value="',$vi,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($af);echo'</div>
',script("setupSubmitHighlight(document);"),script("setupCopyToClipboard(document);"),"</body>\n</html>";}function
int32($df){while($df>=2147483648)$df-=4294967296;while($df<=-2147483649)$df+=4294967296;return(int)$df;}function
long2str($W,$ij){$fh='';foreach($W
as$X)$fh.=pack('V',$X);if($ij)return
substr($fh,0,end($W));return$fh;}function
str2long($fh,$ij){$W=array_values(unpack('V*',str_pad($fh,4*ceil(strlen($fh)/4),"\0")));if($ij)$W[]=strlen($fh);return$W;}function
xxtea_mx($uj,$tj,$Sh,$ne){return
int32((($uj>>5&0x7FFFFFF)^$tj<<2)+(($tj>>3&0x1FFFFFFF)^$uj<<4))^int32(($Sh^$tj)+($ne^$uj));}function
encrypt_string($Nh,$x){if($Nh=="")return"";$x=array_values(unpack("V*",pack("H*",md5($x))));$W=str2long($Nh,true);$df=count($W)-1;$uj=$W[$df];$tj=$W[0];$Bg=floor(6+52/($df+1));$Sh=0;while($Bg-->0){$Sh=int32($Sh+0x9E3779B9);$uc=$Sh>>2&3;for($Uf=0;$Uf<$df;$Uf++){$tj=$W[$Uf+1];$cf=xxtea_mx($uj,$tj,$Sh,$x[$Uf&3^$uc]);$uj=int32($W[$Uf]+$cf);$W[$Uf]=$uj;}$tj=$W[0];$cf=xxtea_mx($uj,$tj,$Sh,$x[$Uf&3^$uc]);$uj=int32($W[$df]+$cf);$W[$df]=$uj;}return
long2str($W,false);}function
decrypt_string($Nh,$x){if($Nh=="")return"";if(!$x)return
false;$x=array_values(unpack("V*",pack("H*",md5($x))));$W=str2long($Nh,false);$df=count($W)-1;$uj=$W[$df];$tj=$W[0];$Bg=floor(6+52/($df+1));$Sh=int32($Bg*0x9E3779B9);while($Sh){$uc=$Sh>>2&3;for($Uf=$df;$Uf>0;$Uf--){$uj=$W[$Uf-1];$cf=xxtea_mx($uj,$tj,$Sh,$x[$Uf&3^$uc]);$tj=int32($W[$Uf]-$cf);$W[$Uf]=$tj;}$uj=$W[$df];$cf=xxtea_mx($uj,$tj,$Sh,$x[$Uf&3^$uc]);$tj=int32($W[0]-$cf);$W[0]=$tj;$Sh=int32($Sh-0x9E3779B9);}return
long2str($W,true);}$g='';$Fd=$_SESSION["token"];if(!$Fd)$_SESSION["token"]=rand(1,1e6);$vi=get_token();$kg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($x)=explode(":",$X);$kg[$x]=$X;}}function
validate_server_input(){if(SERVER=="")return;$eg=parse_url(SERVER);if(!$eg)auth_error(lang(32));if(isset($eg['user'])||isset($eg['pass'])||isset($eg['query'])||isset($eg['fragment']))auth_error(lang(32));if(isset($eg['scheme'])&&!preg_match('~^(https?)$~i',$eg['scheme']))auth_error(lang(32));$Ld=(isset($eg['host'])?$eg['host']:'').(isset($eg['path'])?$eg['path']:'');if(strpos(rtrim($Ld,'/'),'/')!==false)auth_error(lang(32));if(isset($eg['port'])&&($eg['port']<1024||$eg['port']>65535))auth_error(lang(87));}function
build_http_url($M,$V,$F,$bc,$ac=null){if(!preg_match('~^(https?://)?([^:]*)(:\d+)?$~',rtrim($M,'/'),$B)){$this->error=lang(32);return
false;}return($B[1]?:"http://").($V!==""||$F!==""?"$V:$F@":"").($B[2]!==""?$B[2]:$bc).(isset($B[3])?$B[3]:($ac?":$ac":""));}function
add_invalid_login(){global$b;$sd=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$sd)return;$ge=unserialize(stream_get_contents($sd));$li=time();if($ge){foreach($ge
as$he=>$X){if($X[0]<$li)unset($ge[$he]);}}$fe=&$ge[$b->bruteForceKey()];if(!$fe)$fe=array($li+30*60,0);$fe[1]++;file_write_unlock($sd,serialize($ge));}function
check_invalid_login(){global$b;$ge=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$fe=($ge?$ge[$b->bruteForceKey()]:array());if($fe===null)return;$jf=($fe[1]>29?$fe[0]-time():0);if($jf>0)auth_error(lang(88,ceil($jf/60)));}$Ka=$_POST["auth"];if($Ka){session_regenerate_id();$dj=$Ka["driver"];$M=trim($Ka["server"]);$V=$Ka["username"];$F=(string)$Ka["password"];$k=$Ka["db"];set_password($dj,$M,$V,$F);$_SESSION["db"][$dj][$M][$V][$k]=true;if($Ka["permanent"]){$x=base64_encode($dj)."-".base64_encode($M)."-".base64_encode($V)."-".base64_encode($k);$wg=$b->permanentLogin(true);$kg[$x]="$x:".base64_encode($wg?encrypt_string($F,$wg):"");cookie("adminer_permanent",implode(" ",$kg));}if(count($_POST)==1||DRIVER!=$dj||SERVER!=$M||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($dj,$M,$V,$k));}elseif($_POST["logout"]&&(!$Fd||verify_token())){foreach(array("pwds","db","dbs","queries")as$x)set_session($x,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(89));}elseif($kg&&!$_SESSION["pwds"]){session_regenerate_id();$wg=$b->permanentLogin();foreach($kg
as$x=>$X){list(,$hb)=explode(":",$X);list($dj,$M,$V,$k)=array_map('base64_decode',explode("-",$x));set_password($dj,$M,$V,decrypt_string(base64_decode($hb),$wg));$_SESSION["db"][$dj][$M][$V][$k]=true;}}function
unset_permanent(){global$kg;foreach($kg
as$x=>$X){list($dj,$M,$V,$k)=array_map('base64_decode',explode("-",$x));if($dj==DRIVER&&$M==SERVER&&$V==$_GET["username"]&&$k==DB)unset($kg[$x]);}cookie("adminer_permanent",implode(" ",$kg));}function
auth_error($m){global$b,$Fd;$uh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$uh]||$_GET[$uh])&&!$Fd)$m=lang(90);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m.=($m?'<br>':'').lang(91,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$uh]&&$_GET[$uh]&&ini_bool("session.use_only_cookies"))$m=lang(92);$Xf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Xf["lifetime"]);page_header(lang(38),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(93)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(94),lang(95,implode(", ",$qg)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){validate_server_input();check_invalid_login();$g=connect();$l=new
Min_Driver($g);}$Ge=null;if(!is_object($g)||($Ge=$b->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?h($g):(is_string($Ge)?$Ge:lang(32)));auth_error($m.(preg_match('~^ | $~',get_password())?'<br>'.lang(96):''));}if($_POST["logout"]&&$Fd&&!verify_token()){page_header(lang(86),lang(97));page_footer("db");exit;}if($Ka&&$_POST["token"])$_POST["token"]=$vi;$m='';if($_POST){if(!verify_token()){$ae="max_input_vars";$Re=ini_get($ae);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$x){$X=ini_get($x);if($X&&(!$Re||$X<$Re)){$ae=$x;$Re=$X;}}}$m=(!$_POST["token"]&&$Re?lang(98,"'$ae'"):lang(97).' '.lang(99));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(100,"'post_max_size'");if(isset($_GET["sql"]))$m.=' '.lang(101);}function
select($H,$h=null,$Kf=array(),$y=0){global$w;$_=array();$v=array();$e=array();$Ua=array();$U=array();$I=array();odd('');for($r=0;(!$y||$r<$y)&&($J=$H->fetch_row());$r++){if(!$r){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($me=0;$me<count($J);$me++){$n=$H->fetch_field();$C=$n->name;$Jf=$n->orgtable;$If=$n->orgname;$I[$n->table]=$Jf;if($Kf&&$w=="sql")$_[$me]=($C=="table"?"table=":($C=="possible_keys"?"indexes=":null));elseif($Jf!=""){if(!isset($v[$Jf])){$v[$Jf]=array();foreach(indexes($Jf,$h)as$u){if($u["type"]=="PRIMARY"){$v[$Jf]=array_flip($u["columns"]);break;}}$e[$Jf]=$v[$Jf];}if(isset($e[$Jf][$If])){unset($e[$Jf][$If]);$v[$Jf][$If]=$me;$_[$me]=$Jf;}}if($n->charsetnr==63)$Ua[$me]=true;$U[$me]=$n->type;echo"<th".($Jf!=""||$n->name!=$If?" title='".h(($Jf!=""?"$Jf.":"").$If)."'":"").">".h($C).($Kf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($C),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($J
as$x=>$X){$z="";if(isset($_[$x])&&!$e[$_[$x]]){if($Kf&&$w=="sql"){$Q=$J[array_search("table=",$_)];$z=ME.$_[$x].urlencode($Kf[$Q]!=""?$Kf[$Q]:$Q);}else{$z=ME."edit=".urlencode($_[$x]);foreach($v[$_[$x]]as$lb=>$me)$z.="&where".urlencode("[".bracket_escape($lb)."]")."=".urlencode($J[$me]);}}elseif(is_url($X))$z=$X;if($X===null)$X="<i>NULL</i>";elseif($Ua[$x]&&!is_utf8($X))$X="<i>".lang(48,strlen($X))."</i>";else{$X=h($X);if($U[$x]==254)$X="<code>$X</code>";}if($z)$X="<a href='".h($z)."'".(is_url($z)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($r?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$I;}function
referencable_primary($nh){$I=array();foreach(table_status('',true)as$Wh=>$Q){if($Wh!=$nh&&fk_support($Q)){foreach(fields($Wh)as$n){if($n["primary"]){if($I[$Wh]){unset($I[$Wh]);break;}$I[$Wh]=$n;}}}}return$I;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$wh);return$wh;}function
adminer_setting($x){$wh=adminer_settings();return$wh[$x];}function
set_adminer_settings($wh){return
cookie("adminer_settings",http_build_query($wh+adminer_settings()));}function
textarea($C,$Y,$K=10,$qb=80){global$w;echo"<textarea name='".h($C)."' rows='$K' cols='$qb' class='sqlarea jush-$w' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($x,$n,$ob,$od=array(),$Uc=array()){global$Oh,$U,$Pi,$yf;$T=$n["type"];echo'<td><select name="',h($x),'[type]" class="type" aria-labelledby="label-type">';if($T&&!isset($U[$T])&&!isset($od[$T])&&!in_array($T,$Uc))$Uc[]=$T;if($od)$Oh[lang(102)]=$od;echo
optionlist(array_merge($Uc,$Oh),$T),'</select><td><input name="',h($x),'[length]" value="',h($n["length"]),'" size="3"',(!$n["length"]&&preg_match('~var(char|binary)$~',$T)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($x)."[collation]'".(preg_match('~(char|text|enum|set)$~',$T)?"":" class='hidden'").'><option value="">('.lang(103).')'.optionlist($ob,$n["collation"]).'</select>',($Pi?"<select name='".h($x)."[unsigned]'".(!$T||preg_match(number_type(),$T)?"":" class='hidden'").'><option>'.optionlist($Pi,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($x)."[on_update]'".(preg_match('~timestamp|datetime~',$T)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(104).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($od?"<select name='".h($x)."[on_delete]'".(preg_match("~`~",$T)?"":" class='hidden'")."><option value=''>(".lang(105).")".optionlist(explode("|",$yf),$n["on_delete"])."</select> ":" ");}function
process_length($Be){global$Ec;return(preg_match("~^\\s*\\(?\\s*$Ec(?:\\s*,\\s*$Ec)*+\\s*\\)?\\s*\$~",$Be)&&preg_match_all("~$Ec~",$Be,$B)?"(".implode(",",$B[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Be)));}function
process_type($n,$mb="COLLATE"){global$Pi;if(DRIVER==='server'&&($n['unsigned']==='unsigned'||stripos((string)$n['type'],'int')!==false)&&min_version(8))$n["length"]='';return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],$Pi)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $mb ".q($n["collation"]):"");}function
process_field($n,$Hi){return
array(idf_escape(trim($n["field"])),process_type($Hi),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value($n){$Zb=$n["default"];return($Zb===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$Zb)?q($Zb):$Zb));}function
type_class($T){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$x=>$X){if(preg_match("~$x|$X~",$T))return" class='$x'";}}function
edit_fields($o,$ob,$T="TABLE",$od=array()){global$be;$o=array_values($o);$cc=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$vb=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($T=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($T=="TABLE"?lang(106):lang(107)),'<td id="label-type">',lang(50),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(108),'<td>',lang(109);if($T=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(52),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype.html#DATATYPE-SERIAL",'mssql'=>"ms186775.aspx",)),'<td id="label-default"',$cc,'>',lang(53),(support("comment")?"<td id='label-comment'$vb>".lang(51):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($o))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(110)."'>".script("row_count = ".count($o).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$r=>$n){$r++;$Lf=$n[($_POST?"orig":"field")];$kc=(isset($_POST["add"][$r-1])||(isset($n["field"])&&isset($_POST["drop_col"][$r])===false))&&(support("drop_col")||$Lf=="");echo'<tr',($kc?"":" style='display: none;'"),'>
',($T=="PROCEDURE"?"<td>".html_select("fields[$r][inout]",explode("|",$be),$n["inout"]):""),'<th>';if($kc){echo'<input name="fields[',$r,'][field]" value="',h($n["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$r,'][orig]" value="',h($Lf),'">';edit_type("fields[$r]",$n,$ob,$od);if($T=="TABLE"){echo'<td>',checkbox("fields[$r][null]",1,$n["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$r,'"';if($n["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$cc,'>',checkbox("fields[$r][has_default]",1,$n["has_default"],"","","","label-default"),'<input name="fields[',$r,'][default]" value="',h($n["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$vb><input name='fields[$r][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(110)."'> "."<input type='image' class='icon' name='up[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.8.4")."' alt='↑' title='".lang(111)."'> "."<input type='image' class='icon' name='down[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.8.4")."' alt='↓' title='".lang(112)."'> ":""),($Lf==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' alt='x' title='".lang(57)."'>":"");}}function
process_fields(&$o){$qf=0;if($_POST["up"]){$we=0;foreach($o
as$x=>$n){if(key($_POST["up"])==$x){unset($o[$x]);array_splice($o,$we,0,array($n));break;}if(isset($n["field"]))$we=$qf;$qf++;}}elseif($_POST["down"]){$qd=false;foreach($o
as$x=>$n){if(isset($n["field"])&&$qd){unset($o[key($_POST["down"])]);array_splice($o,$qf,0,array($qd));break;}if(key($_POST["down"])==$x)$qd=$n;$qf++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($A){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($A[0][0].$A[0][0],$A[0][0],substr($A[0],1,-1))),'\\'))."'";}function
grant($wd,$yg,$e,$xf){if(!$yg)return
true;if($yg==array("ALL PRIVILEGES","GRANT OPTION"))return($wd=="GRANT"?queries("$wd ALL PRIVILEGES$xf WITH GRANT OPTION"):queries("$wd ALL PRIVILEGES$xf")&&queries("$wd GRANT OPTION$xf"));return
queries("$wd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$yg).$e).$xf);}function
drop_create($oc,$i,$pc,$ii,$rc,$Fe,$We,$Ue,$Ve,$uf,$hf){if($_POST["drop"])query_redirect($oc,$Fe,$We);elseif($uf=="")query_redirect($i,$Fe,$Ve);elseif($uf!=$hf){$Lb=queries($i);queries_redirect($Fe,$Ue,$Lb&&queries($oc));if($Lb)queries($pc);}else
queries_redirect($Fe,$Ue,queries($ii)&&queries($rc)&&queries($oc)&&queries($i));}function
create_trigger($xf,$J){global$w;$ni=" $J[Timing] $J[Event]".(preg_match('~ OF~',$J["Event"])?" $J[Of]":"");return"CREATE TRIGGER ".idf_escape($J["Trigger"]).($w=="mssql"?$xf.$ni:$ni.$xf).rtrim(" $J[Type]\n$J[Statement]",";").";";}function
create_routine($bh,$J){global$be,$w;$N=array();$o=(array)$J["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$N[]=(preg_match("~^($be)\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$dc=rtrim("\n$J[definition]",";");return"CREATE $bh ".idf_escape(trim($J["name"]))." (".implode(", ",$N).")".(isset($_GET["function"])?" RETURNS".process_type($J["returns"],"CHARACTER SET"):"").($J["language"]?" LANGUAGE $J[language]":"").($w=="pgsql"?" AS ".q($dc):"$dc;");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($p){global$yf;$k=$p["db"];$lf=$p["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$p["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($lf!=""&&$lf!=$_GET["ns"]?idf_escape($lf).".":"").table($p["table"])." (".implode(", ",array_map('idf_escape',$p["target"])).")".(preg_match("~^($yf)\$~",$p["on_delete"])?" ON DELETE $p[on_delete]":"").(preg_match("~^($yf)\$~",$p["on_update"])?" ON UPDATE $p[on_update]":"");}function
tar_file($dd,$si){$I=pack("a100a8a8a8a12a12",$dd,644,0,0,decoct($si->size),decoct(time()));$gb=8*32;for($r=0;$r<strlen($I);$r++)$gb+=ord($I[$r]);$I.=sprintf("%06o",$gb)."\0 ";echo$I,str_repeat("\0",512-strlen($I));$si->send();echo
str_repeat("\0",511-($si->size+511)%512);}function
ini_bytes($ae){$X=ini_get($ae);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($hg,$ji="<sup>?</sup>"){global$w,$g;$sh=$g->server_info;$ej=preg_replace('~^(\d\.?\d).*~s','\1',$sh);$Ti=array('sql'=>"https://dev.mysql.com/doc/refman/$ej/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$ej/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$sh)."&id=",);if(preg_match('~MariaDB~',$sh)){$Ti['sql']="https://mariadb.com/kb/en/library/";$hg['sql']=(isset($hg['mariadb'])?$hg['mariadb']:str_replace(".html","/",$hg['sql']));}return($hg[$w]?"<a href='".h($Ti[$w].$hg[$w])."'".target_blank().">$ji</a>":"");}function
ob_gzencode($P){return
gzencode($P);}function
db_size($k){global$g;if(!$g->select_db($k))return"?";$I=0;foreach(table_status()as$R)$I+=$R["Data_length"]+$R["Index_length"];return
format_number($I);}function
set_utf8mb4($i){global$g;static$N=false;if(!$N&&preg_match('~\butf8mb4~i',$i)){$N=true;echo"SET NAMES ".charset($g).";\n\n";}}function
connect_error(){global$b,$g,$vi,$m,$nc;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(37).": ".h(DB),lang(113),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(114),drop_databases($_POST["db"]));page_header(lang(115),$m,false);$xa=['database'=>lang(116),'privileges'=>lang(73),'processlist'=>lang(117),'variables'=>lang(118),'status'=>lang(119),];$_=[];foreach($xa
as$x=>$X){if(support($x))$_[]="<a href='".h(ME)."$x='>$X</a>";}echo
generate_linksbar($_),"<p>".lang(120,$nc[DRIVER],"<b>".h($g->server_info)."</b>","<b>$g->extension</b>")."\n","<p>".lang(121,"<b>".h(logged_user())."</b>")."\n";$j=$b->databases();if($j){$ih=support("scheme");$ob=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(37)." - <a href='".h(ME)."refresh=1'>".lang(122)."</a>"."<td>".lang(123)."<td>".lang(124)."<td>".lang(125)." - <a href='".h(ME)."dbsize=1'>".lang(126)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$S){$ah=h(ME)."db=".urlencode($k);$s=h("Db-".$k);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$s):""),"<th><a href='$ah' id='$s'>".h($k)."</a>";$nb=h(db_collation($k,$ob));echo"<td>".(support("database")?"<a href='$ah".($ih?"&amp;ns=":"")."&amp;database=' title='".lang(69)."'>$nb</a>":$nb),"<td align='right'><a href='$ah&amp;schema=' id='tables-".h($k)."' title='".lang(72)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(128)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$vi'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$g->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(80).": ".h($_GET["ns"]),lang(129),true);page_footer("ns");exit;}}}$yf="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Eb){$this->size+=strlen($Eb);fwrite($this->handler,$Eb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$Ec="'(?:''|[^'\\\\]|\\\\.)*'";$be="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$l->select($a,$L,array(where($_GET,$o)),$L);$J=($H?$H->fetch_row():array());echo$l->value($J[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error();$R=table_status1($a,true);$C=$b->tableName($R);page_header(($o&&is_view($R)?$R['Engine']=='materialized view'?lang(130):lang(131):lang(132)).": ".($C!=""?$C:h($a)),$m);$b->selectLinks($R);$ub=$R["Comment"];if($ub!="")echo"<p class='nowrap'>".lang(51).": ".h($ub)."\n";if($o)$b->tableStructurePrint($o);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(133)."</h3>\n";$v=indexes($a);if($v)$b->tableIndexesPrint($v);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(134)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(102)."</h3>\n";$od=foreign_keys($a);if($od){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(135)."<td>".lang(136)."<td>".lang(105)."<td>".lang(104)."<td></thead>\n";foreach($od
as$C=>$p){echo"<tr title='".h($C)."'>","<th><i>".implode("</i>, <i>",array_map('h',$p["source"]))."</i>","<td><a href='".h($p["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($p["db"]),ME):($p["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($p["ns"]),ME):ME))."table=".urlencode($p["table"])."'>".($p["db"]!=""?"<b>".h($p["db"])."</b>.":"").($p["ns"]!=""?"<b>".h($p["ns"])."</b>.":"").h($p["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$p["target"]))."</i>)","<td>".h($p["on_delete"])."\n","<td>".h($p["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($C)).'">'.lang(137).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(138)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(139)."</h3>\n";$Gi=triggers($a);if($Gi){echo"<table cellspacing='0'>\n";foreach($Gi
as$x=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($x)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($x))."'>".lang(137)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(140)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(72),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Yh=array();$Zh=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$B,PREG_SET_ORDER);foreach($B
as$r=>$A){$Yh[$A[1]]=array($A[2],$A[3]);$Zh[]="\n\t'".js_escape($A[1])."': [ $A[2], $A[3] ]";}$wi=0;$Ra=-1;$hh=array();$Mg=array();$_e=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$ng=0;$hh[$Q]["fields"]=array();foreach(fields($Q)as$C=>$n){$ng+=1.25;$n["pos"]=$ng;$hh[$Q]["fields"][$C]=$n;}$hh[$Q]["pos"]=($Yh[$Q]?$Yh[$Q]:array($wi,0));foreach($b->foreignKeys($Q)as$X){if(!$X["db"]){$ye=$Ra;if($Yh[$Q][1]||$Yh[$X["table"]][1])$ye=min(floatval($Yh[$Q][1]),floatval($Yh[$X["table"]][1]))-1;else$Ra-=.1;while($_e[(string)$ye])$ye-=.0001;$hh[$Q]["references"][$X["table"]][(string)$ye]=array($X["source"],$X["target"]);$Mg[$X["table"]][$Q][(string)$ye]=$X["target"];$_e[(string)$ye]=true;}}$wi=max($wi,$hh[$Q]["pos"][0]+2.5+$ng);}echo'<div id="schema" style="height: ',$wi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$Zh)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$wi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($hh
as$C=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($C).'"><b>'.h($C)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["full_type"].($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$fi=>$Ng){foreach($Ng
as$ye=>$Jg){$ze=$ye-$Yh[$C][1];$r=0;foreach($Jg[0]as$Ch)echo"\n<div class='references' title='".h($fi)."' id='refs$ye-".($r++)."' style='left: $ze"."em; top: ".$Q["fields"][$Ch]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$ze)."em;'></div></div>";}}foreach((array)$Mg[$C]as$fi=>$Ng){foreach($Ng
as$ye=>$e){$ze=$ye-$Yh[$C][1];$r=0;foreach($e
as$ei)echo"\n<div class='references' title='".h($fi)."' id='refd$ye-".($r++)."' style='left: $ze"."em; top: ".$Q["fields"][$ei]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.8.4")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$ze)."em;'></div></div>";}}echo"\n</div>\n";}foreach($hh
as$C=>$Q){foreach((array)$Q["references"]as$fi=>$Ng){foreach($Ng
as$ye=>$Jg){$Ze=$wi;$Pe=-10;foreach($Jg[0]as$x=>$Ch){$og=$Q["pos"][0]+$Q["fields"][$Ch]["pos"];$pg=$hh[$fi]["pos"][0]+$hh[$fi]["fields"][$Jg[1][$x]]["pos"];$Ze=min($Ze,$og,$pg);$Pe=max($Pe,$og,$pg);}echo"<div class='references' id='refl$ye' style='left: $ye"."em; top: $Ze"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Pe-$Ze)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(141),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){$Hb="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$x)$Hb.="&$x=".urlencode($_POST[$x]);cookie("adminer_export",substr($Hb,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Rc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$je=preg_match('~sql~',$_POST["format"]);if($je){echo"-- Adminer $ia ".$nc[DRIVER]." ".str_replace("\n"," ",$g->server_info)." dump\n\n";if($w=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$g->query("SET time_zone = '+00:00'");$g->query("SET sql_mode = ''");}}$Ph=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){$b->dumpDatabase($k);if($g->select_db($k)){if($je&&preg_match('~CREATE~',$Ph)&&($i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($Ph=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($je){if($Ph)echo
use_sql($k).";\n\n";$Rf="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$bh){foreach(get_rows("SHOW $bh STATUS WHERE Db = ".q($k),null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE $bh ".idf_escape($J["Name"]),2));set_utf8mb4($i);$Rf.=($Ph!='DROP+CREATE'?"DROP $bh IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE EVENT ".idf_escape($J["Name"]),3));set_utf8mb4($i);$Rf.=($Ph!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}if($Rf)echo"DELIMITER ;;\n\n$Rf"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$gj=array();foreach(table_status('',true)as$C=>$R){$Q=(DB==""||in_array($C,(array)$_POST["tables"]));$Rb=(DB==""||in_array($C,(array)$_POST["data"]));if($Q||$Rb){if($Rc=="tar"){$si=new
TmpFile;ob_start(array($si,'write'),1e5);}$b->dumpTable($C,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$gj[]=$C;elseif($Rb){$o=fields($C);$b->dumpData($C,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($C));}if($je&&$_POST["triggers"]&&$Q&&($Gi=trigger_sql($C)))echo"\nDELIMITER ;;\n$Gi\nDELIMITER ;\n";if($Rc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$C.csv",$si);}elseif($je)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$C=>$R){$Q=(DB==""||in_array($C,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($C);}}foreach($gj
as$fj)$b->dumpTable($fj,$_POST["table_style"],1);if($Rc=="tar")echo
pack("x512");}}}if($je)echo"-- ".$g->result("SELECT NOW()")."\n";exit;}page_header(lang(76),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$Wb=array('','USE','DROP+CREATE','CREATE');$ai=array('','DROP+CREATE','CREATE');$Sb=array('','TRUNCATE+INSERT','INSERT');if($w=="sql")$Sb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$J);if(!$J)$J=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($J["events"])){$J["routines"]=$J["events"]=($_GET["dump"]=="");$J["triggers"]=$J["table_style"];}echo"<tr><th>".lang(142)."<td>".html_select("output",$b->dumpOutput(),$J["output"],0)."\n";echo"<tr><th>".lang(143)."<td>".html_select("format",$b->dumpFormat(),$J["format"],0)."\n";echo($w=="sqlite"?"":"<tr><th>".lang(37)."<td>".html_select('db_style',$Wb,$J["db_style"]).(support("routine")?checkbox("routines",1,$J["routines"],lang(144)):"").(support("event")?checkbox("events",1,$J["events"],lang(145)):"")),"<tr><th>".lang(124)."<td>".html_select('table_style',$ai,$J["table_style"]).checkbox("auto_increment",1,$J["auto_increment"],lang(52)).(support("trigger")?checkbox("triggers",1,$J["triggers"],lang(139)):""),"<tr><th>".lang(146)."<td>".html_select('data_style',$Sb,$J["data_style"]),'</table>
<p><input type="submit" value="',lang(76),'">
<input type="hidden" name="token" value="',$vi,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$sg=array();if(DB!=""){$eb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$eb>".lang(124)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(146)."<input type='checkbox' id='check-data'$eb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$gj="";$bi=tables_list();foreach($bi
as$C=>$T){$rg=preg_replace('~_.*~','',$C);$eb=($a==""||$a==(substr($a,-1)=="%"?"$rg%":$C));$vg="<tr><td>".checkbox("tables[]",$C,$eb,$C,"","block");if($T!==null&&!preg_match('~table~i',$T))$gj.="$vg\n";else
echo"$vg<td align='right'><label class='block'><span id='Rows-".h($C)."'></span>".checkbox("data[]",$C,$eb)."</label>\n";$sg[$rg]++;}echo$gj;if($bi)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(37)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=$b->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$rg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$rg%",$k,"","block")."\n";$sg[$rg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$fd=true;foreach($sg
as$x=>$X){if($x!=""&&$X>1){echo($fd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$x%")."'>".h($x)."</a>";$fd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(73));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(147)."</a>";$H=$g->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$wd=$H;if(!$H)$H=$g->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($wd?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(35)."<th>".lang(34)."<th></thead>\n";while($J=$H->fetch_assoc())echo'<tr'.odd().'><td>'.h($J["User"])."<td>".h($J["Host"]).'<td><a href="'.h(ME.'user='.urlencode($J["User"]).'&host='.urlencode($J["Host"])).'">'.lang(10)."</a>\n";if(!$wd||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$Jd=&get_session("queries");$Id=&$Jd[DB];if(!$m&&$_POST["clear"]){$Id=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(75):lang(66)),$m);if(!$m&&$_POST){$sd=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$Gh=$b->importServerPath();$sd=@fopen((file_exists($Gh)?$Gh:"compress.zlib://$Gh.gz"),"rb");$G=($sd?fread($sd,1e6):false);}else$G=get_file("sql_file",true);if(is_string($G)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$Bg=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$Id||reset(end($Id))!=$Bg){restart_session();$Id[]=array($Bg,time());set_session("queries",$Jd);stop_session();}}$Dh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$fc=";";$qf=0;$Bc=true;$h=connect();if(is_object($h)&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$tb=0;$Gc=array();$Yf='[\'"'.($w=="sql"?'`#':($w=="sqlite"?'`[':($w=="mssql"?'[':''))).']|/\*|-- |$'.($w=="pgsql"?'|\$[^$]*\$':'');$xi=microtime(true);parse_str($_COOKIE["adminer_export"],$za);$tc=$b->dumpFormat();unset($tc["sql"]);while($G!=""){if(!$qf&&preg_match("~^$Dh*+DELIMITER\\s+(\\S+)~i",$G,$A)){$fc=$A[1];$G=substr($G,strlen($A[0]));}else{preg_match('('.preg_quote($fc)."\\s*|$Yf)",$G,$A,PREG_OFFSET_CAPTURE,$qf);list($qd,$ng)=$A[0];if(!$qd&&$sd&&!feof($sd))$G.=fread($sd,1e5);else{if(!$qd&&rtrim($G)=="")break;$qf=$ng+strlen($qd);if($qd&&rtrim($qd)!=$fc){while(preg_match('('.($qd=='/*'?'\*/':($qd=='['?']':(preg_match('~^-- |^#~',$qd)?"\n":preg_quote($qd)."|\\\\."))).'|$)s',$G,$A,PREG_OFFSET_CAPTURE,$qf)){$fh=$A[0][0];if(!$fh&&$sd&&!feof($sd))$G.=fread($sd,1e5);else{$qf=$A[0][1]+strlen($fh);if($fh[0]!="\\")break;}}}else{$Bc=false;$Bg=substr($G,0,$ng);$tb++;$vg="<pre id='sql-$tb'><code class='jush-$w copy-to-clipboard'>".$b->sqlCommandQuery($Bg)."</code></pre>\n";$vg.=generate_linksbar(["<a href='#' class='copy-to-clipboard'>".lang(47)."</a>"]);if($w=="sqlite"&&preg_match("~^$Dh*+ATTACH\\b~i",$Bg,$A)){echo$vg,"<p class='error'>".lang(148)."\n";$Gc[]=" <a href='#sql-$tb'>$tb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$vg;ob_flush();flush();}$Kh=microtime(true);if($g->multi_query($Bg)&&is_object($h)&&preg_match("~^$Dh*+USE\\b~i",$Bg))$h->query($Bg);do{$H=$g->store_result();if($g->error){echo($_POST["only_errors"]?$vg:""),"<p class='error'>".lang(149).($g->errno?" ($g->errno)":"").": ".error()."\n";$Gc[]=" <a href='#sql-$tb'>$tb</a>";if($_POST["error_stops"])break
2;}else{$li=" <span class='time'>(".format_time($Kh).")</span>".(strlen($Bg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($Bg))."'>".lang(10)."</a>":"");$Aa=$g->affected_rows;$jj=($_POST["only_errors"]?"":$l->warnings());$kj="warnings-$tb";if($jj)$li.=", <a href='#$kj'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$kj');","");$Oc=null;$Pc="explain-$tb";if(is_object($H)){$y=$_POST["limit"];$Kf=select($H,$h,array(),$y);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$mf=$H->num_rows;echo"<p>".($mf?($y&&$mf>$y?lang(150,$y):"").lang(151,$mf):""),$li;if($h&&preg_match("~^($Dh|\\()*+SELECT\\b~i",$Bg)&&($Oc=explain($h,$Bg)))echo", <a href='#$Pc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Pc');","");$s="export-$tb";echo", <a href='#$s'>".lang(76)."</a>".script("qsl('a').onclick = partial(toggle, '$s');","")."<span id='$s' class='hidden'>: ".html_select("output",$b->dumpOutput(),$za["output"])." ".html_select("format",$tc,$za["format"])."<input type='hidden' name='query' value='".h($Bg)."'>"." <input type='submit' name='export' value='".lang(76)."'><input type='hidden' name='token' value='$vi'></span>\n"."</form>\n";}}else{if(preg_match("~^$Dh*+(CREATE|DROP|ALTER)$Dh++(DATABASE|SCHEMA)\\b~i",$Bg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($g->info)."'>".lang(152,$Aa)."$li\n";}echo($jj?"<div id='$kj' class='hidden'>\n$jj</div>\n":"");if($Oc){echo"<div id='$Pc' class='hidden'>\n";select($Oc,$h,$Kf);echo"</div>\n";}}$Kh=microtime(true);}while($g->next_result());}$G=substr($G,$qf);$qf=0;}}}}if($Bc)echo"<p class='message'>".lang(153)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(154,$tb-count($Gc))," <span class='time'>(".format_time($xi).")</span>\n";}elseif($Gc&&$tb>1)echo"<p class='error'>".lang(149).": ".implode("",$Gc)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Mc="<input type='submit' value='".lang(155)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$Bg=$_GET["sql"];if($_POST)$Bg=$_POST["query"];elseif($_GET["history"]=="all")$Bg=$Id;elseif($_GET["history"]!="")$Bg=$Id[$_GET["history"]][0];echo"<p>";textarea("query",$Bg,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$Mc\n",lang(156).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(157)."</legend><div>";$Bd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$Bd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Mc":lang(158)),"</div></fieldset>\n";$Qd=$b->importServerPath();if($Qd){echo"<fieldset><legend>".lang(159)."</legend><div>",lang(160,"<code>".h($Qd)."$Bd</code>"),' <input type="submit" name="webfile" value="'.lang(161).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(162))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(163))."\n","<input type='hidden' name='token' value='$vi'>\n";if(!isset($_GET["import"])&&$Id){print_fieldset("history",lang(164),$_GET["history"]!="");for($X=end($Id);$X;$X=prev($Id)){$x=key($Id);list($Bg,$li,$xc)=$X;echo'<a href="'.h(ME."sql=&history=$x").'" class="edit" title="'.lang(10).'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$li)."'>".@date("H:i:s",$li)."</span>"." <code class='jush-$w'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$Bg)))),80,"</code>").($xc?" <span class='time'>($xc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(165)."'>\n","<a href='".h(ME."sql=&history=all")."' class='edit-all' title='".lang(166)."'>".lang(166)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$Qi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$C=>$n){if(!isset($n["privileges"][$Qi?"update":"insert"])||$b->fieldName($n)==""||$n["generated"])unset($o[$C]);}if($_POST&&!$m&&!isset($_GET["select"])){$Fe=$_POST["referer"];if($_POST["insert"])$Fe=($Qi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Fe))$Fe=ME."select=".urlencode($a);$v=indexes($a);$Li=unique_array($_GET["where"],$v);$Eg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Fe,lang(167),$l->delete($a,$Eg,!$Li));else{$N=array();foreach($o
as$C=>$n){$X=process_input($n);if($X!==false&&$X!==null)$N[idf_escape($C)]=$X;}if($Qi){if(!$N)redirect($Fe);queries_redirect($Fe,lang(168),$l->update($a,$N,$Eg,!$Li));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$H=$l->insert($a,$N);$xe=($H?last_id():0);queries_redirect($Fe,lang(169,($xe?" $xe":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($o
as$C=>$n){if(isset($n["privileges"]["select"])){$Ha=convert_field($n);if($_POST["clone"]&&$n["auto_increment"])$Ha="''";if($w=="sql"&&preg_match("~enum|set~",$n["type"]))$Ha="1*".idf_escape($C);$L[]=($Ha?"$Ha AS ":"").idf_escape($C);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$l->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$m=error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$o){if(!$Z){$H=$l->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($l->primary=>"");}if($J){foreach($J
as$x=>$X){if(!$Z)$J[$x]=null;$o[$x]=array("field"=>$x,"null"=>($x!=$l->primary),"auto_increment"=>($x==$l->primary));}}}edit_form($a,$o,$J,$Qi);}elseif(isset($_GET["create"])){$a=$_GET["create"];$ag=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$x)$ag[$x]=$x;$Lg=referencable_primary($a);$od=array();foreach($Lg
as$Wh=>$n)$od[str_replace("`","``",$Wh)."`".str_replace("`","``",$n["field"])]=$Wh;$Nf=array();$R=array();if($a!=""){$Nf=fields($a);$R=table_status($a);if(!$R)$m=lang(9);}$J=$_POST;$J["fields"]=(array)$J["fields"];if($J["auto_increment_col"])$J["fields"][$J["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($J["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(170),drop_tables(array($a)));else{$o=array();$Ea=array();$Ui=false;$md=array();$Mf=reset($Nf);$Ca=" FIRST";foreach($J["fields"]as$x=>$n){$p=$od[$n["type"]];$Hi=($p!==null?$Lg[$p]:$n);if($n["field"]!=""){if(!$n["has_default"])$n["default"]=null;if($x==$J["auto_increment_col"])$n["auto_increment"]=true;$_g=process_field($n,$Hi);$Ea[]=array($n["orig"],$_g,$Ca);if(!$Mf||$_g!=process_field($Mf,$Mf)){$o[]=array($n["orig"],$_g,$Ca);if($n["orig"]!=""||$Ca)$Ui=true;}if($p!==null)$md[idf_escape($n["field"])]=($a!=""&&$w!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$od[$n["type"]],'source'=>array($n["field"]),'target'=>array($Hi["field"]),'on_delete'=>$n["on_delete"],));$Ca=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Ui=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$Mf=next($Nf);if(!$Mf)$Ca="";}}$cg="";if($ag[$J["partition_by"]]){$dg=array();if($J["partition_by"]=='RANGE'||$J["partition_by"]=='LIST'){foreach(array_filter($J["partition_names"])as$x=>$X){$Y=$J["partition_values"][$x];$dg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($J["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$cg.="\nPARTITION BY $J[partition_by]($J[partition])".($dg?" (".implode(",",$dg)."\n)":($J["partitions"]?" PARTITIONS ".(+$J["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$R["Create_options"]))$cg.="\nREMOVE PARTITIONING";$Te=lang(171);if($a==""){cookie("adminer_engine",$J["Engine"]);$Te=lang(172);}$C=trim($J["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($C),$Te,alter_table($a,$C,($w=="sqlite"&&($Ui||$md)?$Ea:$o),$md,($J["Comment"]!=$R["Comment"]?$J["Comment"]:null),($J["Engine"]&&$J["Engine"]!=$R["Engine"]?$J["Engine"]:""),($J["Collation"]&&$J["Collation"]!=$R["Collation"]?$J["Collation"]:""),($J["Auto_increment"]!=""?number($J["Auto_increment"]):""),$cg));}}page_header(($a!=""?lang(44):lang(77)),$m,array("table"=>$a),h($a));if(!$_POST){$J=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($U["int"])?"int":(isset($U["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$J=$R;$J["name"]=$a;$J["fields"]=array();if(!$_GET["auto_increment"])$J["Auto_increment"]="";foreach($Nf
as$n){$n["has_default"]=isset($n["default"]);$J["fields"][]=$n;}if(support("partitioning")){$td="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$H=$g->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $td ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($J["partition_by"],$J["partitions"],$J["partition"])=$H->fetch_row();$dg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $td AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$dg[""]="";$J["partition_names"]=array_keys($dg);$J["partition_values"]=array_values($dg);}}}$ob=collations();$Dc=engines();foreach($Dc
as$Cc){if(!strcasecmp($Cc,$J["Engine"])){$J["Engine"]=$Cc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(173),': <input name="name" data-maxlength="64" value="',h($J["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($Dc?"<select name='Engine'>".optionlist(array(""=>"(".lang(174).")")+$Dc,$J["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($ob&&!preg_match("~sqlite|mssql~",$w)?html_select("Collation",array(""=>"(".lang(103).")")+$ob,$J["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($J["fields"],$ob,"TABLE",$od);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(52),': <input type="number" name="Auto_increment" size="6" value="',h($J["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(175),"columnShow(this.checked, 5)","jsonly");$wb=($_POST?$_POST["comments"]:adminer_setting("comments"));echo(support("comment")?checkbox("comments",1,$wb,lang(51),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$J["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($wb?"":" class='hidden'").">".h($J["Comment"])."</textarea>":'<input name="Comment" value="'.h($J["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($wb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,$a));}if(support("partitioning")){$bg=preg_match('~RANGE|LIST~',$J["partition_by"]);print_fieldset("partition",lang(177),$J["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$ag,$J["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($J["partition"]),'">)
',lang(178),': <input type="number" name="partitions" class="size',($bg||!$J["partition_by"]?" hidden":""),'" value="',h($J["partitions"]),'">
<table cellspacing="0" id="partition-table"',($bg?"":" class='hidden'"),'>
<thead><tr><th>',lang(179),'<th>',lang(180),'</thead>
';foreach($J["partition_names"]as$x=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($x==count($J["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($J["partition_values"][$x]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Td=array("PRIMARY","UNIQUE","INDEX");$R=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$Td[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$Td[]="SPATIAL";$v=indexes($a);$tg=array();if($w=="mongo"){$tg=$v["_id_"];unset($Td[0]);unset($v["_id_"]);}$J=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($J["indexes"]as$u){$C=$u["name"];if(in_array($u["type"],$Td)){$e=array();$Ce=array();$hc=array();$N=array();ksort($u["columns"]);foreach($u["columns"]as$x=>$d){if($d!=""){$Be=$u["lengths"][$x];$gc=$u["descs"][$x];$N[]=idf_escape($d).($Be?"(".(+$Be).")":"").($gc?" DESC":"");$e[]=$d;$Ce[]=($Be?$Be:null);$hc[]=$gc;}}if($e){$Nc=$v[$C];if($Nc){ksort($Nc["columns"]);ksort($Nc["lengths"]);ksort($Nc["descs"]);if($u["type"]==$Nc["type"]&&array_values($Nc["columns"])===$e&&(!$Nc["lengths"]||array_values($Nc["lengths"])===$Ce)&&array_values($Nc["descs"])===$hc){unset($v[$C]);continue;}}$c[]=array($u["type"],$C,$N);}}}foreach($v
as$C=>$Nc)$c[]=array($Nc["type"],$C,"DROP");if(!$c)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(181),alter_indexes($a,$c));}page_header(lang(133),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($J["indexes"]as$x=>$u){if($u["columns"][count($u["columns"])]!="")$J["indexes"][$x]["columns"][]="";}$u=end($J["indexes"]);if($u["type"]||array_filter($u["columns"],'strlen'))$J["indexes"][]=array("columns"=>array(1=>""));}if(!$J){foreach($v
as$x=>$u){$v[$x]["name"]=$x;$v[$x]["columns"][]="";}$v[]=array("columns"=>array(1=>""));$J["indexes"]=$v;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(182),'<th><input type="submit" class="wayoff">',lang(183),'<th id="label-name">',lang(184),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(110)."'>",'</noscript>
</thead>
';if($tg){echo"<tr><td>PRIMARY<td>";foreach($tg["columns"]as$x=>$d){echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(61)."</label> ";}echo"<td><td>\n";}$me=1;foreach($J["indexes"]as$u){if(!$_POST["drop_col"]||$me!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$me][type]",array(-1=>"")+$Td,$u["type"],($me==count($J["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($u["columns"]);$r=1;foreach($u["columns"]as$x=>$d){echo"<span>".select_input(" name='indexes[$me][columns][$r]' title='".lang(49)."'",($o?array_combine($o,$o):$o),$d,"partial(".($r==count($u["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($w=="sql"?"":$_GET["indexes"]."_")."')"),($w=="sql"||$w=="mssql"?"<input type='number' name='indexes[$me][lengths][$r]' class='size' value='".h($u["lengths"][$x])."' title='".lang(108)."'>":""),(support("descidx")?checkbox("indexes[$me][descs][$r]",1,$u["descs"][$x],lang(61)):"")," </span>";$r++;}echo"<td><input name='indexes[$me][name]' value='".h($u["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$me]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' alt='x' title='".lang(57)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$me++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["database"])){$J=$_POST;if($_POST&&!$m&&!isset($_POST["add_x"])){$C=trim($J["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(185),drop_databases(array(DB)));}elseif(DB!==$C){if(DB!=""){$_GET["db"]=$C;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($C),lang(186),rename_database($C,$J["collation"]));}else{$j=explode("\n",str_replace("\r","",$C));$Qh=true;$we="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$J["collation"]))$Qh=false;$we=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($we),lang(187),$Qh);}}else{if(!$J["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($C).(preg_match('~^[a-z0-9_]+$~i',$J["collation"])?" COLLATE $J[collation]":""),substr(ME,0,-1),lang(188));}}page_header(DB!=""?lang(69):lang(116),$m,array(),h(DB));$ob=collations();$C=DB;if($_POST)$C=$J["name"];elseif(DB!="")$J["collation"]=db_collation(DB,$ob);elseif($w=="sql"){foreach(get_vals("SHOW GRANTS")as$wd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$wd,$A)&&$A[1]){$C=stripcslashes(idf_unescape("`$A[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($C,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($C).'</textarea><br>':'<input name="name" id="name" value="'.h($C).'" data-maxlength="64" autocapitalize="off">')."\n".($ob?html_select("collation",array(""=>"(".lang(103).")")+$ob,$J["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"ms187963.aspx",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(176,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(110)."'>\n";echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["scheme"])){$J=$_POST;if($_POST&&!$m){$z=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$z,lang(189));else{$C=trim($J["name"]);$z.=urlencode($C);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($C),$z,lang(190));elseif($_GET["ns"]!=$C)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($C),$z,lang(191));else
redirect($z);}}page_header($_GET["ns"]!=""?lang(70):lang(71),$m);if(!$J)$J["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" id="name" value="',h($J["name"]),'" autocapitalize="off">
',script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(176,$_GET["ns"]))."\n";echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(192).": ".h($da),$m);$bh=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Rd=array();$Rf=array();foreach($bh["fields"]as$r=>$n){if(substr($n["inout"],-3)=="OUT")$Rf[$r]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Rd[]=$r;}if(!$m&&$_POST){$Za=array();foreach($bh["fields"]as$x=>$n){if(in_array($x,$Rd)){$X=process_input($n);if($X===false)$X="''";if(isset($Rf[$x]))$g->query("SET @".idf_escape($n["field"])." = $X");}$Za[]=(isset($Rf[$x])?"@".idf_escape($n["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$Za).")";$Kh=microtime(true);$H=$g->multi_query($G);$Aa=$g->affected_rows;echo$b->selectQuery($G,$Kh,!$H);if(!$H)echo"<p class='error'>".error()."\n";else{$h=connect();if(is_object($h))$h->select_db(DB);do{$H=$g->store_result();if(is_object($H))select($H,$h);else
echo"<p class='message'>".lang(193,$Aa)." <span class='time'>".@date("H:i:s")."</span>\n";}while($g->next_result());if($Rf)select($g->query("SELECT ".implode(", ",$Rf)));}}echo'
<form action="" method="post">
';if($Rd){echo"<table cellspacing='0' class='layout'>\n";foreach($Rd
as$x){$n=$bh["fields"][$x];$C=$n["field"];echo"<tr><th>".$b->fieldName($n);$Y=$_POST["fields"][$C];if($Y!=""){if($n["type"]=="enum")$Y=+$Y;if($n["type"]=="set")$Y=array_sum($Y);}input($n,$Y,(string)$_POST["function"][$C]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(192),'">
<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$C=$_GET["name"];$J=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$Te=($_POST["drop"]?lang(194):($C!=""?lang(195):lang(196)));$Fe=ME."table=".urlencode($a);if(!$_POST["drop"]){$J["source"]=array_filter($J["source"],'strlen');ksort($J["source"]);$ei=array();foreach($J["source"]as$x=>$X)$ei[$x]=$J["target"][$x];$J["target"]=$ei;}if($w=="sqlite")queries_redirect($Fe,$Te,recreate_table($a,$a,array(),array(),array(" $C"=>($_POST["drop"]?"":" ".format_foreign_key($J)))));else{$c="ALTER TABLE ".table($a);$oc="\nDROP ".($w=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($C);if($_POST["drop"])query_redirect($c.$oc,$Fe,$Te);else{query_redirect($c.($C!=""?"$oc,":"")."\nADD".format_foreign_key($J),$Fe,$Te);$m=lang(197)."<br>$m";}}}page_header(lang(198),$m,array("table"=>$a),h($a));if($_POST){ksort($J["source"]);if($_POST["add"])$J["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$J["target"]=array();}elseif($C!=""){$od=foreign_keys($a);$J=$od[$C];$J["source"][]="";}else{$J["table"]=$a;$J["source"]=array("");}echo'
<form action="" method="post">
';$Ch=array_keys(fields($a));if($J["db"]!="")$g->select_db($J["db"]);if($J["ns"]!="")set_schema($J["ns"]);$Kg=array_keys(array_filter(table_status('',true),'fk_support'));$ei=array_keys(fields(in_array($J["table"],$Kg)?$J["table"]:reset($Kg)));$zf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(199).": ".html_select("table",$Kg,$J["table"],$zf)."\n";if($w=="pgsql")echo
lang(80).": ".html_select("ns",$b->schemas(),$J["ns"]!=""?$J["ns"]:$_GET["ns"],$zf);elseif($w!="sqlite"){$Xb=array();foreach($b->databases()as$k){if(!information_schema($k))$Xb[]=$k;}echo
lang(79).": ".html_select("db",$Xb,$J["db"]!=""?$J["db"]:$_GET["db"],$zf);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(200),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(135),'<th id="label-target">',lang(136),'</thead>
';$me=0;foreach($J["source"]as$x=>$X){echo"<tr>","<td>".html_select("source[".(+$x)."]",array(-1=>"")+$Ch,$X,($me==count($J["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$x)."]",$ei,isset($J["target"][$x])?$J["target"][$x]:null,1,"label-target");$me++;}echo'</table>
<p>
',lang(105),': ',html_select("on_delete",array(-1=>"")+explode("|",$yf),$J["on_delete"]),' ',lang(104),': ',html_select("on_update",array(-1=>"")+explode("|",$yf),$J["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"ms174979.aspx",'oracle'=>"https://docs.oracle.com/cd/B19306_01/server.102/b14200/clauses002.htm#sthref2903",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(201),'"></noscript>
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,$C));}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$J=$_POST;$Of="VIEW";if($w=="pgsql"&&$a!=""){$O=table_status($a);$Of=strtoupper($O["Engine"]);}if($_POST&&!$m){$C=trim($J["name"]);$Ha=" AS\n$J[select]";$Fe=ME."table=".urlencode($C);$Te=lang(202);$T=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$C&&$w!="sqlite"&&$T=="VIEW"&&$Of=="VIEW")query_redirect(($w=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($C).$Ha,$Fe,$Te);else{$gi=$C."_adminer_".uniqid();drop_create("DROP $Of ".table($a),"CREATE $T ".table($C).$Ha,"DROP $T ".table($C),"CREATE $T ".table($gi).$Ha,"DROP $T ".table($gi),($_POST["drop"]?substr(ME,0,-1):$Fe),lang(203),$Te,lang(204),$a,$C);}}if(!$_POST&&$a!=""){$J=view($a);$J["name"]=$a;$J["materialized"]=($Of!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(43):lang(205)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(184),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$J["materialized"],lang(130)):""),'<p>';textarea("select",$J["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,$a));}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$ee=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Mh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$J=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(206));elseif(in_array($J["INTERVAL_FIELD"],$ee)&&isset($Mh[$J["STATUS"]])){$gh="\nON SCHEDULE ".($J["INTERVAL_VALUE"]?"EVERY ".q($J["INTERVAL_VALUE"])." $J[INTERVAL_FIELD]".($J["STARTS"]?" STARTS ".q($J["STARTS"]):"").($J["ENDS"]?" ENDS ".q($J["ENDS"]):""):"AT ".q($J["STARTS"]))." ON COMPLETION".($J["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(207):lang(208)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$gh.($aa!=$J["EVENT_NAME"]?"\nRENAME TO ".idf_escape($J["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($J["EVENT_NAME"]).$gh)."\n".$Mh[$J["STATUS"]]." COMMENT ".q($J["EVENT_COMMENT"]).rtrim(" DO\n$J[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(209).": ".h($aa):lang(210)),$m);if(!$J&&$aa!=""){$K=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$J=reset($K);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(184),'<td><input name="EVENT_NAME" value="',h($J["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(211),'<td><input name="STARTS" value="',h("$J[EXECUTE_AT]$J[STARTS]"),'">
<tr><th title="datetime">',lang(212),'<td><input name="ENDS" value="',h($J["ENDS"]),'">
<tr><th>',lang(213),'<td><input type="number" name="INTERVAL_VALUE" value="',h($J["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$ee,$J["INTERVAL_FIELD"]),'<tr><th>',lang(119),'<td>',html_select("STATUS",$Mh,$J["STATUS"]),'<tr><th>',lang(51),'<td><input name="EVENT_COMMENT" value="',h($J["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$J["ON_COMPLETION"]=="PRESERVE",lang(214)),'</table>
<p>';textarea("EVENT_DEFINITION",$J["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,$aa));}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$bh=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$J=$_POST;$J["fields"]=(array)$J["fields"];if($_POST&&!process_fields($J["fields"])&&!$m){$Lf=routine($_GET["procedure"],$bh);$gi="$J[name]_adminer_".uniqid();drop_create("DROP $bh ".routine_id($da,$Lf),create_routine($bh,$J),"DROP $bh ".routine_id($J["name"],$J),create_routine($bh,array("name"=>$gi)+$J),"DROP $bh ".routine_id($gi,$J),substr(ME,0,-1),lang(215),lang(216),lang(217),$da,$J["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(218):lang(219)).": ".h($da):(isset($_GET["function"])?lang(220):lang(221))),$m);if(!$_POST&&$da!=""){$J=routine($_GET["procedure"],$bh);$J["name"]=$da;}$ob=get_vals("SHOW CHARACTER SET");sort($ob);$ch=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(184),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',($ch?lang(19).": ".html_select("language",$ch,$J["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($J["fields"],$ob,$bh);if(isset($_GET["function"])){echo"<tr><td>".lang(222);edit_type("returns",$J["returns"],$ob,array(),($w=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$J["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,$da));}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$J=$_POST;if($_POST&&!$m){$z=substr(ME,0,-1);$C=trim($J["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$z,lang(223));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($C),$z,lang(224));elseif($fa!=$C)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($C),$z,lang(225));else
redirect($z);}page_header($fa!=""?lang(226).": ".h($fa):lang(227),$m);if(!$J)$J["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(176,$fa))."\n";echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$J=$_POST;if($_POST&&!$m){$z=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$z,lang(228));else
query_redirect("CREATE TYPE ".idf_escape(trim($J["name"]))." $J[as]",$z,lang(229));}page_header($ga!=""?lang(230).": ".h($ga):lang(231),$m);if(!$J)$J["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!="")echo"<input type='submit' name='drop' value='".lang(128)."'>".confirm(lang(176,$ga))."\n";else{echo"<input name='name' value='".h($J['name'])."' autocapitalize='off'>\n";textarea("as",$J["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$C=$_GET["name"];$Fi=trigger_options();$J=(array)trigger($C,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$Fi["Timing"])&&in_array($_POST["Event"],$Fi["Event"])&&in_array($_POST["Type"],$Fi["Type"])){$xf=" ON ".table($a);$oc="DROP TRIGGER ".idf_escape($C).($w=="pgsql"?$xf:"");$Fe=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($oc,$Fe,lang(232));else{if($C!="")queries($oc);queries_redirect($Fe,($C!=""?lang(233):lang(234)),queries(create_trigger($xf,$_POST)));if($C!="")queries(create_trigger($xf,$J+array("Type"=>reset($Fi["Type"]))));}}$J=$_POST;}page_header(($C!=""?lang(235).": ".h($C):lang(236)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(237),'<td>',html_select("Timing",$Fi["Timing"],$J["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(238),'<td>',html_select("Event",$Fi["Event"],$J["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Fi["Event"])?" <input name='Of' value='".h($J["Of"])."' class='hidden'>":""),'<tr><th>',lang(50),'<td>',html_select("Type",$Fi["Type"],$J["Type"]),'</table>
<p>',lang(184),': <input name="Trigger" value="',h($J["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$J["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,$C));}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$yg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$J){foreach(explode(",",($J["Privilege"]=="Grant option"?"":$J["Context"]))as$Fb)$yg[$Fb][$J["Privilege"]]=$J["Comment"];}$yg["Server Admin"]+=$yg["File access on server"];$yg["Databases"]["Create routine"]=$yg["Procedures"]["Create routine"];unset($yg["Procedures"]["Create routine"]);$yg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$yg["Columns"][$X]=$yg["Tables"][$X];unset($yg["Server Admin"]["Usage"]);foreach($yg["Tables"]as$x=>$X)unset($yg["Databases"][$x]);$gf=array();if($_POST){foreach($_POST["objects"]as$x=>$X)$gf[$X]=(array)$gf[$X]+(array)$_POST["grants"][$x];}$xd=array();$vf="";if(isset($_GET["host"])&&($H=$g->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($J=$H->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$J[0],$A)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$A[1],$B,PREG_SET_ORDER)){foreach($B
as$X){if($X[1]!="USAGE")$xd["$A[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$J[0]))$xd["$A[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$J[0],$A))$vf=$A[1];}}if($_POST&&!$m){$wf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $wf",ME."privileges=",lang(239));else{$if=q($_POST["user"])."@".q($_POST["host"]);$fg=$_POST["pass"];if($fg!=''&&!$_POST["hashed"]&&!min_version(8)){$fg=$g->result("SELECT PASSWORD(".q($fg).")");$m=!$fg;}$Lb=false;if(!$m){if($wf!=$if){$Lb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $if IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($fg));$m=!$Lb;}elseif($fg!=$vf)queries("SET PASSWORD FOR $if = ".q($fg));}if(!$m){$Yg=array();foreach($gf
as$of=>$wd){if(isset($_GET["grant"]))$wd=array_filter($wd);$wd=array_keys($wd);if(isset($_GET["grant"]))$Yg=array_diff(array_keys(array_filter($gf[$of],'strlen')),$wd);elseif($wf==$if){$tf=array_keys((array)$xd[$of]);$Yg=array_diff($tf,$wd);$wd=array_diff($wd,$tf);unset($xd[$of]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$of,$A)&&(!grant("REVOKE",$Yg,$A[2]," ON $A[1] FROM $if")||!grant("GRANT",$wd,$A[2]," ON $A[1] TO $if"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($wf!=$if)queries("DROP USER $wf");elseif(!isset($_GET["grant"])){foreach($xd
as$of=>$Yg){if(preg_match('~^(.+)(\(.*\))?$~U',$of,$A))grant("REVOKE",array_keys($Yg),$A[2]," ON $A[1] FROM $if");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(240):lang(241)),!$m);if($Lb)$g->query("DROP USER $if");}}page_header((isset($_GET["host"])?lang(35).": ".h("$ha@$_GET[host]"):lang(147)),$m,array("privileges"=>array('',lang(73))));if($_POST){$J=$_POST;$xd=$gf;}else{$J=$_GET+array("host"=>$g->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$J["pass"]=$vf;if($vf!="")$J["hashed"]=true;$xd[(DB==""||$xd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(34),'<td><input name="host" data-maxlength="60" value="',h($J["host"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="user" data-maxlength="80" value="',h($J["user"]),'" autocapitalize="off">
<tr><th>',lang(36),'<td><input name="pass" id="pass" value="',h($J["pass"]),'" autocomplete="new-password">
';if(!$J["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$J["hashed"],lang(242),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(73).doc_link(array('sql'=>"grant.html#priv_level"));$r=0;foreach($xd
as$of=>$wd){echo'<th>'.($of!="*.*"?"<input name='objects[$r]' value='".h($of)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$r]' value='*.*' size='10'>*.*");$r++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(34),"Databases"=>lang(37),"Tables"=>lang(132),"Columns"=>lang(49),"Procedures"=>lang(243),)as$Fb=>$gc){foreach((array)$yg[$Fb]as$xg=>$ub){echo"<tr".odd()."><td".($gc?">$gc<td":" colspan='2'").' lang="en" title="'.h($ub).'">'.h($xg);$r=0;foreach($xd
as$of=>$wd){$C="'grants[$r][".h(strtoupper($xg))."]'";$Y=$wd[strtoupper($xg)];if($Fb=="Server Admin"&&$of!=(isset($xd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$C><option><option value='1'".($Y?" selected":"").">".lang(244)."<option value='0'".($Y=="0"?" selected":"").">".lang(245)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$C value='1'".($Y?" checked":"").($xg=="All privileges"?" id='grants-$r-all'>":">".($xg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$r-all'); };"))),"</label>";}$r++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(128),'">',confirm(lang(176,"$ha@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$re=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$re++;}queries_redirect(ME."processlist=",lang(246,$re),$re||!$_POST["kill"]);}}page_header(lang(117),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$r=-1;foreach(process_list()as$r=>$J){if(!$r){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($J
as$x=>$X)echo"<th>$x".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($x),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$J[$w=="sql"?"Id":"pid"],0):"");foreach($J
as$x=>$X)echo"<td>".(($w=="sql"&&$x=="Info"&&preg_match("~Query|Killed~",$J["Command"])&&$X!="")||($w=="pgsql"&&$x=="current_query"&&$X!="<IDLE>")||($w=="oracle"&&$x=="sql_text"&&$X!="")?"<code class='jush-$w'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($J["db"]!=""?"db=".urlencode($J["db"])."&":"")."sql=".urlencode($X)).'">'.lang(247).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($r+1)."/".lang(248,max_connections()),"<p><input type='submit' value='".lang(249)."'>\n";}echo'<input type="hidden" name="token" value="',$vi,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$v=indexes($a);$o=fields($a);$od=column_foreign_keys($a);$rf=$R["Oid"];parse_str($_COOKIE["adminer_import"],$_a);$Zg=array();$e=array();$ki=null;foreach($o
as$x=>$n){$C=$b->fieldName($n);if(isset($n["privileges"]["select"])&&$C!=""){$e[$x]=html_entity_decode(strip_tags($C),ENT_QUOTES);if(is_shortable($n))$ki=$b->selectLengthProcess();}$Zg+=$n["privileges"];}list($L,$yd)=$b->selectColumnsProcess($e,$v);$ie=count($yd)<count($L)||strstr($L[0],"DISTINCT");$Z=$b->selectSearchProcess($o,$v);$Hf=$b->selectOrderProcess($o,$v);$y=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Mi=>$J){$Ha=convert_field($o[key($J)]);$L=array($Ha?$Ha:idf_escape(key($J)));$Z[]=where_check($Mi,$o);$I=$l->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$tg=$Oi=null;foreach($v
as$u){if($u["type"]=="PRIMARY"){$tg=array_flip($u["columns"]);$Oi=($L?$tg:array());foreach($Oi
as$x=>$X){if(in_array(idf_escape($x),$L))unset($Oi[$x]);}break;}}if($rf&&!$tg){$tg=$Oi=array($rf=>0);$v[]=array("type"=>"PRIMARY","columns"=>array($rf));}if($_POST&&!$m){$pj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$fb=array();foreach($_POST["check"]as$cb)$fb[]=where_check($cb,$o);$pj[]="((".implode(") OR (",$fb)."))";}$pj=($pj?"\nWHERE ".implode(" AND ",$pj):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$td=($L?implode(", ",$L):"*").convert_fields($e,$o,$L)."\nFROM ".table($a);$_d=($yd&&$ie?"\nGROUP BY ".implode(", ",$yd):"").($Hf?"\nORDER BY ".implode(", ",$Hf):"");if(!is_array($_POST["check"])||$tg)$G="SELECT $td$pj$_d";else{$Ki=array();foreach($_POST["check"]as$X)$Ki[]="(SELECT".limit($td,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$_d,1).")";$G=implode(" UNION ALL ",$Ki);}$b->dumpData($a,"table",$G);exit;}if(!$b->selectEmailProcess($Z,$od)){if($_POST["save"]||$_POST["delete"]){$H=true;$Aa=0;$N=array();if(!$_POST["delete"]){foreach($e
as$C=>$X){$X=process_input($o[$C]);if($X!==null&&($_POST["clone"]||$X!==false))$N[idf_escape($C)]=($X!==false?$X:idf_escape($C));}}if($_POST["delete"]||$N){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($N)).")\nSELECT ".implode(", ",$N)."\nFROM ".table($a);if($_POST["all"]||($tg&&is_array($_POST["check"]))||$ie){$H=($_POST["delete"]?$l->delete($a,$pj):($_POST["clone"]?queries("INSERT $G$pj"):$l->update($a,$N,$pj)));$Aa=$g->affected_rows;}else{foreach((array)$_POST["check"]as$X){$lj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$H=($_POST["delete"]?$l->delete($a,$lj,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$lj)):$l->update($a,$N,$lj,1)));if(!$H)break;$Aa+=$g->affected_rows;}}}$Te=lang(250,$Aa);if($_POST["clone"]&&$H&&$Aa==1){$xe=last_id();if($xe)$Te=lang(169," $xe");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Te,$H);if(!$_POST["delete"]){edit_form($a,$o,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(251);else{$H=true;$Aa=0;foreach($_POST["val"]as$Mi=>$J){$N=array();foreach($J
as$x=>$X){$x=bracket_escape($x,1);$N[idf_escape($x)]=(preg_match('~char|text~',$o[$x]["type"])||$X!=""?$b->processInput($o[$x],$X):"NULL");}$H=$l->update($a,$N," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Mi,$o),!$ie&&!$tg," ");if(!$H)break;$Aa+=$g->affected_rows;}queries_redirect(remove_from_uri(),lang(250,$Aa),$H);}}elseif(!is_string($cd=get_file("csv_file",true)))$m=upload_error($cd);elseif(!preg_match('~~u',$cd))$m=lang(252);else{cookie("adminer_import","output=".urlencode($_a["output"])."&format=".urlencode($_POST["separator"]));$H=true;$qb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$cd,$B);$Aa=count($B[0]);$l->begin();$ph=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($B[0]as$x=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$ph]*)$ph~",$X.$ph,$Me);if(!$x&&!array_diff($Me[1],$qb)){$qb=$Me[1];$Aa--;}else{$N=array();foreach($Me[1]as$r=>$lb)$N[idf_escape($qb[$r])]=($lb==""&&$o[$qb[$r]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$lb))));$K[]=$N;}}$H=(!$K||$l->insertUpdate($a,$K,$tg));if($H)$H=$l->commit();queries_redirect(remove_from_uri("page"),lang(253,$Aa),$H);$l->rollback();}}}$Wh=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(54).": $Wh",$m);$N=null;if(isset($Zg["insert"])||!support("table")){$N="";foreach((array)$_GET["where"]as$X){if($od[$X["col"]]&&count($od[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$N.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($R,$N);if(!$e&&support("table"))echo"<p class='error'>".lang(254).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">','<input type="submit" value="'.h(lang(54)).'">';echo"</div>\n";$b->selectColumnsPrint($L,$e);$b->selectSearchPrint($Z,$e,$v);$b->selectOrderPrint($Hf,$e,$v);$b->selectLimitPrint($y);$b->selectLengthPrint($ki);$b->selectActionPrint($v);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$rd=$g->result(count_rows($a,$Z,$ie,$yd));$E=floor(max(0,$rd-1)/$y);}$kh=$L;$zd=$yd;if(!$kh){$kh[]="*";$Gb=convert_fields($e,$o,$L);if($Gb)$kh[]=substr($Gb,2);}foreach($L
as$x=>$X){$n=$o[idf_unescape($X)];if($n&&($Ha=convert_field($n)))$kh[$x]="$Ha AS $X";}if(!$ie&&$Oi){foreach($Oi
as$x=>$X){$kh[]=idf_escape($x);if($zd)$zd[]=idf_escape($x);}}$H=$l->select($a,$kh,$Z,$zd,$Hf,$y,$E,true);if(!$H)echo"<p class='error'>".error()."\n";else{if($w=="mssql"&&$E)$H->seek($y*$E);$Ac=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($E&&$w=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$y!=""&&$yd&&$ie&&$w=="sql")$rd=$g->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(12)."\n";else{$Qa=$b->backwardKeys($a,$Wh);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$yd&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."' title='".lang(255)."' class='edit-all'>".lang(255)."</a>");$ef=array();$ud=array();reset($L);$Gg=1;foreach($K[0]as$x=>$X){if(!isset($Oi[$x])){$X=$_GET["columns"][key($L)]??null;$n=$o[$L?($X?$X["col"]:current($L)):$x];$C=($n?$b->fieldName($n,$Gg):($X["fun"]?"*":$x));if($C!=""){$Gg++;$ef[$x]=$C;$d=idf_escape($x);$Md=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($x);$gc="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($x))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Md.($Hf[0]==$d||$Hf[0]==$x||(!$Hf&&$ie&&$yd[0]==$d)?$gc:'')).'">';echo
apply_sql_function($X["fun"]??null,$C)."</a>";echo"<span class='column hidden'>","<a href='".h($Md.$gc)."' title='".lang(61)."' class='text'> ↓</a>";if(isset($X["fun"])===false){echo'<a href="#fieldset-search" title="'.lang(58).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($x)."');");}echo"</span>";}$ud[$x]=$X["fun"]??null;next($L);}}$Ce=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$x=>$X)$Ce[$x]=max($Ce[$x],min(40,strlen(utf8_decode($X))));}}echo($Qa?"<th>".lang(256):"")."</thead>\n";if(is_ajax()){if($y%2==1&&$E%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($K,$od)as$df=>$J){$Li=unique_array($K[$df],$v);if(!$Li){$Li=array();foreach($K[$df]as$x=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$x))$Li[$x]=$X;}}$Mi="";foreach($Li
as$x=>$X){if(($w=="sql"||$w=="pgsql")&&preg_match('~char|text|enum|set~',$o[$x]["type"])&&strlen($X)>64){$x=(strpos($x,'(')?$x:idf_escape($x));$x="MD5(".($w!='sql'||preg_match("~^utf8~",$o[$x]["collation"])?$x:"CONVERT($x USING ".charset($g).")").")";$X=md5($X);}$Mi.="&".($X!==null?urlencode("where[".bracket_escape($x)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($x));}echo"<tr".odd().">".(!$yd&&$L?"":"<td>".checkbox("check[]",substr($Mi,1),in_array(substr($Mi,1),(array)$_POST["check"])).($ie||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Mi)."' class='edit' title='".lang(257)."'>".lang(257)."</a>"));foreach($J
as$x=>$X){if(isset($ef[$x])){$n=$o[$x];$X=$l->value($X,$n);if($X!=""&&(!isset($Ac[$x])||$Ac[$x]!=""))$Ac[$x]=(is_mail($X)?$ef[$x]:"");$z="";if(preg_match('~blob|bytea|raw|file~',$n["type"]??null)&&$X!="")$z=ME.'download='.urlencode($a).'&field='.urlencode($x).$Mi;if(!$z&&$X!==null){foreach((array)$od[$x]as$p){if(count($od[$x])==1||end($p["source"])==$x){$z="";foreach($p["source"]as$r=>$Ch)$z.=where_link($r,$p["target"][$r],$K[$df][$Ch]);$z=($p["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($p["db"]),ME):ME).'select='.urlencode($p["table"]).$z;if($p["ns"])$z=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($p["ns"]),$z);if(count($p["source"])==1)break;}}}if($x=="COUNT(*)"){$z=ME."select=".urlencode($a);$r=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Li))$z.=where_link($r++,$W["col"],$W["val"],$W["op"]);}foreach($Li
as$ne=>$W)$z.=where_link($r++,$ne,$W);}$X=select_value($X,$z,$n,$ki);$s=h("val[$Mi][".bracket_escape($x)."]");$Y=null;if(isset($_POST["val"][$Mi][bracket_escape($x)]))$_POST["val"][$Mi][bracket_escape($x)];$wc=!is_array($J[$x])&&is_utf8($X)&&$K[$df][$x]==$J[$x]&&!$ud[$x];$ji=preg_match('~text|lob~',$n["type"]??null);echo"<td id='$s'";if(($_GET["modify"]&&$wc)||$Y!==null){$Cd=h($Y!==null?$Y:$J[$x]);echo">".($ji?"<textarea name='$s' cols='30' rows='".(substr_count($J[$x],"\n")+1)."'>$Cd</textarea>":"<input name='$s' value='$Cd' size='$Ce[$x]'>");}else{$He=strpos($X,"<i>…</i>");echo" data-text='".($He?2:($ji?1:0))."'".($wc?"":" data-warning='".h(lang(258))."'").">$X</td>";}}}if($Qa)echo"<td>";$b->backwardKeysPrint($Qa,$K[$df]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($K||$E){$Lc=true;if($_GET["page"]!="last"){if($y==""||(count($K)<$y&&($K||!$E)))$rd=($E?$E*$y:0)+count($K);elseif($w!="sql"||!$ie){$rd=($ie?false:found_rows($R,$Z));if($rd<max(1e4,2*($E+1)*$y))$rd=reset(slow_query(count_rows($a,$Z,$ie,$yd)));else$Lc=false;}}$Vf=($y!=""&&($rd===false||$rd>$y||$E));if($Vf){echo(($rd===false?count($K)+1:$rd-$E*$y)>$y?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(259).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$y).", '".lang(260)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$E){if($Vf){$Oe=($rd===false?$E+(count($K)>=$y?2:1):floor(($rd-1)/$y));echo"<fieldset>";if($w!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(261)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(261)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($r=max(1,$E-4);$r<min($Oe,$E+5);$r++)echo
pagination($r,$E);if($Oe>0){echo($E+5<$Oe?" …":""),($Lc&&$rd!==false?pagination($Oe,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Oe'>".lang(262)."</a>");}}else{echo"<legend>".lang(261)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Oe>$E?pagination($E+1,$E).($Oe>$E+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(263)."</legend>";$lc=($Lc?"":"~ ").$rd;echo
checkbox("all",1,0,($rd!==false?($Lc?"":"~ ").lang(151,$rd):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$lc' : checked); selectCount('selected2', this.checked || !checked ? '$lc' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(255),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(251).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(127),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(247),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$pd=$b->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($pd['sql']);break;}}if($pd){print_fieldset("export",lang(76)." <span id='selected2'></span>");$Sf=$b->dumpOutput();echo($Sf?html_select("output",$Sf,$_a["output"])." ":""),html_select("format",$pd,$_a["format"])," <input type='submit' name='export' value='".lang(76)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($Ac,'strlen'),$e);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(75)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$_a["format"],1);echo" <input type='submit' name='import' value='".lang(75)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$vi'>\n","</form>\n",(!$yd&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$O=isset($_GET["status"]);page_header($O?lang(119):lang(118));$cj=($O?show_status():show_variables());if(!$cj)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($cj
as$x=>$X){echo"<tr>","<th><code class='jush-".$w.($O?"status":"set")."'>".h($x)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Th=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$C=>$R){json_row("Comment-$C",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$x)json_row("$x-$C",h($R[$x]));foreach($Th+array("Auto_increment"=>0,"Rows"=>0)as$x=>$X){if($R[$x]!=""){$X=format_number($R[$x]);json_row("$x-$C",($x=="Rows"&&$X&&$R["Engine"]==($w=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Th[$x]))$Th[$x]+=($R["Engine"]!="InnoDB"||$x!="Data_free"?$R[$x]:0);}elseif(array_key_exists($x,$R))json_row("$x-$C");}}}foreach($Th
as$x=>$X)json_row("sum-$x",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$g->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$ci=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($ci&&!$m&&!$_POST["search"]){$H=true;$Te="";if($w=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$H=truncate_tables($_POST["tables"]);$Te=lang(264);}elseif($_POST["move"]){$H=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Te=lang(265);}elseif($_POST["copy"]){$H=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Te=lang(266);}elseif($_POST["drop"]){if($_POST["views"])$H=drop_views($_POST["views"]);if($H&&$_POST["tables"])$H=drop_tables($_POST["tables"]);$Te=lang(267);}elseif($w!="sql"){$H=($w=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Te=lang(268);}elseif(!$_POST["tables"])$Te=lang(9);elseif($H=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($J=$H->fetch_assoc())$Te.="<b>".h($J["Table"])."</b>: ".h($J["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Te,$H);}page_header(($_GET["ns"]==""?lang(37).": ".h(DB):lang(80).": ".h($_GET["ns"])),$m,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(269)."</h3>\n";$bi=tables_list();if(!$bi)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(270)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(58)."'>\n";if($b->operator_regexp!==null){echo"<p><label><input type='checkbox' name='regexp' value='1'".(empty($_POST['regexp'])?'':' checked').'>'.lang(271).'</label>',doc_link(array('sql'=>'regexp.html','pgsql'=>'functions-matching.html#FUNCTIONS-POSIX-REGEXP'))."</p>\n";}echo"</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$b->operator_regexp===null||empty($_POST['regexp'])?"LIKE %%":$b->operator_regexp;search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(132),'<td>'.lang(272).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(123).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(273).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(274).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(275).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(52).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(276).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(51).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$S=0;foreach($bi
as$C=>$T){$fj=($T!==null&&!preg_match('~table|sequence~i',$T));$s=h("Table-".$C);echo'<tr'.odd().'><td>'.checkbox(($fj?"views[]":"tables[]"),$C,in_array($C,$ci,true),"","","",$s),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($C)."' title='".lang(42)."' id='$s'>".h($C).'</a>':h($C));if($fj){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($C).'" title="'.lang(43).'">'.(preg_match('~materialized~i',$T)?lang(130):lang(131)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($C).'" title="'.lang(41).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(44)),"Index_length"=>array("indexes",lang(134)),"Data_free"=>array("edit",lang(45)),"Auto_increment"=>array("auto_increment=1&create",lang(44)),"Rows"=>array("select",lang(41)),)as$x=>$z){$s=" id='$x-".h($C)."'";echo($z?"<td align='right'>".(support("table")||$x=="Rows"||(support("indexes")&&$x!="Data_length")?"<a href='".h(ME."$z[0]=").urlencode($C)."'$s title='$z[1]'>?</a>":"<span$s>?</span>"):"<td id='$x-".h($C)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($C)."'>":"");}echo"<tr><td><th>".lang(248,count($bi)),"<td>".h($w=="sql"?$g->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$x)echo"<td align='right' id='sum-$x'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Zi="<input type='submit' value='".lang(277)."'> ".on_help("'VACUUM'");$Ef="<input type='submit' name='optimize' value='".lang(278)."'> ".on_help($w=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(127)." <span id='selected'></span></legend><div>".($w=="sqlite"?$Zi:($w=="pgsql"?$Zi.$Ef:($w=="sql"?"<input type='submit' value='".lang(279)."'> ".on_help("'ANALYZE TABLE'").$Ef."<input type='submit' name='check' value='".lang(280)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(281)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(282)."'> ".on_help($w=="sqlite"?"'DELETE'":"'TRUNCATE".($w=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(128)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?$b->schemas():$b->databases());if(count($j)!=1&&$w!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(283).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(284)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(285)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(286)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$vi'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}$_=[];$_[]="<a href='".h(ME)."create='>".lang(77)."</a>";if(support("view"))$_[]="<a href='".h(ME)."view='>".lang(205)."</a>";echo
generate_linksbar($_);if(support("routine")){echo"<h3 id='routines'>".lang(144)."</h3>\n";$dh=routines();if($dh){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(184).'<td>'.lang(50).'<td>'.lang(222)."<td></thead>\n";odd('');foreach($dh
as$J){$C=($J["SPECIFIC_NAME"]==$J["ROUTINE_NAME"]?"":"&name=".urlencode($J["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.h($J["ROUTINE_NAME"]).'</a>','<td>'.h($J["ROUTINE_TYPE"]),'<td>'.h($J["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.lang(137)."</a>";}echo"</table>\n";}$_=[];if(support('procedure'))$_[]="<a href='".h(ME)."procedure='>".lang(221)."</a>";$_[]="<a href='".h(ME)."function='>".lang(220)."</a>";echo
generate_linksbar($_);}if(support("sequence")){echo"<h3 id='sequences'>".lang(287)."</h3>\n";$rh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($rh){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(184)."</thead>\n";odd('');foreach($rh
as$X)echo"<tr".odd()."><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo
generate_linksbar(["<a href='".h(ME)."sequence='>".lang(227)."</a>"]);}if(support("type")){echo"<h3 id='user-types'>".lang(26)."</h3>\n";$Xi=types();if($Xi){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(184)."</thead>\n";odd('');foreach($Xi
as$X)echo"<tr".odd()."><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo
generate_linksbar(["<a href='".h(ME)."type='>".lang(231)."</a>"]);}if(support("event")){echo"<h3 id='events'>".lang(145)."</h3>\n";$K=get_rows("SHOW EVENTS");if($K){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(184)."<td>".lang(288)."<td>".lang(211)."<td>".lang(212)."<td></thead>\n";foreach($K
as$J){echo"<tr>","<th>".h($J["Name"]),"<td>".($J["Execute at"]?lang(289)."<td>".$J["Execute at"]:lang(213)." ".$J["Interval value"]." ".$J["Interval field"]."<td>$J[Starts]"),"<td>$J[Ends]",'<td><a href="'.h(ME).'event='.urlencode($J["Name"]).'">'.lang(137).'</a>';}echo"</table>\n";$Jc=$g->result("SELECT @@event_scheduler");if($Jc&&$Jc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Jc)."\n";}echo
generate_linksbar(["<a href='".h(ME)."event='>".lang(210)."</a>"]);}if($bi)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();